/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultLongValue;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class LongKeyHandler
extends KeyHandler<Long> {
    private SpinnerValidator validator;
    private long min;
    private long max;

    public LongKeyHandler(StorageHandler<?> storageHandler, String string) {
        super(storageHandler, string);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        ArrayList<Class<SpinnerValidator>> arrayList = new ArrayList<Class<SpinnerValidator>>();
        arrayList.add(SpinnerValidator.class);
        return arrayList.toArray(new Class[0]);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultLongValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(0L);
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        if (this.validator != null) {
            this.min = this.validator.min();
            this.max = this.validator.max();
        }
    }

    @Override
    protected void putValue(Long l) {
        this.storageHandler.putPrimitive(this.getKey(), l);
    }

    @Override
    protected void validateValue(Long l) throws Throwable {
        long l2;
        if (this.validator != null && ((l2 = l.longValue()) < this.min || l2 > this.max)) {
            throw new ValidationException();
        }
    }
}

