/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.StorageKeyAddedEvent;
import org.appwork.storage.StorageKeyRemovedEvent;
import org.appwork.storage.StorageValueChangeEvent;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging.Log;

public class JsonKeyValueStorage
extends Storage {
    private final HashMap<String, Object> map = new HashMap();
    private final String name;
    private final File file;
    private final boolean plain;
    private final byte[] key;
    private boolean autoPutValues = true;
    private boolean closed = false;
    private boolean changed = false;

    public JsonKeyValueStorage(File file) throws StorageException {
        this(file, false);
    }

    public JsonKeyValueStorage(File file, boolean bl) throws StorageException {
        this(file, bl, JSonStorage.KEY);
    }

    public JsonKeyValueStorage(File file, boolean bl, byte[] byArray) throws StorageException {
        this.plain = bl;
        this.file = file;
        this.name = file.getName();
        this.key = byArray;
        HashMap hashMap = JSonStorage.restoreFrom(file, bl, byArray, new TypeRef<HashMap<String, Object>>(){}, new HashMap());
        this.map.putAll(hashMap);
    }

    public JsonKeyValueStorage(String string) throws StorageException {
        this(string, false);
    }

    public JsonKeyValueStorage(String string, boolean bl) throws StorageException {
        this(string, bl, JSonStorage.KEY);
    }

    public JsonKeyValueStorage(String string, boolean bl, byte[] byArray) throws StorageException {
        this.name = string;
        this.plain = bl;
        this.file = Application.getResource("cfg/" + string + (bl ? ".json" : ".ejs"));
        Log.L.finer("Read Config: " + this.file.getAbsolutePath());
        this.key = byArray;
        HashMap hashMap = JSonStorage.restoreFrom(this.file, bl, byArray, new TypeRef<HashMap<String, Object>>(){}, new HashMap());
        this.map.putAll(hashMap);
    }

    public JsonKeyValueStorage(File file, URL uRL, boolean bl, byte[] byArray) {
        HashMap hashMap;
        this.plain = bl;
        this.file = file;
        this.name = file.getName();
        this.key = byArray;
        if (uRL != null) {
            try {
                hashMap = JSonStorage.restoreFromString(IO.readURL(uRL), bl, byArray, new TypeRef<HashMap<String, Object>>(){}, new HashMap());
                this.map.putAll(hashMap);
            }
            catch (IOException iOException) {
                throw new WTFException(iOException);
            }
        }
        if (file.exists()) {
            hashMap = JSonStorage.restoreFrom(file, bl, byArray, new TypeRef<HashMap<String, Object>>(){}, new HashMap());
            this.map.putAll(hashMap);
        }
    }

    @Override
    public void clear() throws StorageException {
        Iterator<Map.Entry<String, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            iterator.remove();
            if (!this.hasEventSender()) continue;
            this.getEventSender().fireEvent(new StorageKeyRemovedEvent<Object>(this, entry.getKey(), entry.getValue()));
        }
        this.map.clear();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public <E> E get(String string, E e) throws StorageException {
        Object object;
        boolean bl = this.map.containsKey(string);
        Object object2 = object = bl ? this.map.get(string) : null;
        if (object != null && e != null && object.getClass() != e.getClass()) {
            if (e instanceof Long) {
                if (object instanceof Integer) {
                    object = new Long(((Integer)object).longValue());
                }
            } else if (e instanceof Integer) {
                if (object instanceof Long) {
                    object = new Integer(((Long)object).intValue());
                }
            } else if (e instanceof Double) {
                if (object instanceof Float) {
                    object = ((Float)object).doubleValue();
                }
            } else if (e instanceof Float && object instanceof Double) {
                object = Float.valueOf(((Double)object).floatValue());
            }
        }
        if (!bl && this.autoPutValues) {
            object = e;
            if (e instanceof Boolean) {
                this.put(string, (Boolean)e);
            } else if (e instanceof Long) {
                this.put(string, (Long)e);
            } else if (e instanceof Integer) {
                this.put(string, (Integer)e);
            } else if (e instanceof Byte) {
                this.put(string, (Byte)e);
            } else if (e instanceof String || e == null) {
                this.put(string, (String)e);
            } else if (e instanceof Enum) {
                this.put(string, (Enum)e);
            } else if (e instanceof Double) {
                this.put(string, (Double)e);
            } else if (e instanceof Float) {
                this.put(string, (Float)e);
            } else {
                throw new StorageException("Invalid datatype: " + (e != null ? e.getClass() : "null"));
            }
        }
        if (e instanceof Enum && object instanceof String) {
            try {
                object = Enum.valueOf(((Enum)e).getDeclaringClass(), (String)object);
            }
            catch (Throwable throwable) {
                this.map.remove(string);
                Log.exception(throwable);
                if (this.autoPutValues) {
                    this.put(string, (Enum)e);
                }
                object = e;
            }
        }
        return (E)object;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getID() {
        return this.file.getAbsolutePath();
    }

    public HashMap<String, Object> getInternalStorageMap() {
        return this.map;
    }

    public byte[] getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.map.containsKey(string);
    }

    public boolean isAutoPutValues() {
        return this.autoPutValues;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void put(String string, boolean bl) throws StorageException {
        boolean bl2 = this.map.containsKey(string);
        boolean bl3 = bl2 ? this.get(string, bl) : null;
        this.map.put(string, bl);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl2) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Boolean>((Storage)this, string, bl3, bl));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Boolean>(this, string, bl));
        }
    }

    @Override
    public void put(String string, Boolean bl) throws StorageException {
        boolean bl2 = this.map.containsKey(string);
        Boolean bl3 = bl2 ? this.get(string, bl) : null;
        this.map.put(string, bl);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl2) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Boolean>((Storage)this, string, bl3, bl));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Boolean>(this, string, bl));
        }
    }

    @Override
    public void put(String string, Byte by) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Byte by2 = bl ? this.get(string, by) : null;
        this.map.put(string, by);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Byte>((Storage)this, string, by2, by));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Byte>(this, string, by));
        }
    }

    @Override
    public void put(String string, Double d) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Double d2 = bl ? this.get(string, d) : null;
        this.map.put(string, d);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Double>((Storage)this, string, d2, d));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Double>(this, string, d));
        }
    }

    @Override
    public void put(String string, Enum<?> enum_) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Enum<?> enum_2 = bl ? this.get(string, enum_) : null;
        this.map.put(string, enum_);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent((Storage)this, string, enum_2, enum_));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent(this, string, enum_));
        }
    }

    @Override
    public void put(String string, Float f) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Float f2 = bl ? this.get(string, f) : null;
        this.map.put(string, f);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Float>((Storage)this, string, f2, f));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Float>(this, string, f));
        }
    }

    public void put(String string, int n) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Integer n2 = bl ? this.get(string, n) : null;
        this.map.put(string, n);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Integer>((Storage)this, string, n2, n));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Integer>(this, string, n));
        }
    }

    @Override
    public void put(String string, Integer n) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Integer n2 = bl ? this.get(string, n) : null;
        this.map.put(string, n);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Integer>((Storage)this, string, n2, n));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Integer>(this, string, n));
        }
    }

    public void put(String string, long l) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Long l2 = bl ? this.get(string, l) : null;
        this.map.put(string, l);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Long>((Storage)this, string, l2, l));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Long>(this, string, l));
        }
    }

    @Override
    public void put(String string, Long l) throws StorageException {
        boolean bl = this.map.containsKey(string);
        Long l2 = bl ? this.get(string, l) : null;
        this.map.put(string, l);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Long>((Storage)this, string, l2, l));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Long>(this, string, l));
        }
    }

    @Override
    public void put(String string, String string2) throws StorageException {
        boolean bl = this.map.containsKey(string);
        String string3 = bl ? this.get(string, string2) : null;
        this.map.put(string, string2);
        this.changed = true;
        if (!this.hasEventSender()) {
            return;
        }
        if (bl) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<String>((Storage)this, string, string3, string2));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<String>(this, string, string2));
        }
    }

    @Override
    public Object remove(String string) {
        Object object = this.map.remove(string);
        if (object != null) {
            this.changed = true;
            if (this.hasEventSender()) {
                this.getEventSender().fireEvent(new StorageKeyRemovedEvent<Object>(this, string, object));
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws StorageException {
        if (this.closed) {
            throw new StorageException("StorageChest already closed!");
        }
        if (!this.changed) {
            return;
        }
        Object object = JSonStorage.LOCK;
        synchronized (object) {
            String string = JSonStorage.getMapper().objectToString(this.map);
            JSonStorage.saveTo(this.file, this.plain, this.key, string);
        }
    }

    public void setAutoPutValues(boolean bl) {
        this.autoPutValues = bl;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        try {
            return JSonStorage.getMapper().objectToString(this.map);
        }
        catch (Throwable throwable) {
            return this.map.toString();
        }
    }
}

