/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.shutdown;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.utils.logging.Log;

public class ShutdownController
extends Thread {
    private static final ShutdownController INSTANCE = new ShutdownController();
    private final LinkedList<ShutdownEvent> hooks;
    private final ArrayList<ShutdownVetoListener> vetoListeners;
    private int exitCode = 0;
    private final AtomicInteger requestedShutDowns = new AtomicInteger(0);

    public static ShutdownController getInstance() {
        return INSTANCE;
    }

    public static void main(String[] stringArray) {
        Log.L.setLevel(Level.ALL);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public int getHookPriority() {
                return 1;
            }

            @Override
            public void run() {
                Log.L.finest("DO " + this.getHookPriority());
            }
        });
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public int getHookPriority() {
                return 3;
            }

            @Override
            public void run() {
                Log.L.finest("DO " + this.getHookPriority());
            }
        });
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public int getHookPriority() {
                return 2;
            }

            @Override
            public void run() {
                Log.L.finest("DO " + this.getHookPriority());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShutdownController() {
        super(ShutdownController.class.getSimpleName());
        this.hooks = new LinkedList();
        this.vetoListeners = new ArrayList();
        try {
            Map map;
            IdentityHashMap<Thread, Thread> identityHashMap = new IdentityHashMap<Thread, Thread>(){
                private static final long serialVersionUID = 8334628124340671103L;

                @Override
                public Thread put(Thread thread, Thread thread2) {
                    ShutdownEventWrapper shutdownEventWrapper = new ShutdownEventWrapper(thread2);
                    ShutdownController.this.addShutdownEvent(shutdownEventWrapper);
                    return null;
                }

                @Override
                public Thread remove(Object object) {
                    ShutdownController.this.removeShutdownEvent(new ShutdownEventWrapper((Thread)object));
                    return (Thread)object;
                }
            };
            Field field = Class.forName("java.lang.ApplicationShutdownHooks").getDeclaredField("hooks");
            field.setAccessible(true);
            Map map2 = map = (Map)field.get(null);
            synchronized (map2) {
                Set set = map.keySet();
                for (Thread thread : set) {
                    this.addShutdownEvent(new ShutdownEventWrapper(thread));
                }
                field.set(null, identityHashMap);
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
            Runtime.getRuntime().addShutdownHook(this);
        }
        Log.L.finest("Init ShutdownController");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownEvent(ShutdownEvent shutdownEvent) {
        if (this.isAlive()) {
            Log.exception(new IllegalStateException("Cannot add hooks during shutdown"));
            return;
        }
        LinkedList<ShutdownEvent> linkedList = this.hooks;
        synchronized (linkedList) {
            int n = 0;
            for (ShutdownEvent shutdownEvent2 : this.hooks) {
                if (shutdownEvent2.getHookPriority() <= shutdownEvent.getHookPriority()) {
                    this.hooks.add(n, shutdownEvent);
                    return;
                }
                ++n;
            }
            this.hooks.add(shutdownEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownVetoListener(ShutdownVetoListener shutdownVetoListener) {
        ArrayList<ShutdownVetoListener> arrayList = this.vetoListeners;
        synchronized (arrayList) {
            Log.L.finest("ADD " + shutdownVetoListener);
            this.vetoListeners.remove(shutdownVetoListener);
            this.vetoListeners.add(shutdownVetoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ShutdownVetoException> collectVetos() {
        ArrayList<ShutdownVetoException> arrayList = new ArrayList<ShutdownVetoException>();
        ArrayList<ShutdownVetoListener> arrayList2 = this.vetoListeners;
        synchronized (arrayList2) {
            for (ShutdownVetoListener shutdownVetoListener : this.vetoListeners) {
                try {
                    shutdownVetoListener.onShutdownRequest(arrayList.size());
                }
                catch (ShutdownVetoException shutdownVetoException) {
                    arrayList.add(shutdownVetoException);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private String getStackTrace(Thread thread) {
        try {
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            StringBuilder stringBuilder = new StringBuilder("");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuilder.append(stackTraceElement);
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasShutdownEvent(ShutdownEvent shutdownEvent) {
        LinkedList<ShutdownEvent> linkedList = this.hooks;
        synchronized (linkedList) {
            return this.hooks.contains(shutdownEvent);
        }
    }

    public boolean isShutDownRequested() {
        return this.requestedShutDowns.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownEvent(ShutdownEvent shutdownEvent) {
        if (this.isAlive()) {
            throw new IllegalStateException("Cannot add hooks during shutdown");
        }
        LinkedList<ShutdownEvent> linkedList = this.hooks;
        synchronized (linkedList) {
            Iterator iterator = this.hooks.iterator();
            while (iterator.hasNext()) {
                ShutdownEvent shutdownEvent2 = (ShutdownEvent)iterator.next();
                if (shutdownEvent2 != shutdownEvent) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownVetoListener(ShutdownVetoListener shutdownVetoListener) {
        ArrayList<ShutdownVetoListener> arrayList = this.vetoListeners;
        synchronized (arrayList) {
            Log.L.finest("Remove " + shutdownVetoListener);
            this.vetoListeners.remove(shutdownVetoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShutdown() {
        block18: {
            this.requestedShutDowns.incrementAndGet();
            try {
                ArrayList<ShutdownVetoException> arrayList = this.collectVetos();
                if (arrayList.size() == 0) {
                    Object object = this.vetoListeners;
                    synchronized (object) {
                        ShutdownVetoListener[] shutdownVetoListenerArray;
                        for (ShutdownVetoListener shutdownVetoListener : shutdownVetoListenerArray = this.vetoListeners.toArray(new ShutdownVetoListener[0])) {
                            try {
                                shutdownVetoListener.onShutdown();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    }
                    object = new Thread("ShutdownThread"){

                        @Override
                        public void run() {
                            System.exit(ShutdownController.this.getExitCode());
                        }
                    };
                    ((Thread)object).start();
                    while (((Thread)object).isAlive()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.requestedShutDowns.decrementAndGet();
                            return;
                        }
                    }
                    Log.L.finest("DONE");
                    break block18;
                }
                ArrayList<ShutdownVetoListener> arrayList2 = this.vetoListeners;
                synchronized (arrayList2) {
                    ShutdownVetoListener[] shutdownVetoListenerArray;
                    for (ShutdownVetoListener shutdownVetoListener : shutdownVetoListenerArray = this.vetoListeners.toArray(new ShutdownVetoListener[0])) {
                        shutdownVetoListener.onShutdownVeto(arrayList);
                    }
                }
            }
            finally {
                this.requestedShutDowns.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LinkedList<ShutdownEvent> linkedList = this.hooks;
            synchronized (linkedList) {
                int n = 0;
                for (ShutdownEvent shutdownEvent : this.hooks) {
                    try {
                        long l = System.currentTimeMillis();
                        Log.L.finest("[" + ++n + "/" + this.hooks.size() + "|Priority: " + shutdownEvent.getHookPriority() + "]" + "ShutdownController: start item->" + shutdownEvent);
                        Thread thread = new Thread(shutdownEvent);
                        thread.setName("ShutdownHook [" + n + "/" + this.hooks.size() + "|Priority: " + shutdownEvent.getHookPriority() + "]");
                        thread.start();
                        try {
                            thread.join(shutdownEvent.getMaxDuration());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        if (thread.isAlive()) {
                            Log.L.finest("[" + n + "/" + this.hooks.size() + "|Priority: " + shutdownEvent.getHookPriority() + "]" + "ShutdownController: " + shutdownEvent + "->is still running after " + shutdownEvent.getMaxDuration() + " ms");
                            Log.L.finest("[" + n + "/" + this.hooks.size() + "|Priority: " + shutdownEvent.getHookPriority() + "]" + "ShutdownController: " + shutdownEvent + "->StackTrace:\r\n" + this.getStackTrace(thread));
                            continue;
                        }
                        Log.L.finest("[" + n + "/" + this.hooks.size() + "|Priority: " + shutdownEvent.getHookPriority() + "]" + "ShutdownController: item ended after->" + (System.currentTimeMillis() - l));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setExitCode(int n) {
        this.exitCode = n;
    }

    class ShutdownEventWrapper
    extends ShutdownEvent {
        private final Thread orgThread;

        public ShutdownEventWrapper(Thread thread) {
            this.orgThread = thread;
            this.setHookPriority(Integer.MIN_VALUE);
        }

        public boolean equals(Object object) {
            if (object instanceof ShutdownEventWrapper) {
                return this.orgThread == ((ShutdownEventWrapper)object).orgThread;
            }
            return false;
        }

        public int hashCode() {
            return this.orgThread.hashCode();
        }

        @Override
        public void run() {
            this.orgThread.run();
        }

        @Override
        public String toString() {
            return "ShutdownEventWrapper " + this.orgThread + " - " + this.orgThread.getClass().getName() + " Priority: " + this.getHookPriority();
        }
    }
}

