/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import java.util.HashMap;
import java.util.Map;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.decrypter.TbCm;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

@HostPlugin(revision="$Revision: 19806 $", interfaceVersion=2, names={"youtube.com"}, urls={"(httpJDYoutube://[\\w\\.\\-]*?youtube\\.com/(videoplayback\\?.+|get_video\\?.*?video_id=.+&.+(&fmt=\\d+)?))|(httpJDYoutube://video\\.google\\.com/timedtext\\?type=track&name=.*?\\&lang=[a-z]{2}\\&v=[a-z\\-_A-Z0-9]+)|(httpJDYoutube://img\\.youtube.com/vi/[a-z\\-_A-Z0-9]+/(hqdefault|mqdefault|default|maxresdefault).jpg)"}, flags={2})
public class Youtube
extends PluginForHost {
    private static Object lock = new Object();
    private boolean prem = false;
    private static final String ISVIDEOANDPLAYLIST = "ISVIDEOANDPLAYLIST";
    private static final String IDASFILENAME = "ISASFILENAME";
    private static final String IDINFILENAME = "IDINFILENAME_V2";
    private static final String USEUPLOADERINNAME = "USEUPLOADERINNAME";
    private static final String ALLOW_MP3 = "ALLOW_MP3_V2";
    private static final String ALLOW_MP4 = "ALLOW_MP4_V2";
    private static final String ALLOW_WEBM = "ALLOW_WEBM_V2";
    private static final String ALLOW_FLV = "ALLOW_FLV_V2";
    private static final String ALLOW_3GP = "ALLOW_3GP_V2";
    private static final String ALLOW_240P = "ALLOW_240P_V2";
    private static final String ALLOW_360P = "ALLOW_360P_V2";
    private static final String ALLOW_480P = "ALLOW_480P_V2";
    private static final String ALLOW_720P = "ALLOW_720P_V2";
    private static final String ALLOW_1080P = "ALLOW_1080P_V2";
    private static final String ALLOW_ORIGINAL = "ALLOW_ORIGINAL_V2";
    private static final String ALLOW_BEST = "ALLOW_BEST2";
    private static final String ALLOW_SUBTITLES = "ALLOW_SUBTITLES_V2";
    private static final String GROUP_FORMAT = "GROUP_FORMAT";
    private static final String ALLOW_THUMBNAIL_MAX = "ALLOW_THUMBNAIL_MAX";
    private static final String ALLOW_THUMBNAIL_HQ = "ALLOW_THUMBNAIL_HQ";
    private static final String ALLOW_THUMBNAIL_MQ = "ALLOW_THUMBNAIL_MQ";
    private static final String ALLOW_THUMBNAIL_DEFAULT = "ALLOW_THUMBNAIL_DEFAULT";
    private static final String FAST_CHECK = "FAST_CHECK2";
    private static final String PROXY_ACTIVE = "PROXY_ACTIVE";
    private static final String PROXY_ADDRESS = "PROXY_ADDRESS";
    private static final String PROXY_PORT = "PROXY_PORT";

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': 
                case '\\': {
                    char c2 = c;
                    c = string.charAt(++i);
                    StringBuilder stringBuilder2 = null;
                    switch (c) {
                        case 'u': {
                            stringBuilder2 = new StringBuilder();
                            int n = ++i + 4;
                            while (i < n) {
                                c = string.charAt(i);
                                if (stringBuilder2.length() > 0 || c != '0') {
                                    stringBuilder2.append(c);
                                }
                                ++i;
                            }
                            --i;
                            stringBuilder.append((char)Long.parseLong(stringBuilder2.toString(), 16));
                            continue block7;
                        }
                        case 'x': {
                            stringBuilder2 = new StringBuilder();
                            int n = ++i + 2;
                            while (i < n) {
                                c = string.charAt(i);
                                stringBuilder2.append(c);
                                ++i;
                            }
                            --i;
                            stringBuilder.append((char)Long.parseLong(stringBuilder2.toString(), 16));
                            continue block7;
                        }
                    }
                    if (c2 == '%') {
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public Youtube(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        this.enablePremium("http://www.youtube.com/login?next=/index");
        this.setConfigElements();
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) throws Exception {
        downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceFirst("httpJDYoutube", "http"));
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        AccountInfo accountInfo = new AccountInfo();
        try {
            this.login(account, this.br, true, true);
        }
        catch (PluginException pluginException) {
            account.setValid(false);
            return accountInfo;
        }
        accountInfo.setStatus(JDL.L("plugins.hoster.youtube.accountok", "Account is OK."));
        accountInfo.setValidUntil(-1L);
        account.setValid(true);
        return accountInfo;
    }

    @Override
    public String getAGBLink() {
        return "http://youtube.com/t/terms";
    }

    @Override
    public String getDescription() {
        return "JDownloader's YouTube Plugin helps downloading VideoClip from youtube.com. YouTube provides different video formats and qualities. JDownloader is able to extract audio after download, and save it as mp3 file. \r\n - Hear your favourite YouTube Clips on your MP3 Player.";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return 20;
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.setBrowserExclusive();
        this.prem = false;
        downloadLink.setProperty("valid", false);
        this.requestFileInformation(downloadLink);
        this.br.setDebug(true);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), true, 0);
        if (!(this.dl.getConnection().isContentDisposition() || this.dl.getConnection().getContentType().startsWith("video") || downloadLink.getBooleanProperty("subtitle", false).booleanValue() || downloadLink.getBooleanProperty("thumbnail", false).booleanValue())) {
            downloadLink.setProperty("valid", false);
            this.dl.getConnection().disconnect();
            throw new PluginException(4);
        }
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    @Override
    public void handlePremium(DownloadLink downloadLink, Account account) throws Exception {
        this.login(account, this.br, false, false);
        this.prem = true;
        this.requestFileInformation(downloadLink);
        this.br.setDebug(true);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), true, 0);
        if (!this.dl.getConnection().isContentDisposition() && !this.dl.getConnection().getContentType().startsWith("video")) {
            downloadLink.setProperty("valid", false);
            this.dl.getConnection().disconnect();
            throw new PluginException(4);
        }
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Account account, Browser browser, boolean bl, boolean bl2) throws Exception {
        Object object = lock;
        synchronized (object) {
            if (browser == null) {
                browser = this.br;
            }
            try {
                Object object2;
                Object object3;
                Object object5;
                browser.setDebug(true);
                this.setBrowserExclusive();
                if (account.getProperty("cookies") != null && (object5 = (HashMap)account.getProperty("cookies")) != null && ((HashMap)object5).containsKey("LOGIN_INFO")) {
                    for (Map.Entry object42 : ((HashMap)object5).entrySet()) {
                        object3 = (String)object42.getKey();
                        object2 = (String)object42.getValue();
                        browser.setCookie("youtube.com", (String)object3, (String)object2);
                    }
                    if (!bl) {
                        return;
                    }
                    browser.getPage("http://www.youtube.com");
                    if (!browser.containsHTML("<span class=\"yt-uix-button-content\">Sign In </span></button></div>")) {
                        return;
                    }
                }
                browser.setFollowRedirects(true);
                browser.getPage("http://www.youtube.com/");
                browser.getPage("https://www.google.com/accounts/ServiceLogin?uilel=3&service=youtube&passive=true&continue=http%3A%2F%2Fwww.youtube.com%2Fsignin%3Faction_handle_signin%3Dtrue%26nomobiletemp%3D1%26hl%3Den_US%26next%3D%252Findex&hl=en_US&ltmpl=sso");
                object5 = browser.getRegex("iframeUri: '(https.*?)'").getMatch(0);
                if (object5 != null) {
                    object5 = Youtube.unescape((String)object5);
                    browser.cloneBrowser().getPage((String)object5);
                }
                Form form = browser.getForm(0);
                form.put("pstMsg", "1");
                form.put("dnConn", "https%3A%2F%2Faccounts.youtube.com&continue=http%3A%2F%2Fwww.youtube.com%2Fsignin%3Faction_handle_signin%3Dtrue%26nomobiletemp%3D1%26hl%3Den_US%26next%3D%252F");
                form.put("Email", Encoding.urlEncode(account.getUser()));
                form.put("Passwd", Encoding.urlEncode(account.getPass()));
                form.put("GALX", browser.getCookie("http://www.google.com", "GALX"));
                form.put("timeStmp", "");
                form.put("secTok", "");
                form.put("rmShown", "1");
                form.put("signIn", "Anmelden");
                form.put("asts", "");
                browser.setFollowRedirects(false);
                String string = browser.getCookie("http://www.google.com", "GALX");
                if (string == null) {
                    throw new PluginException(0x400000);
                }
                browser.submitForm(form);
                if (browser.getRedirectLocation() == null) {
                    object3 = Encoding.htmlDecode(browser.toString());
                    object2 = new Regex((String)object3, "url='(http://.*?)'").getMatch(0);
                    if (object2 == null) {
                        account.setValid(false);
                        throw new PluginException(256, 1L);
                    }
                    browser.getPage((String)object2);
                }
                browser.getPage(browser.getRedirectLocation());
                if (browser.containsHTML("Google will check if this")) {
                    account.setValid(false);
                    throw new PluginException(256, 1L);
                }
                if (browser.containsHTML("2-step verification")) {
                    object3 = browser.getForm(0);
                    ((Form)object3).remove("exp");
                    ((Form)object3).remove("ltmpl");
                    browser.setFollowRedirects(true);
                    browser.submitForm((Form)object3);
                    if (browser.containsHTML("The code you entered didn&#39;t verify")) {
                        account.setValid(false);
                        throw new PluginException(256, JDL.L("plugins.hoster.youtube.2step.failed", "2-Step verification code couldn't be verified!"));
                    }
                    object3 = browser.getForm(0);
                    ((Form)object3).remove("nojssubmit");
                    browser.submitForm((Form)object3);
                    browser.getPage("http://www.youtube.com/signin?action_handle_signin=true");
                } else {
                    browser.setFollowRedirects(true);
                    browser.getPage(browser.getRedirectLocation());
                    object3 = Youtube.unescape(browser.getRegex("location\\.replace\\(\"(.*?)\"").getMatch(0));
                    browser.getPage((String)object3);
                }
                if (browser.getCookie("http://www.youtube.com", "LOGIN_INFO") == null) {
                    account.setValid(false);
                    throw new PluginException(256, 1L);
                }
                object3 = new HashMap<String, String>();
                object2 = browser.getCookies("youtube.com");
                for (Cookie cookie : ((Cookies)object2).getCookies()) {
                    ((HashMap)object3).put(cookie.getKey(), cookie.getValue());
                }
                account.setProperty("cookies", object3);
            }
            catch (PluginException pluginException) {
                account.setProperty("cookies", null);
                throw pluginException;
            }
        }
    }

    private void postprocess(DownloadLink downloadLink) {
        if (downloadLink.getProperty("convertto") != null) {
            TbCm.DestinationFormat destinationFormat = TbCm.DestinationFormat.valueOf(downloadLink.getProperty("convertto").toString());
            TbCm.DestinationFormat destinationFormat2 = TbCm.DestinationFormat.VIDEOFLV;
            if (destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEOWEBM) || destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEOMP4) || destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEO3GP)) {
                destinationFormat2 = destinationFormat;
            }
            if (destinationFormat.equals((Object)TbCm.DestinationFormat.AUDIOAAC)) {
                destinationFormat2 = TbCm.DestinationFormat.VIDEOMP4;
            }
            if (!TbCm.ConvertFile(downloadLink, destinationFormat2, destinationFormat)) {
                this.logger.severe("Video-Convert failed!");
            }
        }
        if (downloadLink.getBooleanProperty("subtitle", false).booleanValue() && !TbCm.convertSubtitle(downloadLink)) {
            this.logger.severe("Subtitle conversion failed!");
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws Exception {
        if (downloadLink.getBooleanProperty("subtitle", false).booleanValue() || downloadLink.getBooleanProperty("thumbnail", false).booleanValue()) {
            URLConnectionAdapter uRLConnectionAdapter = this.br.openGetConnection(downloadLink.getDownloadURL());
            if (uRLConnectionAdapter.getResponseCode() == 404) {
                return DownloadLink.AvailableStatus.FALSE;
            }
            String string = uRLConnectionAdapter.getHeaderField("Content-Length");
            downloadLink.setDownloadSize(Long.parseLong(string));
            return DownloadLink.AvailableStatus.TRUE;
        }
        downloadLink.setProperty("STREAMING", true);
        for (int i = 0; i < 4; ++i) {
            if (downloadLink.getBooleanProperty("valid", true).booleanValue()) {
                downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
                downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
                return DownloadLink.AvailableStatus.TRUE;
            }
            downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
            downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
            PluginForDecrypt pluginForDecrypt = JDUtilities.getPluginForDecrypt("youtube.com");
            if (pluginForDecrypt == null) {
                throw new PluginException(0x400000, "cannot decrypt videolink");
            }
            if (downloadLink.getStringProperty("fmtNew", null) == null) {
                throw new PluginException(131072, "You have to add link again");
            }
            if (downloadLink.getStringProperty("videolink", null) == null) {
                throw new PluginException(131072, "You have to add link again");
            }
            HashMap<Integer, String[]> hashMap = ((TbCm)pluginForDecrypt).getLinks(downloadLink.getStringProperty("videolink", null), this.prem, this.br, 0);
            if (hashMap == null || hashMap.isEmpty()) {
                if (this.br.containsHTML("<div\\s+id=\"verify-age-actions\">")) {
                    throw new PluginException(131072, "The entered account couldn't pass the age verification!");
                }
                throw new PluginException(32);
            }
            if (hashMap.get(downloadLink.getIntegerProperty("fmtNew", 0)) != null) {
                downloadLink.setUrlDownload(hashMap.get(downloadLink.getIntegerProperty("fmtNew", 0))[0]);
                return DownloadLink.AvailableStatus.TRUE;
            }
            Thread.sleep(5000L);
        }
        throw new PluginException(32);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
        downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
        downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
        downloadLink.setProperty("valid", false);
    }

    @Override
    public void resetPluginGlobals() {
    }

    private void setConfigElements() {
        this.getConfig().addEntry(new ConfigEntry(15, this.getPluginConfig(), ISVIDEOANDPLAYLIST, new String[]{JDL.L("plugins.host.youtube.isvideoandplaylist.video", "Only add video"), JDL.L("plugins.host.youtube.isvideoandplaylist.playlist", "Add playlist and video"), JDL.L("plugins.host.youtube.isvideoandplaylist.ask", "Ask everytime")}, JDL.L("plugins.host.youtube.isvideoandplaylist", "If a video also contains a playlist?")).setDefaultValue(2));
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), FAST_CHECK, JDL.L("plugins.hoster.youtube.fast", "Fast LinkCheck?")).setDefaultValue(false));
        ConfigEntry configEntry = new ConfigEntry(3, this.getPluginConfig(), IDASFILENAME, JDL.L("plugins.hoster.youtube.idasfilename", "Use Video-ID as filename?")).setDefaultValue(false);
        this.getConfig().addEntry(configEntry);
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), IDINFILENAME, JDL.L("plugins.hoster.youtube.idinfilename", "Use Video-ID additionally in filename?")).setDefaultValue(false).setEnabledCondidtion(configEntry, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), USEUPLOADERINNAME, JDL.L("plugins.hoster.youtube.useuploaderinname", "Use uploader name in filename?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_SUBTITLES, JDL.L("plugins.hoster.youtube.grabsubtitles", "Grab subtitles?")).setDefaultValue(true));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), GROUP_FORMAT, JDL.L("plugins.hoster.youtube.groupbyformat", "Group by format?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(6));
        ConfigEntry configEntry2 = new ConfigEntry(3, this.getPluginConfig(), ALLOW_BEST, JDL.L("plugins.hoster.youtube.checkbest", "Only grab best available resolution")).setDefaultValue(false);
        this.getConfig().addEntry(configEntry2);
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_WEBM, JDL.L("plugins.hoster.youtube.checkwebm", "Grab WEBM?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_MP4, JDL.L("plugins.hoster.youtube.checkmp4", "Grab MP4?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_MP3, JDL.L("plugins.hoster.youtube.checkmp3", "Grab MP3?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_FLV, JDL.L("plugins.hoster.youtube.checkflv", "Grab FLV?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_3GP, JDL.L("plugins.hoster.youtube.check3gp", "Grab 3GP?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_240P, JDL.L("plugins.hoster.youtube.check240p", "Grab 240p?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_360P, JDL.L("plugins.hoster.youtube.check360p", "Grab 360p?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_480P, JDL.L("plugins.hoster.youtube.check480p", "Grab 480p?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_720P, JDL.L("plugins.hoster.youtube.check720p", "Grab 720p?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_1080P, JDL.L("plugins.hoster.youtube.check1080p", "Grab 1080p?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_ORIGINAL, JDL.L("plugins.hoster.youtube.checkoriginal", "Grab Original?")).setDefaultValue(true).setEnabledCondidtion(configEntry2, false));
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_THUMBNAIL_MAX, JDL.L("plugins.hoster.youtube.grabrhumbnailmax", "Grab max. resulution thumbnail?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_THUMBNAIL_HQ, JDL.L("plugins.hoster.youtube.grabrhumbnailhq", "Grab HQ (480x360) thumbnail?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_THUMBNAIL_MQ, JDL.L("plugins.hoster.youtube.grabrhumbnailmq", "Grab MQ (320x180) thumbnail?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_THUMBNAIL_DEFAULT, JDL.L("plugins.hoster.youtube.grabrhumbnaildefault", "Grab default (120x90) thumbnail?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), PROXY_ACTIVE, JDL.L("plugins.hoster.youtube.proxyactive", "Use HTTP Proxy?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(0, this.getPluginConfig(), PROXY_ADDRESS, JDL.L("plugins.hoster.youtube.proxyaddress", "Proxy Address")));
        this.getConfig().addEntry(new ConfigEntry(0, this.getPluginConfig(), PROXY_PORT, JDL.L("plugins.hoster.youtube.proxyport", "Proxy Port")));
    }
}

