/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.logging.Level;
import jd.controlling.JDLogger;
import jd.http.Request;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging.Log;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class RAFDownload
extends DownloadInterface {
    public static final Object HASHCHECKLOCK = new Object();
    private RandomAccessFile outputFile;

    public RAFDownload(PluginForHost pluginForHost, DownloadLink downloadLink, Request request) throws IOException, PluginException {
        super(pluginForHost, downloadLink, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChunksReady() {
        this.logger.info("Close connections if they are not closed yet");
        try {
            for (DownloadInterface.Chunk object : this.getChunks()) {
                object.closeConnections();
            }
        }
        finally {
            this.logger.info("Close File. Let AV programs run");
            try {
                this.outputFile.close();
            }
            catch (Throwable throwable) {}
        }
        this.downloadLink.getLinkStatus().setStatusText(null);
        if (!this.handleErrors()) {
            return;
        }
        try {
            File file = new File(this.downloadLink.getFileOutput() + ".part");
            if (JsonConfig.create(GeneralSettings.class).isHashCheckEnabled()) {
                Object object = HASHCHECKLOCK;
                synchronized (object) {
                    Object object2;
                    String string = null;
                    String string2 = null;
                    Boolean throwable = null;
                    string = this.downloadLink.getMD5Hash();
                    if (string != null) {
                        string2 = "MD5";
                        this.downloadLink.getLinkStatus().setStatusText(_JDT._.system_download_doCRC2("MD5"));
                        object2 = Hash.getMD5(file);
                        throwable = string.equalsIgnoreCase((String)object2);
                    } else {
                        string = this.downloadLink.getSha1Hash();
                        if (string != null) {
                            string2 = "MD5";
                            this.downloadLink.getLinkStatus().setStatusText(_JDT._.system_download_doCRC2("SHA1"));
                            object2 = Hash.getSHA1(file);
                            throwable = string.equalsIgnoreCase((String)object2);
                        } else {
                            object2 = null;
                            Object object3 = this.downloadLink.getFilePackage();
                            synchronized (object3) {
                                for (DownloadLink downloadLink : this.downloadLink.getFilePackage().getChildren()) {
                                    if (!downloadLink.getFileOutput().toLowerCase().endsWith(".sfv")) continue;
                                    object2 = downloadLink;
                                    break;
                                }
                            }
                            if (object2 != null && ((DownloadLink)object2).getLinkStatus().hasStatus(2) && (object3 = IO.readFileToString(new File(((DownloadLink)object2).getFileOutput()))) != null && (object3 = ((String)object3).replaceAll(";(.*?)[\r\n]{1,2}", "")) != null && ((String)object3).contains(this.downloadLink.getName())) {
                                this.downloadLink.getLinkStatus().setStatusText(_JDT._.system_download_doCRC2("CRC32"));
                                string2 = "CRC32";
                                String string3 = Long.toHexString(Hash.getCRC32(file));
                                throwable = new Regex((String)object3, this.downloadLink.getName() + "\\s*" + (String)string3).matches();
                            }
                        }
                    }
                    if (throwable != null) {
                        this.hashCheckFinished(string2, throwable);
                    }
                }
            }
            File file2 = new File(this.downloadLink.getFileOutput());
            boolean bl = false;
            for (int i = 5; i > 0 && !(bl = file.renameTo(file2)); --i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException date) {
                    break;
                }
            }
            if (!bl) {
                this.logger.severe("Could not rename file " + file + " to " + file2);
                this.logger.severe("Try copy workaround!");
                try {
                    if (Application.getJavaVersion() >= Application.JAVA16) {
                        long l = 0L;
                        l = file.getParentFile().getFreeSpace();
                        if (l > 0L && l < file.length()) {
                            throw new Throwable("not enough diskspace free to copy part to complete file");
                        }
                    }
                    IO.copyFile(file, file2);
                    bl = true;
                    file.deleteOnExit();
                    file.delete();
                }
                catch (Throwable throwable) {
                    this.logger.log(Level.SEVERE, "Exception", throwable);
                    file2.delete();
                    file2.deleteOnExit();
                }
                if (!bl) {
                    this.logger.severe("Copy workaround: :(");
                    this.error(0x200000, _JDT._.system_download_errors_couldnotrename());
                } else {
                    this.logger.severe("Copy workaround: :)");
                }
            }
            if (bl) {
                Date date = TimeFormatter.parseDateString(this.connection.getHeaderField("Last-Modified"));
                if (date != null && JsonConfig.create(GeneralSettings.class).isUseOriginalLastModified()) {
                    file2.setLastModified(date.getTime());
                } else {
                    file2.setLastModified(System.currentTimeMillis());
                }
            }
        }
        catch (Exception exception) {
            Log.exception(exception);
            this.addException(exception);
        }
    }

    private void hashCheckFinished(String string, boolean bl) {
        this.logger.info(string + "-Check: " + (bl ? "ok" : "failed"));
        if (bl) {
            this.downloadLink.getLinkStatus().setStatusText(_JDT._.system_download_doCRC2_success(string));
        } else {
            String string2 = _JDT._.system_download_doCRC2_failed(string);
            this.downloadLink.getLinkStatus().removeStatus(2);
            this.downloadLink.getLinkStatus().setStatusText(string2);
            this.downloadLink.getLinkStatus().setValue(0x8000000L);
            this.error(16384, string2);
        }
    }

    @Override
    protected void setupChunks() throws Exception {
        try {
            if (this.isResume() && this.checkResumabled()) {
                this.logger.finer("Setup resume");
                this.setupResume();
            } else {
                this.logger.finer("Setup virgin download");
                this.setupVirginStart();
            }
        }
        catch (Exception exception) {
            try {
                this.logger.info("CLOSE HD FILE");
                this.outputFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.addException(exception);
            throw exception;
        }
    }

    private void setupVirginStart() throws FileNotFoundException {
        DownloadInterface.Chunk chunk;
        this.totaleLinkBytesLoaded = 0L;
        this.downloadLink.setDownloadCurrent(0L);
        long l = this.fileSize / (long)this.getChunkNum();
        if (this.connection.getRange() != null) {
            if (this.connection.getRange()[1] == this.connection.getRange()[2] - 1L || this.connection.getRange()[1] == this.connection.getRange()[2]) {
                this.logger.warning("Chunkload protection. this may cause traffic errors");
                l = this.fileSize / (long)this.getChunkNum();
            } else {
                l = (this.fileSize - this.connection.getLongContentLength()) / (long)(this.getChunkNum() - 1);
            }
        }
        if (l <= 0L) {
            this.logger.warning("Could not get Filesize.... reset chunks to 1");
            this.setChunkNum(1);
        }
        this.logger.finer("Start Download in " + this.getChunkNum() + " chunks. Chunksize: " + l);
        this.createOutputChannel();
        this.downloadLink.setChunksProgress(new long[this.chunkNum]);
        this.addToChunksInProgress(this.getChunkNum());
        int n = 0;
        long l2 = 0L;
        if (this.connection.getRange() != null && this.connection.getRange()[1] != this.connection.getRange()[2] - 1L) {
            l2 = this.connection.getRange()[1];
            chunk = new DownloadInterface.Chunk(0L, l2, this.connection, this);
            ++l2;
            this.logger.finer("Setup chunk 0: " + chunk);
            this.addChunk(chunk);
            ++n;
        }
        for (int i = n; i < this.getChunkNum(); ++i) {
            if (i == this.getChunkNum() - 1) {
                chunk = new DownloadInterface.Chunk(l2, -1L, this.connection, this);
            } else {
                chunk = new DownloadInterface.Chunk(l2, l2 + l - 1L, this.connection, this);
                l2 += l;
            }
            this.logger.finer("Setup chunk " + i + ": " + chunk);
            this.addChunk(chunk);
        }
    }

    private void createOutputChannel() throws FileNotFoundException {
        if (!new File(this.downloadLink.getFileOutput()).getParentFile().exists()) {
            new File(this.downloadLink.getFileOutput()).getParentFile().mkdirs();
        }
        this.outputFile = new RandomAccessFile(this.downloadLink.getFileOutput() + ".part", "rw");
    }

    private void setupResume() throws FileNotFoundException {
        long l = this.fileSize / (long)this.getChunkNum();
        this.logger.info("Resume: " + this.fileSize + " partsize: " + l);
        this.createOutputChannel();
        this.addToChunksInProgress(this.getChunkNum());
        for (int i = 0; i < this.getChunkNum(); ++i) {
            DownloadInterface.Chunk chunk;
            if (i == this.getChunkNum() - 1) {
                chunk = new DownloadInterface.Chunk(this.downloadLink.getChunksProgress()[i] == 0L ? 0L : this.downloadLink.getChunksProgress()[i] + 1L, -1L, this.connection, this);
                chunk.setLoaded(this.downloadLink.getChunksProgress()[i] - (long)i * l + 1L);
            } else {
                chunk = new DownloadInterface.Chunk(this.downloadLink.getChunksProgress()[i] == 0L ? 0L : this.downloadLink.getChunksProgress()[i] + 1L, (long)(i + 1) * l - 1L, this.connection, this);
                chunk.setLoaded(this.downloadLink.getChunksProgress()[i] - (long)i * l + 1L);
            }
            this.logger.finer("Setup chunk " + i + ": " + chunk);
            this.addChunk(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeChunkBytes(DownloadInterface.Chunk chunk) {
        try {
            RandomAccessFile randomAccessFile = this.outputFile;
            synchronized (randomAccessFile) {
                this.outputFile.seek(chunk.getWritePosition());
                this.outputFile.write(chunk.buffer.getInternalBuffer(), 0, chunk.buffer.size());
                if (chunk.getID() >= 0) {
                    this.downloadLink.getChunksProgress()[chunk.getID()] = chunk.getCurrentBytesPosition() - 1L;
                }
                return true;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            this.error(0x200000, Exceptions.getStackTrace(exception));
            this.addException(exception);
            return false;
        }
    }

    public static DownloadInterface download(DownloadLink downloadLink, Request request, boolean bl, int n) throws IOException, PluginException {
        request.getHeaders().put("Accept-Encoding", null);
        RAFDownload rAFDownload = new RAFDownload(downloadLink.getLivePlugin(), downloadLink, request);
        PluginForHost pluginForHost = downloadLink.getLivePlugin();
        if (pluginForHost != null) {
            pluginForHost.setDownloadInterface(rAFDownload);
        }
        if (n == 0) {
            rAFDownload.setChunkNum(JsonConfig.create(GeneralSettings.class).getMaxChunksPerFile());
        } else {
            rAFDownload.setChunkNum(n < 0 ? Math.min(n * -1, JsonConfig.create(GeneralSettings.class).getMaxChunksPerFile()) : n);
        }
        rAFDownload.setResume(bl);
        return rAFDownload;
    }

    public static DownloadInterface download(DownloadLink downloadLink, Request request) throws Exception {
        return RAFDownload.download(downloadLink, request, false, 1);
    }

    @Override
    public void cleanupDownladInterface() {
        try {
            this.outputFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

