/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import jd.controlling.GarbageController;
import jd.controlling.JDLogger;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Regex;
import org.appwork.utils.ReusableByteArrayOutputStreamPool;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.translate._JDT;

public abstract class DownloadInterface {
    public static final int ERROR_REDIRECTED = -1;
    public Logger logger = null;
    protected int chunkNum = 1;
    private Vector<Chunk> chunks = new Vector();
    private ManagedThrottledConnectionHandler connectionHandler = null;
    private int chunksDownloading = 0;
    private int chunksInProgress = 0;
    protected URLConnectionAdapter connection;
    protected DownloadLink downloadLink;
    private Vector<Integer> errors = new Vector();
    private Vector<Exception> exceptions = null;
    protected long fileSize = -1L;
    protected LinkStatus linkStatus;
    protected PluginForHost plugin;
    private int readTimeout = 100000;
    private int requestTimeout = 100000;
    private boolean resume = false;
    private boolean fixWrongContentDispositionHeader = false;
    private boolean allowFilenameFromURL = false;
    protected long totaleLinkBytesLoaded = 0L;
    private boolean waitFlag = true;
    private boolean fatalErrorOccured = false;
    private boolean doFileSizeCheck = true;
    private Request request = null;
    private boolean fileSizeVerified = false;
    private boolean connected;
    private boolean firstChunkRangeless;
    private int chunksStarted = 0;
    private Browser browser;
    private volatile boolean externalStop = false;
    private boolean resumable = false;

    public long getTotaleLinkBytesLoaded() {
        return this.totaleLinkBytesLoaded;
    }

    public void setFilenameFix(boolean bl) {
        this.fixWrongContentDispositionHeader = bl;
    }

    public synchronized void addChunksStarted(int n) {
        this.chunksStarted += n;
    }

    public synchronized int getChunksStarted() {
        return this.chunksStarted;
    }

    public void setAllowFilenameFromURL(boolean bl) {
        this.allowFilenameFromURL = bl;
    }

    private DownloadInterface(PluginForHost pluginForHost, DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
        this.plugin = pluginForHost;
        this.logger = pluginForHost.getLogger();
        this.linkStatus = downloadLink.getLinkStatus();
        this.linkStatus.setStatusText(_JDT._.download_connection_normal());
        this.browser = pluginForHost.getBrowser().cloneBrowser();
        downloadLink.setDownloadInstance(this);
        this.requestTimeout = JsonConfig.create(GeneralSettings.class).getHttpConnectTimeout();
        this.readTimeout = JsonConfig.create(GeneralSettings.class).getHttpReadTimeout();
        this.connectionHandler = new ManagedThrottledConnectionHandler(downloadLink);
    }

    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    public int getSpeed() {
        return this.connectionHandler.getSpeed();
    }

    public DownloadInterface(PluginForHost pluginForHost, DownloadLink downloadLink, Request request) throws IOException, PluginException {
        this(pluginForHost, downloadLink);
        this.request = request;
    }

    public boolean isFileSizeVerified() {
        return this.fileSizeVerified;
    }

    public void setFileSizeVerified(boolean bl) throws PluginException {
        this.fileSizeVerified = bl;
        if (this.fileSize <= 0L && bl) {
            this.logger.severe("Downloadsize==0");
            throw new PluginException(2048, 1200000L);
        }
    }

    protected boolean checkResumabled() {
        if (this.downloadLink.getChunksProgress() == null || this.downloadLink.getChunksProgress().length == 0) {
            return false;
        }
        long l = this.getFileSize();
        int n = this.downloadLink.getChunksProgress().length;
        long l2 = l / (long)n;
        long l3 = -1L;
        for (int i = 0; i < n; ++i) {
            long l4 = this.downloadLink.getChunksProgress()[i] - (long)i * l2;
            if (l4 < 0L) {
                return false;
            }
            if (this.downloadLink.getChunksProgress()[i] <= l3) {
                return false;
            }
            l3 = this.downloadLink.getChunksProgress()[i];
        }
        if (n > 0) {
            if (n <= this.getChunkNum()) {
                this.setChunkNum(n);
            } else {
                this.logger.info("Download has " + n + " Chunks but only " + this.getChunkNum() + " allowed! Change to 1!");
                this.setChunkNum(1);
                this.downloadLink.setChunksProgress(new long[]{this.downloadLink.getChunksProgress()[0]});
            }
            return true;
        }
        return false;
    }

    public URLConnectionAdapter connect(Browser browser) throws Exception {
        this.setReadTimeout(browser.getReadTimeout());
        this.setRequestTimeout(browser.getConnectTimeout());
        this.request.setConnectTimeout(this.getRequestTimeout());
        this.request.setReadTimeout(this.getReadTimeout());
        browser.setRequest(this.request);
        URLConnectionAdapter uRLConnectionAdapter = this.connect();
        browser.updateCookies(this.request);
        return uRLConnectionAdapter;
    }

    public URLConnectionAdapter connect() throws Exception {
        this.logger.finer("Connect...");
        if (this.request == null) {
            throw new IllegalStateException("Wrong Mode. Instance is in direct Connection mode");
        }
        this.connected = true;
        if (this.isResume() && this.checkResumabled()) {
            this.connectResumable();
        } else {
            int n;
            if (this.isFileSizeVerified() && (n = Math.min(Math.max(1, (int)(this.downloadLink.getDownloadSize() / 0x100000L)), this.getChunkNum())) != this.getChunkNum()) {
                this.logger.finer("Corrected Chunknum: " + this.getChunkNum() + " -->" + n);
                this.setChunkNum(n);
            }
            if (this.isFileSizeVerified() && this.downloadLink.getDownloadSize() > 0L && this.getChunkNum() > 1 && !this.isFirstChunkRangeless()) {
                this.connectFirstRange();
            } else {
                this.request.getHeaders().remove("Range");
                this.browser.connect(this.request);
            }
        }
        if (this.plugin.getBrowser().isDebug()) {
            this.logger.finest(this.request.printHeaders());
        }
        this.connection = this.request.getHttpConnection();
        if (this.request.getLocation() != null) {
            throw new PluginException(16384, -1L);
        }
        if (this.connection.getRange() != null) {
            if (this.connection.getRange()[2] > 0L) {
                this.setFilesizeCheck(true);
                this.downloadLink.setDownloadSize(this.connection.getRange()[2]);
            }
        } else if (this.connection.getLongContentLength() > 0L) {
            this.setFilesizeCheck(true);
            this.downloadLink.setDownloadSize(this.connection.getLongContentLength());
        }
        this.fileSize = this.downloadLink.getDownloadSize();
        return this.connection;
    }

    private void connectFirstRange() throws IOException {
        long l = this.downloadLink.getDownloadSize() / (long)this.getChunkNum();
        this.request.getHeaders().put("Range", "bytes=0-" + (l - 1L));
        this.browser.connect(this.request);
        if (this.request.getHttpConnection().getResponseCode() == 416) {
            this.logger.warning("HTTP/1.1 416 Requested Range Not Satisfiable");
            if (this.plugin.getBrowser().isDebug()) {
                this.logger.finest(this.request.printHeaders());
            }
            throw new IllegalStateException("HTTP/1.1 416 Requested Range Not Satisfiable");
        }
        if (this.request.getHttpConnection().getRange() == null) {
            this.logger.warning("No Chunkload");
            this.setChunkNum(1);
        } else {
            if (this.request.getHttpConnection().getRange()[0] != 0L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + ". Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
            if (this.request.getHttpConnection().getRange()[1] < l - 2L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
            if (this.request.getHttpConnection().getRange()[1] == this.request.getHttpConnection().getRange()[2] - 1L && this.getChunkNum() > 1) {
                this.logger.warning(" Chunkload Protection.. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            } else if (this.request.getHttpConnection().getRange()[1] > l - 1L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
        }
    }

    private void connectResumable() throws IOException {
        long[] lArray = this.downloadLink.getChunksProgress();
        String string = "";
        String string2 = "";
        if (this.isFileSizeVerified()) {
            string2 = lArray[0] == 0L ? "0" : lArray[0] + 1L + "";
            string = this.fileSize / (long)lArray.length + "";
        } else {
            string2 = lArray[0] == 0L ? "0" : lArray[0] + 1L + "";
            String string3 = string = lArray.length > 1 ? lArray[1] + 1L + "" : "";
        }
        if (this.isFirstChunkRangeless() && string2.equals("0")) {
            this.request.getHeaders().remove("Range");
        } else {
            this.request.getHeaders().put("Range", "bytes=" + string2 + "-" + string);
        }
        this.browser.connect(this.request);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChunk(Chunk chunk) {
        Vector<Chunk> vector = this.chunks;
        synchronized (vector) {
            this.chunks.add(chunk);
        }
        chunk.startChunk();
    }

    public synchronized void addChunksDownloading(long l) {
        this.chunksDownloading = (int)((long)this.chunksDownloading + l);
    }

    protected void addException(Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new Vector();
        }
        this.exceptions.add(exception);
    }

    public synchronized void addToChunksInProgress(long l) {
        this.chunksInProgress = (int)((long)this.chunksInProgress + l);
    }

    protected synchronized void addToTotalLinkBytesLoaded(long l) {
        this.totaleLinkBytesLoaded += l;
    }

    protected synchronized void error(int n, String string) {
        if (this.externalDownloadStop()) {
            return;
        }
        this.logger.severe("Error occured (" + n + "): " + LinkStatus.toString(n));
        if (this.errors.indexOf(n) < 0) {
            this.errors.add(n);
        }
        if (this.fatalErrorOccured) {
            return;
        }
        this.linkStatus.addStatus(n);
        this.linkStatus.setErrorMessage(string);
        switch (n) {
            case 4: 
            case 32: 
            case 2048: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 131072: 
            case 524288: 
            case 0x100000: 
            case 0x200000: {
                this.fatalErrorOccured = true;
                this.terminate();
            }
        }
    }

    public int getChunkNum() {
        return this.chunkNum;
    }

    public Vector<Chunk> getChunks() {
        return this.chunks;
    }

    public int getChunksDownloading() {
        return this.chunksDownloading;
    }

    public Vector<Integer> getErrors() {
        return this.errors;
    }

    public Vector<Exception> getExceptions() {
        return this.exceptions;
    }

    public File getFile() {
        return new File(this.downloadLink.getFileOutput());
    }

    protected long getFileSize() {
        if (this.fileSize > 0L) {
            return this.fileSize;
        }
        if (this.connection != null && this.connection.getLongContentLength() > 0L) {
            return this.connection.getLongContentLength();
        }
        if (this.downloadLink.getDownloadSize() > 0L) {
            return this.downloadLink.getDownloadSize();
        }
        return -1L;
    }

    public int getReadTimeout() {
        return Math.max(10000, this.readTimeout);
    }

    public int getRequestTimeout() {
        return Math.max(10000, this.requestTimeout);
    }

    public int getRunningChunks() {
        return this.chunksInProgress;
    }

    public boolean handleErrors() {
        if (this.externalDownloadStop()) {
            return false;
        }
        if (this.doFileSizeCheck && (this.totaleLinkBytesLoaded <= 0L || this.totaleLinkBytesLoaded != this.fileSize && this.fileSize > 0L)) {
            if (this.totaleLinkBytesLoaded > this.fileSize) {
                this.logger.severe("Filesize: " + this.fileSize + " Loaded: " + this.totaleLinkBytesLoaded);
                if (!this.linkStatus.isFailed()) {
                    this.linkStatus.setStatus(2);
                }
                return true;
            }
            this.logger.severe("Filesize: " + this.fileSize + " Loaded: " + this.totaleLinkBytesLoaded);
            this.logger.severe("DOWNLOAD INCOMPLETE DUE TO FILESIZECHECK");
            this.error(512, _JDT._.download_error_message_incomplete());
            return false;
        }
        if (this.getExceptions() != null && this.getExceptions().size() > 0) {
            this.error(4, _JDT._.download_error_message_incomplete());
            return false;
        }
        if (!this.linkStatus.isFailed()) {
            this.linkStatus.setStatus(2);
        }
        return true;
    }

    public boolean isResume() {
        return this.resume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunkFinished() {
        DownloadInterface downloadInterface = this;
        synchronized (downloadInterface) {
            if (this.waitFlag) {
                this.waitFlag = false;
                this.notify();
            }
        }
        GarbageController.requestGC();
    }

    protected abstract void onChunksReady();

    public void setChunkNum(int n) {
        if (n <= 0) {
            this.logger.severe("Chunks value must be >=1");
            return;
        }
        this.chunkNum = n;
    }

    public void setFilesize(long l) {
        this.fileSize = l;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setRequestTimeout(int n) {
        this.requestTimeout = n;
    }

    public void setResume(boolean bl) {
        this.resumable = bl;
        if (this.checkResumabled()) {
            this.resume = bl;
        } else {
            this.logger.warning("Resumepoint not valid");
        }
    }

    public boolean isResumable() {
        return this.resumable;
    }

    protected abstract void setupChunks() throws Exception;

    public static boolean preDownloadCheckFailed(DownloadLink downloadLink) {
        if (!downloadLink.isAvailabilityStatusChecked()) {
            return false;
        }
        DownloadLink downloadLink2 = downloadLink;
        DownloadLink downloadLink3 = DownloadController.getInstance().getFirstLinkThatBlocks(downloadLink2);
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (downloadLink3 != null) {
            linkStatus.addStatus(8192);
            if (downloadLink3.getDefaultPlugin() != null) {
                linkStatus.setStatusText(_JDT._.system_download_errors_linkisBlocked(downloadLink3.getHost()));
            }
            return true;
        }
        File file = new File(downloadLink2.getFileOutput());
        if (file.getParentFile() == null) {
            linkStatus.addStatus(131072);
            linkStatus.setErrorMessage(_JDT._.system_download_errors_invalidoutputfile());
            return true;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            linkStatus.addStatus(131072);
            linkStatus.setErrorMessage(_JDT._.system_download_errors_invalidoutputfile());
            return true;
        }
        if (file.exists()) {
            if (JsonConfig.create(GeneralSettings.class).getIfFileExistsAction() == IfFileExistsAction.OVERWRITE_FILE) {
                if (!new File(downloadLink2.getFileOutput()).delete()) {
                    linkStatus.addStatus(131072);
                    linkStatus.setErrorMessage(_JDT._.system_download_errors_couldnotoverwrite());
                    return true;
                }
            } else {
                linkStatus.addStatus(8192);
                linkStatus.setErrorMessage(_JDT._.downloadlink_status_error_file_exists());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDownload() throws Exception {
        try {
            this.linkStatus.addStatus(1024);
            this.logger.finer("Start Download");
            if (!this.connected) {
                this.connect();
            }
            if (this.connection != null && this.connection.getHeaderField("Content-Encoding") != null && this.connection.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip")) {
                this.setResume(false);
                this.setChunkNum(1);
            }
            if (this.downloadLink.getFinalFileName() == null && (this.connection != null && this.connection.isContentDisposition() || this.allowFilenameFromURL)) {
                String string = Plugin.getFileNameFromHeader(this.connection);
                if (this.fixWrongContentDispositionHeader) {
                    this.downloadLink.setFinalFileName(Encoding.htmlDecode(string));
                } else {
                    this.downloadLink.setFinalFileName(string);
                }
            }
            this.downloadLink.getLinkStatus().setStatusText(null);
            if (this.connection == null || !this.connection.isOK()) {
                if (this.connection != null) {
                    this.logger.finest(this.connection.toString());
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PluginException(2048, 600000L);
            }
            if (this.connection.getHeaderField("Location") != null) {
                this.error(0x400000, "Sent a redirect to Downloadinterface");
                boolean bl = false;
                return bl;
            }
            if (DownloadInterface.preDownloadCheckFailed(this.downloadLink)) {
                boolean bl = false;
                return bl;
            }
            try {
                this.downloadLink.getDownloadLinkController().getConnectionHandler().addConnectionHandler(this.connectionHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setupChunks();
            this.waitForChunks();
            this.onChunksReady();
            boolean bl = this.handleErrors();
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                this.error(0x200000, _JDT._.download_error_message_localio(exception.getMessage()));
            } else {
                JDLogger.exception(exception);
            }
            this.handleErrors();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.downloadLink.getDownloadLinkController().getConnectionHandler().removeConnectionHandler(this.connectionHandler);
            }
            catch (Throwable throwable) {}
            this.linkStatus.removeStatus(1024);
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {}
            this.cleanupDownladInterface();
        }
    }

    public abstract void cleanupDownladInterface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        if (!this.externalDownloadStop()) {
            this.logger.severe("A critical Downloaderror occured. Terminate...");
        }
        int n = -1;
        ArrayList<Object> arrayList = new ArrayList();
        while (true) {
            n = arrayList.size();
            Vector<Chunk> vector = this.chunks;
            synchronized (vector) {
                arrayList = new ArrayList<Chunk>(this.chunks);
            }
            boolean bl = true;
            if (arrayList.size() != n) {
                bl = false;
            }
            for (Chunk chunk : arrayList) {
                try {
                    if (chunk.getInputStream() != null) {
                        bl = false;
                    }
                    chunk.closeConnections();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                chunk.interrupt();
            }
            if (bl) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChunks() {
        try {
            this.logger.finer("Wait for chunks");
            while (this.chunksInProgress > 0) {
                DownloadInterface downloadInterface = this;
                synchronized (downloadInterface) {
                    if (this.waitFlag) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Exception exception) {
                            this.terminate();
                            return;
                        }
                    }
                }
                this.waitFlag = true;
            }
            this.downloadLink.setDownloadCurrent(this.totaleLinkBytesLoaded);
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
    }

    protected synchronized boolean writeBytes(Chunk chunk) {
        return this.writeChunkBytes(chunk);
    }

    protected abstract boolean writeChunkBytes(Chunk var1);

    public void setFilesizeCheck(boolean bl) {
        this.doFileSizeCheck = bl;
    }

    public URLConnectionAdapter getConnection() {
        return this.connection;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setFirstChunkRangeless(boolean bl) {
        this.firstChunkRangeless = bl;
    }

    public boolean isFirstChunkRangeless() {
        return this.firstChunkRangeless;
    }

    public synchronized void stopDownload() {
        if (this.externalStop) {
            return;
        }
        this.logger.severe("externalStop recieved");
        this.externalStop = true;
        this.terminate();
    }

    public synchronized boolean externalDownloadStop() {
        return this.externalStop;
    }

    public class Chunk
    extends Thread {
        public static final long MIN_CHUNKSIZE = 0x100000L;
        protected ReusableByteArrayOutputStreamPool.ReusableByteArrayOutputStream buffer;
        private long chunkBytesLoaded;
        private URLConnectionAdapter connection;
        private long endByte;
        private int id;
        private MeteredThrottledInputStream inputStream;
        private long startByte;
        private long bytes2Do;
        private DownloadInterface dl;
        private boolean connectionclosed;
        private boolean addedtoStartedChunks;
        private boolean chunkinprogress;
        private boolean clonedconnection;

        public Chunk(long l, long l2, URLConnectionAdapter uRLConnectionAdapter, DownloadInterface downloadInterface2) {
            super("Downloadchunk " + l + " - " + l2);
            this.buffer = null;
            this.chunkBytesLoaded = 0L;
            this.id = -1;
            this.bytes2Do = -1L;
            this.connectionclosed = false;
            this.addedtoStartedChunks = false;
            this.chunkinprogress = false;
            this.clonedconnection = false;
            this.startByte = l;
            this.endByte = l2;
            this.connection = uRLConnectionAdapter;
            this.clonedconnection = false;
            this.dl = downloadInterface2;
            this.setPriority(1);
        }

        @Deprecated
        public int getMaximalSpeed() {
            return 0;
        }

        @Deprecated
        public void setMaximalSpeed(int n) {
        }

        private void addChunkBytesLoaded(long l) {
            this.chunkBytesLoaded += l;
        }

        public boolean inProgress() {
            return this.chunkinprogress;
        }

        public boolean isClonedConnection() {
            return this.clonedconnection;
        }

        public void setInProgress(boolean bl) {
            this.chunkinprogress = bl;
        }

        private void setChunkStartet() {
            if (this.addedtoStartedChunks) {
                return;
            }
            DownloadInterface.this.addChunksStarted(1);
            this.addedtoStartedChunks = true;
        }

        public int getPercent() {
            return (int)(10000L * this.chunkBytesLoaded / Math.max(1L, Math.max(this.chunkBytesLoaded, this.endByte - this.startByte)));
        }

        private URLConnectionAdapter copyConnection(URLConnectionAdapter uRLConnectionAdapter) {
            try {
                while (DownloadInterface.this.downloadLink.getLivePlugin().waitForNextConnectionAllowed()) {
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (NullPointerException nullPointerException) {
                if (DownloadInterface.this.downloadLink.getLivePlugin() == null) {
                    return null;
                }
                throw nullPointerException;
            }
            DownloadInterface.this.downloadLink.getLivePlugin().putLastConnectionTime(System.currentTimeMillis());
            long l = this.startByte;
            String string = (this.endByte > 0L ? Long.valueOf(this.endByte + 1L) : "") + "";
            if (l == 0L) {
                DownloadInterface.this.logger.finer("Takeover 0 Connection");
                return uRLConnectionAdapter;
            }
            if (uRLConnectionAdapter.getRange() != null && uRLConnectionAdapter.getRange()[0] == l) {
                DownloadInterface.this.logger.finer("Takeover connection at " + uRLConnectionAdapter.getRange()[0]);
                return uRLConnectionAdapter;
            }
            try {
                Object object;
                boolean bl = DownloadInterface.this.plugin.getBrowser().getHeaders().contains("Referer");
                Browser browser = DownloadInterface.this.plugin.getBrowser().cloneBrowser();
                browser.setReadTimeout(DownloadInterface.this.getReadTimeout());
                browser.setConnectTimeout(DownloadInterface.this.getRequestTimeout());
                Map<String, String> map = uRLConnectionAdapter.getRequestProperties();
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (entry.getValue() == null) continue;
                        object = entry.getValue().toString();
                        browser.getHeaders().put(entry.getKey(), (String)object);
                    }
                }
                if (!bl) {
                    browser.setCurrentURL(null);
                }
                object = null;
                this.clonedconnection = true;
                if (uRLConnectionAdapter.getRequestMethod() == HTTPConnection.RequestMethod.POST) {
                    uRLConnectionAdapter.getRequest().getHeaders().put("Range", "bytes=" + l + "-" + string);
                    object = browser.openRequestConnection(uRLConnectionAdapter.getRequest());
                } else {
                    browser.getHeaders().put("Range", "bytes=" + l + "-" + string);
                    object = browser.openGetConnection(uRLConnectionAdapter.getURL() + "");
                }
                if (!object.isOK()) {
                    try {
                        object.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (object.getResponseCode() != 416) {
                        DownloadInterface.this.error(16384, "Server: " + object.getResponseMessage());
                    } else {
                        DownloadInterface.this.logger.warning("HTTP 416, maybe finished last chunk?");
                    }
                    return null;
                }
                if (object.getHeaderField("Location") != null) {
                    try {
                        object.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    DownloadInterface.this.error(16384, "Server: Redirect");
                    return null;
                }
                return object;
            }
            catch (Exception exception) {
                DownloadInterface.this.addException(exception);
                DownloadInterface.this.error(4, Exceptions.getStackTrace(exception));
                JDLogger.exception(exception);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download() {
            int n;
            int n2 = 0;
            int n3 = JsonConfig.create(GeneralSettings.class).getFlushBufferTimeout();
            try {
                n = JsonConfig.create(GeneralSettings.class).getMaxBufferSize() * 1024;
                this.buffer = ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(Math.max(n, 10240), false);
                n2 = Math.max(n / 100 * JsonConfig.create(GeneralSettings.class).getFlushBufferLevel(), 1);
            }
            catch (Throwable throwable) {
                DownloadInterface.this.error(131072, _JDT._.download_error_message_outofmemory());
                return;
            }
            if (this.endByte > 0L) {
                this.bytes2Do = this.endByte - this.startByte + 1L;
            }
            try {
                this.chunkinprogress = true;
                this.connection.setReadTimeout(DownloadInterface.this.getReadTimeout());
                this.connection.setConnectTimeout(DownloadInterface.this.getRequestTimeout());
                this.inputStream = new MeteredThrottledInputStream(this.connection.getInputStream(), new AverageSpeedMeter(10));
                DownloadInterface.this.connectionHandler.addThrottledConnection(this.inputStream);
                n = 0;
                int n4 = 0;
                boolean bl = false;
                long l = 0L;
                while (!this.isExternalyAborted()) {
                    try {
                        this.buffer.reset();
                        n = bl ? -1 : 0;
                        l = System.currentTimeMillis();
                        while (!bl && this.buffer.free() > 0 && this.buffer.size() <= n2) {
                            if (this.endByte > 0L) {
                                n4 = this.inputStream.read(this.buffer.getInternalBuffer(), this.buffer.size(), (int)Math.min(this.bytes2Do, (long)(this.buffer.getInternalBuffer().length - this.buffer.size())));
                                if (n4 > 0) {
                                    this.bytes2Do -= (long)n4;
                                    if (this.bytes2Do == 0L) {
                                        bl = true;
                                    }
                                }
                            } else {
                                n4 = this.inputStream.read(this.buffer.getInternalBuffer(), this.buffer.size(), this.buffer.getInternalBuffer().length - this.buffer.size());
                            }
                            if (n4 > 0) {
                                this.buffer.setUsed(n += n4);
                            } else if (n4 == -1) {
                                bl = true;
                            } else {
                                Chunk chunk = this;
                                synchronized (chunk) {
                                    this.wait(500L);
                                }
                            }
                            if (System.currentTimeMillis() - l <= (long)n3) continue;
                            break;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if (this.inputStream == null) {
                            if (!this.isExternalyAborted() && !this.connectionclosed) {
                                throw nullPointerException;
                            }
                            n = -1;
                            break;
                        }
                        throw nullPointerException;
                    }
                    catch (SocketException socketException) {
                        if (!this.isExternalyAborted()) {
                            throw socketException;
                        }
                        n = -1;
                        break;
                    }
                    catch (ClosedByInterruptException closedByInterruptException) {
                        if (!this.isExternalyAborted()) {
                            DownloadInterface.this.logger.severe("Timeout detected");
                            DownloadInterface.this.error(0x100000, null);
                        }
                        n = -1;
                        break;
                    }
                    catch (AsynchronousCloseException asynchronousCloseException) {
                        if (!this.isExternalyAborted() && !this.connectionclosed) {
                            throw asynchronousCloseException;
                        }
                        n = -1;
                        break;
                    }
                    catch (IOException iOException) {
                        if (!this.isExternalyAborted() && !this.connectionclosed) {
                            throw iOException;
                        }
                        n = -1;
                        break;
                    }
                    if (n == -1 || this.isExternalyAborted() || this.connectionclosed) break;
                    if (n > 0) {
                        DownloadInterface.this.addToTotalLinkBytesLoaded(n);
                        this.addChunkBytesLoaded(n);
                        DownloadInterface.this.writeBytes(this);
                    }
                    if ((this.bytes2Do != 0L || this.endByte <= 0L) && (this.getCurrentBytesPosition() <= this.endByte || this.endByte <= 0L)) continue;
                }
                if (this.getCurrentBytesPosition() < this.endByte && this.endByte > 0L || this.getCurrentBytesPosition() <= 0L) {
                    DownloadInterface.this.logger.warning("Download not finished. Loaded until now: " + this.getCurrentBytesPosition() + "/" + this.endByte);
                    DownloadInterface.this.error(16384, _JDT._.download_error_message_incomplete());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DownloadInterface.this.logger.severe("file not found. " + fileNotFoundException.getLocalizedMessage());
                DownloadInterface.this.error(32, null);
            }
            catch (SecurityException securityException) {
                DownloadInterface.this.logger.severe("not enough rights to write the file. " + securityException.getLocalizedMessage());
                DownloadInterface.this.error(0x200000, _JDT._.download_error_message_iopermissions());
            }
            catch (UnknownHostException unknownHostException) {
                DownloadInterface.this.linkStatus.setValue(600000L);
                DownloadInterface.this.error(2048, _JDT._.download_error_message_unavailable());
            }
            catch (IOException iOException) {
                if (iOException.getMessage() != null && iOException.getMessage().contains("reset")) {
                    JDLogger.getLogger().info("Connection reset: network problems!");
                    DownloadInterface.this.linkStatus.setValue(300000L);
                    DownloadInterface.this.error(2048, _JDT._.download_error_message_networkreset());
                } else if (iOException.getMessage() != null && iOException.getMessage().indexOf("timed out") >= 0) {
                    JDLogger.getLogger().info("Read timeout: network problems! (too many connections?, firewall/antivirus?)");
                    DownloadInterface.this.error(0x100000, _JDT._.download_error_message_networkreset());
                    JDLogger.exception(iOException);
                } else {
                    JDLogger.exception(iOException);
                    if (iOException.getMessage() != null && iOException.getMessage().contains("503")) {
                        DownloadInterface.this.linkStatus.setValue(600000L);
                        DownloadInterface.this.error(2048, _JDT._.download_error_message_unavailable());
                    } else {
                        DownloadInterface.this.logger.severe("error occurred while writing to file. " + iOException.getMessage());
                        DownloadInterface.this.error(0x200000, _JDT._.download_error_message_iopermissions());
                    }
                }
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                DownloadInterface.this.error(4, Exceptions.getStackTrace(exception));
                DownloadInterface.this.addException(exception);
            }
            finally {
                ReusableByteArrayOutputStreamPool.reuseReusableByteArrayOutputStream(this.buffer);
                this.buffer = null;
                this.chunkinprogress = false;
                try {
                    this.inputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.inputStream = null;
                }
                try {
                    if (this.clonedconnection) {
                        this.connection.disconnect();
                        this.connection = null;
                    }
                }
                catch (Throwable throwable) {}
            }
        }

        public long getBytesLoaded() {
            return this.getCurrentBytesPosition() - this.startByte;
        }

        public long getChunkSize() {
            return this.endByte - this.startByte + 1L;
        }

        public long getCurrentBytesPosition() {
            return this.startByte + this.chunkBytesLoaded;
        }

        public long getEndByte() {
            return this.endByte;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getID() {
            if (this.id < 0) {
                Vector vector = DownloadInterface.this.chunks;
                synchronized (vector) {
                    this.id = DownloadInterface.this.chunks.indexOf(this);
                }
            }
            return this.id;
        }

        public long getStartByte() {
            return this.startByte;
        }

        public long getWritePosition() throws Exception {
            long l = this.getCurrentBytesPosition();
            long l2 = this.buffer.size();
            return l - l2;
        }

        private boolean isExternalyAborted() {
            DownloadInterface downloadInterface = DownloadInterface.this.downloadLink.getDownloadInstance();
            return this.isInterrupted() || downloadInterface != null && downloadInterface.externalDownloadStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.run0();
                do {
                    if (DownloadInterface.this.getChunksStarted() == DownloadInterface.this.chunkNum) {
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                } while (!this.isExternalyAborted());
            }
            finally {
                try {
                    DownloadInterface.this.addToChunksInProgress(-1L);
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
                DownloadInterface.this.onChunkFinished();
            }
        }

        private Long[] parseContentRange(URLConnectionAdapter uRLConnectionAdapter, long l, long l2) {
            String string = uRLConnectionAdapter.getHeaderField("Content-Range");
            String[] stringArray = null;
            if (string != null) {
                stringArray = new Regex(string, ".*?(\\d+).*?-.*?(\\d+).*?/.*?(\\d+)").getRow(0);
                if (stringArray != null) {
                    long l3 = Formatter.filterLong(stringArray[0]);
                    long l4 = Formatter.filterLong(stringArray[1]);
                    long l5 = Formatter.filterLong(stringArray[2]);
                    if (l3 != l) {
                        DownloadInterface.this.logger.severe("Range Conflict " + stringArray[0] + " - " + stringArray[1] + " wished start: " + 0);
                    }
                    if (l2 <= 0L) {
                        l2 = l5 - 1L;
                    }
                    if (l4 == l2) {
                        DownloadInterface.this.logger.finer("ServerType: RETURN Rangeend-1");
                    } else if (l4 == l2 + 1L) {
                        DownloadInterface.this.logger.finer("ServerType: RETURN exact rangeend");
                    } else if (l4 < l2) {
                        DownloadInterface.this.logger.severe("Range Conflict " + stringArray[0] + " - " + stringArray[1] + " wishedend: " + l2);
                    } else if (l4 > l2 + 1L) {
                        DownloadInterface.this.logger.warning("Possible RangeConflict or Servermisconfiguration. wished endByte: " + l2 + " got: " + l4);
                    }
                    l2 = Math.min(l2, l4);
                    return new Long[]{l3, l2, l5};
                }
                stringArray = new Regex(string, ".*?(\\d+).*?-/.*?(\\d+)").getRow(0);
                if (stringArray != null) {
                    long l6;
                    long l7 = Formatter.filterLong(stringArray[0]);
                    long l8 = Formatter.filterLong(stringArray[1]);
                    if (l7 != l) {
                        DownloadInterface.this.logger.severe("Range Conflict " + stringArray[0] + "->wished start: " + 0);
                    }
                    if (l2 <= 0L) {
                        l2 = l8 - 1L;
                    }
                    if ((l6 = l7 + uRLConnectionAdapter.getLongContentLength()) == l2) {
                        DownloadInterface.this.logger.finer("ServerType: RETURN Rangeend-1");
                    } else if (l6 == l2 + 1L) {
                        DownloadInterface.this.logger.finer("ServerType: RETURN exact rangeend");
                    } else if (l6 < l2) {
                        DownloadInterface.this.logger.severe("Range Conflict " + stringArray[0] + " - " + stringArray[1] + " wishedend: " + l2);
                    } else if (l6 > l2 + 1L) {
                        DownloadInterface.this.logger.warning("Possible RangeConflict or Servermisconfiguration. wished endByte: " + l2 + " got: " + l6);
                    }
                    l2 = Math.min(l2, l6);
                    return new Long[]{l7, l2, l8};
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run0() {
            try {
                DownloadInterface.this.logger.finer("Start Chunk " + this.getID() + " : " + this.startByte + " - " + this.endByte);
                if (this.startByte >= this.endByte) {
                    if (this.endByte > 0L) return;
                }
                if (this.startByte >= DownloadInterface.this.getFileSize() && this.endByte > 0L) {
                    return;
                }
                if (DownloadInterface.this.chunkNum > 1) {
                    this.connection = this.copyConnection(this.connection);
                    if (this.connection == null) {
                        if (this.startByte >= DownloadInterface.this.fileSize && DownloadInterface.this.fileSize > 0L) {
                            DownloadInterface.this.downloadLink.getLinkStatus().removeStatus(16384);
                            DownloadInterface.this.logger.finer("Is no error. Last chunk is just already finished");
                            return;
                        }
                        DownloadInterface.this.error(16384, _JDT._.download_error_message_connectioncopyerror());
                        if (this.isExternalyAborted()) return;
                        DownloadInterface.this.logger.severe("ERROR Chunk (connection copy failed) " + this.getID());
                        return;
                    }
                } else if (this.startByte > 0L) {
                    this.connection = this.copyConnection(this.connection);
                    if (this.startByte >= DownloadInterface.this.fileSize && DownloadInterface.this.fileSize > 0L) {
                        DownloadInterface.this.downloadLink.getLinkStatus().removeStatus(16384);
                        DownloadInterface.this.logger.finer("Is no error. Last chunk is just already finished");
                        return;
                    }
                    if (this.connection == null) {
                        DownloadInterface.this.error(16384, _JDT._.download_error_message_connectioncopyerror());
                        if (this.isExternalyAborted()) return;
                        DownloadInterface.this.logger.severe("ERROR Chunk (connection copy failed) " + this.getID());
                        return;
                    }
                    if (this.startByte > 0L && (this.connection.getHeaderField("Content-Range") == null || this.connection.getHeaderField("Content-Range").length() == 0)) {
                        DownloadInterface.this.error(16384, _JDT._.download_error_message_rangeheaders());
                        DownloadInterface.this.logger.severe("ERROR Chunk (no range header response)" + this.getID() + this.connection.toString());
                        return;
                    }
                }
                Long[] longArray = this.parseContentRange(this.connection, this.startByte, this.endByte);
                if (this.startByte > 0L) {
                    if (longArray != null && longArray.length == 3) {
                        this.endByte = longArray[1];
                    } else {
                        if (DownloadInterface.this.chunkNum > 1) {
                            if (this.connection.getLongContentLength() == this.startByte) {
                                return;
                            }
                            DownloadInterface.this.logger.severe("ERROR Chunk (range header parse error)" + this.getID() + this.connection.toString());
                            DownloadInterface.this.error(16384, _JDT._.download_error_message_rangeheaderparseerror() + this.connection.getHeaderField("Content-Range"));
                            return;
                        }
                        this.endByte = this.connection.getLongContentLength() - 1L;
                    }
                } else if (longArray != null) {
                    DownloadInterface.this.logger.severe("No Range Request->Content-Range Response?!");
                    this.endByte = longArray[1];
                }
                if (this.endByte <= 0L) {
                    this.endByte = this.connection.getLongContentLength() - 1L;
                }
                DownloadInterface.this.addChunksDownloading(1L);
                this.setChunkStartet();
                this.download();
                DownloadInterface.this.addChunksDownloading(-1L);
                DownloadInterface.this.logger.finer("Chunk finished " + this.getID() + " " + this.getBytesLoaded() + " bytes");
                return;
            }
            finally {
                this.setChunkStartet();
                try {
                    if (this.clonedconnection) {
                        this.connection.disconnect();
                        this.connection = null;
                    }
                }
                catch (Throwable throwable) {}
            }
        }

        public void setLoaded(long l) {
            l = Math.max(0L, l);
            DownloadInterface.this.addToTotalLinkBytesLoaded(l);
        }

        public void startChunk() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeConnections() {
            this.connectionclosed = true;
            try {
                this.inputStream.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.inputStream = null;
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.connection = null;
            }
        }

        public MeteredThrottledInputStream getInputStream() {
            return this.inputStream;
        }
    }
}

