/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;
import jd.nutils.JDFlags;
import jd.plugins.DownloadLink;
import jd.plugins.download.DownloadInterface;
import org.appwork.utils.Exceptions;
import org.appwork.utils.formatter.StringFormatter;
import org.jdownloader.translate._JDT;

public class LinkStatus
implements Serializable {
    public static final int TODO = 1;
    public static final int FINISHED = 2;
    public static final int ERROR_RETRY = 4;
    public static final int ERROR_CAPTCHA = 8;
    public static final int ERROR_IP_BLOCKED = 16;
    public static final int ERROR_FILE_NOT_FOUND = 32;
    public static final int ERROR_PREMIUM = 256;
    public static final int ERROR_DOWNLOAD_INCOMPLETE = 512;
    public static final int DOWNLOADINTERFACE_IN_PROGRESS = 1024;
    public static final int ERROR_TEMPORARILY_UNAVAILABLE = 2048;
    public static final int ERROR_HOSTER_TEMPORARILY_UNAVAILABLE = 4096;
    public static final int ERROR_ALREADYEXISTS = 8192;
    public static final int ERROR_DOWNLOAD_FAILED = 16384;
    public static final int ERROR_NO_CONNECTION = 32768;
    public static final int ERROR_FATAL = 131072;
    public static final int PLUGIN_IN_PROGRESS = 262144;
    public static final int ERROR_LINK_IN_PROGRESS = 524288;
    public static final int ERROR_TIMEOUT_REACHED = 0x100000;
    public static final int ERROR_LOCAL_IO = 0x200000;
    public static final int ERROR_PLUGIN_DEFECT = 0x400000;
    public static final int WAITING_USERIO = 0x800000;
    public static final int ERROR_POST_PROCESS = 0x1000000;
    public static final int VALUE_FAILED_HASH = 0x8000000;
    private transient boolean isActive = false;
    private transient boolean inProgress = false;
    public static final int ERROR_PLUGIN_NEEDED = 0x40000000;
    public static final int NOT_ENOUGH_HARDDISK_SPACE = Integer.MIN_VALUE;
    private static HashMap<Integer, String> toStringHelper;
    private static final long serialVersionUID = 3885661829491436448L;
    private final DownloadLink downloadLink;
    private String errorMessage;
    private int lastestStatus = 1;
    private int status = 1;
    private String statusText = null;
    private long totalWaitTime = 0L;
    private long value = 0L;
    private long waitUntil = 0L;
    private int retryCount = 0;
    private ImageIcon statusIcon;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.isActive = false;
        this.inProgress = false;
    }

    public LinkStatus(DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void addStatus(int n) {
        if (this.lastestStatus == n) {
            return;
        }
        this.status |= n;
        if (JDFlags.hasSomeFlags(n, 2) && this.downloadLink.getFinishedDate() == -1L) {
            this.downloadLink.setFinishedDate(System.currentTimeMillis());
        }
        this.lastestStatus = n;
        this.notifyChanges();
    }

    public void exceptionToErrorMessage(Exception exception) {
        this.setErrorMessage(Exceptions.getStackTrace(exception));
    }

    private String getDefaultErrorMessage() {
        switch (this.lastestStatus) {
            case 4: {
                return _JDT._.downloadlink_status_error_retry();
            }
            case 0x400000: {
                return _JDT._.downloadlink_status_error_defect();
            }
            case 0x40000000: {
                return _JDT._.downloadlink_status_error_no_plugin_available();
            }
            case 512: {
                return _JDT._.downloadlink_status_incomplete();
            }
            case 8192: {
                return _JDT._.downloadlink_status_error_file_exists();
            }
            case 8: {
                return _JDT._.downloadlink_status_error_captcha_wrong();
            }
            case 16384: {
                return _JDT._.downloadlink_status_error_downloadfailed();
            }
            case 16: {
                return _JDT._.downloadlink_status_error_download_limit();
            }
            case 32: {
                return _JDT._.downloadlink_status_error_file_not_found();
            }
            case 0x1000000: {
                return _JDT._.downloadlink_status_error_post_process();
            }
            case 32768: 
            case 0x100000: {
                return _JDT._.downloadlink_status_error_no_connection();
            }
            case 256: {
                return _JDT._.downloadlink_status_error_premium();
            }
            case 2048: {
                return _JDT._.downloadlink_status_error_temp_unavailable();
            }
            case 4096: {
                return _JDT._.downloadlink_status_error_hoster_temp_unavailable();
            }
            case 131072: {
                return _JDT._.downloadlink_status_error_fatal();
            }
            case 0x800000: {
                return _JDT._.downloadlink_status_waitinguserio();
            }
            case -2147483648: {
                return _JDT._.downloadlink_status_error();
            }
        }
        return null;
    }

    public String getLongErrorMessage() {
        String string = this.errorMessage;
        if (string == null) {
            string = this.getDefaultErrorMessage();
        }
        if (string == null) {
            string = _JDT._.downloadlink_status_error_unexpected();
        }
        return string;
    }

    public int getLatestStatus() {
        return this.lastestStatus;
    }

    public void setLatestStatus(int n) {
        this.lastestStatus = n;
    }

    public long getRemainingWaittime() {
        long l = System.currentTimeMillis();
        long l2 = this.waitUntil - l;
        return Math.max(0L, l2);
    }

    public String getStatusString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasStatus(0x1000000)) {
            if (this.getErrorMessage() != null) {
                stringBuilder.append(this.getErrorMessage());
            } else if (this.getStatusText() != null) {
                stringBuilder.append(this.getStatusText());
            } else {
                stringBuilder.append(_JDT._.gui_downloadlink_errorpostprocess3());
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(2)) {
            return this.getStatusText() != null ? " > " + this.getStatusText() : "";
        }
        if (this.hasStatus(32)) {
            return this.getLongErrorMessage();
        }
        if (!this.downloadLink.isEnabled() && !this.hasStatus(2)) {
            if (this.downloadLink.isAborted() && (this.statusText == null || this.statusText.trim().length() == 0)) {
                stringBuilder.append(_JDT._.gui_downloadlink_aborted()).append(' ');
            } else if (this.downloadLink.isAborted()) {
                stringBuilder.append(this.statusText);
            }
            if (this.errorMessage != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(new char[]{':', ' '});
                }
                stringBuilder.append(this.errorMessage);
            }
            return stringBuilder.toString();
        }
        if (this.hasStatus(2048) && this.getRemainingWaittime() > 0L) {
            stringBuilder.append(_JDT._.gui_download_waittime_status2(Formatter.formatSeconds(this.getRemainingWaittime() / 1000L)));
            if (this.errorMessage != null) {
                return this.errorMessage + " " + stringBuilder.toString();
            }
            return stringBuilder.toString();
        }
        if (this.isFailed()) {
            return this.getLongErrorMessage();
        }
        DownloadInterface downloadInterface = this.downloadLink.getDownloadInstance();
        if (downloadInterface == null && this.hasStatus(1024)) {
            this.removeStatus(1024);
        }
        if (this.hasStatus(1024)) {
            long l = this.downloadLink.getDownloadSpeed();
            String string = "";
            if (downloadInterface != null && downloadInterface.getChunkNum() > 1) {
                string = " (" + downloadInterface.getChunksDownloading() + "/" + downloadInterface.getChunkNum() + ")";
            }
            if (l > 0L) {
                if (this.downloadLink.getDownloadSize() < 0L) {
                    return Formatter.formatReadable(l) + "/s " + _JDT._.gui_download_filesize_unknown();
                }
                long l2 = this.downloadLink.getDownloadSize() - this.downloadLink.getDownloadCurrent();
                long l3 = l2 / l;
                return "ETA " + Formatter.formatSeconds((int)l3) + " @ " + Formatter.formatReadable(l) + "/s" + string;
            }
            return _JDT._.gui_download_create_connection() + string;
        }
        if (this.downloadLink.isAvailabilityStatusChecked() && !this.downloadLink.isAvailable()) {
            return _JDT._.gui_download_onlinecheckfailed();
        }
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.statusText != null) {
            return this.statusText;
        }
        return "";
    }

    public long getValue() {
        return this.value;
    }

    private boolean hasOnlyStatus(int n) {
        return (this.status & ~n) == 0;
    }

    public boolean hasStatus(int n) {
        return (this.status & n) != 0;
    }

    public boolean isFailed() {
        return !this.isActive && !this.inProgress && !this.hasOnlyStatus(8397843);
    }

    public boolean isPluginActive() {
        return this.isActive;
    }

    public boolean isPluginInProgress() {
        return this.inProgress;
    }

    public boolean isStatus(int n) {
        return this.status == n;
    }

    public void removeStatus(int n) {
        int n2 = -1;
        this.status &= (n2 &= ~n);
    }

    public void reset(boolean bl) {
        this.notifyChanges();
        this.setStatus(1);
        this.setLatestStatus(1);
        this.errorMessage = null;
        this.statusText = null;
        if (bl) {
            this.retryCount = 0;
        }
        this.value = 0L;
        this.resetWaitTime();
    }

    public void reset() {
        this.reset(true);
    }

    public void resetWaitTime() {
        this.totalWaitTime = 0L;
        this.waitUntil = 0L;
    }

    public void setErrorMessage(String string) {
        if (!this.downloadLink.isAborted() || string == null) {
            this.errorMessage = string;
        }
    }

    public void setInProgress(boolean bl) {
        if (bl == this.inProgress) {
            return;
        }
        this.inProgress = bl;
        this.notifyChanges();
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive) {
            return;
        }
        this.isActive = bl;
        this.notifyChanges();
    }

    private void notifyChanges() {
        DownloadLink downloadLink = this.downloadLink;
        if (downloadLink != null) {
            downloadLink.getFilePackage().nodeUpdated(downloadLink);
        }
    }

    public void setStatus(int n) {
        if (n == 2) {
            this.resetWaitTime();
        }
        this.status = n;
        if (JDFlags.hasSomeFlags(n, 2) && this.downloadLink.getFinishedDate() == -1L) {
            this.downloadLink.setFinishedDate(System.currentTimeMillis());
        }
        this.lastestStatus = n;
    }

    public void setStatusText(String string) {
        this.statusText = string;
        this.notifyChanges();
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setWaitTime(long l) {
        this.waitUntil = System.currentTimeMillis() + l;
        this.totalWaitTime = l;
    }

    public static String toString(int n) {
        return toStringHelper.get(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringFormatter.fillString(Integer.toBinaryString(this.status), "0", "", 32) + " < Statuscode\r\n");
        String string = "";
        for (Map.Entry<Integer, String> entry : toStringHelper.entrySet()) {
            int n = entry.getKey();
            if (!this.hasStatus(n)) continue;
            if (n == this.lastestStatus) {
                string = "Latest: " + entry.getValue() + "\r\n";
            }
            stringBuilder.append(StringFormatter.fillString(Integer.toBinaryString(n), "0", "", 32)).append(" | ").append(entry.getValue()).append("\r\n");
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append(stringBuilder.toString());
        if (this.statusText != null) {
            stringBuilder2.append("StatusText: ").append(this.statusText).append("\r\n");
        }
        if (this.errorMessage != null) {
            stringBuilder2.append("ErrorMessage: ").append(this.errorMessage).append("\r\n");
        }
        return stringBuilder2.toString();
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatusIcon(ImageIcon imageIcon) {
        this.statusIcon = imageIcon;
    }

    public ImageIcon getStatusIcon() {
        return this.statusIcon;
    }

    public boolean isFinished() {
        return this.hasStatus(8192) || this.hasStatus(2);
    }

    public void resetStatus(int ... nArray) {
        if (this.downloadLink != null) {
            int n = 1;
            int n2 = 1;
            String string = null;
            String string2 = null;
            int n3 = 0;
            for (int n4 : nArray) {
                n3 |= n4;
            }
            Object object = this.downloadLink.getLinkStatus();
            for (int n5 : nArray) {
                if (!((LinkStatus)object).hasStatus(n5)) continue;
                n = ((LinkStatus)object).getStatus();
                n2 = ((LinkStatus)object).getLatestStatus();
                string = ((LinkStatus)object).getErrorMessage();
                string2 = ((LinkStatus)object).getStatusText();
                break;
            }
            n = JDFlags.filterFlags(n, n3 | 1);
            n2 = JDFlags.filterFlags(n2, n3 | 1);
            ((LinkStatus)object).reset();
            ((LinkStatus)object).setStatus(n);
            ((LinkStatus)object).setLatestStatus(n2);
            ((LinkStatus)object).setErrorMessage(string);
            ((LinkStatus)object).setStatusText(string2);
            this.notifyChanges();
        }
    }

    static {
        Field[] fieldArray;
        toStringHelper = new HashMap();
        for (Field field : fieldArray = LinkStatus.class.getDeclaredFields()) {
            if (field.getModifiers() != 25) continue;
            try {
                toStringHelper.put(field.getInt(LinkStatus.class), field.getName());
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
    }
}

