/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jd.config.Property;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackageView;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.controlling.UniqueSessionID;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class FilePackage
extends Property
implements Serializable,
AbstractPackageNode<DownloadLink, FilePackage> {
    private static final long serialVersionUID = -8859842964299890820L;
    private String downloadDirectory;
    private ArrayList<DownloadLink> downloadLinkList;
    private static transient FilePackage FP = null;
    private String name = null;
    private long created = -1L;
    private transient boolean isExpanded = false;
    private transient PackageController<FilePackage, DownloadLink> controlledby = null;
    private transient UniqueSessionID uniqueID = new UniqueSessionID();
    public static final String PROPERTY_EXPANDED = "EXPANDED";
    private static final String PROPERTY_COMMENT = "COMMENT";
    private static final String PROPERTY_EXTRACT = "EXTRACT";
    private static final String PROPERTY_FINISHTIME = "FINISHTIME";
    private transient FilePackageView fpInfo = null;
    private ArrayList<String> passwordList = null;

    public static FilePackage getDefaultFilePackage() {
        return FP;
    }

    public static boolean isDefaultFilePackage(FilePackage filePackage) {
        return FP == filePackage;
    }

    public UniqueSessionID getUniqueID() {
        return this.uniqueID;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilePackage)) {
            return false;
        }
        return ((FilePackage)object).uniqueID == this.uniqueID;
    }

    public static FilePackage getInstance() {
        return new FilePackage();
    }

    private FilePackage() {
        this.downloadDirectory = JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder();
        this.created = System.currentTimeMillis();
        this.downloadLinkList = new ArrayList();
        this.setName(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.isExpanded = this.getBooleanProperty(PROPERTY_EXPANDED, false);
        this.uniqueID = new UniqueSessionID();
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    @Override
    public long getFinishedDate() {
        return this.getLongProperty(PROPERTY_FINISHTIME, -1L);
    }

    public void setFinishedDate(long l) {
        if (l <= 0L) {
            this.setProperty(PROPERTY_FINISHTIME, Property.NULL);
        } else {
            this.setProperty(PROPERTY_FINISHTIME, l);
        }
    }

    public void add(DownloadLink downloadLink) {
        this._add(downloadLink);
    }

    public void addLinks(ArrayList<DownloadLink> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this._add(arrayList.toArray(new DownloadLink[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(DownloadLink ... downloadLinkArray) {
        if (downloadLinkArray == null || downloadLinkArray.length == 0) {
            return;
        }
        if (this.controlledby == null) {
            FilePackage filePackage = this;
            synchronized (filePackage) {
                for (DownloadLink downloadLink : downloadLinkArray) {
                    if (this.downloadLinkList.contains(downloadLink)) continue;
                    downloadLink._setFilePackage(this);
                    this.downloadLinkList.add(downloadLink);
                }
            }
            this.notifyStructureChanges();
        } else {
            this.controlledby.addmoveChildren(this, Arrays.asList(downloadLinkArray), -1);
        }
    }

    public boolean isPostProcessing() {
        return this.getBooleanProperty(PROPERTY_EXTRACT, true);
    }

    public void setPostProcessing(boolean bl) {
        if (bl) {
            this.setProperty(PROPERTY_EXTRACT, Property.NULL);
        } else {
            this.setProperty(PROPERTY_EXTRACT, false);
        }
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getPasswordAuto(FilePackage filePackage) {
        HashSet<String> hashSet = new HashSet<String>();
        if (filePackage == null) {
            return hashSet;
        }
        FilePackage filePackage2 = filePackage;
        synchronized (filePackage2) {
            for (DownloadLink downloadLink : filePackage.getChildren()) {
                ArrayList<String> arrayList = null;
                arrayList = downloadLink.getSourcePluginPasswordList();
                if (arrayList == null) continue;
                for (String string : arrayList) {
                    if (string == null) continue;
                    hashSet.add(string);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DownloadLink ... downloadLinkArray) {
        if (downloadLinkArray == null || downloadLinkArray.length == 0) {
            return;
        }
        if (this.controlledby == null) {
            FilePackage filePackage = this;
            synchronized (filePackage) {
                for (DownloadLink downloadLink : downloadLinkArray) {
                    if (!this.downloadLinkList.remove(downloadLink) || downloadLink.getFilePackage() != this) continue;
                    downloadLink._setFilePackage(null);
                }
            }
            this.notifyStructureChanges();
        } else {
            this.controlledby.removeChildren(this, Arrays.asList(downloadLinkArray), true);
        }
    }

    public void setComment(String string) {
        if (string == null || string.length() == 0) {
            this.setProperty(PROPERTY_COMMENT, Property.NULL);
        } else {
            this.setProperty(PROPERTY_COMMENT, string);
        }
    }

    public String getComment() {
        return this.getStringProperty(PROPERTY_COMMENT, null);
    }

    public void setDownloadDirectory(String string) {
        this.downloadDirectory = JDUtilities.removeEndingPoints(string);
        if (this.downloadDirectory == null) {
            this.downloadDirectory = JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder();
        }
    }

    public void setName(String string) {
        this.name = string == null || string.length() == 0 ? JDUtilities.removeEndingPoints(_JDT._.controller_packages_defaultname()) : JDUtilities.removeEndingPoints(JDIO.validateFileandPathName(string));
        this.name = this.name.trim();
    }

    public int size() {
        return this.downloadLinkList.size();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setExpanded(boolean bl) {
        if (this.isExpanded == bl) {
            return;
        }
        this.isExpanded = bl;
        if (!bl) {
            this.setProperty(PROPERTY_EXPANDED, Property.NULL);
        } else {
            this.setProperty(PROPERTY_EXPANDED, bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getView().isEnabled();
    }

    public void setPasswordList(ArrayList<String> arrayList) {
        this.passwordList = arrayList;
    }

    public String[] getPasswordList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.passwordList != null) {
            arrayList.addAll(this.passwordList);
        }
        Iterator<String> iterator = FilePackage.getPasswordAuto(this).iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public List<DownloadLink> getChildren() {
        return this.downloadLinkList;
    }

    @Override
    public PackageController<FilePackage, DownloadLink> getControlledBy() {
        return this.controlledby;
    }

    @Override
    public void setControlledBy(PackageController<FilePackage, DownloadLink> packageController) {
        this.controlledby = packageController;
    }

    @Override
    public void notifyStructureChanges() {
        if (this.fpInfo != null) {
            this.fpInfo.changeStructure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean bl) {
        FilePackage filePackage = this;
        synchronized (filePackage) {
            for (DownloadLink downloadLink : this.getChildren()) {
                downloadLink.setEnabled(bl);
            }
        }
    }

    @Override
    public void nodeUpdated(DownloadLink downloadLink) {
        this.notifyChanges();
    }

    private void notifyChanges() {
        PackageController<FilePackage, DownloadLink> packageController = this.getControlledBy();
        if (packageController != null) {
            packageController.nodeUpdated(this);
        }
        if (this.fpInfo != null) {
            this.fpInfo.changeVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(DownloadLink downloadLink) {
        FilePackage filePackage = this;
        synchronized (filePackage) {
            return this.downloadLinkList.indexOf(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePackageView getView() {
        if (this.fpInfo != null) {
            return this.fpInfo;
        }
        FilePackage filePackage = this;
        synchronized (filePackage) {
            if (this.fpInfo == null) {
                this.fpInfo = new FilePackageView(this);
            }
        }
        return this.fpInfo;
    }

    static {
        FP = new FilePackage(){
            private static final long serialVersionUID = 1L;

            @Override
            public void _add(DownloadLink ... downloadLinkArray) {
            }

            @Override
            public void remove(DownloadLink ... downloadLinkArray) {
            }

            @Override
            public void setControlledBy(PackageController<FilePackage, DownloadLink> packageController) {
            }

            @Override
            public UniqueSessionID getUniqueID() {
                return null;
            }
        };
        FP.setName(_JDT._.controller_packages_defaultname());
        FilePackage.FP.downloadLinkList = new ArrayList<DownloadLink>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public DownloadLink set(int n, DownloadLink downloadLink) {
                return null;
            }

            @Override
            public boolean add(DownloadLink downloadLink) {
                return true;
            }

            @Override
            public void add(int n, DownloadLink downloadLink) {
            }

            @Override
            public boolean addAll(Collection<? extends DownloadLink> collection) {
                return false;
            }

            @Override
            public boolean addAll(int n, Collection<? extends DownloadLink> collection) {
                return false;
            }
        };
    }
}

