/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.RequestVariable;
import jd.parser.html.Form;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class PostRequest
extends Request {
    private final ArrayList<RequestVariable> postVariables = new ArrayList();
    private String postString = null;
    private String contentType = null;
    private byte[] postBytes = null;
    private SEND sendWHAT = null;

    public static ArrayList<RequestVariable> variableMaptoArray(LinkedHashMap<String, String> linkedHashMap) {
        if (linkedHashMap == null) {
            return null;
        }
        ArrayList<RequestVariable> arrayList = new ArrayList<RequestVariable>();
        for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
            arrayList.add(new RequestVariable(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    public PostRequest(Form form) throws MalformedURLException {
        super(form.getAction(null));
    }

    public PostRequest(String string) throws MalformedURLException {
        super(Browser.correctURL(string));
    }

    public void addAll(ArrayList<RequestVariable> arrayList) {
        this.postVariables.addAll(arrayList);
    }

    public void addAll(HashMap<String, String> hashMap) {
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            this.postVariables.add(new RequestVariable(entry));
        }
    }

    public void addVariable(String string, String string2) {
        this.postVariables.add(new RequestVariable(string, string2));
    }

    public String getPostDataString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (RequestVariable requestVariable : this.postVariables) {
            if (requestVariable.getKey() == null) continue;
            stringBuilder.append("&");
            stringBuilder.append(requestVariable.getKey());
            stringBuilder.append("=");
            if (requestVariable.getValue() != null) {
                stringBuilder.append(requestVariable.getValue());
                continue;
            }
            stringBuilder.append("");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        return stringBuilder.substring(1);
    }

    public String log() {
        if (this.sendWHAT == null) {
            return null;
        }
        switch (this.sendWHAT) {
            case NOTHING: {
                return "zero content send";
            }
            case BYTES: {
                return this.postBytes.length + " raw-bytes send";
            }
            case STRING: {
                return this.postString;
            }
            case VARIABLES: {
                return this.getPostDataString();
            }
        }
        return "unknown postData send";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long postContent(URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        if (this.sendWHAT == null) {
            throw new IOException("preRequest needs to be called first!");
        }
        String string = null;
        CountingOutputStream countingOutputStream = null;
        countingOutputStream = uRLConnectionAdapter != null && uRLConnectionAdapter.getOutputStream() != null ? new CountingOutputStream(uRLConnectionAdapter.getOutputStream()) : new CountingOutputStream(new NullOutputStream());
        switch (this.sendWHAT) {
            case NOTHING: {
                return 0L;
            }
            case BYTES: {
                countingOutputStream.write(this.postBytes);
                return countingOutputStream.transferedBytes();
            }
            case STRING: {
                string = this.postString;
                break;
            }
            case VARIABLES: {
                string = this.getPostDataString();
                break;
            }
            default: {
                throw new IOException("not implemented " + this.sendWHAT.name());
            }
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)countingOutputStream, "UTF-8");
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        countingOutputStream.flush();
        return countingOutputStream.transferedBytes();
    }

    @Override
    public long postRequest() throws IOException {
        return this.postContent(this.httpConnection);
    }

    @Override
    public void preRequest() throws IOException {
        this.httpConnection.setRequestMethod(HTTPConnection.RequestMethod.POST);
        if (this.contentType != null) {
            this.httpConnection.setRequestProperty("Content-Type", this.contentType);
        }
        if (this.postVariables != null && this.postVariables.size() > 0) {
            this.sendWHAT = SEND.VARIABLES;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else if (!StringUtils.isEmpty(this.postString)) {
            this.sendWHAT = SEND.STRING;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else if (this.postBytes != null) {
            this.sendWHAT = SEND.BYTES;
            this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
        } else {
            this.sendWHAT = SEND.NOTHING;
            this.httpConnection.setRequestProperty("Content-Length", "0");
        }
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setPostBytes(byte[] byArray) {
        this.postBytes = byArray;
    }

    public void setPostDataString(String string) {
        this.postString = string;
    }

    private static enum SEND {
        VARIABLES,
        STRING,
        BYTES,
        NOTHING;

    }
}

