/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class PostFormDataRequest
extends Request {
    private String boundary;
    private final ArrayList<FormData> formDatas;
    private String encodeType = "multipart/form-data";

    public PostFormDataRequest(String string) throws MalformedURLException {
        super(Browser.correctURL(string));
        this.generateBoundary();
        this.formDatas = new ArrayList();
    }

    public void addFormData(FormData formData) {
        this.formDatas.add(formData);
    }

    private void generateBoundary() {
        long l = (long)(Math.random() * 8.99999999999999E14) + 100000000000000L;
        this.boundary = "---------------------" + l;
    }

    public String getEncodeType() {
        return this.encodeType;
    }

    public String getPostDataString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.formDatas.size(); ++i) {
            this.write(this.formDatas.get(i), stringBuffer);
        }
        stringBuffer.append(this.boundary);
        stringBuffer.append("--\r\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long postContent(URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        CountingOutputStream countingOutputStream = null;
        countingOutputStream = uRLConnectionAdapter != null && uRLConnectionAdapter.getOutputStream() != null ? new CountingOutputStream(uRLConnectionAdapter.getOutputStream()) : new CountingOutputStream(new NullOutputStream());
        for (int i = 0; i < this.formDatas.size(); ++i) {
            this.write(this.formDatas.get(i), countingOutputStream);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(countingOutputStream);
        outputStreamWriter.write(this.boundary);
        outputStreamWriter.write("--\r\n");
        outputStreamWriter.flush();
        countingOutputStream.flush();
        return countingOutputStream.transferedBytes();
    }

    @Override
    public long postRequest() throws IOException {
        return this.postContent(this.httpConnection);
    }

    @Override
    public void preRequest() throws IOException {
        this.httpConnection.setRequestMethod(HTTPConnection.RequestMethod.POST);
        this.httpConnection.setRequestProperty("Content-Type", this.encodeType + "; boundary=" + this.boundary.substring(2));
        this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
    }

    public void setEncodeType(String string) {
        this.encodeType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(FormData formData, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write(this.boundary);
        outputStreamWriter.write("\r\n");
        switch (formData.getType()) {
            case VARIABLE: {
                outputStreamWriter.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"");
                outputStreamWriter.write("\r\n\r\n");
                outputStreamWriter.write(formData.getValue() + "\r\n");
                break;
            }
            case DATA: {
                outputStreamWriter.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                outputStreamWriter.write("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                outputStreamWriter.flush();
                outputStream.write(formData.getData(), 0, formData.getData().length);
                outputStream.flush();
                outputStreamWriter.write("\r\n");
                outputStreamWriter.flush();
                break;
            }
            case FILE: {
                outputStreamWriter.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + formData.getValue() + "\"");
                outputStreamWriter.write("\r\nContent-Type: " + formData.getDataType() + "\r\n\r\n");
                outputStreamWriter.flush();
                byte[] byArray = new byte[1024];
                FileInputStream fileInputStream = null;
                try {
                    int n;
                    fileInputStream = new FileInputStream(formData.getFile());
                    while ((n = ((InputStream)fileInputStream).read(byArray)) > -1) {
                        outputStream.write(byArray, 0, n);
                    }
                    outputStream.flush();
                    outputStreamWriter.write("\r\n");
                    outputStreamWriter.flush();
                    if (fileInputStream == null) break;
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                break;
            }
        }
        outputStreamWriter.flush();
        outputStream.flush();
    }

    private void write(FormData formData, StringBuffer stringBuffer) {
        stringBuffer.append(this.boundary);
        stringBuffer.append("\r\n");
        switch (formData.getType()) {
            case VARIABLE: {
                stringBuffer.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"");
                stringBuffer.append("\r\n\r\n");
                stringBuffer.append(formData.getValue()).append("\r\n");
                break;
            }
            case DATA: {
                stringBuffer.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"; filename=\"").append(formData.getValue()).append("\"");
                stringBuffer.append("\r\nContent-Type: ").append(formData.getDataType());
                stringBuffer.append("\r\n\r\n[.....").append(formData.getData().length).append(" Byte DATA....]\r\n");
                break;
            }
            case FILE: {
                stringBuffer.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"; filename=\"").append(formData.getValue()).append("\"");
                stringBuffer.append("\r\nContent-Type: ").append(formData.getDataType());
                stringBuffer.append("\r\n\r\n[.....").append(formData.getFile().length()).append(" FileByte DATA....]\r\n");
            }
        }
    }
}

