/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

import jd.crypt.AEStables;
import jd.crypt.Copy;

public class AESencrypt {
    private static final int Nb = 4;
    private int Nk;
    private int Nr;
    private AEStables tab;
    private byte[] w;
    private int wCount;

    public AESencrypt(byte[] byArray, int n) {
        this.Nk = n;
        this.Nr = this.Nk + 6;
        this.tab = new AEStables();
        this.w = new byte[16 * (this.Nr + 1)];
        this.KeyExpansion(byArray, this.w);
    }

    private void AddRoundKey(byte[][] byArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray[j][i] = (byte)(byArray[j][i] ^ this.w[this.wCount++]);
            }
        }
    }

    public void Cipher(byte[] byArray, byte[] byArray2) {
        this.wCount = 0;
        byte[][] byArray3 = new byte[4][4];
        Copy.copy(byArray3, byArray);
        this.AddRoundKey(byArray3);
        for (int i = 1; i < this.Nr; ++i) {
            this.SubBytes(byArray3);
            this.ShiftRows(byArray3);
            this.MixColumns(byArray3);
            this.AddRoundKey(byArray3);
        }
        this.SubBytes(byArray3);
        this.ShiftRows(byArray3);
        this.AddRoundKey(byArray3);
        Copy.copy(byArray2, byArray3);
    }

    private void KeyExpansion(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = new byte[4];
        for (n = 0; n < 4 * this.Nk; ++n) {
            byArray2[n] = (byte)(byArray[n] + (byte)n);
        }
        while (n < 16 * (this.Nr + 1)) {
            int n2;
            int n3 = n / 4;
            for (n2 = 0; n2 < 4; ++n2) {
                byArray3[n2] = byArray2[n - 4 + n2];
            }
            if (n3 % this.Nk == 0) {
                int n4 = byArray3[0];
                for (int i = 0; i < 4; ++i) {
                    n2 = i == 3 ? n4 : byArray3[i + 1];
                    byte by = i == 0 ? this.tab.Rcon(n3 / this.Nk) : (byte)0;
                    byArray3[i] = (byte)(this.tab.SBox((byte)n2) ^ by);
                }
            } else if (this.Nk > 6 && n3 % this.Nk == 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    byArray3[n2] = this.tab.SBox(byArray3[n2]);
                }
            }
            for (n2 = 0; n2 < 4; ++n2) {
                byArray2[n + n2] = (byte)(byArray2[n - 4 * this.Nk + n2] ^ byArray3[n2]);
            }
            n += 4;
        }
    }

    private void MixColumns(byte[][] byArray) {
        int[] nArray = new int[4];
        byte by = 2;
        byte by2 = 3;
        for (int i = 0; i < 4; ++i) {
            nArray[0] = this.tab.FFMul(by, byArray[0][i]) ^ this.tab.FFMul(by2, byArray[1][i]) ^ byArray[2][i] ^ byArray[3][i];
            nArray[1] = byArray[0][i] ^ this.tab.FFMul(by, byArray[1][i]) ^ this.tab.FFMul(by2, byArray[2][i]) ^ byArray[3][i];
            nArray[2] = byArray[0][i] ^ byArray[1][i] ^ this.tab.FFMul(by, byArray[2][i]) ^ this.tab.FFMul(by2, byArray[3][i]);
            nArray[3] = this.tab.FFMul(by2, byArray[0][i]) ^ byArray[1][i] ^ byArray[2][i] ^ this.tab.FFMul(by, byArray[3][i]);
            for (int j = 0; j < 4; ++j) {
                byArray[j][i] = (byte)nArray[j];
            }
        }
    }

    private void ShiftRows(byte[][] byArray) {
        byte[] byArray2 = new byte[4];
        for (int i = 1; i < 4; ++i) {
            int n;
            for (n = 0; n < 4; ++n) {
                byArray2[n] = byArray[i][(n + i) % 4];
            }
            for (n = 0; n < 4; ++n) {
                byArray[i][n] = byArray2[n];
            }
        }
    }

    private void SubBytes(byte[][] byArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray[i][j] = this.tab.SBox(byArray[i][j]);
            }
        }
    }
}

