/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.HashSet;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.UniqueSessionID;

public class PackageInfo {
    private UniqueSessionID uniqueId = null;
    private Boolean autoExtractionEnabled = null;
    private HashSet<String> extractionPasswords = new HashSet();
    private String name = null;
    private String destinationFolder = null;
    private String comment = null;

    public Boolean isAutoExtractionEnabled() {
        return this.autoExtractionEnabled;
    }

    public void setAutoExtractionEnabled(Boolean bl) {
        this.autoExtractionEnabled = bl;
    }

    public UniqueSessionID getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(UniqueSessionID uniqueSessionID) {
        this.uniqueId = uniqueSessionID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDestinationFolder(String string) {
        this.destinationFolder = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public HashSet<String> getExtractionPasswords() {
        return this.extractionPasswords;
    }

    public String createPackageID() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getUniqueId() != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("_");
            }
            stringBuilder.append(this.getUniqueId().toString());
        }
        if (!StringUtils.isEmpty(this.getName())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("_");
            }
            stringBuilder.append(this.getName());
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    public static CrawledPackage createCrawledPackage(CrawledLink crawledLink) {
        PackageInfo packageInfo = crawledLink.getDesiredPackageInfo();
        if (packageInfo == null) {
            return null;
        }
        CrawledPackage crawledPackage = new CrawledPackage();
        String string = packageInfo.getName();
        if (StringUtils.isEmpty(string)) {
            string = LinknameCleaner.cleanFileName(crawledLink.getName());
            crawledPackage.setName(string);
        } else {
            crawledPackage.setName(string);
        }
        crawledPackage.setCreated(crawledLink.getCreated());
        crawledPackage.setComment(packageInfo.getComment());
        if (packageInfo.isAutoExtractionEnabled() != null) {
            crawledPackage.setAutoExtractionEnabled(packageInfo.isAutoExtractionEnabled());
        }
        if (!StringUtils.isEmpty(packageInfo.getDestinationFolder())) {
            crawledPackage.setDownloadFolder(packageInfo.getDestinationFolder());
        }
        return crawledPackage;
    }
}

