/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jd.config.Property;
import jd.controlling.IOPermission;
import jd.controlling.JDPluginLogger;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.BrokenCrawlerHandler;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.LinkCrawlerConfig;
import jd.controlling.linkcrawler.LinkCrawlerDistributer;
import jd.controlling.linkcrawler.LinkCrawlerEvent;
import jd.controlling.linkcrawler.LinkCrawlerEventSender;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.controlling.linkcrawler.LinkCrawlerRunnable;
import jd.controlling.linkcrawler.LinkCrawlerThread;
import jd.controlling.linkcrawler.PackageInfo;
import jd.http.Browser;
import jd.parser.html.HTMLParser;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging.Log;
import org.jdownloader.controlling.UniqueSessionID;
import org.jdownloader.plugins.controller.container.ContainerPluginController;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GeneralSettings;

public class LinkCrawler
implements IOPermission {
    private PluginForHost directHTTP = null;
    private PluginForHost ftp = null;
    private ArrayList<CrawledLink> crawledLinks = new ArrayList();
    private AtomicInteger crawledLinksCounter = new AtomicInteger(0);
    private ArrayList<CrawledLink> filteredLinks = new ArrayList();
    private AtomicInteger filteredLinksCounter = new AtomicInteger(0);
    private AtomicInteger crawler = new AtomicInteger(0);
    private static AtomicInteger CRAWLER = new AtomicInteger(0);
    private HashSet<String> duplicateFinderContainer = new HashSet();
    private HashSet<String> duplicateFinderCrawler = new HashSet();
    private HashSet<String> duplicateFinderFinal = new HashSet();
    private HashSet<String> duplicateFinderDeep = new HashSet();
    private LinkCrawlerHandler handler = null;
    private static ThreadPoolExecutor threadPool = null;
    private HashSet<String> captchaBlockedHoster = new HashSet();
    private boolean captchaBlockedAll = false;
    private LinkCrawlerFilter filter = null;
    private volatile boolean allowCrawling = true;
    private AtomicInteger crawlerGeneration = new AtomicInteger(0);
    private LinkCrawler parentCrawler = null;
    private final long created;
    public static final String ALLOW_MERGE = "ALLOW_MERGE";
    public static final UniqueSessionID PERMANENT_OFFLINE_ID = new UniqueSessionID();
    private boolean doDuplicateFinderFinalCheck = true;
    private static Comparator<Runnable> comparator = new Comparator<Runnable>(){

        @Override
        public int compare(Runnable runnable, Runnable runnable2) {
            long l;
            if (runnable == runnable2) {
                return 0;
            }
            long l2 = ((LinkCrawlerRunnable)runnable).getAverageRuntime();
            return l2 < (l = ((LinkCrawlerRunnable)runnable2).getAverageRuntime()) ? -1 : (l2 == l ? 0 : 1);
        }
    };
    private static LinkCrawlerEventSender EVENTSENDER;

    public boolean isDoDuplicateFinderFinalCheck() {
        if (this.parentCrawler != null) {
            this.parentCrawler.isDoDuplicateFinderFinalCheck();
        }
        return this.doDuplicateFinderFinalCheck;
    }

    public static LinkCrawlerEventSender getEventSender() {
        return EVENTSENDER;
    }

    public LinkCrawler() {
        this(true, true);
    }

    public LinkCrawler(boolean bl, boolean bl2) {
        this.setHandler(this.defaulHandlerFactory());
        this.setFilter(LinkCrawler.defaultFilterFactory());
        if (bl && Thread.currentThread() instanceof LinkCrawlerThread) {
            LinkCrawlerThread linkCrawlerThread = (LinkCrawlerThread)Thread.currentThread();
            this.parentCrawler = linkCrawlerThread.getCurrentLinkCrawler();
        }
        for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
            if (this.directHTTP == null && "http links".equals(lazyHostPlugin.getDisplayName())) {
                this.directHTTP = (PluginForHost)lazyHostPlugin.getPrototype();
            }
            if (this.ftp != null || !"ftp".equals(lazyHostPlugin.getDisplayName())) continue;
            this.ftp = (PluginForHost)lazyHostPlugin.getPrototype();
        }
        this.created = System.currentTimeMillis();
        this.doDuplicateFinderFinalCheck = bl2;
    }

    public LinkCrawler(boolean bl) {
        this(true, true);
    }

    public long getCreated() {
        if (this.parentCrawler != null) {
            return this.parentCrawler.getCreated();
        }
        return this.created;
    }

    protected int getCrawlerGeneration(boolean bl) {
        if (!bl && this.parentCrawler != null) {
            return Math.max(this.crawlerGeneration.get(), this.parentCrawler.getCrawlerGeneration(false));
        }
        return this.crawlerGeneration.get();
    }

    protected CrawledLink crawledLinkFactorybyURL(String string) {
        return new CrawledLink(string);
    }

    public void crawl(String string) {
        this.crawl(string, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crawl(final String string, final String string2, final boolean bl) {
        block9: {
            int n = this.getCrawlerGeneration(true);
            if (!this.checkStartNotify()) {
                return;
            }
            try {
                if (StringUtils.isEmpty(string)) {
                    return;
                }
                if (this.insideDecrypterPlugin()) {
                    ArrayList<CrawledLink> arrayList = this._crawl(string, string2, bl);
                    this.crawl(arrayList);
                    break block9;
                }
                if (!this.checkStartNotify()) {
                    return;
                }
                threadPool.execute(new LinkCrawlerRunnable(this, n){

                    @Override
                    void crawling() {
                        ArrayList arrayList = LinkCrawler.this._crawl(string, string2, bl);
                        LinkCrawler.this.crawl(arrayList);
                    }
                });
                return;
            }
            finally {
                this.checkFinishNotify();
            }
        }
    }

    private ArrayList<CrawledLink> _crawl(String string, String string2, boolean bl) {
        String[] stringArray = HTMLParser.getHttpLinks(string, string2);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>(stringArray.length);
        for (String string3 : stringArray) {
            CrawledLink crawledLink = this.crawledLinkFactorybyURL(string3);
            arrayList.add(crawledLink);
            crawledLink.setCrawlDeep(bl);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crawl(final ArrayList<CrawledLink> arrayList) {
        int n = this.getCrawlerGeneration(true);
        if (!this.checkStartNotify()) {
            return;
        }
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            if (this.insideDecrypterPlugin()) {
                this.distribute(arrayList);
                return;
            }
            if (!this.checkStartNotify()) {
                return;
            }
            threadPool.execute(new LinkCrawlerRunnable(this, n){

                @Override
                void crawling() {
                    LinkCrawler.this.distribute(arrayList);
                }
            });
            return;
        }
        finally {
            this.checkFinishNotify();
        }
    }

    private boolean insideDecrypterPlugin() {
        return Thread.currentThread() instanceof LinkCrawlerThread && ((LinkCrawlerThread)Thread.currentThread()).isLinkCrawlerThreadUsedbyDecrypter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFinishNotify() {
        boolean bl = false;
        LinkCrawler linkCrawler = this;
        synchronized (linkCrawler) {
            if (this.crawler.decrementAndGet() == 0) {
                Serializable serializable = CRAWLER;
                synchronized (serializable) {
                    CRAWLER.decrementAndGet();
                }
                serializable = this.crawler;
                synchronized (serializable) {
                    this.crawler.notifyAll();
                }
                serializable = this.duplicateFinderContainer;
                synchronized (serializable) {
                    this.duplicateFinderContainer.clear();
                }
                serializable = this.duplicateFinderCrawler;
                synchronized (serializable) {
                    this.duplicateFinderCrawler.clear();
                }
                serializable = this.duplicateFinderFinal;
                synchronized (serializable) {
                    this.duplicateFinderFinal.clear();
                }
                serializable = this.duplicateFinderDeep;
                synchronized (serializable) {
                    this.duplicateFinderDeep.clear();
                }
                bl = true;
            }
        }
        if (bl) {
            EVENTSENDER.fireEvent(new LinkCrawlerEvent(this, LinkCrawlerEvent.Type.STOPPED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStartNotify() {
        boolean bl = false;
        LinkCrawler linkCrawler = this;
        synchronized (linkCrawler) {
            if (!this.allowCrawling) {
                return false;
            }
            if (this.crawler.get() == 0) {
                bl = true;
                AtomicInteger atomicInteger = CRAWLER;
                synchronized (atomicInteger) {
                    CRAWLER.incrementAndGet();
                }
            }
            this.crawler.incrementAndGet();
        }
        if (bl) {
            EVENTSENDER.fireEvent(new LinkCrawlerEvent(this, LinkCrawlerEvent.Type.STARTED));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void crawlDeeper(CrawledLink crawledLink) {
        if (!this.checkStartNotify()) {
            return;
        }
        try {
            Object object;
            block34: {
                ArrayList<CrawledLink> arrayList;
                block33: {
                    if (crawledLink == null) {
                        return;
                    }
                    object = this.duplicateFinderDeep;
                    synchronized (object) {
                        if (!this.duplicateFinderDeep.add(crawledLink.getURL())) {
                            return;
                        }
                    }
                    object = null;
                    arrayList = null;
                    new URL(crawledLink.getURL());
                    if (!this.isCrawledLinkFiltered(crawledLink)) break block33;
                    try {
                        ((Browser)object).getHttpConnection().disconnect();
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        return;
                    }
                }
                object = new Browser();
                String string = crawledLink.getURL();
                ((Browser)object).openGetConnection(string);
                if (((Browser)object).getRedirectLocation() != null) {
                    try {
                        ((Browser)object).getHttpConnection().disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    string = ((Browser)object).getRedirectLocation();
                    ((Browser)object).openGetConnection(string);
                }
                if (((Browser)object).getHttpConnection().isContentDisposition() || ((Browser)object).getHttpConnection().getContentType() != null && !((Browser)object).getHttpConnection().getContentType().contains("text")) {
                    try {
                        ((Browser)object).getHttpConnection().disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    arrayList = this._crawl("directhttp://" + string, null, false);
                } else {
                    ((Browser)object).followConnection();
                    String string2 = new Regex(crawledLink.getURL(), "(.+)/").getMatch(0);
                    if (string2 != null && !string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    arrayList = this._crawl(((Browser)object).toString(), string2, false);
                }
                if (arrayList == null || arrayList.size() <= 0) break block34;
                this.crawl(arrayList);
            }
            try {
                ((Browser)object).getHttpConnection().disconnect();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
            catch (Throwable throwable) {
                try {
                    ((Browser)object).getHttpConnection().disconnect();
                    return;
                }
                catch (Throwable throwable2) {
                    return;
                }
                catch (Throwable throwable3) {
                    try {
                        ((Browser)object).getHttpConnection().disconnect();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw throwable3;
                }
            }
        }
        finally {
            this.checkFinishNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void distribute(ArrayList<CrawledLink> var1_1) {
        var2_2 = this.getCrawlerGeneration(true);
        if (!this.checkStartNotify()) {
            return;
        }
        try {
            if (var1_1 == null || var1_1.size() == 0) {
                return;
            }
            block21: for (final CrawledLink var4_4 : var1_1) {
                while (true) {
                    var5_5 = var4_4.getUnknownHandler();
                    var4_4.setUnknownHandler(null);
                    if (var4_4.gethPlugin() != null) {
                        this.handleCrawledLink(var4_4);
                        continue block21;
                    }
                    var6_6 = var4_4.getURL();
                    if (var6_6 == null) continue block21;
                    if (!var6_6.startsWith("directhttp")) {
                        for (Object var8_11 : ContainerPluginController.getInstance().list()) {
                            if (!var8_11.canHandle(var6_6)) continue;
                            var9_12 = var8_11.getContainerLinks(var6_6);
                            if (var9_12 == null) continue block21;
                            var10_16 = var9_12.iterator();
                            while (var10_16.hasNext()) {
                                var11_17 = (CrawledLink)var10_16.next();
                                this.forwardCrawledLinkInfos(var4_4, (CrawledLink)var11_17);
                                if (var4_4.getCryptedLink() != null) {
                                    var12_18 = var4_4.getCryptedLink().getProperties();
                                    if (var12_18 != null && !var12_18.isEmpty()) {
                                        var11_17.getCryptedLink().setProperties(new HashMap<String, Object>((Map<String, Object>)var12_18));
                                    }
                                    var11_17.getCryptedLink().setDecrypterPassword(var4_4.getCryptedLink().getDecrypterPassword());
                                }
                                if (this.insideDecrypterPlugin()) {
                                    this.container((CrawledLink)var11_17);
                                    continue;
                                }
                                if (this.checkStartNotify()) ** break block49
                                return;
                            }
                            continue block21;
                            {
                                try {
                                    LinkCrawler.threadPool.execute(new LinkCrawlerRunnable(this, var2_2, (CrawledLink)var11_17){
                                        final /* synthetic */ CrawledLink val$decryptThis;
                                        {
                                            this.val$decryptThis = crawledLink;
                                            super(linkCrawler2, n);
                                        }

                                        @Override
                                        void crawling() {
                                            LinkCrawler.this.container(this.val$decryptThis);
                                        }
                                    });
                                    continue;
                                }
                                catch (Throwable var9_13) {
                                    Log.exception(var9_13);
                                    continue block21;
                                    break;
                                }
                            }
                        }
                        for (Object var8_11 : CrawlerPluginController.getInstance().list()) {
                            if (!var8_11.canHandle(var6_6)) continue;
                            var9_12 = (PluginForDecrypt)var8_11.getPrototype();
                            if (var9_12 == null || (var10_16 = var9_12.getCrawlableLinks(var6_6)) == null) continue block21;
                            var11_17 = var10_16.iterator();
                            while (var11_17.hasNext()) {
                                var12_18 = (CrawledLink)var11_17.next();
                                this.forwardCrawledLinkInfos(var4_4, (CrawledLink)var12_18);
                                if (var4_4.getCryptedLink() != null) {
                                    var13_19 = var4_4.getCryptedLink().getProperties();
                                    if (var13_19 != null && !var13_19.isEmpty()) {
                                        var12_18.getCryptedLink().setProperties(new HashMap<String, Object>((Map<String, Object>)var13_19));
                                    }
                                    var12_18.getCryptedLink().setDecrypterPassword(var4_4.getCryptedLink().getDecrypterPassword());
                                }
                                if (this.insideDecrypterPlugin()) {
                                    this.crawl((CrawledLink)var12_18);
                                    continue;
                                }
                                if (this.checkStartNotify()) ** break block50
                                return;
                            }
                            continue block21;
                            {
                                try {
                                    LinkCrawler.threadPool.execute(new LinkCrawlerRunnable(this, var2_2, (LazyCrawlerPlugin)var8_11, (CrawledLink)var12_18){
                                        final /* synthetic */ LazyCrawlerPlugin val$pDecrypt;
                                        final /* synthetic */ CrawledLink val$decryptThis;
                                        {
                                            this.val$pDecrypt = lazyCrawlerPlugin;
                                            this.val$decryptThis = crawledLink;
                                            super(linkCrawler2, n);
                                        }

                                        @Override
                                        public long getAverageRuntime() {
                                            return this.val$pDecrypt.getAverageCrawlRuntime();
                                        }

                                        @Override
                                        void crawling() {
                                            LinkCrawler.this.crawl(this.val$decryptThis);
                                        }
                                    });
                                    continue;
                                }
                                catch (Throwable var9_14) {
                                    Log.exception(var9_14);
                                    continue block21;
                                    break;
                                }
                            }
                        }
                    }
                    for (Object var8_11 : HostPluginController.getInstance().list()) {
                        if (!var8_11.canHandle(var6_6)) continue;
                        try {
                            var9_12 = (PluginForHost)var8_11.getPrototype();
                            if (var9_12 == null) continue block21;
                            if (this.ftp != null && this.ftp == var9_12) continue;
                            var10_16 = null;
                            if (var4_4.getDownloadLink() != null) {
                                var10_16 = var4_4.getDownloadLink().getFilePackage();
                            }
                            if ((var11_17 = var9_12.getDownloadLinks(var6_6, (FilePackage)var10_16)) == null) continue block21;
                            this.forwardDownloadLinkInfos(var4_4.getDownloadLink(), (List<DownloadLink>)var11_17);
                            var12_18 = var11_17.iterator();
                            while (var12_18.hasNext()) {
                                var13_19 = (DownloadLink)var12_18.next();
                                var14_20 = new CrawledLink((DownloadLink)var13_19);
                                this.forwardCrawledLinkInfos(var4_4, var14_20);
                                this.handleCrawledLink(var14_20);
                            }
                            continue block21;
                        }
                        catch (Throwable var9_15) {
                            Log.exception(var9_15);
                            continue block21;
                        }
                    }
                    if (var5_5 == null) break;
                    try {
                        var5_5.unhandledCrawledLink(var4_4, this);
                    }
                    catch (Throwable var7_8) {
                        Log.exception(var7_8);
                    }
                }
                if (this.directHTTP != null) {
                    var6_6 = var6_6.replaceFirst("http://", "httpviajd://");
                    if (this.directHTTP.canHandle(var6_6 = var6_6.replaceFirst("https://", "httpsviajd://"))) {
                        try {
                            var7_7 = null;
                            if (var4_4.getDownloadLink() != null) {
                                var7_7 = var4_4.getDownloadLink().getFilePackage();
                            }
                            if ((var8_11 = this.directHTTP.getDownloadLinks(var6_6, (FilePackage)var7_7)) == null) continue;
                            this.forwardDownloadLinkInfos(var4_4.getDownloadLink(), (List<DownloadLink>)var8_11);
                            var9_12 = var8_11.iterator();
                            while (var9_12.hasNext()) {
                                var10_16 = var9_12.next();
                                var11_17 = new CrawledLink((DownloadLink)var10_16);
                                this.forwardCrawledLinkInfos(var4_4, (CrawledLink)var11_17);
                                this.handleCrawledLink((CrawledLink)var11_17);
                            }
                            continue;
                        }
                        catch (Throwable var7_9) {
                            Log.exception(var7_9);
                            continue;
                        }
                    }
                }
                if (this.ftp != null && this.ftp.canHandle(var6_6)) {
                    try {
                        var7_7 = null;
                        if (var4_4.getDownloadLink() != null) {
                            var7_7 = var4_4.getDownloadLink().getFilePackage();
                        }
                        if ((var8_11 = this.ftp.getDownloadLinks(var6_6, (FilePackage)var7_7)) == null) continue;
                        this.forwardDownloadLinkInfos(var4_4.getDownloadLink(), (List<DownloadLink>)var8_11);
                        var9_12 = var8_11.iterator();
                        while (var9_12.hasNext()) {
                            var10_16 = var9_12.next();
                            var11_17 = new CrawledLink((DownloadLink)var10_16);
                            this.forwardCrawledLinkInfos(var4_4, (CrawledLink)var11_17);
                            this.handleCrawledLink((CrawledLink)var11_17);
                        }
                        continue;
                    }
                    catch (Throwable var7_10) {
                        Log.exception(var7_10);
                        continue;
                    }
                }
                if (!var4_4.isCrawlDeep()) continue;
                if (this.insideDecrypterPlugin()) {
                    this.crawlDeeper(var4_4);
                    continue;
                }
                if (!this.checkStartNotify()) {
                    return;
                }
                LinkCrawler.threadPool.execute(new LinkCrawlerRunnable(this, var2_2){

                    @Override
                    void crawling() {
                        LinkCrawler.this.crawlDeeper(var4_4);
                    }
                });
            }
        }
        finally {
            this.checkFinishNotify();
        }
    }

    private void forwardCrawledLinkInfos(CrawledLink crawledLink, CrawledLink crawledLink2) {
        if (crawledLink == null || crawledLink2 == null) {
            return;
        }
        crawledLink2.setSourceLink(crawledLink);
        crawledLink2.setMatchingFilter(crawledLink.getMatchingFilter());
        crawledLink2.setSourceJob(crawledLink.getSourceJob());
        crawledLink2.setDesiredPackageInfo(crawledLink.getDesiredPackageInfo());
        this.convertFilePackageInfos(crawledLink2);
        this.permanentOffline(crawledLink2);
    }

    private PackageInfo convertFilePackageInfos(CrawledLink crawledLink) {
        if (crawledLink.getDownloadLink() != null && !FilePackage.isDefaultFilePackage(crawledLink.getDownloadLink().getFilePackage())) {
            FilePackage filePackage;
            PackageInfo packageInfo = crawledLink.getDesiredPackageInfo();
            if (packageInfo == null) {
                packageInfo = new PackageInfo();
            }
            if ((filePackage = crawledLink.getDownloadLink().getFilePackage()).getDownloadDirectory() != null && !filePackage.getDownloadDirectory().equals(JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder())) {
                packageInfo.setDestinationFolder(filePackage.getDownloadDirectory());
            }
            packageInfo.setAutoExtractionEnabled(filePackage.isPostProcessing());
            packageInfo.setName(LinknameCleaner.cleanFileName(filePackage.getName()));
            if (Boolean.FALSE.equals(filePackage.getBooleanProperty(ALLOW_MERGE, false))) {
                packageInfo.setUniqueId(filePackage.getUniqueID());
            }
            for (String string : filePackage.getPasswordList()) {
                packageInfo.getExtractionPasswords().add(string);
            }
            crawledLink.setDesiredPackageInfo(packageInfo);
            return packageInfo;
        }
        return null;
    }

    private void permanentOffline(CrawledLink crawledLink) {
        DownloadLink downloadLink = crawledLink.getDownloadLink();
        try {
            if (downloadLink != null && downloadLink.getDefaultPlugin().getLazyP().getClassname().contains("Offline")) {
                PackageInfo packageInfo = crawledLink.getDesiredPackageInfo();
                if (packageInfo == null) {
                    packageInfo = new PackageInfo();
                    crawledLink.setDesiredPackageInfo(packageInfo);
                }
                packageInfo.setUniqueId(PERMANENT_OFFLINE_ID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void forwardDownloadLinkInfos(DownloadLink downloadLink, List<DownloadLink> list) {
        if (downloadLink == null || list == null || list.size() == 0) {
            return;
        }
        for (DownloadLink downloadLink2 : list) {
            HashMap<String, Object> hashMap;
            downloadLink2.addSourcePluginPasswordList(downloadLink.getSourcePluginPasswordList());
            downloadLink2.setSourcePluginComment(downloadLink.getComment());
            downloadLink2.setName(downloadLink.getName());
            downloadLink2.forceFileName(downloadLink.getForcedFileName());
            downloadLink2.setFinalFileName(downloadLink.getFinalFileName());
            if (downloadLink.gotBrowserUrl()) {
                downloadLink2.setBrowserUrl(downloadLink.getBrowserUrl());
            }
            if (downloadLink.isAvailabilityStatusChecked()) {
                downloadLink2.setAvailable(downloadLink.isAvailable());
            }
            if ((hashMap = downloadLink.getProperties()) != null && !hashMap.isEmpty()) {
                downloadLink2.setProperties(new HashMap<String, Object>(hashMap));
            }
            downloadLink2.getLinkStatus().setStatusText(downloadLink.getLinkStatus().getStatusString());
            downloadLink2.setDownloadSize(downloadLink.getDownloadSize());
        }
    }

    public boolean isCrawlingAllowed() {
        return this.allowCrawling;
    }

    public void setCrawlingAllowed(boolean bl) {
        this.allowCrawling = bl;
    }

    public void stopCrawling() {
        this.crawlerGeneration.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCrawling() {
        while (this.crawler.get() > 0) {
            LinkCrawler linkCrawler = this;
            synchronized (linkCrawler) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        return this.crawler.get() == 0;
    }

    public boolean isRunning() {
        return this.crawler.get() > 0;
    }

    public static boolean isCrawling() {
        return CRAWLER.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void container(CrawledLink crawledLink) {
        int n = this.getCrawlerGeneration(true);
        if (!this.checkStartNotify()) {
            return;
        }
        try {
            Object object = this.duplicateFinderContainer;
            // MONITORENTER : object
            if (!this.duplicateFinderContainer.add(crawledLink.getURL())) {
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (this.isCrawledLinkFiltered(crawledLink)) {
                return;
            }
            if (crawledLink.getcPlugin() == null) return;
            if (crawledLink.getURL() == null) {
                return;
            }
            object = null;
            try {
                object = (PluginsC)crawledLink.getcPlugin().getClass().newInstance();
            }
            catch (Throwable throwable) {
                this.checkFinishNotify();
                return;
            }
            LinkCrawlerThread linkCrawlerThread = null;
            if (Thread.currentThread() instanceof LinkCrawlerThread) {
                linkCrawlerThread = (LinkCrawlerThread)Thread.currentThread();
            }
            boolean bl = false;
            LinkCrawler linkCrawler = null;
            try {
                ArrayList<CrawledLink> arrayList;
                if (linkCrawlerThread != null) {
                    bl = linkCrawlerThread.isLinkCrawlerThreadUsedbyDecrypter();
                    linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(true);
                    linkCrawler = linkCrawlerThread.getCurrentLinkCrawler();
                    linkCrawlerThread.setCurrentLinkCrawler(this);
                }
                if ((arrayList = ((PluginsC)object).decryptContainer(crawledLink)) != null && arrayList.size() > 0) {
                    for (CrawledLink crawledLink2 : arrayList) {
                        this.forwardCrawledLinkInfos(crawledLink, crawledLink2);
                    }
                    if (!this.checkStartNotify()) {
                        if (linkCrawlerThread == null) return;
                        linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(bl);
                        linkCrawlerThread.setCurrentLinkCrawler(linkCrawler);
                        return;
                    }
                    threadPool.execute(new LinkCrawlerRunnable(this, n){

                        @Override
                        void crawling() {
                            LinkCrawler.this.distribute(arrayList);
                        }
                    });
                }
                if (linkCrawlerThread == null) return;
                linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(bl);
                linkCrawlerThread.setCurrentLinkCrawler(linkCrawler);
                return;
            }
            catch (Throwable throwable) {
                if (linkCrawlerThread == null) throw throwable;
                linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(bl);
                linkCrawlerThread.setCurrentLinkCrawler(linkCrawler);
                throw throwable;
            }
        }
        finally {
            this.checkFinishNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void crawl(final CrawledLink crawledLink) {
        final int n = this.getCrawlerGeneration(true);
        if (!this.checkStartNotify()) {
            return;
        }
        ClassLoader classLoader = null;
        try {
            Object object = this.duplicateFinderCrawler;
            // MONITORENTER : object
            if (!this.duplicateFinderCrawler.add(crawledLink.getURL())) {
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (this.isCrawledLinkFiltered(crawledLink)) {
                return;
            }
            if (crawledLink.getdPlugin() == null) return;
            if (crawledLink.getCryptedLink() == null) {
                return;
            }
            object = crawledLink.getdPlugin();
            PluginForDecrypt pluginForDecrypt = ((PluginForDecrypt)object).getNewInstance();
            pluginForDecrypt.setIOPermission(this);
            pluginForDecrypt.setBrowser(new Browser());
            pluginForDecrypt.setLogger(new JDPluginLogger(crawledLink.getURL()));
            LinkCrawlerThread linkCrawlerThread = null;
            if (Thread.currentThread() instanceof LinkCrawlerThread) {
                linkCrawlerThread = (LinkCrawlerThread)Thread.currentThread();
            }
            boolean bl = false;
            LinkCrawlerDistributer linkCrawlerDistributer = null;
            LinkCrawler linkCrawler = null;
            ArrayList<DownloadLink> arrayList = null;
            try {
                linkCrawlerDistributer = new LinkCrawlerDistributer(){
                    CrawledLinkModifier lm = new CrawledLinkModifier(){

                        @Override
                        public void modifyCrawledLink(CrawledLink crawledLink) {
                            DownloadLink downloadLink = crawledLink.getDownloadLink();
                            if (downloadLink != null && !downloadLink.gotBrowserUrl()) {
                                downloadLink.setBrowserUrl(crawledLink.getURL());
                            }
                        }
                    };

                    @Override
                    public void distribute(DownloadLink ... downloadLinkArray) {
                        if (downloadLinkArray == null || downloadLinkArray.length == 0) {
                            return;
                        }
                        final ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>(downloadLinkArray.length);
                        for (DownloadLink downloadLink : downloadLinkArray) {
                            CrawledLink crawledLink2 = new CrawledLink(downloadLink);
                            arrayList.add(crawledLink2);
                            crawledLink2.setCustomCrawledLinkModifier(this.lm);
                            LinkCrawler.this.forwardCrawledLinkInfos(crawledLink, crawledLink2);
                        }
                        if (!LinkCrawler.this.checkStartNotify()) {
                            return;
                        }
                        threadPool.execute(new LinkCrawlerRunnable(LinkCrawler.this, n){

                            @Override
                            void crawling() {
                                LinkCrawler.this.distribute(arrayList);
                            }
                        });
                    }
                };
                pluginForDecrypt.setDistributer(linkCrawlerDistributer);
                if (linkCrawlerThread != null) {
                    bl = linkCrawlerThread.isLinkCrawlerThreadUsedbyDecrypter();
                    linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(true);
                    linkCrawler = linkCrawlerThread.getCurrentLinkCrawler();
                    linkCrawlerThread.setCurrentLinkCrawler(this);
                }
                long l = System.currentTimeMillis();
                classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((PluginForDecrypt)object).getLazyC().getClassLoader());
                arrayList = pluginForDecrypt.decryptLink(crawledLink);
                long l2 = System.currentTimeMillis() - l;
                ((PluginForDecrypt)object).getLazyC().updateCrawlRuntime(l2);
                if (linkCrawlerThread != null) {
                    linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(bl);
                    linkCrawlerThread.setCurrentLinkCrawler(linkCrawler);
                }
                pluginForDecrypt.setDistributer(null);
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                if (linkCrawlerThread != null) {
                    linkCrawlerThread.setLinkCrawlerThreadUsedbyDecrypter(bl);
                    linkCrawlerThread.setCurrentLinkCrawler(linkCrawler);
                }
                pluginForDecrypt.setDistributer(null);
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            BrokenCrawlerHandler brokenCrawlerHandler = crawledLink.getBrokenCrawlerHandler();
            crawledLink.setBrokenCrawlerHandler(null);
            if (arrayList != null) {
                linkCrawlerDistributer.distribute(arrayList.toArray(new DownloadLink[arrayList.size()]));
                return;
            }
            if (brokenCrawlerHandler == null) return;
            try {
                brokenCrawlerHandler.brokenCrawler(crawledLink, this);
                return;
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
                return;
            }
        }
        finally {
            this.checkFinishNotify();
        }
    }

    public ArrayList<CrawledLink> getCrawledLinks() {
        return this.crawledLinks;
    }

    public ArrayList<CrawledLink> getFilteredLinks() {
        return this.filteredLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCrawledLink(CrawledLink crawledLink) {
        boolean bl;
        Object object;
        if (crawledLink == null) {
            return;
        }
        crawledLink.setCreated(this.getCreated());
        if (crawledLink.getDownloadLink() != null && crawledLink.getDownloadLink().getBooleanProperty("ALLOW_DUPE", false).booleanValue()) {
            crawledLink.getDownloadLink().setProperty("ALLOW_DUPE", Property.NULL);
        }
        try {
            this.generalCrawledLinkModifier(crawledLink);
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>();
        arrayList.add(0, crawledLink);
        for (CrawledLink crawledLink2 = crawledLink.getSourceLink(); crawledLink2 != null; crawledLink2 = crawledLink2.getSourceLink()) {
            arrayList.add(0, crawledLink2);
        }
        for (CrawledLink crawledLink3 : arrayList) {
            object = crawledLink3.getCustomCrawledLinkModifier();
            if (crawledLink == crawledLink3) {
                crawledLink.setCustomCrawledLinkModifier(null);
            }
            if (object == null) continue;
            try {
                object.modifyCrawledLink(crawledLink);
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
        CrawledLink crawledLink4 = crawledLink.getOriginLink();
        boolean bl2 = bl = crawledLink4 != crawledLink && crawledLink4.getLinkID().equals(crawledLink.getLinkID());
        if (this.isDoDuplicateFinderFinalCheck()) {
            object = this.duplicateFinderFinal;
            synchronized (object) {
                if (!this.duplicateFinderFinal.add(crawledLink.getLinkID()) && !bl) {
                    return;
                }
            }
        }
        if (!this.isCrawledLinkFiltered(crawledLink)) {
            this.crawledLinksCounter.incrementAndGet();
            this.handler.handleFinalLink(crawledLink);
        }
    }

    protected void generalCrawledLinkModifier(CrawledLink crawledLink) {
    }

    protected boolean isCrawledLinkFiltered(CrawledLink crawledLink) {
        if (this.filter.dropByUrl(crawledLink)) {
            this.filteredLinksCounter.incrementAndGet();
            this.handler.handleFilteredLink(crawledLink);
            return true;
        }
        return false;
    }

    public int crawledLinksFound() {
        return this.crawledLinksCounter.get();
    }

    public int filteredLinksFound() {
        return this.filteredLinksCounter.get();
    }

    protected LinkCrawlerHandler defaulHandlerFactory() {
        return new LinkCrawlerHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFinalLink(CrawledLink crawledLink) {
                ArrayList arrayList = LinkCrawler.this.crawledLinks;
                synchronized (arrayList) {
                    LinkCrawler.this.crawledLinks.add(crawledLink);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFilteredLink(CrawledLink crawledLink) {
                ArrayList arrayList = LinkCrawler.this.filteredLinks;
                synchronized (arrayList) {
                    LinkCrawler.this.filteredLinks.add(crawledLink);
                }
            }
        };
    }

    public static LinkCrawlerFilter defaultFilterFactory() {
        return new LinkCrawlerFilter(){

            @Override
            public boolean dropByUrl(CrawledLink crawledLink) {
                return false;
            }

            @Override
            public boolean dropByFileProperties(CrawledLink crawledLink) {
                return false;
            }
        };
    }

    public void setFilter(LinkCrawlerFilter linkCrawlerFilter) {
        if (linkCrawlerFilter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.filter = linkCrawlerFilter;
    }

    public LinkCrawlerFilter getFilter() {
        return this.filter;
    }

    public void setHandler(LinkCrawlerHandler linkCrawlerHandler) {
        if (linkCrawlerHandler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        this.handler = linkCrawlerHandler;
    }

    public LinkCrawlerHandler getHandler() {
        return this.handler;
    }

    @Override
    public synchronized boolean isCaptchaAllowed(String string) {
        if (this.parentCrawler != null) {
            return this.parentCrawler.isCaptchaAllowed(string);
        }
        if (this.captchaBlockedAll) {
            return false;
        }
        return !this.captchaBlockedHoster.contains(string);
    }

    @Override
    public synchronized void setCaptchaAllowed(String string, IOPermission.CAPTCHA cAPTCHA) {
        if (this.parentCrawler != null) {
            this.parentCrawler.setCaptchaAllowed(string, cAPTCHA);
            return;
        }
        switch (cAPTCHA) {
            case OK: {
                if (string != null && string.length() > 0) {
                    this.captchaBlockedHoster.remove(string);
                    break;
                }
                this.captchaBlockedHoster.clear();
                this.captchaBlockedAll = false;
                break;
            }
            case BLOCKALL: {
                this.captchaBlockedAll = true;
                break;
            }
            case BLOCKHOSTER: {
                this.captchaBlockedHoster.add(string);
            }
        }
    }

    static {
        int n = Math.max(JsonConfig.create(LinkCrawlerConfig.class).getMaxThreads(), 1);
        int n2 = Math.max(JsonConfig.create(LinkCrawlerConfig.class).getThreadKeepAlive(), 100);
        threadPool = new ThreadPoolExecutor(0, n, (long)n2, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(100, comparator), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new LinkCrawlerThread(runnable);
            }
        }, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()){

            @Override
            protected void beforeExecute(Thread thread, Runnable runnable) {
                super.beforeExecute(thread, runnable);
                int n = threadPool.getActiveCount();
                int n2 = threadPool.getPoolSize();
                int n3 = threadPool.getMaximumPoolSize();
                if (n2 < n3 && n == n2) {
                    threadPool.setCorePoolSize(Math.min(n3, n2 + 1));
                }
            }
        };
        threadPool.allowCoreThreadTimeOut(true);
        EVENTSENDER = new LinkCrawlerEventSender();
    }
}

