/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import jd.controlling.AccountController;
import jd.controlling.IOEQ;
import jd.controlling.IOEQAction;
import jd.controlling.IOPermission;
import jd.controlling.JDLogger;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadControllerEvent;
import jd.controlling.downloadcontroller.DownloadControllerListener;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.ProxyInfo;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.download.DownloadInterface;
import org.appwork.controlling.State;
import org.appwork.controlling.StateMachine;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DownloadWatchDog
implements DownloadControllerListener,
StateMachineInterface,
ShutdownVetoListener,
IOPermission,
FileCreationListener {
    public static final State IDLE_STATE = new State("IDLE");
    public static final State RUNNING_STATE = new State("RUNNING");
    public static final State STOPPING_STATE = new State("STOPPING");
    public static final State STOPPED_STATE = new State("STOPPED_STATE");
    private final LinkedList<SingleDownloadController> DownloadControllers = new LinkedList();
    private final LinkedList<DownloadLink> forcedLinks = new LinkedList();
    private final LinkedList<DownloadLink> sessionHistory = new LinkedList();
    private final HashMap<String, ArrayList<SingleDownloadController>> activeDownloadsbyHost = new HashMap();
    private Object currentstopMark = STOPMARK.NONE;
    private static final Logger LOG;
    private boolean paused = false;
    private Thread watchDogThread = null;
    private DownloadController dlc = null;
    private AtomicInteger activeDownloads = new AtomicInteger(0);
    private StateMachine stateMachine = null;
    private DownloadSpeedManager dsm = null;
    private int lastReconnectCounter = 0;
    private GeneralSettings config = JsonConfig.create(GeneralSettings.class);
    private static final DownloadWatchDog INSTANCE;
    private int speedLimitBeforePause = 0;
    private boolean speedLimitedBeforePause = false;

    public static DownloadWatchDog getInstance() {
        return INSTANCE;
    }

    private DownloadWatchDog() {
        this.dsm = new DownloadSpeedManager();
        this.dsm.setLimit(this.config.isDownloadSpeedLimitEnabled() ? this.config.getDownloadSpeedLimit() : 0);
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getEventSender().addListener(new GenericConfigEventListener<Integer>(){

            @Override
            public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer n) {
                DownloadWatchDog.this.dsm.setLimit(DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled() ? DownloadWatchDog.this.config.getDownloadSpeedLimit() : 0);
            }

            @Override
            public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer n, ValidationException validationException) {
            }
        }, false);
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.getEventSender().addListener(new GenericConfigEventListener<Boolean>(){

            @Override
            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean bl, ValidationException validationException) {
            }

            @Override
            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean bl) {
                DownloadWatchDog.this.dsm.setLimit(DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled() ? DownloadWatchDog.this.config.getDownloadSpeedLimit() : 0);
            }
        }, false);
        this.stateMachine = new StateMachine(this, IDLE_STATE, STOPPED_STATE);
        this.dlc = DownloadController.getInstance();
        this.dlc.addListener(this);
        ShutdownController.getInstance().addShutdownVetoListener(this);
        FileCreationManager.getInstance().getEventSender().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSingleDownloadController(SingleDownloadController singleDownloadController) {
        DownloadLink downloadLink = singleDownloadController.getDownloadLink();
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            if (this.DownloadControllers.contains(singleDownloadController)) {
                throw new IllegalStateException("SingleDownloadController already registered");
            }
            this.DownloadControllers.add(singleDownloadController);
            this.activeDownloads.incrementAndGet();
            String string = downloadLink.getHost();
            ArrayList<SingleDownloadController> arrayList = this.activeDownloadsbyHost.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.activeDownloadsbyHost.put(string, arrayList);
            }
            arrayList.add(singleDownloadController);
            LinkedList<DownloadLink> linkedList2 = this.sessionHistory;
            synchronized (linkedList2) {
                if (!this.sessionHistory.contains(singleDownloadController.getDownloadLink())) {
                    this.sessionHistory.add(singleDownloadController.getDownloadLink());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int activeDownloadsbyHosts(String string) {
        HashMap<String, ArrayList<SingleDownloadController>> hashMap = this.activeDownloadsbyHost;
        synchronized (hashMap) {
            ArrayList<SingleDownloadController> arrayList = this.activeDownloadsbyHost.get(string);
            if (arrayList != null) {
                return arrayList.size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFreeDiskSpace(File file, long l) {
        if (Application.getJavaVersion() < 16000000L) {
            return true;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        while (!file2.exists()) {
            if ((file2 = file2.getParentFile()) != null) continue;
            return false;
        }
        long l2 = 0x100000L * (long)this.config.getForcedFreeSpaceOnDisk();
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            for (SingleDownloadController singleDownloadController : this.DownloadControllers) {
                DownloadLink downloadLink = singleDownloadController.getDownloadLink();
                l2 += downloadLink.getDownloadSize() - downloadLink.getDownloadCurrent();
            }
        }
        return file2.getUsableSpace() >= l2 + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDownloadListStatus() {
        ProxyController.getInstance().removeIPBlockTimeout(null, true);
        ProxyController.getInstance().removeHostBlockedTimeout(null, false);
        DownloadController downloadController = DownloadController.getInstance();
        synchronized (downloadController) {
            Iterator iterator = DownloadController.getInstance().getPackages().iterator();
            while (iterator.hasNext()) {
                FilePackage filePackage;
                FilePackage filePackage2 = filePackage = (FilePackage)iterator.next();
                synchronized (filePackage2) {
                    for (DownloadLink downloadLink : filePackage.getChildren()) {
                        downloadLink.getLinkStatus().resetStatus(0x422000, 32, 2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSingleDownloadController(SingleDownloadController singleDownloadController) {
        DownloadLink downloadLink = singleDownloadController.getDownloadLink();
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            if (!this.DownloadControllers.remove(singleDownloadController)) {
                throw new IllegalStateException("SingleDownloadController not registed!");
            }
            this.activeDownloads.decrementAndGet();
            String string = downloadLink.getHost();
            ArrayList<SingleDownloadController> arrayList = this.activeDownloadsbyHost.get(string);
            if (arrayList == null) {
                throw new IllegalStateException("SingleDownloadController not registed!");
            }
            arrayList.remove(singleDownloadController);
            if (arrayList.size() == 0) {
                this.activeDownloadsbyHost.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forcedLinksWaiting() {
        LinkedList<DownloadLink> linkedList = this.forcedLinks;
        synchronized (linkedList) {
            return this.forcedLinks.size() > 0;
        }
    }

    public void forceDownload(final ArrayList<DownloadLink> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        IOEQ.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DownloadWatchDog.this.stateMachine.isState(STOPPING_STATE)) {
                    return;
                }
                if (DownloadWatchDog.this.stateMachine.isStartState() || DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.setStopMark(arrayList.get(0));
                    DownloadWatchDog.this.startDownloads();
                }
                LinkedList linkedList = DownloadWatchDog.this.forcedLinks;
                synchronized (linkedList) {
                    DownloadWatchDog.this.forcedLinks.addAll(arrayList);
                }
            }
        }, true);
    }

    public int getActiveDownloads() {
        return this.activeDownloads.get();
    }

    public DownloadSpeedManager getDownloadSpeedManager() {
        return this.dsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadssincelastStart() {
        LinkedList<DownloadLink> linkedList = this.sessionHistory;
        synchronized (linkedList) {
            return this.sessionHistory.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadControlInfo getNextForcedDownloadLink() {
        DownloadLink downloadLink = null;
        LinkedList<DownloadLink> linkedList = this.forcedLinks;
        synchronized (linkedList) {
            if (this.forcedLinks.size() > 0) {
                downloadLink = this.forcedLinks.removeFirst();
            }
        }
        if (downloadLink == null) {
            return null;
        }
        if (downloadLink.getDefaultPlugin() == null || downloadLink.getLinkStatus().isPluginActive() || downloadLink.getLinkStatus().hasStatus(Integer.MIN_VALUE)) {
            return null;
        }
        boolean bl = CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled();
        Account account = null;
        if (!downloadLink.getLinkStatus().hasStatus(2048)) {
            if (bl) {
                account = AccountController.getInstance().getValidAccount(downloadLink.getDefaultPlugin());
            }
            boolean bl2 = downloadLink.getDefaultPlugin().bypassMaxSimultanDownloadNum(downloadLink, account);
            ProxyInfo proxyInfo = ProxyController.getInstance().getProxyForDownload(downloadLink, account, bl2);
            if (proxyInfo != null && downloadLink.getLinkStatus().isStatus(1)) {
                if (!downloadLink.isEnabled()) {
                    downloadLink.setEnabled(true);
                }
                DownloadControlInfo downloadControlInfo = new DownloadControlInfo();
                downloadControlInfo.link = downloadLink;
                downloadControlInfo.account = account;
                downloadControlInfo.proxy = proxyInfo;
                downloadControlInfo.byPassSimultanDownloadNum = bl2;
                return downloadControlInfo;
            }
        }
        return null;
    }

    public DownloadControlInfo getNextDownloadLink(List<DownloadLink> list) {
        DownloadControlInfo downloadControlInfo = this.getNextForcedDownloadLink();
        if (downloadControlInfo != null) {
            return downloadControlInfo;
        }
        downloadControlInfo = new DownloadControlInfo();
        boolean bl = CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled();
        Account account = null;
        String string = null;
        int n = this.getSimultanDownloadNumPerHost();
        try {
            for (DownloadLink downloadLink : list) {
                if (downloadLink.getDefaultPlugin() == null || !downloadLink.isEnabled() || downloadLink.getLinkStatus().hasStatus(2048) || downloadLink.getLinkStatus().hasStatus(Integer.MIN_VALUE) || downloadLink.getLinkStatus().isPluginActive() || !downloadLink.getLinkStatus().isStatus(1) && !downloadLink.getLinkStatus().hasStatus(16) || this.activeDownloadsbyHosts(downloadLink.getHost()) >= n) continue;
                if (bl && (string == null || !string.equalsIgnoreCase(downloadLink.getHost())) && (account = AccountController.getInstance().getValidAccount(downloadLink.getDefaultPlugin())) != null) {
                    string = downloadLink.getHost();
                }
                boolean bl2 = downloadLink.getDefaultPlugin().bypassMaxSimultanDownloadNum(downloadLink, account);
                ProxyInfo proxyInfo = ProxyController.getInstance().getProxyForDownload(downloadLink, account, bl2);
                if (proxyInfo == null || downloadControlInfo.link != null && downloadLink.getPriority() <= downloadControlInfo.link.getPriority()) continue;
                downloadControlInfo.byPassSimultanDownloadNum = bl2;
                downloadControlInfo.proxy = proxyInfo;
                downloadControlInfo.link = downloadLink;
                downloadControlInfo.account = account;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (downloadControlInfo.link == null) {
            return null;
        }
        return downloadControlInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getForbiddenReconnectDownloadNum() {
        boolean bl = this.config.isInterruptResumeableDownloadsEnable();
        int n = 0;
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            for (SingleDownloadController singleDownloadController : this.DownloadControllers) {
                DownloadInterface downloadInterface;
                DownloadLink downloadLink = singleDownloadController.getDownloadLink();
                if (!downloadLink.getLinkStatus().hasStatus(1024) || (downloadInterface = downloadLink.getDownloadInstance()) != null && downloadInterface.isResumable() && bl) continue;
                ++n;
            }
        }
        return n;
    }

    public int getSimultanDownloadNumPerHost() {
        int n = 0;
        if (!CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.isEnabled() || (n = this.config.getMaxSimultaneDownloadsPerHost()) <= 0) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopMark(Object object) {
        return this.currentstopMark == object;
    }

    public boolean isStopMarkSet() {
        return this.currentstopMark != STOPMARK.NONE;
    }

    private boolean newDLStartAllowed() {
        if (!this.stateMachine.isState(RUNNING_STATE)) {
            return false;
        }
        if (this.paused) {
            return false;
        }
        return !CFG_GENERAL.AUTO_RECONNECT_ENABLED.isEnabled() || !this.config.isDownloadControllerPrefersReconnectEnabled() || !IPController.getInstance().isInvalidated();
    }

    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent downloadControllerEvent) {
        switch ((DownloadControllerEvent.TYPE)((Object)downloadControllerEvent.getType())) {
            case REMOVE_CONTENT: {
                if (this.currentstopMark == downloadControllerEvent.getParameter()) {
                    this.setStopMark((Object)STOPMARK.HIDDEN);
                    break;
                }
                if (downloadControllerEvent.getParameter() == null || !(downloadControllerEvent.getParameter() instanceof List)) break;
                List list = (List)downloadControllerEvent.getParameter();
                for (Object e : list) {
                    if (e != this.currentstopMark) continue;
                    this.setStopMark((Object)STOPMARK.HIDDEN);
                }
                break;
            }
        }
    }

    public void pauseDownloadWatchDog(final boolean bl) {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                if (DownloadWatchDog.this.paused == bl) {
                    return;
                }
                DownloadWatchDog.this.paused = bl;
                if (bl) {
                    DownloadWatchDog.this.speedLimitBeforePause = DownloadWatchDog.this.config.getDownloadSpeedLimit();
                    DownloadWatchDog.this.speedLimitedBeforePause = DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled();
                    DownloadWatchDog.this.config.setDownloadSpeedLimit(DownloadWatchDog.this.config.getPauseSpeed());
                    DownloadWatchDog.this.config.setDownloadSpeedLimitEnabled(true);
                    LOG.info("Pause enabled: Reducing downloadspeed to " + DownloadWatchDog.this.config.getPauseSpeed() + " KiB/s");
                } else {
                    DownloadWatchDog.this.config.setDownloadSpeedLimit(DownloadWatchDog.this.speedLimitBeforePause);
                    DownloadWatchDog.this.config.setDownloadSpeedLimitEnabled(DownloadWatchDog.this.speedLimitedBeforePause);
                    DownloadWatchDog.this.speedLimitBeforePause = 0;
                    LOG.info("Pause disabled: Switch back to old downloadspeed");
                }
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStopMarkReached() {
        if (this.forcedLinksWaiting()) {
            return false;
        }
        Object object = this.currentstopMark;
        if (object == STOPMARK.HIDDEN) {
            return true;
        }
        if (object instanceof DownloadLink) {
            Serializable serializable = this.sessionHistory;
            synchronized (serializable) {
                if (this.sessionHistory.contains(object)) {
                    return true;
                }
            }
            serializable = (DownloadLink)object;
            if (!((DownloadLink)serializable).isEnabled()) {
                return true;
            }
            return ((DownloadLink)serializable).getLinkStatus().isFinished();
        }
        if (object instanceof FilePackage) {
            Object object2 = object;
            synchronized (object2) {
                for (DownloadLink downloadLink : ((FilePackage)object).getChildren()) {
                    LinkedList<DownloadLink> linkedList = this.sessionHistory;
                    synchronized (linkedList) {
                        if (this.sessionHistory.contains(downloadLink)) {
                            continue;
                        }
                    }
                    if (downloadLink.isEnabled() && downloadLink.getLinkStatus().isFinished()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void removeIPBlockTimeout(DownloadLink downloadLink) {
        ProxyController.getInstance().removeIPBlockTimeout(downloadLink.getHost(), true);
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.hasStatus(16)) {
            linkStatus.reset();
        }
    }

    public void removeTempUnavailTimeout(DownloadLink downloadLink) {
        ProxyController.getInstance().removeHostBlockedTimeout(downloadLink.getHost(), false);
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.hasStatus(4096)) {
            linkStatus.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDownloadSpeedbyFilePackage(FilePackage filePackage) {
        long l = -1L;
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            for (SingleDownloadController singleDownloadController : this.DownloadControllers) {
                if (singleDownloadController.getDownloadLink().getFilePackage() != filePackage) continue;
                l += singleDownloadController.getDownloadLink().getDownloadSpeed();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadsbyFilePackage(FilePackage filePackage) {
        int n = 0;
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            for (SingleDownloadController singleDownloadController : this.DownloadControllers) {
                if (singleDownloadController.getDownloadLink().getFilePackage() != filePackage) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRunningDownloads(FilePackage filePackage) {
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            for (SingleDownloadController singleDownloadController : this.DownloadControllers) {
                if (singleDownloadController.getDownloadLink().getFilePackage() != filePackage) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAllSingleDownloadControllers() {
        ArrayList<SingleDownloadController> arrayList = new ArrayList<SingleDownloadController>();
        LinkedList<SingleDownloadController> linkedList = this.DownloadControllers;
        synchronized (linkedList) {
            arrayList.addAll(this.DownloadControllers);
            for (SingleDownloadController object : this.DownloadControllers) {
                object.abortDownload();
            }
        }
        int n = this.activeDownloads.get();
        if (n > 0) {
            while (true) {
                boolean bl = false;
                for (SingleDownloadController singleDownloadController : arrayList) {
                    if (!singleDownloadController.isAlive()) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    JDLogger.exception(interruptedException);
                }
            }
        }
    }

    public void resetSingleDownloadController(final SingleDownloadController singleDownloadController) {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                final DownloadLink downloadLink = singleDownloadController.getDownloadLink();
                singleDownloadController.getStateMachine().executeOnceOnState(new Runnable(){

                    @Override
                    public void run() {
                        DownloadWatchDog.this.removeIPBlockTimeout(downloadLink);
                        DownloadWatchDog.this.removeTempUnavailTimeout(downloadLink);
                        downloadLink.reset();
                    }
                }, SingleDownloadController.FINAL_STATE);
                if (downloadLink.getLinkStatus().isPluginActive()) {
                    singleDownloadController.abortDownload();
                }
            }
        }, true);
    }

    private int setDownloadActive(List<DownloadLink> list) {
        DownloadControlInfo downloadControlInfo = null;
        int n = 0;
        int n2 = this.config.getMaxSimultaneDownloads();
        for (int i = list.size(); (this.forcedLinksWaiting() || this.activeDownloads.get() < n2) && i >= 0; --i) {
            if (!this.newDLStartAllowed()) {
                return n;
            }
            if (this.isStopMarkReached()) {
                return n;
            }
            downloadControlInfo = this.getNextDownloadLink(list);
            if (downloadControlInfo == null) {
                return n;
            }
            Log.L.info("Start " + downloadControlInfo);
            DownloadLink downloadLink = downloadControlInfo.link;
            if (!this.checkFreeDiskSpace(new File(downloadLink.getFileOutput()), downloadLink.getDownloadSize() - downloadLink.getDownloadCurrent())) {
                downloadControlInfo.link.getLinkStatus().setStatus(Integer.MIN_VALUE);
                continue;
            }
            this.activateSingleDownloadController(downloadControlInfo);
            ++n;
        }
        return n;
    }

    public void setStopMark(final Object object) {
        IOEQ.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2 = object;
                if (object2 == null || object2 == STOPMARK.NONE) {
                    object2 = STOPMARK.NONE;
                }
                if (object2 == STOPMARK.RANDOM) {
                    LinkedList linkedList = DownloadWatchDog.this.DownloadControllers;
                    synchronized (linkedList) {
                        object2 = DownloadWatchDog.this.DownloadControllers.size() > 0 ? ((SingleDownloadController)DownloadWatchDog.this.DownloadControllers.getFirst()).getDownloadLink() : STOPMARK.NONE;
                    }
                }
                DownloadWatchDog.this.currentstopMark = object2;
            }
        }, true);
    }

    public void startDownloads() {
        IOEQ.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.stateMachine.reset(false);
                }
                if (!DownloadWatchDog.this.stateMachine.isStartState()) {
                    return;
                }
                DownloadWatchDog.this.stateMachine.setStatus(RUNNING_STATE);
                if (DownloadWatchDog.this.isStopMarkReached()) {
                    DownloadWatchDog.this.setStopMark((Object)STOPMARK.NONE);
                }
                LinkedList linkedList = DownloadWatchDog.this.sessionHistory;
                synchronized (linkedList) {
                    DownloadWatchDog.this.sessionHistory.clear();
                }
                LOG.info("DownloadWatchDog: start");
                DownloadWatchDog.this.startWatchDogThread();
            }
        }, true);
    }

    private void activateSingleDownloadController(final DownloadControlInfo downloadControlInfo) {
        LOG.info("Start new Download: " + downloadControlInfo.link.getHost() + ":" + downloadControlInfo.link.getName() + ":" + downloadControlInfo.proxy);
        final SingleDownloadController singleDownloadController = new SingleDownloadController(downloadControlInfo.link, downloadControlInfo.account, downloadControlInfo.proxy, this.dsm);
        if (!downloadControlInfo.byPassSimultanDownloadNum && downloadControlInfo.proxy != null) {
            downloadControlInfo.proxy.increaseActiveDownloads(downloadControlInfo.link.getHost());
        }
        singleDownloadController.setIOPermission(this);
        this.registerSingleDownloadController(singleDownloadController);
        singleDownloadController.getStateMachine().executeOnceOnState(new Runnable(){

            @Override
            public void run() {
                if (!downloadControlInfo.byPassSimultanDownloadNum && downloadControlInfo.proxy != null) {
                    downloadControlInfo.proxy.decreaseActiveDownloads(downloadControlInfo.link.getHost());
                }
                DownloadWatchDog.this.unregisterSingleDownloadController(singleDownloadController);
            }
        }, SingleDownloadController.FINAL_STATE);
        singleDownloadController.start();
    }

    private synchronized void startWatchDogThread() {
        if (this.watchDogThread == null || !this.watchDogThread.isAlive()) {
            this.watchDogThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.setName("DownloadWatchDog");
                    try {
                        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
                        int n = 2;
                        long l = -1L;
                        long l2 = -1L;
                        block19: while (DownloadWatchDog.this.stateMachine.isState(RUNNING_STATE)) {
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            boolean bl5 = DownloadController.getInstance().readLock();
                            try {
                                long l3 = DownloadController.getInstance().getPackageControllerChanges();
                                long l4 = DownloadController.getInstance().getContentChanges();
                                if (l3 != l || l4 != l2) {
                                    arrayList.clear();
                                    Iterator iterator = DownloadController.getInstance().getPackages().iterator();
                                    while (iterator.hasNext()) {
                                        FilePackage filePackage;
                                        FilePackage filePackage2 = filePackage = (FilePackage)iterator.next();
                                        synchronized (filePackage2) {
                                            for (DownloadLink downloadLink : filePackage.getChildren()) {
                                                if (downloadLink.getDefaultPlugin() == null || !downloadLink.isEnabled() || downloadLink.getAvailableStatus() == DownloadLink.AvailableStatus.FALSE || downloadLink.getLinkStatus().isFinished() || downloadLink.getLinkStatus().hasStatus(Integer.MIN_VALUE)) continue;
                                                arrayList.add(downloadLink);
                                            }
                                        }
                                    }
                                    l = l3;
                                    l2 = l4;
                                }
                            }
                            finally {
                                DownloadController.getInstance().readUnlock(bl5);
                            }
                            try {
                                for (DownloadLink downloadLink : arrayList) {
                                    LinkStatus linkStatus = downloadLink.getLinkStatus();
                                    if (!downloadLink.isEnabled()) continue;
                                    if (!linkStatus.isPluginActive()) {
                                        if (linkStatus.hasStatus(2048) || linkStatus.hasStatus(4096)) {
                                            if (linkStatus.getRemainingWaittime() == 0L) {
                                                if (linkStatus.hasStatus(4096)) {
                                                    AccountController.getInstance().removeAccountBlocked(downloadLink.getHost());
                                                }
                                                linkStatus.reset(false);
                                                continue;
                                            }
                                            bl2 = true;
                                            continue;
                                        }
                                        if (linkStatus.hasStatus(16)) {
                                            if (linkStatus.getRemainingWaittime() == 0L || bl4) {
                                                linkStatus.reset();
                                                AccountController.getInstance().removeAccountBlocked(downloadLink.getHost());
                                                continue;
                                            }
                                            if (bl4 || DownloadWatchDog.this.activeDownloadsbyHosts(downloadLink.getHost()) != 0) continue;
                                            bl3 = true;
                                            IPController.getInstance().invalidate();
                                            continue;
                                        }
                                        if (ProxyController.getInstance().hasHostBlocked(downloadLink.getHost()) && !downloadLink.getLinkStatus().isFinished()) {
                                            bl2 = true;
                                            continue;
                                        }
                                        if (!ProxyController.getInstance().hasIPBlock(downloadLink.getHost()) || downloadLink.getLinkStatus().isFinished() || DownloadWatchDog.this.activeDownloadsbyHosts(downloadLink.getHost()) != 0) continue;
                                        bl3 = true;
                                        IPController.getInstance().invalidate();
                                        continue;
                                    }
                                    bl = true;
                                }
                                int n2 = DownloadWatchDog.this.setDownloadActive(arrayList);
                                if (n2 == 0) {
                                    if (!(bl2 || bl || bl3 || DownloadWatchDog.this.activeDownloads.get() != 0)) {
                                        if (DownloadWatchDog.this.newDLStartAllowed()) {
                                            LOG.info(--n + "rounds left to start new downloads");
                                        }
                                        if (n == 0) {
                                            break;
                                        }
                                    }
                                } else {
                                    n = 2;
                                }
                            }
                            catch (Exception exception) {
                                JDLogger.exception(exception);
                            }
                            try {
                                int n3 = 0;
                                while (DownloadWatchDog.this.stateMachine.isState(RUNNING_STATE)) {
                                    9.sleep(1000L);
                                    if (++n3 == 5) continue block19;
                                    if (arrayList.size() != 0) continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        DownloadWatchDog.this.stateMachine.setStatus(STOPPING_STATE);
                        LinkedList linkedList = DownloadWatchDog.this.forcedLinks;
                        synchronized (linkedList) {
                            DownloadWatchDog.this.forcedLinks.clear();
                        }
                        LOG.info("DownloadWatchDog: stopping");
                        DownloadWatchDog.this.abortAllSingleDownloadControllers();
                        linkedList = DownloadWatchDog.this.sessionHistory;
                        synchronized (linkedList) {
                            DownloadWatchDog.this.sessionHistory.clear();
                        }
                        DownloadWatchDog.this.clearDownloadListStatus();
                        AccountController.getInstance().removeAccountBlocked((String)null);
                        DownloadWatchDog.this.pauseDownloadWatchDog(false);
                        if (DownloadWatchDog.this.isStopMarkReached()) {
                            DownloadWatchDog.this.setStopMark((Object)STOPMARK.NONE);
                        }
                    }
                    finally {
                        LOG.info("DownloadWatchDog: stopped");
                        DownloadWatchDog.this.stateMachine.setStatus(STOPPED_STATE);
                    }
                }
            };
            this.watchDogThread.start();
        }
    }

    public void stopDownloads() {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                if (DownloadWatchDog.this.stateMachine.isFinal() || DownloadWatchDog.this.stateMachine.isStartState()) {
                    return;
                }
                if (DownloadWatchDog.this.stateMachine.isState(STOPPING_STATE)) {
                    return;
                }
                DownloadWatchDog.this.stateMachine.setStatus(STOPPING_STATE);
            }
        }, true);
    }

    public void toggleStartStop() {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                if (DownloadWatchDog.this.stateMachine.isStartState() || DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.startDownloads();
                } else {
                    DownloadWatchDog.this.stopDownloads();
                }
            }
        }, true);
    }

    public void toggleStopMark(final Object object) {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                if (object == null || object == DownloadWatchDog.this.currentstopMark || object == STOPMARK.NONE) {
                    DownloadWatchDog.this.setStopMark((Object)STOPMARK.NONE);
                } else {
                    DownloadWatchDog.this.setStopMark(object);
                }
            }
        }, true);
    }

    @Override
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public void onShutdown() {
        IOEQ.getQueue().addWait(new IOEQAction(){

            @Override
            public void ioeqRun() {
                DownloadWatchDog.this.stopDownloads();
            }

            @Override
            protected boolean allowAsync() {
                return false;
            }
        });
    }

    @Override
    public void onShutdownRequest(int n) throws ShutdownVetoException {
        if (n > 0) {
            return;
        }
        if (this.stateMachine.isState(RUNNING_STATE, STOPPING_STATE)) {
            // empty if block
        }
        this.config.setClosedWithRunningDownloads(false);
    }

    @Override
    public void onShutdownVeto(ArrayList<ShutdownVetoException> arrayList) {
    }

    @Override
    public boolean isCaptchaAllowed(String string) {
        return true;
    }

    @Override
    public void setCaptchaAllowed(String string, IOPermission.CAPTCHA cAPTCHA) {
    }

    @Override
    public void onNewFile(Object object, File[] fileArray) {
        if (JsonConfig.create(GeneralSettings.class).isAutoOpenContainerAfterDownload()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : fileArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append("file://");
                stringBuilder.append(file.getPath());
            }
            LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(stringBuilder.toString()));
        }
    }

    static {
        IDLE_STATE.addChildren(RUNNING_STATE);
        RUNNING_STATE.addChildren(STOPPING_STATE);
        STOPPING_STATE.addChildren(STOPPED_STATE);
        LOG = JDLogger.getLogger();
        INSTANCE = new DownloadWatchDog();
    }

    public static enum STOPMARK {
        NONE,
        HIDDEN,
        RANDOM;

    }

    public static class DownloadControlInfo {
        public boolean byPassSimultanDownloadNum = false;
        public DownloadLink link;
        public ProxyInfo proxy;
        public Account account;

        public String toString() {
            return "Proxy: " + this.proxy + ", Account " + this.account + " link: " + this.link + " bypasssim: " + this.byPassSimultanDownloadNum;
        }
    }
}

