/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;

public class DownloadInformations {
    private static final DownloadInformations INSTANCE = new DownloadInformations();
    private final Object UPDATELOCK = new Object();
    private long lastUpdate = 0L;
    private long totalDownloadSize = 0L;
    private long currentDownloadSize = 0L;
    private int packages = 0;
    private int downloadLinks = 0;
    private int disabledDownloads = 0;
    private int runningDownloads = 0;
    private int finishedDownloads = 0;
    private int duplicateDownloads = 0;

    public static DownloadInformations getInstance() {
        return INSTANCE;
    }

    private DownloadInformations() {
    }

    protected void reset() {
        this.totalDownloadSize = 0L;
        this.currentDownloadSize = 0L;
        this.packages = 0;
        this.downloadLinks = 0;
        this.disabledDownloads = 0;
        this.runningDownloads = 0;
        this.finishedDownloads = 0;
        this.duplicateDownloads = 0;
    }

    protected void addTotalDownloadSize(long l) {
        this.totalDownloadSize += l;
    }

    protected void addCurrentDownloadSize(long l) {
        this.currentDownloadSize += l;
    }

    protected void addPackages(int n) {
        this.packages += n;
    }

    protected void addDownloadLinks(int n) {
        this.downloadLinks += n;
    }

    protected void addDisabledDownloads(int n) {
        this.disabledDownloads += n;
    }

    protected void addRunningDownloads(int n) {
        this.runningDownloads += n;
    }

    protected void addFinishedDownloads(int n) {
        this.finishedDownloads += n;
    }

    protected void addDuplicateDownloads(int n) {
        this.duplicateDownloads += n;
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public long getCurrentDownloadSize() {
        return this.currentDownloadSize;
    }

    public int getPackagesCount() {
        return this.packages;
    }

    public int getDownloadCount() {
        return this.downloadLinks;
    }

    public int getDisabledDownloads() {
        return this.disabledDownloads;
    }

    public int getRunningDownloads() {
        return this.runningDownloads;
    }

    public int getFinishedDownloads() {
        return this.finishedDownloads;
    }

    public int getDuplicateDownloads() {
        return this.duplicateDownloads;
    }

    public long getETA() {
        long l = 0L;
        if (DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed() > 1024) {
            l = (this.getTotalDownloadSize() - this.getCurrentDownloadSize()) / (long)DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
        }
        return l;
    }

    public double getPercent() {
        return (double)Math.round((double)this.getCurrentDownloadSize() * 10000.0 / (double)this.getTotalDownloadSize()) / 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInformations() {
        Object object = this.UPDATELOCK;
        synchronized (object) {
            if (System.currentTimeMillis() - this.lastUpdate >= 1000L) {
                try {
                    DownloadController.getInstance().getDownloadStatus(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.lastUpdate = System.currentTimeMillis();
                }
            }
        }
    }
}

