/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import jd.controlling.IOEQ;
import jd.controlling.JDLogger;
import jd.controlling.downloadcontroller.DownloadControllerEvent;
import jd.controlling.downloadcontroller.DownloadControllerListener;
import jd.controlling.downloadcontroller.DownloadInformations;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.FilePackageStorable;
import jd.controlling.packagecontroller.PackageController;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging.Log;
import org.appwork.utils.zip.ZipIOReader;
import org.appwork.utils.zip.ZipIOWriter;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class DownloadController
extends PackageController<FilePackage, DownloadLink> {
    private transient Eventsender<DownloadControllerListener, DownloadControllerEvent> broadcaster = new Eventsender<DownloadControllerListener, DownloadControllerEvent>(){

        @Override
        protected void fireEvent(DownloadControllerListener downloadControllerListener, DownloadControllerEvent downloadControllerEvent) {
            downloadControllerListener.onDownloadControllerEvent(downloadControllerEvent);
        }
    };
    private DelayedRunnable asyncSaving = null;
    private boolean allowSave = false;
    private boolean allowLoad = true;
    private static DownloadController INSTANCE = new DownloadController();
    private static Object SAVELOADLOCK = new Object();

    public static DownloadController getInstance() {
        return INSTANCE;
    }

    private DownloadController() {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                for (int i = 10; i > 0 && !DownloadWatchDog.getInstance().getStateMachine().isFinal() && !DownloadWatchDog.getInstance().getStateMachine().isStartState(); --i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                DownloadController.this.saveDownloadLinks();
            }

            @Override
            public String toString() {
                return "save downloadlist...";
            }
        });
        this.asyncSaving = new DelayedRunnable(IOEQ.TIMINGQUEUE, 5000L, 60000L){

            @Override
            public void delayedrun() {
                DownloadController.this.saveDownloadLinks();
            }
        };
        this.broadcaster.addListener(new DownloadControllerListener(){

            @Override
            public void onDownloadControllerEvent(DownloadControllerEvent downloadControllerEvent) {
                DownloadController.this.asyncSaving.run();
            }
        });
    }

    @Override
    protected void _controllerPackageNodeAdded(FilePackage filePackage, Queue.QueuePriority queuePriority) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, DownloadControllerEvent.TYPE.REFRESH_STRUCTURE));
    }

    @Override
    protected void _controllerPackageNodeRemoved(FilePackage filePackage, Queue.QueuePriority queuePriority) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, DownloadControllerEvent.TYPE.REMOVE_CONTENT, filePackage));
    }

    @Override
    protected void _controllerParentlessLinks(List<DownloadLink> list, Queue.QueuePriority queuePriority) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, DownloadControllerEvent.TYPE.REMOVE_CONTENT, list));
        if (list != null) {
            for (DownloadLink downloadLink : list) {
                downloadLink.setEnabled(false);
            }
        }
    }

    @Override
    protected void _controllerStructureChanged(Queue.QueuePriority queuePriority) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, DownloadControllerEvent.TYPE.REFRESH_STRUCTURE));
    }

    public void addAll(ArrayList<FilePackage> arrayList) {
        this.addAllAt(arrayList, 0);
    }

    public void addAllAt(final ArrayList<FilePackage> arrayList, final int n) {
        if (arrayList != null && arrayList.size() > 0) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                @Override
                protected Void run() throws RuntimeException {
                    int n2 = n;
                    for (FilePackage filePackage : arrayList) {
                        DownloadController.this.addmovePackageAt(filePackage, n2++);
                    }
                    return null;
                }
            });
        }
    }

    public void addListener(DownloadControllerListener downloadControllerListener) {
        this.broadcaster.addListener(downloadControllerListener);
    }

    public void addPackage(FilePackage filePackage) {
        this.addmovePackageAt(filePackage, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<DownloadLink> getAllDownloadLinks() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        boolean bl = this.readLock();
        try {
            Iterator iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                FilePackage filePackage;
                FilePackage filePackage2 = filePackage = (FilePackage)iterator.next();
                synchronized (filePackage2) {
                    arrayList.addAll(filePackage.getChildren());
                }
            }
            return arrayList;
        }
        finally {
            this.readUnlock(bl);
        }
    }

    private String getCheckFileName() {
        return "check.info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getDownloadLinksbyStatus(FilePackage filePackage, int n) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        if (filePackage != null) {
            FilePackage filePackage2 = filePackage;
            synchronized (filePackage2) {
                for (DownloadLink downloadLink : filePackage.getChildren()) {
                    if (!downloadLink.getLinkStatus().hasStatus(n)) continue;
                    arrayList.add(downloadLink);
                }
            }
        }
        return arrayList;
    }

    private File getDownloadListFile() {
        return Application.getResource("cfg/downloadList.zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getDownloadStatus(DownloadInformations downloadInformations) {
        downloadInformations.reset();
        downloadInformations.addRunningDownloads(DownloadWatchDog.getInstance().getActiveDownloads());
        boolean bl = this.readLock();
        try {
            Iterator iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                FilePackage filePackage;
                FilePackage filePackage2 = filePackage = (FilePackage)iterator.next();
                synchronized (filePackage2) {
                    downloadInformations.addPackages(1);
                    downloadInformations.addDownloadLinks(filePackage.size());
                    for (DownloadLink downloadLink : filePackage.getChildren()) {
                        LinkStatus linkStatus = downloadLink.getLinkStatus();
                        boolean bl2 = downloadLink.isEnabled();
                        if (!linkStatus.hasStatus(8192) && bl2) {
                            downloadInformations.addTotalDownloadSize(downloadLink.getDownloadSize());
                            downloadInformations.addCurrentDownloadSize(downloadLink.getDownloadCurrent());
                        }
                        if (linkStatus.hasStatus(8192)) {
                            downloadInformations.addDuplicateDownloads(1);
                            continue;
                        }
                        if (!bl2) {
                            downloadInformations.addDisabledDownloads(1);
                            continue;
                        }
                        if (!linkStatus.hasStatus(2)) continue;
                        downloadInformations.addFinishedDownloads(1);
                    }
                }
            }
            return;
        }
        finally {
            this.readUnlock(bl);
        }
    }

    /*
     * Exception decompiling
     */
    public DownloadLink getFirstLinkThatBlocks(DownloadLink var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public LinkedList<FilePackage> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDownloadLinkwithURL(String string) {
        if (string == null) return false;
        String string2 = string.trim();
        boolean bl = this.readLock();
        try {
            Iterator iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                FilePackage filePackage;
                FilePackage filePackage2 = filePackage = (FilePackage)iterator.next();
                synchronized (filePackage2) {
                    for (DownloadLink downloadLink : filePackage.getChildren()) {
                        if (!string2.equalsIgnoreCase(downloadLink.getDownloadURL())) continue;
                        boolean bl2 = true;
                        return bl2;
                    }
                }
            }
            return false;
        }
        finally {
            this.readUnlock(bl);
        }
    }

    public synchronized void initDownloadLinks() {
        if (!this.isLoadAllowed()) {
            return;
        }
        LinkedList<FilePackage> linkedList = null;
        try {
            linkedList = this.load(this.getDownloadListFile());
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        try {
            if (linkedList == null) {
                linkedList = this.load(new File(this.getDownloadListFile().getAbsolutePath() + ".tmp"));
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        try {
            if (linkedList == null) {
                linkedList = this.loadDownloadLinks();
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        this.postInit(linkedList);
        final LinkedList<FilePackage> linkedList2 = linkedList;
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void run() throws RuntimeException {
                if (DownloadController.this.isLoadAllowed()) {
                    DownloadController.this.writeLock();
                    try {
                        for (FilePackage filePackage : linkedList2) {
                            filePackage.setControlledBy(DownloadController.this);
                        }
                        DownloadController.this.packages.addAll(0, linkedList2);
                    }
                    finally {
                        DownloadController.this.setLoadAllowed(false);
                        DownloadController.this.setSaveAllowed(true);
                        DownloadController.this.writeUnlock();
                    }
                    DownloadController.this.broadcaster.fireEvent(new DownloadControllerEvent(DownloadController.this, DownloadControllerEvent.TYPE.REFRESH_STRUCTURE));
                }
                return null;
            }
        });
    }

    public boolean isLoadAllowed() {
        return this.allowLoad;
    }

    public boolean isSaveAllowed() {
        return this.allowSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private LinkedList<FilePackage> load(File file) {
        Object object = SAVELOADLOCK;
        synchronized (object) {
            LinkedList linkedList;
            block43: {
                linkedList = null;
                if (file == null || !file.exists()) break block43;
                ZipIOReader zipIOReader = null;
                try {
                    void var10_20;
                    Object object2;
                    int n;
                    Object object4;
                    Object object5;
                    zipIOReader = new ZipIOReader(file);
                    ZipEntry zipEntry = zipIOReader.getZipFile(this.getCheckFileName());
                    String string = null;
                    if (zipEntry != null) {
                        object5 = null;
                        try {
                            object5 = zipIOReader.getInputStream(zipEntry);
                            object4 = IO.readStream(1024, (InputStream)object5);
                            string = new String((byte[])object4, "UTF-8");
                            object4 = null;
                        }
                        finally {
                            try {
                                ((InputStream)object5).close();
                            }
                            catch (Throwable throwable) {}
                        }
                        zipEntry = null;
                    }
                    if (string != null) {
                        object5 = MessageDigest.getInstance("SHA1");
                        object4 = new byte[1024];
                        n = 0;
                        for (ZipEntry zipEntry2 : zipIOReader.getZipFiles()) {
                            if (!zipEntry2.getName().matches("^\\d+$")) continue;
                            ++n;
                            FilterInputStream filterInputStream = null;
                            try {
                                filterInputStream = new DigestInputStream(zipIOReader.getInputStream(zipEntry2), (MessageDigest)object5);
                                while (filterInputStream.read((byte[])object4) >= 0) {
                                }
                            }
                            finally {
                                try {
                                    filterInputStream.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        String i = HexFormatter.byteArrayToHex(((MessageDigest)object5).digest());
                        object2 = new Regex(string, "(\\d+)").getMatch(0);
                        String string2 = new Regex(string, ".*?:(\\d+)").getMatch(0);
                        String string3 = new Regex(string, ".*?:.*?:(.+)").getMatch(0);
                        boolean bl = string2 != null && Integer.parseInt(string2) == n;
                        boolean bl2 = string3 != null && string3.equalsIgnoreCase(i);
                        Log.L.info("DownloadListVerify: TimeStamp(" + (String)object2 + ")|numberOfPackages(" + n + "):" + bl + "|hash:" + bl2);
                    }
                    object5 = new HashMap();
                    object4 = zipIOReader.getZipFiles();
                    n = ((byte[])object4).length;
                    boolean iterator = false;
                    while (var10_20 < n) {
                        object2 = object4[var10_20];
                        if (object2.getName().matches("^\\d+$")) {
                            InputStream inputStream;
                            block42: {
                                int n2 = Integer.parseInt(object2.getName());
                                InputStream inputStream2 = null;
                                try {
                                    inputStream = zipIOReader.getInputStream((ZipEntry)object2);
                                    byte[] byArray = IO.readStream((int)object2.getSize(), inputStream);
                                    String string4 = new String(byArray, "UTF-8");
                                    byArray = null;
                                    FilePackageStorable filePackageStorable = JSonStorage.restoreFromString(string4, new TypeRef<FilePackageStorable>(){}, null);
                                    string4 = null;
                                    if (filePackageStorable == null) break block42;
                                    ((HashMap)object5).put(n2, filePackageStorable._getFilePackage());
                                }
                                catch (Throwable throwable) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        ++var10_20;
                    }
                    object4 = new ArrayList(((HashMap)object5).keySet());
                    Collections.sort(object4);
                    ArrayList arrayList = new ArrayList(((ArrayList)object4).size());
                    Iterator iterator2 = ((ArrayList)object4).iterator();
                    while (iterator2.hasNext()) {
                        object2 = (Integer)iterator2.next();
                        arrayList.add(((HashMap)object5).get(object2));
                    }
                    object5 = null;
                    object4 = null;
                    linkedList = new LinkedList(arrayList);
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
                finally {
                    try {
                        zipIOReader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return linkedList;
        }
    }

    private LinkedList<FilePackage> loadDownloadLinks() throws Exception {
        Object object = JDUtilities.getDatabaseConnector().getLinks();
        if (object != null && object instanceof ArrayList && (((ArrayList)object).size() == 0 || ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof FilePackage)) {
            return new LinkedList<FilePackage>((ArrayList)object);
        }
        throw new Exception("Linklist incompatible");
    }

    public void move(Object object, Object object2, MOVE mOVE) {
    }

    private void postInit(LinkedList<FilePackage> linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        PluginForHost pluginForHost = null;
        while (iterator.hasNext()) {
            FilePackage filePackage = (FilePackage)iterator.next();
            if (filePackage.getChildren().size() == 0) {
                iterator.remove();
                continue;
            }
            for (DownloadLink downloadLink : filePackage.getChildren()) {
                downloadLink.getLinkStatus().resetStatus(8192, 32, 2, 131072);
                try {
                    pluginForHost = null;
                    LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(downloadLink.getHost());
                    if (lazyHostPlugin != null) {
                        pluginForHost = (PluginForHost)lazyHostPlugin.getPrototype();
                    }
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
                if (pluginForHost == null) {
                    try {
                        for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
                            if (!((PluginForHost)lazyHostPlugin.getPrototype()).rewriteHost(downloadLink)) continue;
                            pluginForHost = (PluginForHost)lazyHostPlugin.getPrototype();
                            break;
                        }
                        if (pluginForHost != null) {
                            Log.L.info("Plugin " + pluginForHost.getHost() + " now handles " + downloadLink.getName());
                        }
                    }
                    catch (Throwable throwable) {
                        Log.exception(throwable);
                    }
                }
                if (pluginForHost != null) {
                    downloadLink.setDefaultPlugin(pluginForHost);
                    continue;
                }
                Log.L.severe("Could not find plugin " + downloadLink.getHost() + " for " + downloadLink.getName());
            }
        }
    }

    public void removeListener(DownloadControllerListener downloadControllerListener) {
        this.broadcaster.removeListener(downloadControllerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(ArrayList<FilePackage> arrayList, File file) {
        Object object = SAVELOADLOCK;
        synchronized (object) {
            boolean bl;
            block32: {
                bl = false;
                if (arrayList != null && file != null) {
                    boolean bl2;
                    ZipIOWriter zipIOWriter;
                    block31: {
                        boolean bl3;
                        block30: {
                            boolean bl4;
                            block29: {
                                File file2 = new File(file.getAbsolutePath() + ".tmp");
                                file2.getParentFile().mkdirs();
                                file2.delete();
                                zipIOWriter = null;
                                int n = 0;
                                String string = "%02d";
                                if (arrayList.size() >= 10) {
                                    string = String.format("%%0%dd", (int)Math.log10(arrayList.size()) + 1);
                                }
                                try {
                                    MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                                    zipIOWriter = new ZipIOWriter(file2, true);
                                    for (FilePackage filePackage : arrayList) {
                                        FilePackageStorable filePackageStorable = new FilePackageStorable(filePackage);
                                        String string2 = JSonStorage.toString(filePackageStorable);
                                        filePackageStorable = null;
                                        byte[] byArray = string2.getBytes("UTF-8");
                                        string2 = null;
                                        messageDigest.update(byArray);
                                        zipIOWriter.addByteArry(byArray, true, "", String.format(string, n++));
                                    }
                                    String string3 = System.currentTimeMillis() + ":" + arrayList.size() + ":" + HexFormatter.byteArrayToHex(messageDigest.digest());
                                    zipIOWriter.addByteArry(string3.getBytes("UTF-8"), true, "", this.getCheckFileName());
                                    try {
                                        zipIOWriter.close();
                                    }
                                    catch (Throwable throwable) {
                                        boolean bl5 = false;
                                        try {
                                            zipIOWriter.close();
                                        }
                                        catch (Throwable throwable2) {
                                            // empty catch block
                                        }
                                        return bl5;
                                    }
                                    if (file.exists() && !file.delete()) {
                                        Log.exception(new WTFException("Could not delete: " + file.getAbsolutePath()));
                                        bl4 = false;
                                        break block29;
                                    }
                                    if (!file2.renameTo(file)) {
                                        Log.exception(new WTFException("Could not rename file: " + file2 + " to " + file));
                                        bl3 = false;
                                        break block30;
                                    }
                                    bl2 = true;
                                    break block31;
                                }
                                catch (Throwable throwable) {
                                    Log.exception(throwable);
                                    break block32;
                                }
                            }
                            return bl4;
                        }
                        return bl3;
                    }
                    return bl2;
                    finally {
                        try {
                            zipIOWriter.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDownloadLinks() {
        if (!this.isSaveAllowed()) {
            return;
        }
        ArrayList<FilePackage> arrayList = null;
        boolean bl = this.readLock();
        try {
            arrayList = new ArrayList<FilePackage>(this.packages);
        }
        finally {
            this.readUnlock(bl);
        }
        this.save(arrayList, this.getDownloadListFile());
    }

    public void setLoadAllowed(boolean bl) {
        this.allowLoad = bl;
    }

    public void setSaveAllowed(boolean bl) {
        this.allowSave = bl;
    }

    public static enum MOVE {
        BEFORE,
        AFTER,
        BEGIN,
        END,
        TOP,
        BOTTOM,
        UP,
        DOWN;

    }
}

