/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jd.JDInitFlags;
import jd.controlling.JDLogger;
import org.appwork.utils.logging.FileLogFormatter;

public class JDPluginLogger
extends Logger {
    private ArrayList<LogRecord> records = new ArrayList();
    public static final JDPluginLogger Trash = new JDPluginLogger("TRASH", true);
    private final FileLogFormatter formatter = new FileLogFormatter();

    public JDPluginLogger(String string) {
        this(string, false);
    }

    public JDPluginLogger(String string, boolean bl) {
        this(string, null);
        this.setUseParentHandlers(false);
        this.setLevel(Level.ALL);
        if (bl) {
            return;
        }
        if (JDInitFlags.SWITCH_FORCELOG) {
            for (Handler handler : JDLogger.getLogger().getHandlers()) {
                this.addHandler(handler);
            }
        }
        this.addHandler(new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(LogRecord logRecord) {
                ArrayList arrayList = JDPluginLogger.this.records;
                synchronized (arrayList) {
                    JDPluginLogger.this.records.add(logRecord);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    protected JDPluginLogger(String string, String string2) {
        super(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<LogRecord> arrayList = this.records;
        synchronized (arrayList) {
            this.records.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInto(Logger logger) {
        if (JDInitFlags.SWITCH_FORCELOG) {
            return;
        }
        if (logger == null) {
            return;
        }
        ArrayList<LogRecord> arrayList = this.records;
        synchronized (arrayList) {
            for (LogRecord logRecord : this.records) {
                logger.log(logRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.records.size() == 0) {
            return "empty logger";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<LogRecord> arrayList = this.records;
        synchronized (arrayList) {
            for (LogRecord logRecord : this.records) {
                stringBuilder.append(this.formatter.format(logRecord));
            }
        }
        return stringBuilder.toString();
    }
}

