/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.prog.gui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressMonitor {
    int total;
    int current = -1;
    boolean indeterminate;
    int milliSecondsToWait = 500;
    String status;
    public boolean started;
    private ArrayList listeners = new ArrayList();
    private ChangeEvent ce = new ChangeEvent(this);

    public ProgressMonitor(int n, boolean bl, int n2) {
        this.total = n;
        this.indeterminate = bl;
        this.milliSecondsToWait = n2;
    }

    public ProgressMonitor(int n, boolean bl) {
        this.total = n;
        this.indeterminate = bl;
    }

    public int getTotal() {
        return this.total;
    }

    public void start(String string) {
        if (this.current != -1) {
            throw new IllegalStateException("not started yet");
        }
        this.status = string;
        this.current = 0;
        this.fireChangeEvent();
        this.started = true;
    }

    public int getMilliSecondsToWait() {
        return this.milliSecondsToWait;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setCurrent(String string, int n) {
        if (n == -1) {
            throw new IllegalStateException("not started yet");
        }
        this.current = n;
        if (string != null) {
            this.status = string;
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(this.ce);
        }
    }
}

