/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.prog.gui;

import de.savemytube.prog.gui.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressDialog
extends JDialog
implements ChangeListener {
    JLabel statusLabel = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    ProgressMonitor monitor;

    public ProgressDialog(Frame frame, ProgressMonitor progressMonitor) throws HeadlessException {
        super(frame, "Progress", true);
        this.init(progressMonitor);
    }

    public ProgressDialog(Dialog dialog, ProgressMonitor progressMonitor) throws HeadlessException {
        super(dialog);
        this.init(progressMonitor);
    }

    private void init(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        this.progressBar = new JProgressBar(0, progressMonitor.getTotal());
        if (progressMonitor.isIndeterminate()) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setValue(progressMonitor.getCurrent());
        }
        this.statusLabel.setText(progressMonitor.getStatus());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.statusLabel, "North");
        jPanel.add(this.progressBar);
        this.setDefaultCloseOperation(0);
        progressMonitor.addChangeListener(this);
    }

    @Override
    public void stateChanged(final ChangeEvent changeEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.stateChanged(changeEvent);
                }
            });
            return;
        }
        if (this.monitor.getCurrent() != this.monitor.getTotal()) {
            this.statusLabel.setText(this.monitor.getStatus());
            if (!this.monitor.isIndeterminate()) {
                this.progressBar.setValue(this.monitor.getCurrent());
            }
        } else {
            this.dispose();
        }
    }
}

