/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.prog.gui;

import de.http.ProxyDefintion;
import de.savemytube.prog.Processor;
import de.savemytube.prog.gui.About;
import de.savemytube.prog.gui.FolderFilter;
import de.savemytube.prog.gui.FrmProxy;
import de.savemytube.prog.gui.IconLoader;
import de.savemytube.prog.gui.ProgressMonitor;
import de.savemytube.prog.gui.ProgressUtil;
import de.savemytube.prog.util.OpenBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FrmMain
extends JFrame {
    private About about;
    private static final long serialVersionUID = 1L;
    private static final String THE_URL = "http://dasbecks.jucktmich.net";
    private JPanel jContentPane = null;
    private JPanel pnlMain = null;
    private JPanel pnlInput = null;
    private JLabel lblInput = null;
    private JTextField txtUrl = null;
    private JButton jButton = null;
    private JButton btnOpen = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenu = null;
    private JMenuItem exit = null;
    private JMenu JMenu2 = null;
    private JMenuItem Info = null;
    private Processor proc = new Processor();
    private String theFolder;
    private FolderFilter folderFilter;
    private JPanel pnlMedia = null;
    private JCheckBox cbxVideo = null;
    private JCheckBox cbxMusic = null;
    private ProxyDefintion theProxyDef = null;
    private JMenu JMenu3;
    private JMenuItem menuProxy;
    private FrmProxy frmProxy = null;

    private FrmProxy getFrmProxy() {
        if (this.frmProxy == null) {
            this.frmProxy = new FrmProxy(this);
        }
        return this.frmProxy;
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 1;
            this.lblInput = new JLabel();
            this.lblInput.setText("Youtube Url:");
            this.lblInput.setDisplayedMnemonic(0);
            this.pnlMain = new JPanel();
            this.pnlMain.setLayout(new GridBagLayout());
            this.pnlMain.add((Component)this.getPnlInput(), gridBagConstraints3);
            this.pnlMain.add((Component)this.lblInput, gridBagConstraints5);
            this.pnlMain.add((Component)this.getTxtUrl(), gridBagConstraints4);
            this.pnlMain.add((Component)this.getJButton(), gridBagConstraints2);
            this.pnlMain.add((Component)this.getBtnOpen(), gridBagConstraints);
        }
        return this.pnlMain;
    }

    private JPanel getPnlInput() {
        if (this.pnlInput == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.pnlInput = new JPanel();
            this.pnlInput.setLayout(new GridBagLayout());
            this.pnlInput.add((Component)this.getPnlMedia(), gridBagConstraints);
        }
        return this.pnlInput;
    }

    private JTextField getTxtUrl() {
        if (this.txtUrl == null) {
            this.txtUrl = new JTextField();
            this.txtUrl.setCursor(new Cursor(2));
            this.txtUrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrmMain.this.processUrl(FrmMain.this.txtUrl.getText());
                }
            });
        }
        return this.txtUrl;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Download");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrmMain.this.processUrl(FrmMain.this.txtUrl.getText());
                }
            });
        }
        return this.jButton;
    }

    private JButton getBtnOpen() {
        if (this.btnOpen == null) {
            this.btnOpen = new JButton();
            this.btnOpen.setText("Open");
            this.btnOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = FrmMain.this.showChooser();
                    FrmMain.this.processFile(string);
                }
            });
        }
        return this.btnOpen;
    }

    private String showChooser() {
        if (this.theFolder == null) {
            this.theFolder = System.getProperty("user.dir");
        }
        JFileChooser jFileChooser = new JFileChooser(this.theFolder);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".flv");
            }

            @Override
            public String getDescription() {
                return "FLVs";
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.theFolder = jFileChooser.getSelectedFile().getAbsoluteFile().getAbsolutePath();
            return jFileChooser.getSelectedFile().getPath();
        }
        return "";
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJMenu());
            this.jJMenuBar.add(this.getJMenu3());
            this.jJMenuBar.add(this.getJMenu2());
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
            this.jMenu.setText("File");
            this.jMenu.add(this.getExit());
        }
        return this.jMenu;
    }

    private JMenuItem getExit() {
        if (this.exit == null) {
            this.exit = new JMenuItem();
            this.exit.setText("Exit");
            this.exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(1);
                }
            });
        }
        return this.exit;
    }

    public void centerScreen() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.requestFocus();
    }

    private JMenu getJMenu2() {
        if (this.JMenu2 == null) {
            this.JMenu2 = new JMenu();
            this.JMenu2.setText("Info");
            this.JMenu2.add(this.getInfo());
        }
        return this.JMenu2;
    }

    private JMenuItem getInfo() {
        if (this.Info == null) {
            this.Info = new JMenuItem();
            this.Info.setText("About");
            FrmMain frmMain = this;
            this.Info.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrmMain.this.about.setVisible(true);
                }
            });
        }
        return this.Info;
    }

    private JMenu getJMenu3() {
        if (this.JMenu3 == null) {
            this.JMenu3 = new JMenu();
            this.JMenu3.setText("Proxy");
            this.JMenu3.add(this.getMenuProxy());
        }
        return this.JMenu3;
    }

    private JMenuItem getMenuProxy() {
        if (this.menuProxy == null) {
            this.menuProxy = new JMenuItem();
            this.menuProxy.setText("Settings");
            this.menuProxy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrmMain.this.showProxySettings();
                }
            });
        }
        return this.menuProxy;
    }

    private void showProxySettings() {
        this.getFrmProxy().show(this.getProxyDef());
        this.theProxyDef = this.getFrmProxy().getProxyDef();
    }

    private JPanel getPnlMedia() {
        if (this.pnlMedia == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.gridy = 1;
            this.pnlMedia = new JPanel();
            this.pnlMedia.setLayout(new GridBagLayout());
            this.pnlMedia.setBorder(BorderFactory.createTitledBorder(null, "Extract", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlMedia.add((Component)this.getCbxVideo(), gridBagConstraints);
            this.pnlMedia.add((Component)this.getCbxMusic(), gridBagConstraints2);
        }
        return this.pnlMedia;
    }

    private JCheckBox getCbxVideo() {
        if (this.cbxVideo == null) {
            this.cbxVideo = new JCheckBox();
            this.cbxVideo.setText("Video");
        }
        return this.cbxVideo;
    }

    private JCheckBox getCbxMusic() {
        if (this.cbxMusic == null) {
            this.cbxMusic = new JCheckBox();
            this.cbxMusic.setText("Audio");
        }
        return this.cbxMusic;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMain frmMain = new FrmMain();
                frmMain.setDefaultCloseOperation(3);
                frmMain.setVisible(true);
            }
        });
    }

    public FrmMain() {
        this.initialize();
        this.folderFilter = new FolderFilter();
    }

    private void initialize() {
        this.setSize(378, 201);
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("JToothpaste");
        this.centerScreen();
        this.about = new About(this);
        IconLoader iconLoader = new IconLoader();
        this.setIconImage(iconLoader.createImage("toothpaste_short.gif", ""));
        this.setDefaultCloseOperation(3);
        this.getCbxMusic().setSelected(true);
        this.applyColors(this);
        this.applyColors(this.getFrmProxy());
        this.applyColors(this.about);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlMain(), "Center");
        }
        return this.jContentPane;
    }

    public void processUrl(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if ("".equals(this.getFolder())) {
            OpenBrowser.openURL(THE_URL);
            return;
        }
        OpenBrowser.openURL(THE_URL);
        ProxyDefintion proxyDefintion = this.getProxyDef();
        FrmMain frmMain = this;
        String string2 = this.getTitle();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String[] stringArray = new String[]{"--", "\\", "|", "/"};
                int n = 0;
                String string = "Processing";
                while (true) {
                    if (n > stringArray.length - 1) {
                        n = 0;
                    }
                    FrmMain.this.setTitle(string + " " + stringArray[n]);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            this.proc.process(string, this.getCbxMusic().isSelected(), this.getCbxVideo().isSelected(), this.theFolder, proxyDefintion);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        thread.stop();
        this.setTitle(string2);
    }

    public void processFile(final String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        final FrmMain frmMain = this;
        OpenBrowser.openURL(THE_URL);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressMonitor progressMonitor = ProgressUtil.createModalProgressMonitor(frmMain, 100, true, 1000);
                progressMonitor.start("Processing");
                FrmMain.this.proc.processFLV(string, FrmMain.this.getCbxMusic().isSelected(), FrmMain.this.getCbxVideo().isSelected());
                try {
                    progressMonitor.setCurrent(null, progressMonitor.getTotal());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private String getFolder() {
        if (this.theFolder == null) {
            this.theFolder = System.getProperty("user.dir");
        }
        JFileChooser jFileChooser = new JFileChooser(this.theFolder);
        jFileChooser.setFileFilter(this.folderFilter);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.theFolder = jFileChooser.getSelectedFile().getAbsoluteFile().getAbsolutePath();
            return this.theFolder;
        }
        return "";
    }

    private ProxyDefintion getProxyDef() {
        if (this.theProxyDef == null) {
            this.theProxyDef = new ProxyDefintion("", "", "", "");
        }
        return this.theProxyDef;
    }

    private void applyColors(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setBackground(Color.GRAY);
            componentArray[i].setForeground(Color.white);
            if (componentArray[i] instanceof Container) {
                this.applyColors((Container)componentArray[i]);
            }
            if (!(componentArray[i] instanceof JButton) && !(componentArray[i] instanceof JTextField) && !(componentArray[i] instanceof JMenuBar) && !(componentArray[i] instanceof JMenuItem) && !(componentArray[i] instanceof JMenu)) continue;
            componentArray[i].setBackground(new Color(100, 100, 100));
        }
    }
}

