/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FLVTagVideo
extends FLVTag {
    public static final int VIDEO_CODECID_H263 = 2;
    public static final int VIDEO_CODECID_SCREENVIDEO = 3;
    public static final int VIDEO_CODECID_ON2_VP6 = 4;
    public static final int VIDEO_CODECID_ON2_VP6_ALPHA = 5;
    public static final int VIDEO_CODECID_SCREENVIDEO2 = 6;
    public static final int VIDEOFRAMETYPE_KEYFRAME = 1;
    public static final int VIDEOFRAMETYPE_INTERFRAME = 2;
    public static final int VIDEOFRAMETYPE_DISPOSABLEINTERFRAME = 3;
    public static final String[] S_CODEC = new String[]{"", "", "H.263", "Screen video", "On2 VP6", "On2 VP6 Alpha", "ScreenVideo 2"};
    public static final String[] S_FRAMETYPE = new String[]{"", "keyframe", "inter frame", "disposable inter frame"};
    private int codecID;
    private int frameType;

    public FLVTagVideo(byte by, int n, int n2, byte by2, int n3) {
        super(by, n, n2, by2, n3);
    }

    @Override
    public void read(ReadableByteChannel readableByteChannel) throws IOException {
        ByteData byteData = this.read(readableByteChannel, 1);
        ByteBuffer byteBuffer = byteData.getByteBuffer();
        byte by = this.getBytes(byteBuffer)[0];
        this.setInfo(by);
        this.setBodyLength(this.getBodyLength() - 1);
        byteData = this.read(readableByteChannel, this.getBodyLength());
        this.setBody(this.getBytes(byteData.getByteBuffer()));
    }

    private void setInfo(byte by) {
        this.codecID = (by & 0xF) >> 0;
        this.frameType = (by & 0xF0) >> 4;
    }

    @Override
    public String toString() {
        String string = "---- VideoFormat ----\n";
        string = string + super.toString() + "\n";
        string = string + S_CODEC[this.codecID] + " " + S_FRAMETYPE[this.frameType];
        return string;
    }

    public int getCodecID() {
        return this.codecID;
    }

    public void setCodecID(int n) {
        this.codecID = n;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }
}

