/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.log.Category;
import de.savemytube.avi.AVIWriter;
import de.savemytube.avi.Framerate;
import de.savemytube.avi.FramerateCalculator;
import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import de.savemytube.flv.FLVTagAudio;
import de.savemytube.flv.FLVTagVideo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;

public class FLV {
    static Category log = Category.getInstance(FLV.class);
    private String filename;
    private boolean video = false;
    private boolean audio = false;
    private byte version;
    private String signature;
    private int offset;
    private ArrayList tagsAudio = new ArrayList();
    private ArrayList videoTimeStamps = new ArrayList();
    boolean debug = false;
    private AVIWriter aviWriter;
    private boolean extract_audio;
    private boolean extract_video;

    public FLV() {
    }

    public FLV(String string, boolean bl, boolean bl2) {
        this.filename = string;
        this.extract_audio = bl;
        this.extract_video = bl2;
        this.read();
    }

    private void read() {
        try {
            File file = new File(this.filename);
            long l = file.length();
            FileChannel fileChannel = new FileInputStream(this.filename).getChannel();
            ByteData byteData = this.read(fileChannel, 9);
            ByteBuffer byteBuffer = byteData.getByteBuffer();
            this.signature = new String(this.getBytes(byteBuffer, 0, 3));
            this.version = this.getBytes(byteBuffer, 4, 1)[0];
            byte by = this.getBytes(byteBuffer, 5, 1)[0];
            if ((by & 4) == 4) {
                this.audio = true;
            }
            if ((by & 1) == 1) {
                this.video = true;
            }
            byte[] byArray = this.getBytes(byteBuffer, 6, 4);
            this.offset = FLV.getInt(byArray);
            log.debug(this.toString());
            this.read(fileChannel, 3);
            this.readTags(fileChannel);
            fileChannel.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readTags(ReadableByteChannel readableByteChannel) throws Exception {
        ByteData byteData = this.read(readableByteChannel, 1);
        ByteBuffer byteBuffer = byteData.getByteBuffer();
        byte by = this.getBytes(byteBuffer, 0, 1)[0];
        int n = 0;
        int n2 = 0;
        while (byteData != null && !byteData.isEof()) {
            byteData = this.read(readableByteChannel, 11);
            byteBuffer = byteData.getByteBuffer();
            byte by2 = this.getBytes(byteBuffer, 0, 1)[0];
            int n3 = FLV.getInt(this.getBytes(byteBuffer, 1, 3));
            int n4 = FLV.getInt(this.getBytes(byteBuffer, 4, 3));
            byte by3 = this.getBytes(byteBuffer, 7, 1)[0];
            int n5 = FLV.getInt(this.getBytes(byteBuffer, 8, 3));
            n4 |= by3 << 24;
            FLVTagAudio fLVTagAudio = null;
            switch (by2) {
                case 8: {
                    fLVTagAudio = new FLVTagAudio(by2, n3, n4, by3, n5);
                    ((FLVTag)fLVTagAudio).read(readableByteChannel);
                    log.debug(((FLVTag)fLVTagAudio).toString());
                    ++n;
                    this.tagsAudio.add(fLVTagAudio);
                    break;
                }
                case 9: {
                    FLVTagVideo fLVTagVideo = new FLVTagVideo(by2, n3, n4, by3, n5);
                    fLVTagVideo.read(readableByteChannel);
                    log.debug(fLVTagVideo.toString());
                    if (this.extract_video) {
                        AVIWriter aVIWriter = this.getAVIWriter(this.filename.substring(0, this.filename.length() - 4) + ".avi", fLVTagVideo.getCodecID());
                        aVIWriter.writeChunk(fLVTagVideo.getBody(), n4, fLVTagVideo.getFrameType());
                    }
                    this.videoTimeStamps.add(new Long(n4));
                    ++n2;
                    break;
                }
                default: {
                    byteData = this.read(readableByteChannel, n3);
                }
            }
            this.read(readableByteChannel, 4);
        }
        if (this.extract_audio && this.audio) {
            this.writeAudioFile(this.filename.substring(0, this.filename.length() - 4) + ".mp3", this.tagsAudio);
        }
        if (this.extract_video && this.video) {
            Framerate framerate = FramerateCalculator.calculateTrueFrameRate(this.videoTimeStamps);
            this.getAVIWriter("", 0).finish(framerate);
        }
    }

    public ByteData read(ReadableByteChannel readableByteChannel, int n) throws IOException {
        Object object;
        if (n == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.rewind();
        int n2 = readableByteChannel.read(byteBuffer);
        if (byteBuffer != null) {
            byteBuffer.rewind();
        }
        if (this.debug) {
            object = this.getBytes(byteBuffer);
            for (int i = 0; i < ((byte[])object).length; ++i) {
                log.debug(i + 1 + ": " + object[i]);
            }
            byteBuffer.rewind();
        }
        object = new ByteData(byteBuffer, n2 == -1);
        return object;
    }

    public byte[] getBytes(ByteBuffer byteBuffer) {
        return this.getBytes(byteBuffer, 0, byteBuffer.capacity());
    }

    public byte[] getBytes(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    public static int getInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[byArray.length - 1 - i];
            int n2 = i << 3;
            int n3 = (by & 0xFF) << n2;
            n |= n3;
        }
        return n;
    }

    public static long arr2long(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        byte[] byArray2 = new byte[n3];
        for (n2 = n; n2 < n + n3; ++n2) {
            byArray2[n4] = byArray[n2];
            ++n4;
        }
        long l = 0L;
        n2 = 0;
        for (int i = 0; i < 32; i += 8) {
            l |= (long)(byArray2[n2] & 0xFF) << i;
            ++n2;
        }
        return l;
    }

    public byte[] getBytes(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = i << 3;
            byArray[3 - i] = (byte)((n & 255 << n2) >>> n2);
        }
        return byArray;
    }

    public void writeAudioFile(String string, ArrayList arrayList) throws FileNotFoundException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        for (int i = 0; i < arrayList.size(); ++i) {
            FLVTag fLVTag = (FLVTag)arrayList.get(i);
            randomAccessFile.write(fLVTag.getBody());
        }
        randomAccessFile.close();
    }

    public void reverse(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; n < i; ++n, --i) {
            byte by = byArray[n];
            byArray[n] = byArray[i];
            byArray[i] = by;
        }
    }

    public String toString() {
        String string = "FLVInformation - Signature:" + this.signature + " Version:" + this.version + " hasAudio:" + this.audio + " hasVideo:" + this.video + " Offset:" + this.offset;
        return string;
    }

    private AVIWriter getAVIWriter(String string, int n) throws Exception {
        if (this.aviWriter == null) {
            this.aviWriter = new AVIWriter(string, n);
        }
        return this.aviWriter;
    }
}

