/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.avi;

import de.savemytube.avi.Framerate;
import de.savemytube.flv.FLV;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class AVIWriter
extends FLV {
    private RandomAccessFile file;
    private ArrayList _index;
    private int _codecID;
    private int _width;
    private int _height;
    private int _framecount = 0;
    private int _moviDataSize;
    private int _frameCount;
    private int _indexChunkSize;

    public AVIWriter(String string, int n) throws Exception {
        if (n != 2 && n != 4 && n != 5) {
            throw new Exception("Unsupported video codec.");
        }
        this._codecID = n;
        this.file = new RandomAccessFile(string, "rw");
        this.WriteFourCC("RIFF");
        this.writeInt(0);
        this.WriteFourCC("AVI ");
        this.WriteFourCC("LIST");
        this.writeInt(192);
        this.WriteFourCC("hdrl");
        this.WriteFourCC("avih");
        this.writeInt(56);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.WriteFourCC("LIST");
        this.writeInt(116);
        this.WriteFourCC("strl");
        this.WriteFourCC("strh");
        this.writeInt(56);
        this.WriteFourCC("vids");
        this.WriteFourCC(this.getCodecFourCC(n));
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.WriteFourCC("strf");
        this.writeInt(40);
        this.writeInt(40);
        this.writeInt(0);
        this.writeInt(0);
        this.writeShort((short)1);
        this.writeShort((short)24);
        this.WriteFourCC(this.getCodecFourCC(n));
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.WriteFourCC("LIST");
        this.writeInt(0);
        this.WriteFourCC("movi");
        this._index = new ArrayList();
    }

    private String getCodecFourCC(int n) {
        if (n == 2) {
            return "FLV1";
        }
        if (n == 4 || n == 5) {
            return "FLV4";
        }
        return "NULL";
    }

    private void WriteFourCC(String string) throws Exception {
        byte[] byArray = string.getBytes();
        if (byArray.length != 4) {
            throw new Exception("Invalid FourCC length.");
        }
        this.file.write(byArray);
    }

    public void writeChunk(byte[] byArray, int n, int n2) throws Exception {
        int n3 = 0;
        if (this._codecID == 4) {
            n3 = 1;
        }
        if (this._codecID == 5) {
            n3 = 4;
        }
        int n4 = Math.max(byArray.length - n3, 0);
        this._index.add(n2 == 1 ? new Integer(16) : new Integer(0));
        this._index.add(new Integer(this._moviDataSize + 4));
        this._index.add(new Integer(n4));
        if (this._width == 0 && this._height == 0) {
            this.getFrameSize(byArray);
        }
        this.WriteFourCC("00dc");
        this.writeInt(n4);
        this.file.write(byArray, n3, n4);
        if (n4 % 2 != 0) {
            this.file.write(0);
            ++n4;
        }
        this._moviDataSize += n4 + 8;
        ++this._frameCount;
    }

    private void getFrameSize(byte[] byArray) {
        if (this._codecID == 2) {
            if (byArray[0] != 0 || byArray[1] != 0) {
                return;
            }
            byte[] byArray2 = new byte[]{byArray[2], byArray[3], byArray[4], byArray[5]};
            long l = AVIWriter.arr2long(byArray2, 0);
            this.readBits(l, 5);
            this.readBits(l, 8);
            int n = this.readBits(l, 3);
            switch (n) {
                case 0: {
                    this._width = this.readBits(l, 8);
                    this._height = this.readBits(l, 8);
                    break;
                }
                case 1: {
                    this._width = this.readBits(l, 16);
                    this._height = this.readBits(l, 16);
                    break;
                }
                case 2: {
                    this._width = 352;
                    this._height = 288;
                    break;
                }
                case 3: {
                    this._width = 176;
                    this._height = 144;
                    break;
                }
                case 4: {
                    this._width = 128;
                    this._height = 96;
                    break;
                }
                case 5: {
                    this._width = 320;
                    this._height = 240;
                    break;
                }
                case 6: {
                    this._width = 160;
                    this._height = 120;
                    break;
                }
                default: {
                    return;
                }
            }
        } else if (this._codecID == 4 || this._codecID == 5) {
            byte[] byArray3 = null;
            byArray3 = this._codecID != 4 ? new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]} : new byte[]{byArray[0]};
            long l = AVIWriter.getInt(byArray3);
            if ((this.readBits(l, 16) & 0x80FE) != 70) {
                return;
            }
            this._height = this.readBits(l, 8) * 16;
            this._width = this.readBits(l, 8) * 16;
        }
    }

    private int readBits(long l, int n) {
        int n2 = (int)(l >> 32 - n);
        l <<= n;
        return n2;
    }

    private void WriteIndexChunk() throws Exception {
        int n = this._frameCount * 16;
        this.WriteFourCC("idx1");
        this.writeInt(n);
        for (int i = 0; i < this._frameCount; ++i) {
            this.WriteFourCC("00dc");
            Integer n2 = (Integer)this._index.get(i * 3 + 0);
            Integer n3 = (Integer)this._index.get(i * 3 + 1);
            Integer n4 = (Integer)this._index.get(i * 3 + 2);
            this.writeInt(n2);
            this.writeInt(n3);
            this.writeInt(n4);
        }
        this._indexChunkSize = n + 8;
    }

    private void writeInt(int n) throws IOException {
        n = Integer.reverseBytes(n);
        this.file.writeInt(n);
    }

    private void writeShort(short s) throws IOException {
        s = Short.reverseBytes(s);
        this.file.writeShort(s);
    }

    public void finish(Framerate framerate) throws Exception {
        this.WriteIndexChunk();
        int n = 4;
        this.file.seek(n);
        this.writeInt(224 + this._moviDataSize + this._indexChunkSize - 8);
        n = 32;
        this.file.seek(n);
        this.writeInt(0);
        n = n + 12 + 4;
        this.file.seek(n);
        this.writeInt(this._frameCount);
        n = n + 12 + 4;
        this.file.seek(n);
        this.writeInt(this._width);
        this.writeInt(this._height);
        n = 128;
        this.file.seek(n);
        this.writeInt(framerate.D);
        this.writeInt(framerate.N);
        n = n + 4 + 4 + 4;
        this.file.seek(n);
        this.writeInt(this._frameCount);
        n = n + 16 + 4;
        this.file.seek(n);
        this.writeShort((short)this._width);
        this.writeShort((short)this._height);
        n = 176;
        this.file.seek(n);
        this.writeInt(this._width);
        this.writeInt(this._height);
        n = n + 8 + 4 + 4;
        this.file.seek(n);
        this.writeInt(this._width * this._height * 6);
        n = 216;
        this.file.seek(n);
        this.writeInt(this._moviDataSize + 4);
        this.file.close();
    }
}

