/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import org.xnap.commons.i18n.EmptyResourceBundle;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nCache;
import org.xnap.commons.i18n.I18nManager;

public class I18nFactory {
    private static final String BASENAME_KEY = "basename";
    public static final int DEFAULT = 0;
    public static final int FALLBACK = 1;
    public static final int READ_PROPERTIES = 2;
    public static final int NO_CACHE = 4;
    public static final String DEFAULT_BASE_NAME = "i18n.Messages";
    public static final String PROPS_FILENAME = "i18n.properties";
    private static final I18nCache i18nCache = new I18nCache();

    private I18nFactory() {
    }

    static void clearCache() {
        i18nCache.visit(new I18nCache.Visitor(){

            @Override
            public void visit(I18n i18n) {
                I18nManager.getInstance().remove(i18n);
            }
        });
        i18nCache.clear();
    }

    public static I18n getI18n(Class clazz) {
        return I18nFactory.getI18n(clazz, Locale.getDefault());
    }

    public static I18n getI18n(Class clazz, Locale locale) {
        return I18nFactory.getI18n(clazz, locale, 2);
    }

    public static I18n getI18n(Class clazz, Locale locale, int n) {
        ClassLoader classLoader = I18nFactory.getClassLoader(clazz.getClassLoader());
        String string = null;
        if (I18nFactory.isReadPropertiesSet(n)) {
            int n2;
            String string2 = clazz.getName();
            while ((string = I18nFactory.readFromPropertiesFile(string2 = (n2 = string2.lastIndexOf(46)) != -1 ? string2.substring(0, n2) : "", locale, classLoader)) == null && n2 != -1) {
            }
        }
        if (string == null) {
            string = DEFAULT_BASE_NAME;
        }
        return I18nFactory.getI18n("", string, classLoader, locale, n);
    }

    public static I18n getI18n(Class clazz, String string) {
        return I18nFactory.getI18n(clazz, string, Locale.getDefault());
    }

    public static I18n getI18n(Class clazz, String string, Locale locale) {
        return I18nFactory.getI18n(clazz, string, locale, 0);
    }

    public static I18n getI18n(Class clazz, String string, Locale locale, int n) {
        return I18nFactory.getI18n(clazz.getName(), string, clazz.getClassLoader(), locale, n);
    }

    public static I18n getI18n(String string, String string2, ClassLoader classLoader, Locale locale, int n) {
        Object object;
        int n2;
        String string3 = string;
        do {
            I18n i18n;
            if ((i18n = i18nCache.get((String)(object = (string3 = (n2 = string3.lastIndexOf(46)) != -1 ? string3.substring(0, n2) : "").length() == 0 ? string2 : string3 + "." + string2), locale)) != null) {
                return i18n;
            }
            i18n = I18nFactory.findByBaseName((String)object, locale, I18nFactory.getClassLoader(classLoader), n);
            if (i18n == null) continue;
            if ((n & 4) == 0) {
                i18nCache.put((String)object, i18n);
            }
            return i18n;
        } while (n2 != -1);
        if (I18nFactory.isFallbackSet(n)) {
            object = i18nCache.get("", locale);
            if (object == null) {
                object = new I18n(new EmptyResourceBundle(locale));
                i18nCache.put("", (I18n)object);
            }
            return object;
        }
        throw new MissingResourceException("Resource bundle not found", string, string2);
    }

    static ClassLoader getClassLoader(ClassLoader classLoader) {
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFromPropertiesFile(String string, Locale locale, ClassLoader classLoader) {
        Properties properties = new Properties();
        String string2 = string.length() == 0 ? PROPS_FILENAME : string.replace('.', '/') + "/" + PROPS_FILENAME;
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return properties.getProperty(BASENAME_KEY);
        }
        return null;
    }

    static I18n findByBaseName(String string, Locale locale, ClassLoader classLoader, int n) {
        try {
            return I18nFactory.createI18n(string, locale, classLoader, n);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static I18n createI18n(String string, Locale locale, ClassLoader classLoader, int n) {
        I18n i18n = new I18n(string, locale, classLoader);
        if (!I18nFactory.isNoCacheSet(n)) {
            I18nManager.getInstance().add(i18n);
        }
        return i18n;
    }

    private static boolean isFallbackSet(int n) {
        return (n & 1) != 0;
    }

    private static boolean isReadPropertiesSet(int n) {
        return (n & 2) != 0;
    }

    private static boolean isNoCacheSet(int n) {
        return (n & 4) != 0;
    }
}

