/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.xnap.commons.ant.gettext.AbstractGettextTask;
import org.xnap.commons.ant.gettext.GettextUtils;

public class GettextExtractKeysTask
extends AbstractGettextTask {
    protected Vector filesets = new Vector();
    private String xgettextCommand = "xgettext";
    private String encoding = "utf-8";
    private String keywords = "-ktrc:1c,2 -ktrnc:1c,2,3 -ktr -kmarktr -ktrn:1,2 -k";

    public void addFileSet(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void setXgettextCommand(String string) {
        this.xgettextCommand = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    private void checkPreconditions() throws BuildException {
        if (this.poDirectory == null) {
            throw new BuildException("poDirectory must be set for xgettext");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("at least one fileset must be specified to search for .java files in");
        }
    }

    public void execute() {
        FileSet fileSet2;
        this.checkPreconditions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileSet fileSet2 : this.filesets) {
            DirectoryScanner directoryScanner = fileSet2.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = fileSet2.getDir(this.getProject());
            String string = GettextUtils.getRelativePath(file, this.getLocation());
            this.log(string);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(GettextUtils.createAbsolutePath(string, stringArray[i]));
            }
        }
        File file = this.createListFile(arrayList);
        fileSet2 = new Commandline();
        fileSet2.setExecutable(this.xgettextCommand);
        fileSet2.createArgument().setValue("-c");
        fileSet2.createArgument().setValue("--from-code=" + this.encoding);
        fileSet2.createArgument().setValue("--output=" + new File(this.poDirectory, this.keysFile).getAbsolutePath());
        fileSet2.createArgument().setValue("--language=Java");
        fileSet2.createArgument().setLine(this.keywords);
        fileSet2.createArgument().setValue("--files-from=" + file.getAbsolutePath());
        this.log("Executing: " + fileSet2.toString());
        this.runCommandLineAndWait((Commandline)fileSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createListFile(List list) {
        try {
            File file = File.createTempFile("srcfiles", null);
            this.log(file.getAbsolutePath());
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                for (String string : list) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
            finally {
                bufferedWriter.close();
            }
            return file;
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
            return null;
        }
    }
}

