/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.params.HttpParams;

@ThreadSafe
public class SingleClientConnManager
implements ClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected final SchemeRegistry schemeRegistry;
    protected final ClientConnectionOperator connOperator;
    protected final boolean alwaysShutDown;
    @GuardedBy(value="this")
    protected PoolEntry uniquePoolEntry;
    @GuardedBy(value="this")
    protected ConnAdapter managedConn;
    @GuardedBy(value="this")
    protected long lastReleaseTime;
    @GuardedBy(value="this")
    protected long connectionExpiresTime;
    protected volatile boolean isShutDown;

    public SingleClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        if (schemeRegistry == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schemeRegistry;
        this.connOperator = this.createConnectionOperator(schemeRegistry);
        this.uniquePoolEntry = new PoolEntry();
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schemeRegistry) {
        return new DefaultClientConnectionOperator(schemeRegistry);
    }

    protected final void assertStillUp() throws IllegalStateException {
        if (this.isShutDown) {
            throw new IllegalStateException("Manager is shut down.");
        }
    }

    @Override
    public final ClientConnectionRequest requestConnection(final HttpRoute httpRoute, final Object object) {
        return new ClientConnectionRequest(){

            @Override
            public void abortRequest() {
            }

            @Override
            public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) {
                return SingleClientConnManager.this.getConnection(httpRoute, object);
            }
        };
    }

    public synchronized ManagedClientConnection getConnection(HttpRoute httpRoute, Object object) {
        if (httpRoute == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get connection for route " + httpRoute));
        }
        if (this.managedConn != null) {
            throw new IllegalStateException(MISUSE_MESSAGE);
        }
        boolean bl = false;
        boolean bl2 = false;
        this.closeExpiredConnections();
        if (this.uniquePoolEntry.connection.isOpen()) {
            RouteTracker routeTracker = this.uniquePoolEntry.tracker;
            bl2 = routeTracker == null || !routeTracker.toRoute().equals(httpRoute);
        } else {
            bl = true;
        }
        if (bl2) {
            bl = true;
            try {
                this.uniquePoolEntry.shutdown();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Problem shutting down connection.", (Throwable)iOException);
            }
        }
        if (bl) {
            this.uniquePoolEntry = new PoolEntry();
        }
        this.managedConn = new ConnAdapter(this.uniquePoolEntry, httpRoute);
        return this.managedConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
        this.assertStillUp();
        if (!(managedClientConnection instanceof ConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection " + managedClientConnection));
        }
        ConnAdapter connAdapter = (ConnAdapter)managedClientConnection;
        if (connAdapter.poolEntry == null) {
            return;
        }
        ClientConnectionManager clientConnectionManager = connAdapter.getManager();
        if (clientConnectionManager != null && clientConnectionManager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            if (connAdapter.isOpen() && (this.alwaysShutDown || !connAdapter.isMarkedReusable())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Released connection open but not reusable.");
                }
                connAdapter.shutdown();
            }
        }
        catch (IOException iOException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Exception shutting down released connection.", (Throwable)iOException);
            }
        }
        finally {
            connAdapter.detach();
            this.managedConn = null;
            this.lastReleaseTime = System.currentTimeMillis();
            this.connectionExpiresTime = l > 0L ? timeUnit.toMillis(l) + this.lastReleaseTime : Long.MAX_VALUE;
        }
    }

    @Override
    public synchronized void closeExpiredConnections() {
        if (System.currentTimeMillis() >= this.connectionExpiresTime) {
            this.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void closeIdleConnections(long l, TimeUnit timeUnit) {
        long l2;
        this.assertStillUp();
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (l2 = System.currentTimeMillis() - timeUnit.toMillis(l))) {
            try {
                this.uniquePoolEntry.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Problem closing idle connection.", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.isShutDown = true;
        if (this.managedConn != null) {
            this.managedConn.detach();
        }
        try {
            if (this.uniquePoolEntry != null) {
                this.uniquePoolEntry.shutdown();
            }
        }
        catch (IOException iOException) {
            this.log.debug((Object)"Problem while shutting down manager.", (Throwable)iOException);
        }
        finally {
            this.uniquePoolEntry = null;
        }
    }

    @Deprecated
    protected synchronized void revokeConnection() {
        if (this.managedConn == null) {
            return;
        }
        this.managedConn.detach();
        try {
            this.uniquePoolEntry.shutdown();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"Problem while shutting down connection.", (Throwable)iOException);
        }
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter {
        protected ConnAdapter(PoolEntry poolEntry, HttpRoute httpRoute) {
            super((ClientConnectionManager)SingleClientConnManager.this, poolEntry);
            this.markReusable();
            poolEntry.route = httpRoute;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry {
        protected PoolEntry() {
            super(SingleClientConnManager.this.connOperator, null);
        }

        protected void close() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        protected void shutdown() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }
    }
}

