/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import net.jcip.annotations.ThreadSafe;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestProxyAuthentication;
import org.apache.http.client.protocol.RequestTargetAuthentication;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultProxyAuthenticationHandler;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.client.DefaultTargetAuthenticationHandler;
import org.apache.http.impl.client.DefaultUserTokenHandler;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.impl.cookie.RFC2965SpecFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        super(clientConnectionManager, httpParams);
    }

    public DefaultHttpClient(HttpParams httpParams) {
        super(null, httpParams);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    @Override
    protected HttpParams createHttpParams() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"ISO-8859-1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        VersionInfo versionInfo = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)this.getClass().getClassLoader());
        String string = versionInfo != null ? versionInfo.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)("Apache-HttpClient/" + string + " (java 1.5)"));
        return basicHttpParams;
    }

    @Override
    protected HttpRequestExecutor createRequestExecutor() {
        return new HttpRequestExecutor();
    }

    @Override
    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
        ClientConnectionManager clientConnectionManager = null;
        HttpParams httpParams = this.getParams();
        ClientConnectionManagerFactory clientConnectionManagerFactory = null;
        String string = (String)httpParams.getParameter("http.connection-manager.factory-class-name");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                clientConnectionManagerFactory = (ClientConnectionManagerFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Invalid class name: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
        }
        clientConnectionManager = clientConnectionManagerFactory != null ? clientConnectionManagerFactory.newInstance(httpParams, schemeRegistry) : new SingleClientConnManager(this.getParams(), schemeRegistry);
        return clientConnectionManager;
    }

    @Override
    protected HttpContext createHttpContext() {
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        basicHttpContext.setAttribute("http.scheme-registry", (Object)this.getConnectionManager().getSchemeRegistry());
        basicHttpContext.setAttribute("http.authscheme-registry", (Object)this.getAuthSchemes());
        basicHttpContext.setAttribute("http.cookiespec-registry", (Object)this.getCookieSpecs());
        basicHttpContext.setAttribute("http.cookie-store", (Object)this.getCookieStore());
        basicHttpContext.setAttribute("http.auth.credentials-provider", (Object)this.getCredentialsProvider());
        return basicHttpContext;
    }

    @Override
    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    @Override
    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    @Override
    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        return authSchemeRegistry;
    }

    @Override
    protected CookieSpecRegistry createCookieSpecRegistry() {
        CookieSpecRegistry cookieSpecRegistry = new CookieSpecRegistry();
        cookieSpecRegistry.register("best-match", new BestMatchSpecFactory());
        cookieSpecRegistry.register("compatibility", new BrowserCompatSpecFactory());
        cookieSpecRegistry.register("netscape", new NetscapeDraftSpecFactory());
        cookieSpecRegistry.register("rfc2109", new RFC2109SpecFactory());
        cookieSpecRegistry.register("rfc2965", new RFC2965SpecFactory());
        return cookieSpecRegistry;
    }

    @Override
    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor basicHttpProcessor = new BasicHttpProcessor();
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestDefaultHeaders());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestClientConnControl());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestAddCookies());
        basicHttpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseProcessCookies());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetAuthentication());
        basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestProxyAuthentication());
        return basicHttpProcessor;
    }

    @Override
    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler();
    }

    @Override
    protected RedirectHandler createRedirectHandler() {
        return new DefaultRedirectHandler();
    }

    @Override
    protected AuthenticationHandler createTargetAuthenticationHandler() {
        return new DefaultTargetAuthenticationHandler();
    }

    @Override
    protected AuthenticationHandler createProxyAuthenticationHandler() {
        return new DefaultProxyAuthenticationHandler();
    }

    @Override
    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    @Override
    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    @Override
    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    @Override
    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }
}

