/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;

@Immutable
public class RequestTargetAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        block10: {
            if (httpRequest == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (httpContext == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            String string = httpRequest.getRequestLine().getMethod();
            if (string.equalsIgnoreCase("CONNECT")) {
                return;
            }
            if (httpRequest.containsHeader("Authorization")) {
                return;
            }
            AuthState authState = (AuthState)httpContext.getAttribute("http.auth.target-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials credentials = authState.getCredentials();
            if (credentials == null) {
                this.log.debug((Object)"User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    httpRequest.addHeader(authScheme.authenticate(credentials, httpRequest));
                }
                catch (AuthenticationException authenticationException) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)("Authentication error: " + authenticationException.getMessage()));
                }
            }
        }
    }
}

