/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.protocol.HttpContext;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        int n;
        Header header;
        Object object;
        Object object2;
        URI uRI;
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)httpContext.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.info((Object)"Cookie store not available in HTTP context");
            return;
        }
        CookieSpecRegistry cookieSpecRegistry = (CookieSpecRegistry)httpContext.getAttribute("http.cookiespec-registry");
        if (cookieSpecRegistry == null) {
            this.log.info((Object)"CookieSpec registry not available in HTTP context");
            return;
        }
        HttpHost httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
        if (httpHost == null) {
            throw new IllegalStateException("Target host not specified in HTTP context");
        }
        ManagedClientConnection managedClientConnection = (ManagedClientConnection)httpContext.getAttribute("http.connection");
        if (managedClientConnection == null) {
            throw new IllegalStateException("Client connection not specified in HTTP context");
        }
        String string2 = HttpClientParams.getCookiePolicy(httpRequest.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CookieSpec selected: " + string2));
        }
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid request URI: " + httpRequest.getRequestLine().getUri(), (Throwable)uRISyntaxException);
            }
        }
        String string3 = httpHost.getHostName();
        int n2 = httpHost.getPort();
        if (n2 < 0) {
            object2 = (SchemeRegistry)httpContext.getAttribute("http.scheme-registry");
            if (object2 != null) {
                object = ((SchemeRegistry)object2).get(httpHost.getSchemeName());
                n2 = ((Scheme)object).resolvePort(n2);
            } else {
                n2 = managedClientConnection.getRemotePort();
            }
        }
        object2 = new CookieOrigin(string3, n2, uRI.getPath(), managedClientConnection.isSecure());
        object = cookieSpecRegistry.getCookieSpec(string2, httpRequest.getParams());
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> arrayList2 = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie object3 : arrayList) {
            if (!object3.isExpired(date)) {
                if (!object.match(object3, (CookieOrigin)object2)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cookie " + object3 + " match " + object2));
                }
                arrayList2.add(object3);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Cookie " + object3 + " expired"));
        }
        if (!arrayList2.isEmpty()) {
            List<Header> list = object.formatCookies(arrayList2);
            Iterator bl = list.iterator();
            while (bl.hasNext()) {
                header = (Header)bl.next();
                httpRequest.addHeader(header);
            }
        }
        if ((n = object.getVersion()) > 0) {
            boolean bl;
            boolean bl2 = false;
            header = arrayList2.iterator();
            while (header.hasNext()) {
                Cookie cookie = (Cookie)header.next();
                if (n == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                bl = true;
            }
            if (bl && (header = object.getVersionHeader()) != null) {
                httpRequest.addHeader(header);
            }
        }
        httpContext.setAttribute("http.cookie-spec", object);
        httpContext.setAttribute("http.cookie-origin", object2);
    }
}

