/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import org.limewire.util.VersionFormatException;

public class Version
implements Comparable<Version> {
    private final String v;
    private final int major;
    private final int minor;
    private final int service;
    private final int revision;

    public Version(String string) throws VersionFormatException {
        this.v = string;
        int[] nArray = this.parse(string);
        this.major = nArray[0];
        this.minor = nArray[1];
        this.service = nArray[2];
        this.revision = nArray[3];
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getService() {
        return this.service;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getVersion() {
        return this.v;
    }

    public String toString() {
        return this.getVersion();
    }

    @Override
    public int compareTo(Version version) {
        int n = this.major == version.major ? (this.minor == version.minor ? (this.service == version.service ? this.revision - version.revision : this.service - version.service) : this.minor - version.minor) : this.major - version.major;
        return n;
    }

    public int compareMajorMinorTo(Version version) {
        int n = this.major == version.major ? this.minor - version.minor : this.major - version.major;
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo((Version)object) == 0;
    }

    private int[] parse(String string) throws VersionFormatException {
        int n;
        int n2;
        int n3 = string.indexOf(".");
        if (n3 != -1) {
            n2 = string.indexOf(".", n3 + 1);
            if (n2 == -1) {
                n2 = string.length();
            }
        } else {
            n3 = string.length();
            n2 = -1;
        }
        try {
            n = Integer.parseInt(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionFormatException(string);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 != -1) {
            int n7;
            try {
                n4 = Integer.parseInt(string.substring(n3 + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new VersionFormatException(string);
            }
            try {
                for (n7 = n2 + 1; n7 < string.length() && Character.isDigit(string.charAt(n7)); ++n7) {
                }
                int n8 = n7;
                if (n7 <= string.length()) {
                    n5 = Integer.parseInt(string.substring(n2 + 1, n7));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new VersionFormatException(string);
            }
            try {
                int n9;
                for (n7 = n8 + 1; n7 < string.length() && !Character.isDigit(string.charAt(n7)); ++n7) {
                }
                for (n9 = n7; n9 < string.length() && Character.isDigit(string.charAt(n9)); ++n9) {
                }
                if (n7 < string.length() && n9 <= string.length()) {
                    n6 = Integer.parseInt(string.substring(n7, n9));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{n, n4, n5, n6};
    }
}

