/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LCS {
    public static String lcsHtml(String string, String string2) {
        String string3 = new StringBuffer(string).reverse().toString();
        String string4 = new StringBuffer(string2).reverse().toString();
        LcsString lcsString = new LcsString(string3, string4, true);
        return lcsString.getHtml(true);
    }

    public static <E> List<E> LongestCommonSubsequence(E[] EArray, E[] EArray2) {
        int n;
        int n2;
        int[][] nArray = new int[EArray.length + 1][EArray2.length + 1];
        for (n2 = 1; n2 <= EArray.length; ++n2) {
            for (n = 1; n <= EArray2.length; ++n) {
                nArray[n2][n] = EArray[n2 - 1].equals(EArray2[n - 1]) ? 1 + nArray[n2 - 1][n - 1] : Math.max(nArray[n2 - 1][n], nArray[n2][n - 1]);
            }
        }
        n2 = EArray.length;
        n = EArray2.length;
        LinkedList<E> linkedList = new LinkedList<E>();
        while (n2 != 0 && n != 0) {
            if (EArray[n2 - 1].equals(EArray2[n - 1])) {
                linkedList.add(EArray[n2 - 1]);
                --n2;
                --n;
                continue;
            }
            if (nArray[n2][n - 1] >= nArray[n2 - 1][n]) {
                --n;
                continue;
            }
            --n2;
        }
        Collections.reverse(linkedList);
        return linkedList;
    }

    public static class LcsString
    extends LongestCommonSubsequence<Character> {
        private String x;
        private String y;
        private final boolean ignoreCase;

        public LcsString(String string, String string2, boolean bl) {
            this.x = string;
            this.y = string2;
            this.ignoreCase = bl;
        }

        public LcsString(String string, String string2) {
            this(string, string2, false);
        }

        @Override
        protected int lengthOfY() {
            return this.y.length();
        }

        @Override
        protected int lengthOfX() {
            return this.x.length();
        }

        @Override
        protected Character valueOfX(int n) {
            return Character.valueOf(this.x.charAt(n));
        }

        @Override
        protected Character valueOfY(int n) {
            return Character.valueOf(this.y.charAt(n));
        }

        @Override
        protected boolean equals(Character c, Character c2) {
            if (this.ignoreCase) {
                return null == c && null == c2 || Character.toLowerCase(c.charValue()) == Character.toLowerCase(c2.charValue());
            }
            return super.equals(c, c2);
        }

        public String getHtmlDiff() {
            LongestCommonSubsequence.DiffType diffType = null;
            List list = this.diff();
            StringBuffer stringBuffer = new StringBuffer();
            for (LongestCommonSubsequence.DiffEntry diffEntry : list) {
                if (diffType != diffEntry.getType()) {
                    if (diffType != null) {
                        stringBuffer.append("</span>");
                    }
                    stringBuffer.append("<span class=\"" + diffEntry.getType().getName() + "\">");
                    diffType = diffEntry.getType();
                }
                stringBuffer.append(this.escapeHtml((Character)diffEntry.getValue()));
            }
            stringBuffer.append("</span>");
            return stringBuffer.toString();
        }

        private String getHtml(boolean bl) {
            LongestCommonSubsequence.DiffType diffType = null;
            List list = this.diff();
            if (bl) {
                Collections.reverse(list);
            }
            StringBuffer stringBuffer = new StringBuffer();
            block8: for (LongestCommonSubsequence.DiffEntry diffEntry : list) {
                if (diffType != diffEntry.getType()) {
                    if (diffType != null) {
                        int n = stringBuffer.lastIndexOf("<b>");
                        if (stringBuffer.length() - n > 6) {
                            stringBuffer.append("</b>");
                        } else {
                            stringBuffer.replace(n, n + 3, "");
                        }
                    }
                    switch (diffEntry.getType()) {
                        case REMOVE: {
                            diffType = null;
                            break;
                        }
                        case ADD: {
                            diffType = null;
                            break;
                        }
                        default: {
                            stringBuffer.append("<b>");
                            diffType = diffEntry.getType();
                        }
                    }
                }
                switch (diffEntry.getType()) {
                    case REMOVE: {
                        continue block8;
                    }
                    case ADD: {
                        stringBuffer.append(this.escapeHtml((Character)diffEntry.getValue()));
                        continue block8;
                    }
                }
                stringBuffer.append(this.escapeHtml((Character)diffEntry.getValue()));
            }
            if (diffType != null) {
                stringBuffer.append("<b>");
            }
            return "<html>" + stringBuffer.toString() + "</html>";
        }

        private String escapeHtml(Character c) {
            switch (c.charValue()) {
                case '<': {
                    return "&lt;";
                }
                case '>': {
                    return "&gt;";
                }
                case '\"': {
                    return "\\&quot;";
                }
            }
            return c.toString();
        }
    }

    public static abstract class LongestCommonSubsequence<VALUE> {
        private int[][] c;
        private ArrayList<DiffEntry<VALUE>> diff;
        private ArrayList<VALUE> backtrack;

        protected LongestCommonSubsequence() {
        }

        protected abstract int lengthOfY();

        protected abstract int lengthOfX();

        protected abstract VALUE valueOfX(int var1);

        protected abstract VALUE valueOfY(int var1);

        protected boolean equals(VALUE VALUE, VALUE VALUE2) {
            return null == VALUE && null == VALUE2 || VALUE.equals(VALUE2);
        }

        protected boolean isXYEqual(int n, int n2) {
            return this.equals(this.valueOfXInternal(n), this.valueOfYInternal(n2));
        }

        private VALUE valueOfXInternal(int n) {
            return this.valueOfX(n - 1);
        }

        private VALUE valueOfYInternal(int n) {
            return this.valueOfY(n - 1);
        }

        public void calculateLcs() {
            int n;
            if (this.c != null) {
                return;
            }
            this.c = new int[this.lengthOfX() + 1][];
            for (n = 0; n < this.c.length; ++n) {
                this.c[n] = new int[this.lengthOfY() + 1];
            }
            for (n = 1; n < this.c.length; ++n) {
                for (int i = 1; i < this.c[n].length; ++i) {
                    this.c[n][i] = this.isXYEqual(n, i) ? this.c[n - 1][i - 1] + 1 : Math.max(this.c[n][i - 1], this.c[n - 1][i]);
                }
            }
        }

        public int getLcsLength() {
            this.calculateLcs();
            return this.c[this.lengthOfX()][this.lengthOfY()];
        }

        public int getMinEditDistance() {
            this.calculateLcs();
            return this.lengthOfX() + this.lengthOfY() - 2 * Math.abs(this.getLcsLength());
        }

        public List<VALUE> backtrack() {
            this.calculateLcs();
            if (this.backtrack == null) {
                this.backtrack = new ArrayList();
                this.backtrack(this.lengthOfX(), this.lengthOfY());
            }
            return this.backtrack;
        }

        public void backtrack(int n, int n2) {
            this.calculateLcs();
            if (n == 0 || n2 == 0) {
                return;
            }
            if (this.isXYEqual(n, n2)) {
                this.backtrack(n - 1, n2 - 1);
                this.backtrack.add(this.valueOfXInternal(n));
            } else if (this.c[n][n2 - 1] > this.c[n - 1][n2]) {
                this.backtrack(n, n2 - 1);
            } else {
                this.backtrack(n - 1, n2);
            }
        }

        public List<DiffEntry<VALUE>> diff() {
            this.calculateLcs();
            if (this.diff == null) {
                this.diff = new ArrayList();
                this.diff(this.lengthOfX(), this.lengthOfY());
            }
            return this.diff;
        }

        private void diff(int n, int n2) {
            this.calculateLcs();
            while (n != 0 || n2 != 0) {
                if (n > 0 && n2 > 0 && this.isXYEqual(n, n2)) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.NONE, this.valueOfYInternal(n2)));
                    --n;
                    --n2;
                    continue;
                }
                if (n2 > 0 && (n == 0 || this.c[n][n2 - 1] >= this.c[n - 1][n2])) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.ADD, this.valueOfYInternal(n2)));
                    --n2;
                    continue;
                }
                if (n <= 0 || n2 != 0 && this.c[n][n2 - 1] >= this.c[n - 1][n2]) continue;
                this.diff.add(new DiffEntry<VALUE>(DiffType.REMOVE, this.valueOfXInternal(n)));
                --n;
            }
            Collections.reverse(this.diff);
        }

        public String toString() {
            int n;
            this.calculateLcs();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  ");
            for (n = 1; n <= this.lengthOfY(); ++n) {
                stringBuffer.append(this.valueOfYInternal(n));
            }
            stringBuffer.append("\n");
            stringBuffer.append(" ");
            for (n = 0; n < this.c[0].length; ++n) {
                stringBuffer.append(Integer.toString(this.c[0][n]));
            }
            stringBuffer.append("\n");
            for (n = 1; n < this.c.length; ++n) {
                stringBuffer.append(this.valueOfXInternal(n));
                for (int i = 0; i < this.c[n].length; ++i) {
                    stringBuffer.append(Integer.toString(this.c[n][i]));
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public static class DiffEntry<VALUE> {
            private DiffType type;
            private VALUE value;

            public DiffEntry(DiffType diffType, VALUE VALUE) {
                this.type = diffType;
                this.value = VALUE;
            }

            public DiffType getType() {
                return this.type;
            }

            public void setType(DiffType diffType) {
                this.type = diffType;
            }

            public VALUE getValue() {
                return this.value;
            }

            public void setValue(VALUE VALUE) {
                this.value = VALUE;
            }

            public String toString() {
                return this.type.toString() + this.value.toString();
            }
        }

        public static enum DiffType {
            ADD("+", "add"),
            REMOVE("-", "remove"),
            NONE(" ", "none");

            private String val;
            private String name;

            private DiffType(String string2, String string3) {
                this.val = string2;
                this.name = string3;
            }

            public String toString() {
                return this.val;
            }

            public String getName() {
                return this.name;
            }

            public String getVal() {
                return this.val;
            }
        }
    }
}

