/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPoolExecutor
extends java.util.concurrent.ThreadPoolExecutor {
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(Integer.MIN_VALUE, 0));
    private static final int COUNT_BITS = 30;
    private static final int CAPACITY = 0x3FFFFFFF;
    private static final int RUNNING = Integer.MIN_VALUE;
    private static final int SHUTDOWN = -1073741824;
    private static final int STOP = 0;
    private static final int TERMINATED = 0x40000000;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int n) {
        return n & 0xC0000000;
    }

    private static int workerCountOf(int n) {
        return n & 0x3FFFFFFF;
    }

    private static int ctlOf(int n, int n2) {
        return n | n2;
    }

    private void advanceRunState(int n) {
        int n2;
        while (ThreadPoolExecutor.runStateOf(n2 = this.ctl.get()) < n && !this.ctl.compareAndSet(n2, ThreadPoolExecutor.ctlOf(n, ThreadPoolExecutor.workerCountOf(n2)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate2() {
        int n;
        do {
            int n2;
            if ((n2 = ThreadPoolExecutor.runStateOf(n = this.ctl.get())) < -1073741824 || n2 == 0x40000000 || n2 == -1073741824 && !this.workQueue.isEmpty()) {
                return;
            }
            if (ThreadPoolExecutor.workerCountOf(n) == 0) continue;
            this.interruptIdleWorkers(true);
            return;
        } while (!this.ctl.compareAndSet(n, ThreadPoolExecutor.ctlOf(0x40000000, 0)));
        this.mainLock.lock();
        try {
            this.termination.signalAll();
        }
        finally {
            this.mainLock.unlock();
        }
        this.terminated();
    }

    private void decrementWorkerCount() {
        int n;
        while (!this.ctl.compareAndSet(n = this.ctl.get(), ThreadPoolExecutor.ctlOf(ThreadPoolExecutor.runStateOf(n), ThreadPoolExecutor.workerCountOf(n) - 1))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                for (Worker worker : this.workers) {
                    securityManager.checkAccess(worker.thread);
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                try {
                    worker.thread.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean bl) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                Thread thread = worker.thread;
                if (!thread.isInterrupted() && worker.tryLock()) {
                    try {
                        thread.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        worker.unlock();
                    }
                }
                if (!bl) continue;
                break;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    private void clearInterruptsForTaskRun() {
        if (ThreadPoolExecutor.runStateOf(this.ctl.get()) < 0 && Thread.interrupted() && ThreadPoolExecutor.runStateOf(this.ctl.get()) >= 0) {
            Thread.currentThread().interrupt();
        }
    }

    final void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    void onShutdown2() {
    }

    final boolean isRunningOrShutdown2(boolean bl) {
        int n = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return n == Integer.MIN_VALUE || n == -1073741824 && bl;
    }

    private List<Runnable> drainQueue() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        blockingQueue.drainTo(arrayList);
        if (!blockingQueue.isEmpty()) {
            for (Runnable runnable : blockingQueue.toArray(new Runnable[0])) {
                if (!blockingQueue.remove(runnable)) continue;
                arrayList.add(runnable);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable runnable, boolean bl) {
        int n;
        int n2;
        int n3;
        do {
            if ((n2 = ThreadPoolExecutor.runStateOf(n3 = this.ctl.get())) == -1073741824) {
                if (this.workQueue.isEmpty()) {
                    return false;
                }
                n3 = this.ctl.get();
            }
            n = ThreadPoolExecutor.workerCountOf(n3);
            if (n2 <= -1073741824 && n < 0x3FFFFFFF && n < (bl ? this.corePoolSize : this.maximumPoolSize)) continue;
            return false;
        } while (!this.ctl.compareAndSet(n3, ThreadPoolExecutor.ctlOf(n2, n + 1)));
        Worker worker = new Worker(runnable);
        Thread thread = worker.thread;
        if (thread == null) {
            this.decrementWorkerCount();
            this.tryTerminate2();
            return false;
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.workers.add(worker);
            int n4 = this.workers.size();
            if (n4 > this.largestPoolSize) {
                this.largestPoolSize = n4;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker worker, boolean bl) {
        if (bl) {
            this.decrementWorkerCount();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            this.workers.remove(worker);
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate2();
        if (!bl) {
            int n;
            int n2;
            int n3 = n2 = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
            if (n2 == 0 && !this.workQueue.isEmpty()) {
                n2 = 1;
            }
            if (ThreadPoolExecutor.workerCountOf(n = this.ctl.get()) >= n2 || ThreadPoolExecutor.runStateOf(n) >= 0) {
                return;
            }
        }
        this.addWorker(null, false);
    }

    private Runnable getTask() {
        boolean bl = false;
        while (true) {
            boolean bl2;
            int n;
            int n2;
            if ((n2 = ThreadPoolExecutor.runStateOf(n = this.ctl.get())) == -1073741824 || bl) {
                bl = this.workQueue.isEmpty();
                n = this.ctl.get();
                if (ThreadPoolExecutor.runStateOf(n) != n2) continue;
            }
            int n3 = ThreadPoolExecutor.workerCountOf(n);
            boolean bl3 = bl2 = this.allowCoreThreadTimeOut || n3 > this.corePoolSize;
            if (n3 > this.maximumPoolSize || n2 > -1073741824 || bl && (bl2 || n2 == -1073741824)) {
                if (!this.ctl.compareAndSet(n, ThreadPoolExecutor.ctlOf(n2, n3 - 1))) continue;
                return null;
            }
            try {
                Runnable runnable;
                Runnable runnable2 = runnable = bl2 ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take();
                if (runnable != null) {
                    return runnable;
                }
                bl = true;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker worker) {
        Runnable runnable = worker.firstTask;
        worker.firstTask = null;
        boolean bl = true;
        try {
            while (runnable != null || (runnable = this.getTask()) != null) {
                worker.lock();
                this.clearInterruptsForTaskRun();
                try {
                    this.beforeExecute(worker.thread, runnable);
                    Throwable throwable = null;
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException runtimeException) {
                        throwable = runtimeException;
                        throw runtimeException;
                    }
                    catch (Error error) {
                        throwable = error;
                        throw error;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw new Error(throwable2);
                    }
                    finally {
                        this.afterExecute(runnable, throwable);
                    }
                }
                finally {
                    runnable = null;
                    ++worker.completedTasks;
                    worker.unlock();
                }
            }
            bl = false;
        }
        finally {
            this.processWorkerExit(worker, bl);
        }
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        int n = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(n) < this.corePoolSize) {
            if (this.addWorker(runnable, true)) {
                return;
            }
            n = this.ctl.get();
        }
        if (ThreadPoolExecutor.runStateOf(n) == Integer.MIN_VALUE && this.workQueue.offer(runnable)) {
            int n2 = this.ctl.get();
            if (ThreadPoolExecutor.runStateOf(n2) >= 0 && this.remove(runnable)) {
                this.reject(runnable);
            } else if (ThreadPoolExecutor.workerCountOf(n2) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(runnable, false)) {
            this.reject(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(-1073741824);
            this.interruptIdleWorkers();
            this.onShutdown2();
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptWorkers();
            list = this.drainQueue();
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate2();
        return list;
    }

    @Override
    public boolean isShutdown() {
        return ThreadPoolExecutor.runStateOf(this.ctl.get()) != Integer.MIN_VALUE;
    }

    @Override
    public boolean isTerminating() {
        int n = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return n == -1073741824 || n == 0;
    }

    @Override
    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x40000000;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x40000000) {
                    boolean bl = true;
                    return bl;
                }
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    protected void finalize() {
        this.shutdown();
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    @Override
    public void setCorePoolSize(int n) {
        block3: {
            int n2;
            block2: {
                if (n < 0) {
                    throw new IllegalArgumentException();
                }
                n2 = n - this.corePoolSize;
                this.corePoolSize = n;
                if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) <= n) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (n2 <= 0) break block3;
            int n3 = Math.min(n2, this.workQueue.size());
            while (n3-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    @Override
    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @Override
    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (bl != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = bl;
            if (bl) {
                this.interruptIdleWorkers();
            }
        }
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n <= 0 || n < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = n;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > n) {
            this.interruptIdleWorkers();
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = l2 - this.keepAliveTime;
        this.keepAliveTime = l2;
        if (l3 < 0L) {
            this.interruptIdleWorkers();
        }
    }

    @Override
    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Runnable runnable) {
        boolean bl;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            bl = this.workQueue.remove(runnable);
        }
        finally {
            reentrantLock.unlock();
        }
        if (bl) {
            this.tryTerminate2();
        }
        return bl;
    }

    @Override
    public void purge() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        try {
            Iterator iterator = blockingQueue.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof Future) || !((Future)((Object)runnable)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            for (Object object : blockingQueue.toArray()) {
                if (!(object instanceof Future) || !((Future)object).isCancelled()) continue;
                blockingQueue.remove(object);
            }
        }
        this.tryTerminate2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.workers.size();
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (Worker worker : this.workers) {
                if (!worker.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
                if (!worker.isLocked()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            return l2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
            }
            long l2 = l;
            return l2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    @Override
    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, java.util.concurrent.ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }

    private final class Worker
    extends ReentrantLock
    implements Runnable {
        private static final long serialVersionUID = -1784809862406975944L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable runnable) {
            this.firstTask = runnable;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        @Override
        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }
    }
}

