/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import org.pf.file.LineProcessor;
import org.pf.text.StringUtil;

public class FileUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    private static FileUtil current = new FileUtil();

    private FileUtil() {
    }

    public static FileUtil current() {
        return current;
    }

    public void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.copyStream(inputStream, outputStream, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > -1) {
                outputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        finally {
            this.close(inputStream);
            this.close(outputStream);
        }
    }

    public String readTextFrom(InputStream inputStream) throws IOException {
        StringWriter stringWriter = new StringWriter(1024);
        this.copyText(inputStream, stringWriter);
        return stringWriter.toString();
    }

    public String readTextFrom(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return this.readTextFrom(fileInputStream);
    }

    public String readTextFrom(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return this.readTextFrom(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyText(Reader reader, final StringWriter stringWriter) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            LineProcessor lineProcessor = new LineProcessor(){

                @Override
                public boolean processLine(String string, int n) {
                    if (n > 1) {
                        stringWriter.write(LINE_SEPARATOR);
                    }
                    stringWriter.write(string);
                    return true;
                }
            };
            this.processTextLines(bufferedReader, lineProcessor);
        }
    }

    public void processTextLines(String string, LineProcessor lineProcessor) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        this.processTextLines(fileInputStream, lineProcessor);
    }

    public void processTextLines(InputStream inputStream, LineProcessor lineProcessor) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inStream must not be null");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.processTextLines(inputStreamReader, lineProcessor);
    }

    public void processTextLines(Reader reader, LineProcessor lineProcessor) throws IOException {
        String string;
        int n = 0;
        boolean bl = true;
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (lineProcessor == null) {
            throw new IllegalArgumentException("processor must not be null");
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        while (bl && bufferedReader.ready() && (string = bufferedReader.readLine()) != null) {
            bl = lineProcessor.processLine(string, ++n);
        }
    }

    public boolean close(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        try {
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean close(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        try {
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String standardize(String string) {
        if (string == null) {
            return null;
        }
        return this.standardizeFilename(string);
    }

    public String javaFilename(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('\\', '/');
    }

    protected void copyText(InputStream inputStream, StringWriter stringWriter) throws IOException {
        this.copyText(new InputStreamReader(inputStream), stringWriter);
    }

    protected String standardizeFilename(String string) {
        string = this.javaFilename(string);
        boolean bl = string.startsWith("/");
        String[] stringArray = this.str().parts(string, "/");
        if (stringArray.length > 0) {
            boolean bl2 = stringArray[0].endsWith(":");
            if (bl2) {
                stringArray[0] = stringArray[0].toUpperCase();
            } else if (bl) {
                stringArray = this.str().append(new String[]{""}, stringArray);
            }
            boolean bl3 = bl2 || bl;
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                if (".".equals(stringArray[i])) {
                    stringArray[i] = null;
                    continue;
                }
                if (!"..".equals(stringArray[i]) || (n = this.indexOfPreceedingNotNullElement(stringArray, i - 1)) < 0 || n <= 0 && bl3) continue;
                stringArray[i] = null;
                stringArray[n] = null;
            }
            stringArray = this.str().removeNull(stringArray);
            return this.str().asString(stringArray, "/");
        }
        return "";
    }

    protected int indexOfPreceedingNotNullElement(String[] stringArray, int n) {
        for (int i = n; i >= 0; --i) {
            if (stringArray[i] == null) continue;
            if ("..".equals(stringArray[i])) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

