/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.URL;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class Test
implements Plugin {
    private static AESemaphore init_sem = new AESemaphore("RSSTester");
    private static AEMonitor class_mon = new AEMonitor("RSSTester");
    private static Test singleton;
    protected PluginInterface plugin_interface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser"){

                    @Override
                    public void runSupport() {
                        PluginManager.registerPlugin(Test.class);
                        Properties properties = new Properties();
                        properties.put("MULTI_INSTANCE", "true");
                        PluginManager.startAzureus(1, properties);
                    }
                }.start();
                init_sem.reserve();
            }
            Test test = singleton;
            return test;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        singleton = this;
        init_sem.release();
        try {
            RSSFeed rSSFeed = this.plugin_interface.getUtilities().getRSSFeed(new URL("http://aelitis.com:7979/rss_feed.xml"));
            RSSChannel[] rSSChannelArray = rSSFeed.getChannels();
            for (int i = 0; i < rSSChannelArray.length; ++i) {
                RSSChannel rSSChannel = rSSChannelArray[i];
                System.out.println("chan: title = " + rSSChannel.getTitle() + ", desc = " + rSSChannel.getDescription() + ", link = " + rSSChannel.getLink() + ", pub = " + rSSChannel.getPublicationDate());
                RSSItem[] rSSItemArray = rSSChannel.getItems();
                for (int j = 0; j < rSSItemArray.length; ++j) {
                    RSSItem rSSItem = rSSItemArray[j];
                    System.out.println("    item:" + rSSItem.getTitle() + ", desc = " + rSSItem.getDescription() + ", link = " + rSSItem.getLink());
                    SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = rSSItem.getNode();
                    System.out.println("        [hash] " + simpleXMLParserDocumentNode.getChild("torrent_sha1").getValue());
                    System.out.println("        [size] " + simpleXMLParserDocumentNode.getChild("torrent_size").getValue());
                    System.out.println("        [seed] " + simpleXMLParserDocumentNode.getChild("torrent_seeders").getValue());
                    System.out.println("        [leec] " + simpleXMLParserDocumentNode.getChild("torrent_leechers").getValue());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Test.getSingleton();
    }
}

