/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSItemImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class RSSChannelImpl
implements RSSChannel {
    private SimpleXMLParserDocumentNode node;
    private RSSItem[] items;
    private boolean is_atom;

    protected RSSChannelImpl(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode, boolean bl) {
        this.node = simpleXMLParserDocumentNode;
        this.is_atom = bl;
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = this.node.getChildren();
        ArrayList<RSSItemImpl> arrayList = new ArrayList<RSSItemImpl>();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            SimpleXMLParserDocumentNode simpleXMLParserDocumentNode2 = simpleXMLParserDocumentNodeArray[i];
            if (!simpleXMLParserDocumentNode2.getName().equalsIgnoreCase(this.is_atom ? "entry" : "item")) continue;
            arrayList.add(new RSSItemImpl(simpleXMLParserDocumentNode2, this.is_atom));
        }
        this.items = new RSSItem[arrayList.size()];
        arrayList.toArray(this.items);
    }

    @Override
    public String getTitle() {
        return this.node.getChild("title").getValue();
    }

    @Override
    public String getDescription() {
        String[] stringArray = this.is_atom ? new String[]{"summary", "description"} : new String[]{"description", "summary"};
        for (String string : stringArray) {
            SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = this.node.getChild(string);
            if (simpleXMLParserDocumentNode == null) continue;
            return simpleXMLParserDocumentNode.getValue();
        }
        return null;
    }

    @Override
    public URL getLink() {
        try {
            return new URL(this.node.getChild("link").getValue());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
            return null;
        }
    }

    @Override
    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = this.node.getChild(this.is_atom ? "updated" : "pubdate");
        if (simpleXMLParserDocumentNode == null) {
            return null;
        }
        if (this.is_atom) {
            return RSSUtils.parseAtomDate(simpleXMLParserDocumentNode.getValue());
        }
        return RSSUtils.parseRSSDate(simpleXMLParserDocumentNode.getValue());
    }

    @Override
    public RSSItem[] getItems() {
        return this.items;
    }

    @Override
    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

