/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.DeleteFileOnCloseInputStream;
import com.aelitis.azureus.core.util.Java15Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;
    protected boolean force_no_proxy = false;
    private final String post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL) {
        this(resourceDownloaderBaseImpl, uRL, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, String string, String string2) {
        this(resourceDownloaderBaseImpl, uRL, true, string, string2);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, boolean bl, String string, String string2) {
        this(resourceDownloaderBaseImpl, uRL, null, bl, string, string2);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, URL uRL, String string, boolean bl, String string2, String string3) {
        super(resourceDownloaderBaseImpl);
        this.original_url = uRL;
        this.post_data = string;
        this.auth_supplied = bl;
        this.user_name = string2;
        this.password = string3;
    }

    protected void setForceNoProxy(boolean bl) {
        this.force_no_proxy = bl;
    }

    protected URL getURL() {
        return this.original_url;
    }

    @Override
    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl resourceDownloaderURLImpl = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(resourceDownloaderURLImpl);
                this.size = resourceDownloaderURLImpl.getSizeSupport();
                this.setProperties(resourceDownloaderURLImpl);
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
    }

    @Override
    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String string = this.original_url.getProtocol().toLowerCase();
            if (string.equals("magnet") || string.equals("dht")) {
                return -1L;
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                Object object = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                object = AddressUtils.adjustURL((URL)object);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)object, this);
                    }
                    for (int n = 0; n < 2; ++n) {
                        Object object2;
                        try {
                            Object object3;
                            if (((URL)object).getProtocol().equalsIgnoreCase("https")) {
                                object2 = (HttpsURLConnection)this.openConnection((URL)object);
                                ((HttpsURLConnection)object2).setHostnameVerifier(new HostnameVerifier(){

                                    @Override
                                    public boolean verify(String string, SSLSession sSLSession) {
                                        return true;
                                    }
                                });
                                object3 = object2;
                            } else {
                                object3 = (HttpURLConnection)this.openConnection((URL)object);
                            }
                            ((HttpURLConnection)object3).setRequestMethod("HEAD");
                            ((URLConnection)object3).setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                            this.setRequestProperties((HttpURLConnection)object3, false);
                            ((URLConnection)object3).connect();
                            int n2 = ((HttpURLConnection)object3).getResponseCode();
                            if (n2 != 202 && n2 != 200) {
                                this.setProperty("URL_HTTP_Response", new Long(n2));
                                throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay((URL)object) + "': " + Integer.toString(n2) + " " + ((HttpURLConnection)object3).getResponseMessage());
                            }
                            this.getRequestProperties((HttpURLConnection)object3);
                            long l = UrlUtils.getContentLength((HttpURLConnection)object3);
                            return l;
                        }
                        catch (SSLException sSLException) {
                            if (n == 0 && SESecurityManager.installServerCertificates((URL)object) != null) continue;
                            throw sSLException;
                        }
                        catch (IOException iOException) {
                            if (n == 0 && (object2 = UrlUtils.getIPV4Fallback((URL)object)) != null) {
                                object = object2;
                                continue;
                            }
                            throw iOException;
                        }
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)object, null);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.original_url + "':" + malformedURLException.getMessage(), malformedURLException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + unknownHostException.getMessage() + "'", unknownHostException);
            }
            catch (IOException iOException) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", iOException);
            }
        }
        catch (Throwable throwable) {
            ResourceDownloaderException resourceDownloaderException;
            if (throwable instanceof ResourceDownloaderException) {
                resourceDownloaderException = (ResourceDownloaderException)throwable;
            } else {
                Debug.out(throwable);
                resourceDownloaderException = new ResourceDownloaderException(this, "Unexpected error", throwable);
            }
            throw resourceDownloaderException;
        }
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderURLImpl resourceDownloaderURLImpl = new ResourceDownloaderURLImpl(resourceDownloaderBaseImpl, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        resourceDownloaderURLImpl.setSize(this.size);
        resourceDownloaderURLImpl.setProperties(this);
        resourceDownloaderURLImpl.setForceNoProxy(this.force_no_proxy);
        return resourceDownloaderURLImpl;
    }

    @Override
    public void asyncDownload() {
        final Object object = TorrentUtils.getTLS();
        AEThread2 aEThread2 = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2 = TorrentUtils.getTLS();
                TorrentUtils.setTLS(object);
                try {
                    ResourceDownloaderURLImpl.this.download();
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                }
                finally {
                    TorrentUtils.setTLS(object2);
                }
            }
        };
        aEThread2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.trimForDisplay(this.original_url));
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException(this, "Download already initiated");
                }
                this.download_initiated = true;
            }
            finally {
                this.this_mon.exit();
            }
            try {
                var1_2 = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                var2_7 = var1_2.getProtocol().toLowerCase();
                if (var1_2.getPort() == -1 && !var2_7.equals("magnet") && !var2_7.equals("dht")) {
                    var3_9 = var2_7.equals("http") != false ? 80 != 0 : 443 != 0;
                    try {
                        var4_10 = this.original_url.toString().replaceAll(" ", "%20");
                        var5_13 = var4_10.indexOf("://");
                        var5_13 = var4_10.indexOf("/", var5_13 + 4);
                        var1_2 = var5_13 == -1 ? new URL(var4_10 + ":" + (int)var3_9 + "/") : new URL(var4_10.substring(0, var5_13) + ":" + (int)var3_9 + var4_10.substring(var5_13));
                    }
                    catch (Throwable var4_11) {
                        Debug.printStackTrace(var4_11);
                    }
                }
                var1_2 = AddressUtils.adjustURL((URL)var1_2);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)var1_2, this);
                    }
                    var3_9 = true;
                    var4_12 = true;
                    var5_13 = 0;
                    while (var5_13 < 2) {
                        if (var4_12 == false) throw new ResourceDownloaderException(this, "Should never get here");
                        var4_12 = false;
                        for (var6_14 = 0; var6_14 < 2; ++var6_14) {
                            block69: {
                                block68: {
                                    var7_15 = null;
                                    try {
                                        if (var1_2.getProtocol().equalsIgnoreCase("https")) {
                                            var9_20 = (HttpsURLConnection)this.openConnection((URL)var1_2);
                                            var9_20.setHostnameVerifier(new HostnameVerifier(){

                                                @Override
                                                public boolean verify(String string, SSLSession sSLSession) {
                                                    return true;
                                                }
                                            });
                                            var8_16 = var9_20;
                                        } else {
                                            var8_16 = (HttpURLConnection)this.openConnection((URL)var1_2);
                                        }
                                        var8_16.setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                                        var8_16.setRequestProperty("Connection", "close");
                                        if (var3_9) {
                                            var8_16.addRequestProperty("Accept-Encoding", "gzip");
                                        }
                                        this.setRequestProperties(var8_16, var3_9);
                                        if (this.post_data != null) {
                                            var8_16.setDoOutput(true);
                                            var8_16.setRequestMethod("POST");
                                            var9_20 = new OutputStreamWriter(var8_16.getOutputStream());
                                            var9_20.write(this.post_data);
                                            var9_20.flush();
                                        }
                                        var8_16.connect();
                                        var9_21 = var8_16.getResponseCode();
                                        if (var9_21 != 302 && var9_21 != 301 || (var10_23 = var8_16.getHeaderField("location")) == null || !var1_2.getProtocol().equalsIgnoreCase("http")) break block68;
                                        try {
                                            var11_25 = new URL(URLDecoder.decode((String)var10_23, "UTF-8"));
                                            if (var11_25.getProtocol().equalsIgnoreCase("https")) {
                                                var1_2 = var11_25;
                                                var4_12 = true;
                                                if (var7_15 == null) break;
                                                var7_15.delete();
                                                break;
                                            }
                                        }
                                        catch (Throwable var11_26) {
                                            // empty catch block
                                        }
                                    }
                                    catch (SSLException var8_17) {
                                        if (var6_14 == 0 && SESecurityManager.installServerCertificates((URL)var1_2) != null) {
                                            if (var7_15 == null) continue;
                                            var7_15.delete();
                                            continue;
                                        }
                                        throw var8_17;
                                        catch (ZipException var8_18) {
                                            if (var6_14 != 0) continue;
                                            var3_9 = false;
                                            continue;
                                        }
                                        catch (IOException var8_19) {
                                            if (var6_14 == 0) {
                                                var9_22 = var8_19.getMessage();
                                                if (var9_22 != null && (var9_22 = var9_22.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("gzip") != -1) {
                                                    var3_9 = false;
                                                    if (var7_15 == null) continue;
                                                    var7_15.delete();
                                                    continue;
                                                }
                                            }
                                            ** GOTO lbl-1000
                                            {
                                                var10_23 = UrlUtils.getIPV4Fallback((URL)var1_2);
                                                if (var10_23 == null) ** GOTO lbl-1000
                                                var1_2 = var10_23;
                                                if (var7_15 == null) continue;
                                                var7_15.delete();
                                            }
                                            continue;
lbl-1000:
                                            // 2 sources

                                            {
                                                throw var8_19;
                                            }
                                        }
                                        finally {
                                            if (var7_15 != null) {
                                                var7_15.delete();
                                            }
                                        }
                                    }
                                }
                                if (var9_21 != 202 && var9_21 != 200) {
                                    this.setProperty("URL_HTTP_Response", new Long(var9_21));
                                    throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay((URL)var1_2) + "': " + Integer.toString(var9_21) + " " + var8_16.getResponseMessage());
                                }
                                this.getRequestProperties(var8_16);
                                var10_24 = false;
                                try {
                                    this.this_mon.enter();
                                    this.input_stream = var8_16.getInputStream();
                                    var11_25 = var8_16.getHeaderField("content-encoding");
                                    if (var11_25 == null) break block69;
                                    if (var11_25.equalsIgnoreCase("gzip")) {
                                        var10_24 = true;
                                        this.input_stream = new GZIPInputStream(this.input_stream);
                                        break block69;
                                    }
                                    if (var11_25.equalsIgnoreCase("deflate")) {
                                        var10_24 = true;
                                        this.input_stream = new InflaterInputStream(this.input_stream);
                                    }
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                            }
                            var11_25 = null;
                            var12_27 = null;
                            try {
                                var13_29 = new byte[32768];
                                var14_31 = 0L;
                                v0 = var16_32 = var10_24 != false ? -1L : UrlUtils.getContentLength(var8_16);
                                v1 = var16_32 > 0L ? new ByteArrayOutputStream(var16_32 > 262144L ? 262144 : (int)var16_32) : (var11_25 = new ByteArrayOutputStream());
                                while (!this.cancel_download && (var18_33 = this.input_stream.read((byte[])var13_29)) > 0) {
                                    if (var14_31 > 262144L) {
                                        if (var12_27 == null) {
                                            var7_15 = AETemporaryFileHandler.createTempFile();
                                            var12_27 = new FileOutputStream(var7_15);
                                            var12_27.write(var11_25.toByteArray());
                                            var11_25 = null;
                                        }
                                        var12_27.write((byte[])var13_29, 0, var18_33);
                                    } else {
                                        var11_25.write((byte[])var13_29, 0, var18_33);
                                    }
                                    this.informAmountComplete(var14_31 += (long)var18_33);
                                    if (var16_32 <= 0L) continue;
                                    this.informPercentDone((int)(100L * var14_31 / var16_32));
                                }
                                if (var16_32 > 0L && var14_31 != var16_32) {
                                    if (var14_31 <= var16_32) throw new IOException("Premature end of stream");
                                    Debug.outNoStack("Inconsistent stream length for '" + this.trimForDisplay(this.original_url) + "': expected = " + var16_32 + ", actual = " + var14_31);
                                }
                            }
                            finally {
                                if (var12_27 != null) {
                                    var12_27.close();
                                }
                                this.input_stream.close();
                            }
                            if (var7_15 != null) {
                                var13_29 = new DeleteFileOnCloseInputStream(var7_15);
                                var7_15 = null;
                            } else {
                                var13_29 = new ByteArrayInputStream(var11_25.toByteArray());
                            }
                            var14_30 = false;
                            if (!this.informComplete((InputStream)var13_29)) ** GOTO lbl185
                            var14_30 = true;
                            var15_35 = var13_29;
                            if (!var14_30) {
                            }
                            ** GOTO lbl181
                            {
                                catch (Throwable var20_36) {
                                    if (var14_30 != false) throw var20_36;
                                    var13_29.close();
                                    throw var20_36;
                                }
                                var13_29.close();
lbl181:
                                // 2 sources

                                if (var7_15 == null) return var15_35;
                                var7_15.delete();
                                return var15_35;
lbl185:
                                // 1 sources

                                if (var14_30 != false) throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                var13_29.close();
                                throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                            }
                        }
                        ++var5_13;
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler((URL)var1_2, null);
                    }
                }
            }
            catch (MalformedURLException var1_3) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.trimForDisplay(this.original_url) + "':" + var1_3.getMessage(), var1_3);
            }
            catch (UnknownHostException var1_4) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + var1_4.getMessage() + "'", var1_4);
            }
            catch (IOException var1_5) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", var1_5);
            }
        }
        catch (Throwable var1_6) {
            if (var1_6 instanceof ResourceDownloaderException) {
                var2_8 = (ResourceDownloaderException)var1_6;
            } else {
                Debug.out(var1_6);
                var2_8 = new ResourceDownloaderException(this, "Unexpected error", var1_6);
            }
            this.informFailed(var2_8);
            throw var2_8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.informFailed(new ResourceDownloaderCancelledException(this));
    }

    protected void setRequestProperties(HttpURLConnection httpURLConnection, boolean bl) {
        Map map = this.getLCKeyProperties();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (!string.startsWith("url_") || !(v instanceof String) || (string = string.substring(4)).equals("accept-encoding") && !bl) continue;
            httpURLConnection.setRequestProperty(string, (String)v);
        }
    }

    protected void getRequestProperties(HttpURLConnection httpURLConnection) {
        try {
            this.setProperty("ContentType", httpURLConnection.getContentType());
            this.setProperty("URL_URL", httpURLConnection.getURL());
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<String> list = entry.getValue();
                if (string == null) continue;
                this.setProperty("URL_" + string, list);
            }
            this.setPropertiesSet();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public PasswordAuthentication getAuthentication(String string, URL uRL) {
        if (this.user_name == null || this.password == null) {
            String string2 = uRL.getUserInfo();
            if (string2 == null) {
                return null;
            }
            String string3 = string2;
            String string4 = "";
            int n = string2.indexOf(58);
            if (n != -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
            return new PasswordAuthentication(string3, string4.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    @Override
    public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
    }

    @Override
    public void clearPasswords() {
    }

    private URLConnection openConnection(URL uRL) throws IOException {
        if (this.force_no_proxy) {
            return Java15Utils.openConnectionForceNoProxy(uRL);
        }
        return uRL.openConnection();
    }

    protected String trimForDisplay(URL uRL) {
        String string = uRL.toString();
        int n = string.indexOf(63);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

