/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.InputStream;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;

public class UpdateImpl
implements Update {
    private UpdateCheckInstanceImpl instance;
    private UpdatableComponentImpl component;
    private String name;
    private String[] description;
    private String relative_url_base = "";
    private String new_version;
    private ResourceDownloader[] downloaders;
    private boolean mandatory;
    private int restart_required;
    private String description_url;
    private Object user_object;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private volatile boolean cancelled;
    private volatile boolean complete;
    private volatile boolean succeeded;

    protected UpdateImpl(UpdateCheckInstanceImpl updateCheckInstanceImpl, UpdatableComponentImpl updatableComponentImpl, String string, String[] stringArray, String string2, ResourceDownloader[] resourceDownloaderArray, boolean bl, int n) {
        this.instance = updateCheckInstanceImpl;
        this.component = updatableComponentImpl;
        this.name = string;
        this.description = stringArray;
        this.new_version = string2;
        this.downloaders = resourceDownloaderArray;
        this.mandatory = bl;
        this.restart_required = n;
    }

    @Override
    public UpdateCheckInstance getCheckInstance() {
        return this.instance;
    }

    protected UpdatableComponentImpl getComponent() {
        return this.component;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public String getRelativeURLBase() {
        return this.relative_url_base;
    }

    @Override
    public void setRelativeURLBase(String string) {
        this.relative_url_base = string;
    }

    @Override
    public String getDesciptionURL() {
        return this.description_url;
    }

    @Override
    public void setDescriptionURL(String string) {
        this.description_url = string;
    }

    @Override
    public String getNewVersion() {
        return this.new_version;
    }

    @Override
    public ResourceDownloader[] getDownloaders() {
        return this.downloaders;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setRestartRequired(int n) {
        this.restart_required = n;
    }

    @Override
    public int getRestartRequired() {
        return this.restart_required;
    }

    @Override
    public void setUserObject(Object object) {
        this.user_object = object;
    }

    @Override
    public Object getUserObject() {
        return this.user_object;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (int i = 0; i < this.downloaders.length; ++i) {
            try {
                this.downloaders[i].cancel();
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((UpdateListener)iterator.next()).cancelled(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public void complete(boolean bl) {
        this.complete = true;
        this.succeeded = bl;
        Iterator iterator = this.listeners.iterator();
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UpdateListener)iterator.next()).complete(this);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean wasSuccessful() {
        return this.succeeded;
    }

    @Override
    public Object getDecision(int n, String string, String string2, Object object) {
        return this.instance.getDecision(this, n, string, string2, object);
    }

    @Override
    public InputStream verifyData(InputStream inputStream, boolean bl) throws UpdateException {
        return ((UpdateManagerImpl)this.instance.getManager()).verifyData(this, inputStream, bl);
    }

    @Override
    public void addListener(UpdateListener updateListener) {
        this.listeners.add(updateListener);
        if (this.cancelled) {
            updateListener.cancelled(this);
        } else if (this.complete) {
            updateListener.complete(this);
        }
    }

    @Override
    public void removeListener(UpdateListener updateListener) {
        this.listeners.remove(updateListener);
    }
}

