/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class FilePluginInstallerImpl
extends InstallablePluginImpl
implements FilePluginInstaller {
    protected PluginInstallerImpl installer;
    protected File file;
    protected String id;
    protected String version;
    protected String name;
    protected boolean is_jar;

    protected FilePluginInstallerImpl(PluginInstallerImpl pluginInstallerImpl, File file) throws PluginException {
        super(pluginInstallerImpl);
        this.installer = pluginInstallerImpl;
        this.file = file;
        String string = this.file.getName();
        int n = string.lastIndexOf(".");
        boolean bl = false;
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.lastIndexOf("_src") != -1) {
                if (string2.endsWith("_src")) {
                    string2 = string2.substring(0, string2.length() - 4);
                } else {
                    int n2 = string2.lastIndexOf("_src");
                    string2 = string2.substring(0, n2) + string2.substring(n2 + 1);
                }
            }
            if (string3.toLowerCase(MessageText.LOCALE_ENGLISH).equals("jar") || string3.toLowerCase(MessageText.LOCALE_ENGLISH).equals("zip")) {
                String[] stringArray;
                Object object;
                String string4;
                Object object2;
                this.is_jar = string3.toLowerCase(MessageText.LOCALE_ENGLISH).equals("jar");
                Properties properties = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                    while (properties == null) {
                        object2 = zipInputStream.getNextEntry();
                        if (object2 == null) {
                            break;
                        }
                        string4 = ((ZipEntry)object2).getName().toLowerCase(MessageText.LOCALE_ENGLISH);
                        if (string4.equals("plugin.properties") || string4.endsWith("/plugin.properties")) {
                            properties = new Properties();
                            properties.load(zipInputStream);
                            continue;
                        }
                        if (!string4.endsWith(".jar")) continue;
                        object = new ZipInputStream(zipInputStream);
                        while (properties == null && (stringArray = object.getNextEntry()) != null) {
                            String string5 = stringArray.getName().toLowerCase(MessageText.LOCALE_ENGLISH);
                            if (!string5.equals("plugin.properties")) continue;
                            properties = new Properties();
                            properties.load((InputStream)object);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw new PluginException("Failed to read plugin file", throwable);
                }
                finally {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
                n = string2.lastIndexOf("_");
                object2 = null;
                string4 = null;
                if (n != -1) {
                    object2 = string2.substring(0, n);
                    string4 = string2.substring(n + 1);
                }
                if (properties == null) {
                    if (object2 != null) {
                        this.id = object2;
                        this.version = string4;
                        object = this.installer.getPluginManager().getPluginInterfaceByID(this.id);
                        boolean bl2 = bl = object != null && (object.getPluginDirectoryName() == null || object.getPluginDirectoryName().length() == 0);
                    }
                    if (!bl) {
                        throw new PluginException("Mandatory file 'plugin.properties' not found in plugin file");
                    }
                } else {
                    PluginInitializer.checkJDKVersion("", properties, false);
                    PluginInitializer.checkAzureusVersion("", properties, false);
                    this.id = properties.getProperty("plugin.id");
                    this.version = properties.getProperty("plugin.version");
                    object = this.version;
                    if (object != null && string4 != null && !string4.equals(object)) {
                        throw new PluginException("inconsistent versions [file=" + string4 + ", prop=" + (String)object + "]");
                    }
                }
                if (this.id == null) {
                    object = properties.getProperty("plugin.class");
                    if (object == null && (stringArray = properties.getProperty("plugin.classes")) != null) {
                        int n3 = stringArray.indexOf(";");
                        object = n3 == -1 ? stringArray : stringArray.substring(0, n3);
                    }
                    if (object != null) {
                        try {
                            stringArray = this.installer.getPluginManager().getPluginInterfaceByClass((String)object);
                            if (stringArray != null) {
                                this.id = stringArray.getPluginID();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if ((n = string2.lastIndexOf("_")) != -1) {
                    this.id = this.id == null ? string2.substring(0, n) : this.id;
                    try {
                        object = SFPluginDetailsLoaderFactory.getSingleton();
                        stringArray = object.getPluginIDs();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equalsIgnoreCase(this.id)) continue;
                            this.id = stringArray[i];
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                    this.version = this.version == null ? string2.substring(n + 1) : this.version;
                }
                this.name = this.id;
                if (properties != null && (object = properties.getProperty("plugin.name")) != null) {
                    this.name = object;
                }
                boolean bl3 = bl = this.id != null && this.version != null;
            }
        }
        if (!bl) {
            throw new PluginException("Invalid plugin file name: must be of form <pluginid>_<version>.[jar|zip]");
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.file.toString();
    }

    @Override
    public String getRelativeURLBase() {
        return "";
    }

    @Override
    public void addUpdate(UpdateCheckInstance updateCheckInstance, final PluginUpdatePlugin pluginUpdatePlugin, Plugin plugin, final PluginInterface pluginInterface) {
        updateCheckInstance.addUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return FilePluginInstallerImpl.this.name;
            }

            @Override
            public int getMaximumCheckTime() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkForUpdate(UpdateChecker updateChecker) {
                try {
                    ResourceDownloader resourceDownloader = pluginInterface.getUtilities().getResourceDownloaderFactory().create(FilePluginInstallerImpl.this.file);
                    pluginUpdatePlugin.addUpdate(pluginInterface, updateChecker, this.getName(), new String[]{"Installation from file: " + FilePluginInstallerImpl.this.file.toString()}, FilePluginInstallerImpl.this.version, resourceDownloader, FilePluginInstallerImpl.this.is_jar, pluginInterface.getPluginState().isUnloadable() ? 1 : 2, false);
                }
                finally {
                    updateChecker.completed();
                }
            }
        }, false);
    }
}

