/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.net.URL;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadScrapeResultImpl
implements DownloadScrapeResult {
    protected DownloadImpl download;
    protected TRTrackerScraperResponse response;

    protected DownloadScrapeResultImpl(DownloadImpl downloadImpl, TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.download = downloadImpl;
        this.response = tRTrackerScraperResponse;
    }

    protected void setContent(TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.response = tRTrackerScraperResponse;
    }

    @Override
    public Download getDownload() {
        return this.download;
    }

    @Override
    public int getResponseType() {
        if (this.response != null && this.response.isValid()) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getSeedCount() {
        return this.response == null ? -1 : this.response.getSeeds();
    }

    @Override
    public int getNonSeedCount() {
        return this.response == null ? -1 : this.response.getPeers();
    }

    @Override
    public long getScrapeStartTime() {
        return this.response == null ? -1L : this.response.getScrapeStartTime();
    }

    @Override
    public void setNextScrapeStartTime(long l) {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.getCurrentResponse();
        if (tRTrackerScraperResponse != null) {
            tRTrackerScraperResponse.setNextScrapeStartTime(l);
        }
    }

    @Override
    public long getNextScrapeStartTime() {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.getCurrentResponse();
        return tRTrackerScraperResponse == null ? -1L : tRTrackerScraperResponse.getNextScrapeStartTime();
    }

    @Override
    public String getStatus() {
        if (this.response != null) {
            return this.response.getStatusString();
        }
        return "";
    }

    @Override
    public URL getURL() {
        if (this.response != null) {
            return this.response.getURL();
        }
        return null;
    }

    protected TRTrackerScraperResponse getCurrentResponse() {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.download.getDownload().getTrackerScrapeResponse();
        if (tRTrackerScraperResponse == null) {
            tRTrackerScraperResponse = this.response;
        }
        return tRTrackerScraperResponse;
    }
}

