/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.utils;

import org.gudy.azureus2.plugins.PluginException;

public interface FeatureManager {
    public Licence[] getLicences();

    public Licence[] createLicences(String[] var1) throws PluginException;

    public Licence addLicence(String var1) throws PluginException;

    public FeatureDetails[] getFeatureDetails(String var1);

    public void refreshLicences();

    public void registerFeatureEnabler(FeatureEnabler var1);

    public void unregisterFeatureEnabler(FeatureEnabler var1);

    public void addListener(FeatureManagerListener var1);

    public void removeListener(FeatureManagerListener var1);

    public static interface FeatureManagerListener {
        public void licenceAdded(Licence var1);

        public void licenceChanged(Licence var1);

        public void licenceRemoved(Licence var1);
    }

    public static interface FeatureDetails {
        public static final String PR_PUBLIC_KEY = "PublicKey";
        public static final String PR_VALID_UNTIL = "ValidUntil";
        public static final String PR_OFFLINE_VALID_UNTIL = "OfflineValidUntil";
        public static final String PR_IS_INSTALL_TIME = "IsInstallTime";
        public static final String PR_IS_TRIAL = "IsTrial";
        public static final String PR_TRIAL_USES_LIMIT = "TrialUsesLimit";
        public static final String PR_TRIAL_USES_FAIL_COUNT = "TrialUsesFailCount";
        public static final String PR_TRIAL_USES_REMAINING = "TrialUsesRemaining";
        public static final String PR_REQUIRED_PLUGINS = "Plugins";
        public static final String PR_FINGERPRINT = "Fingerprint";

        public Licence getLicence();

        public String getID();

        public boolean hasExpired();

        public byte[] getEncodedProperties();

        public byte[] getSignature();

        public Object getProperty(String var1);

        public void setProperty(String var1, Object var2);
    }

    public static interface FeatureEnabler {
        public Licence[] getLicences();

        public Licence[] createLicences(String[] var1) throws PluginException;

        public Licence addLicence(String var1);

        public void refreshLicences();

        public void addListener(FeatureManagerListener var1);

        public void removeListener(FeatureManagerListener var1);
    }

    public static interface Licence {
        public static final int LS_PENDING_AUTHENTICATION = 1;
        public static final int LS_AUTHENTICATED = 2;
        public static final int LS_INVALID_KEY = 3;
        public static final int LS_CANCELLED = 4;
        public static final int LS_REVOKED = 5;
        public static final int LS_ACTIVATION_DENIED = 6;

        public int getState();

        public String getKey();

        public String getShortID();

        public FeatureDetails[] getFeatures();

        public boolean isFullyInstalled();

        public void retryInstallation();

        public void addInstallationListener(LicenceInstallationListener var1);

        public void removeInstallationListener(LicenceInstallationListener var1);

        public void remove();

        public static interface LicenceInstallationListener {
            public void start(String var1);

            public void reportActivity(String var1, String var2, String var3);

            public void reportProgress(String var1, String var2, int var3);

            public void complete(String var1);

            public void failed(String var1, PluginException var2);
        }
    }
}

