/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileIsADirectoryException;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TorrentUtils {
    public static final int TORRENT_FLAG_LOW_NOISE = 1;
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_ENABLE = "dht_backup_enable";
    private static final String TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED = "dht_backup_requested";
    private static final String TORRENT_AZ_PROP_TORRENT_FLAGS = "torrent_flags";
    private static final String TORRENT_AZ_PROP_PLUGINS = "plugins";
    public static final String TORRENT_AZ_PROP_OBTAINED_FROM = "obtained_from";
    public static final String TORRENT_AZ_PROP_PEER_CACHE = "peer_cache";
    public static final String TORRENT_AZ_PROP_PEER_CACHE_VALID = "peer_cache_valid";
    private static final String MEM_ONLY_TORRENT_PATH = "?/\\!:mem_only:!\\/?";
    private static final long PC_MARKER = RandomUtils.nextLong();
    private static final List created_torrents;
    private static final Set created_torrents_set;
    private static ThreadLocal<Map<String, Object>> tls;
    private static volatile Set ignore_set;
    private static boolean bSaveTorrentBackup;
    private static CopyOnWriteList torrent_attribute_listeners;
    private static final int PIECE_HASH_TIMEOUT = 180000;
    private static Map torrent_delegates;
    private static HashSet torrentFluffKeyset;
    private static Map fluffThombstone;

    public static TOTorrent readFromFile(File file, boolean bl) throws TOTorrentException {
        return TorrentUtils.readFromFile(file, bl, false);
    }

    public static ExtendedTorrent readDelegateFromFile(File file, boolean bl) throws TOTorrentException {
        return (ExtendedTorrent)TorrentUtils.readFromFile(file, true, bl);
    }

    public static TOTorrent readFromFile(File file, boolean bl, boolean bl2) throws TOTorrentException {
        Object object;
        TOTorrent tOTorrent;
        try {
            tOTorrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            if (bSaveTorrentBackup && !((File)(object = new File(file.getParent(), file.getName() + ".bak"))).exists()) {
                try {
                    tOTorrent.serialiseToBEncodedFile((File)object);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.outNoStack(tOTorrentException.getMessage());
            File file2 = new File(file.getParent(), file.getName() + ".bak");
            if (file2.exists()) {
                tOTorrent = TOTorrentFactory.deserialiseFromBEncodedFile(file2);
            }
            throw tOTorrentException;
        }
        tOTorrent.setAdditionalStringProperty("torrent filename", file.toString());
        if (bl) {
            object = new torrentDelegate(tOTorrent, file);
            if (bl2) {
                ((torrentDelegate)object).discardPieces(SystemTime.getCurrentTime(), true);
            }
            return object;
        }
        return tOTorrent;
    }

    public static TOTorrent readFromBEncodedInputStream(InputStream inputStream) throws TOTorrentException {
        TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
        tOTorrent.removeAdditionalProperties();
        return tOTorrent;
    }

    public static void setMemoryOnly(TOTorrent tOTorrent, boolean bl) {
        if (bl) {
            tOTorrent.setAdditionalStringProperty("torrent filename", MEM_ONLY_TORRENT_PATH);
        } else {
            String string = tOTorrent.getAdditionalStringProperty("torrent filename");
            if (string != null && string.equals(MEM_ONLY_TORRENT_PATH)) {
                tOTorrent.removeAdditionalProperty("torrent filename");
            }
        }
    }

    public static void writeToFile(TOTorrent tOTorrent) throws TOTorrentException {
        TorrentUtils.writeToFile(tOTorrent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(TOTorrent tOTorrent, boolean bl) throws TOTorrentException {
        try {
            tOTorrent.getMonitor().enter();
            String string = tOTorrent.getAdditionalStringProperty("torrent filename");
            if (string == null) {
                throw new TOTorrentException("TorrentUtils::writeToFile: no 'torrent filename' attribute defined", 1);
            }
            if (string.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            File file = new File(string + "._az");
            tOTorrent.serialiseToBEncodedFile(file);
            File file2 = new File(string);
            if ((bl || COConfigurationManager.getBooleanParameter("Save Torrent Backup")) && file2.exists()) {
                File file3 = new File(string + ".bak");
                try {
                    file3.delete();
                    file2.renameTo(file3);
                }
                catch (SecurityException securityException) {
                    Debug.printStackTrace(securityException);
                }
            }
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        finally {
            tOTorrent.getMonitor().exit();
        }
    }

    public static void writeToFile(TOTorrent tOTorrent, File file) throws TOTorrentException {
        TorrentUtils.writeToFile(tOTorrent, file, false);
    }

    public static void writeToFile(TOTorrent tOTorrent, File file, boolean bl) throws TOTorrentException {
        tOTorrent.setAdditionalStringProperty("torrent filename", file.toString());
        TorrentUtils.writeToFile(tOTorrent, bl);
    }

    public static String getTorrentFileName(TOTorrent tOTorrent) throws TOTorrentException {
        String string = tOTorrent.getAdditionalStringProperty("torrent filename");
        if (string == null) {
            throw new TOTorrentException("TorrentUtils::getTorrentFileName: no 'torrent filename' attribute defined", 1);
        }
        if (string.equals(MEM_ONLY_TORRENT_PATH)) {
            return null;
        }
        return string;
    }

    public static void copyToFile(TOTorrent tOTorrent, File file) throws TOTorrentException {
        tOTorrent.serialiseToBEncodedFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(TOTorrent tOTorrent) throws TOTorrentException {
        try {
            tOTorrent.getMonitor().enter();
            String string = tOTorrent.getAdditionalStringProperty("torrent filename");
            if (string == null) {
                throw new TOTorrentException("TorrentUtils::delete: no 'torrent filename' attribute defined", 1);
            }
            if (string.equals(MEM_ONLY_TORRENT_PATH)) {
                return;
            }
            if (!new File(string).delete()) {
                throw new TOTorrentException("TorrentUtils::delete: failed to delete '" + string + "'", 5);
            }
            new File(string + ".bak").delete();
        }
        finally {
            tOTorrent.getMonitor().exit();
        }
    }

    public static void delete(File file, boolean bl) {
        if (!FileUtil.deleteWithRecycle(file, bl)) {
            Debug.out("TorrentUtils::delete: failed to delete '" + file + "'");
        }
        new File(file.toString() + ".bak").delete();
    }

    public static boolean move(File file, File file2) {
        if (!FileUtil.renameFile(file, file2)) {
            return false;
        }
        if (new File(file.toString() + ".bak").exists()) {
            FileUtil.renameFile(new File(file.toString() + ".bak"), new File(file2.toString() + ".bak"));
        }
        return true;
    }

    public static String exceptionToText(TOTorrentException tOTorrentException) {
        String string;
        int n = tOTorrentException.getReason();
        String string2 = n == 1 ? MessageText.getString("DownloadManager.error.filenotfound") : (n == 2 ? MessageText.getString("DownloadManager.error.fileempty") : (n == 3 ? MessageText.getString("DownloadManager.error.filetoobig") : (n == 6 ? MessageText.getString("DownloadManager.error.filewithouttorrentinfo") : (n == 7 ? MessageText.getString("DownloadManager.error.unsupportedencoding") : (n == 4 ? MessageText.getString("DownloadManager.error.ioerror") : (n == 8 ? MessageText.getString("DownloadManager.error.sha1") : (n == 9 ? MessageText.getString("DownloadManager.error.operationcancancelled") : Debug.getNestedExceptionMessage(tOTorrentException))))))));
        if (string2.indexOf(string = Debug.getNestedExceptionMessage(tOTorrentException)) == -1) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    public static List<List<String>> announceGroupsToList(TOTorrent tOTorrent) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
        if (tOTorrentAnnounceURLSetArray.length == 0) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(tOTorrent.getAnnounceURL().toString());
            arrayList.add(arrayList2);
        } else {
            for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                for (int j = 0; j < uRLArray.length; ++j) {
                    arrayList3.add(uRLArray[j].toString());
                }
                if (arrayList3.size() <= 0) continue;
                arrayList.add(arrayList3);
            }
        }
        return arrayList;
    }

    public static void listToAnnounceGroups(List<List<String>> list, TOTorrent tOTorrent) {
        try {
            List<Object> list2;
            TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrent.getAnnounceURLGroup();
            if (list.size() == 1 && (list2 = list.get(0)).size() == 1) {
                tOTorrent.setAnnounceURL(new URL((String)list2.get(0)));
                tOTorrentAnnounceURLGroup.setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                return;
            }
            list2 = new Vector();
            for (int i = 0; i < list.size(); ++i) {
                List<String> list3 = list.get(i);
                URL[] uRLArray = new URL[list3.size()];
                for (int j = 0; j < list3.size(); ++j) {
                    uRLArray[j] = new URL(list3.get(j));
                }
                if (uRLArray.length <= 0) continue;
                ((Vector)list2).add(tOTorrentAnnounceURLGroup.createAnnounceURLSet(uRLArray));
            }
            Object[] objectArray = new TOTorrentAnnounceURLSet[((Vector)list2).size()];
            ((Vector)list2).copyInto(objectArray);
            tOTorrentAnnounceURLGroup.setAnnounceURLSets((TOTorrentAnnounceURLSet[])objectArray);
            if (objectArray.length == 0) {
                tOTorrent.setAnnounceURL(new URL("http://no.valid.urls.defined/announce"));
            }
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent tOTorrent, String string) {
        try {
            TorrentUtils.announceGroupsInsertFirst(tOTorrent, new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Debug.printStackTrace(malformedURLException);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent tOTorrent, URL uRL) {
        TorrentUtils.announceGroupsInsertFirst(tOTorrent, new URL[]{uRL});
    }

    public static void announceGroupsInsertFirst(TOTorrent tOTorrent, URL[] uRLArray) {
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
        TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLGroup.createAnnounceURLSet(uRLArray);
        if (tOTorrentAnnounceURLSetArray.length > 0) {
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2 = new TOTorrentAnnounceURLSet[tOTorrentAnnounceURLSetArray.length + 1];
            tOTorrentAnnounceURLSetArray2[0] = tOTorrentAnnounceURLSet;
            System.arraycopy(tOTorrentAnnounceURLSetArray, 0, tOTorrentAnnounceURLSetArray2, 1, tOTorrentAnnounceURLSetArray.length);
            tOTorrentAnnounceURLGroup.setAnnounceURLSets(tOTorrentAnnounceURLSetArray2);
        } else {
            TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet2 = tOTorrentAnnounceURLGroup.createAnnounceURLSet(new URL[]{tOTorrent.getAnnounceURL()});
            tOTorrentAnnounceURLGroup.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{tOTorrentAnnounceURLSet, tOTorrentAnnounceURLSet2});
        }
    }

    public static void announceGroupsInsertLast(TOTorrent tOTorrent, URL[] uRLArray) {
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
        TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLGroup.createAnnounceURLSet(uRLArray);
        if (tOTorrentAnnounceURLSetArray.length > 0) {
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2 = new TOTorrentAnnounceURLSet[tOTorrentAnnounceURLSetArray.length + 1];
            tOTorrentAnnounceURLSetArray2[tOTorrentAnnounceURLSetArray.length] = tOTorrentAnnounceURLSet;
            System.arraycopy(tOTorrentAnnounceURLSetArray, 0, tOTorrentAnnounceURLSetArray2, 0, tOTorrentAnnounceURLSetArray.length);
            tOTorrentAnnounceURLGroup.setAnnounceURLSets(tOTorrentAnnounceURLSetArray2);
        } else {
            TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet2 = tOTorrentAnnounceURLGroup.createAnnounceURLSet(new URL[]{tOTorrent.getAnnounceURL()});
            tOTorrentAnnounceURLGroup.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{tOTorrentAnnounceURLSet2, tOTorrentAnnounceURLSet});
        }
    }

    public static void announceGroupsSetFirst(TOTorrent tOTorrent, String string) {
        List<List<String>> list = TorrentUtils.announceGroupsToList(tOTorrent);
        boolean bl = false;
        block0: for (int i = 0; i < list.size(); ++i) {
            List<String> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                if (!string.equals(list2.get(j))) continue;
                list2.remove(j);
                list2.add(0, string);
                list.remove(list2);
                list.add(0, list2);
                bl = true;
                break block0;
            }
        }
        if (!bl) {
            System.out.println("TorrentUtils::announceGroupsSetFirst - failed to find '" + string + "'");
        }
        TorrentUtils.listToAnnounceGroups(list, tOTorrent);
    }

    public static boolean announceGroupsContainsURL(TOTorrent tOTorrent, String string) {
        List<List<String>> list = TorrentUtils.announceGroupsToList(tOTorrent);
        for (int i = 0; i < list.size(); ++i) {
            List<String> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                if (!string.equals(list2.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean mergeAnnounceURLs(TOTorrent tOTorrent, TOTorrent tOTorrent2) {
        int n;
        if (tOTorrent == null || tOTorrent2 == null) {
            return false;
        }
        List<List<String>> list = TorrentUtils.announceGroupsToList(tOTorrent);
        List<List<String>> list2 = TorrentUtils.announceGroupsToList(tOTorrent2);
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (n = 0; n < list.size(); ++n) {
            List<String> list3 = list.get(n);
            boolean bl = false;
            for (int i = 0; i < list2.size(); ++i) {
                boolean bl2;
                List<String> list4 = list2.get(i);
                boolean bl3 = bl2 = list3.size() == list4.size();
                if (bl2) {
                    for (int j = 0; j < list3.size(); ++j) {
                        String string = list3.get(j);
                        if (list4.contains(string)) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(list3);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list2.add(n, (List<String>)arrayList.get(n));
        }
        TorrentUtils.listToAnnounceGroups(list2, tOTorrent2);
        return true;
    }

    public static boolean replaceAnnounceURL(TOTorrent tOTorrent, URL uRL, URL uRL2) {
        boolean bl = false;
        String string = uRL.toString();
        String string2 = uRL2.toString();
        List<List<String>> list = TorrentUtils.announceGroupsToList(tOTorrent);
        for (int i = 0; i < list.size(); ++i) {
            List<String> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                if (!list2.get(j).equals(string)) continue;
                bl = true;
                list2.set(j, string2);
            }
        }
        if (bl) {
            TorrentUtils.listToAnnounceGroups(list, tOTorrent);
        }
        if (tOTorrent.getAnnounceURL().toString().equals(string)) {
            tOTorrent.setAnnounceURL(uRL2);
            bl = true;
        }
        if (bl) {
            try {
                TorrentUtils.writeToFile(tOTorrent);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return false;
            }
        }
        return bl;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState downloadManagerState) {
        DiskManagerFactory.setResumeDataCompletelyValid(downloadManagerState);
    }

    public static String getLocalisedName(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return "";
        }
        try {
            String string = tOTorrent.getUTF8Name();
            if (string != null) {
                return string;
            }
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(tOTorrent);
            if (localeUtilDecoder == null) {
                return new String(tOTorrent.getName(), "UTF8");
            }
            return localeUtilDecoder.decodeString(tOTorrent.getName());
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return new String(tOTorrent.getName());
        }
    }

    public static void setTLSTorrentHash(HashWrapper hashWrapper) {
        tls.get().put("hash", hashWrapper);
    }

    public static TOTorrent getTLSTorrent() {
        HashWrapper hashWrapper = (HashWrapper)tls.get().get("hash");
        if (hashWrapper != null) {
            try {
                AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
                DownloadManager downloadManager = azureusCore.getGlobalManager().getDownloadManager(hashWrapper);
                if (downloadManager != null) {
                    return downloadManager.getTorrent();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    public static void setTLSDescription(String string) {
        tls.get().put("desc", string);
    }

    public static String getTLSDescription() {
        return (String)tls.get().get("desc");
    }

    public static Object getTLS() {
        return new HashMap<String, Object>(tls.get());
    }

    public static void setTLS(Object object) {
        Map map = (Map)object;
        Map<String, Object> map2 = tls.get();
        map2.clear();
        map2.putAll(map);
    }

    public static URL getDecentralisedEmptyURL() {
        try {
            return new URL("dht://");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public static URL getDecentralisedURL(TOTorrent tOTorrent) {
        try {
            return new URL("dht://" + ByteFormatter.encodeString(tOTorrent.getHash()) + ".dht/announce");
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return TorrentUtils.getDecentralisedEmptyURL();
        }
    }

    public static void setDecentralised(TOTorrent tOTorrent) {
        tOTorrent.setAnnounceURL(TorrentUtils.getDecentralisedURL(tOTorrent));
    }

    public static boolean isDecentralised(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return false;
        }
        return TorrentUtils.isDecentralised(tOTorrent.getAnnounceURL());
    }

    public static boolean isDecentralised(URL uRL) {
        if (uRL == null) {
            return false;
        }
        return uRL.getProtocol().equalsIgnoreCase("dht");
    }

    private static Map getAzureusProperties(TOTorrent tOTorrent) {
        HashMap hashMap = tOTorrent.getAdditionalMapProperty("azureus_properties");
        if (hashMap == null) {
            hashMap = new HashMap();
            tOTorrent.setAdditionalMapProperty("azureus_properties", hashMap);
        }
        return hashMap;
    }

    private static Map getAzureusPrivateProperties(TOTorrent tOTorrent) {
        HashMap hashMap = tOTorrent.getAdditionalMapProperty("azureus_private_properties");
        if (hashMap == null) {
            hashMap = new HashMap();
            tOTorrent.setAdditionalMapProperty("azureus_private_properties", hashMap);
        }
        return hashMap;
    }

    public static void setObtainedFrom(File file, String string) {
        try {
            TOTorrent tOTorrent = TorrentUtils.readFromFile(file, false, false);
            TorrentUtils.setObtainedFrom(tOTorrent, string);
            TorrentUtils.writeToFile(tOTorrent);
        }
        catch (TOTorrentException tOTorrentException) {
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    public static void setObtainedFrom(TOTorrent tOTorrent, String string) {
        Map map = TorrentUtils.getAzureusPrivateProperties(tOTorrent);
        try {
            map.put(TORRENT_AZ_PROP_OBTAINED_FROM, string.getBytes("UTF-8"));
            TorrentUtils.fireAttributeListener(tOTorrent, TORRENT_AZ_PROP_OBTAINED_FROM, string);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static String getObtainedFrom(TOTorrent tOTorrent) {
        Map map = TorrentUtils.getAzureusPrivateProperties(tOTorrent);
        byte[] byArray = (byte[])map.get(TORRENT_AZ_PROP_OBTAINED_FROM);
        if (byArray != null) {
            try {
                return new String(byArray, "UTF-8");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    public static void setPeerCache(TOTorrent tOTorrent, Map map) {
        Map map2 = TorrentUtils.getAzureusPrivateProperties(tOTorrent);
        try {
            map2.put(TORRENT_AZ_PROP_PEER_CACHE, map);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static void setPeerCacheValid(TOTorrent tOTorrent) {
        Map map = TorrentUtils.getAzureusPrivateProperties(tOTorrent);
        try {
            map.put(TORRENT_AZ_PROP_PEER_CACHE_VALID, new Long(PC_MARKER));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static Map getPeerCache(TOTorrent tOTorrent) {
        try {
            Map map = TorrentUtils.getAzureusPrivateProperties(tOTorrent);
            Long l = (Long)map.get(TORRENT_AZ_PROP_PEER_CACHE_VALID);
            if (l != null && l == PC_MARKER) {
                Map map2 = (Map)map.get(TORRENT_AZ_PROP_PEER_CACHE);
                return map2;
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        return null;
    }

    public static void setFlag(TOTorrent tOTorrent, int n, boolean bl) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        Long l = (Long)map.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (l == null) {
            l = new Long(0L);
        }
        map.put(TORRENT_AZ_PROP_TORRENT_FLAGS, new Long(l.intValue() | n));
    }

    public static boolean getFlag(TOTorrent tOTorrent, int n) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        Long l = (Long)map.get(TORRENT_AZ_PROP_TORRENT_FLAGS);
        if (l == null) {
            return false;
        }
        return (l.intValue() & n) != 0;
    }

    public static void setPluginStringProperty(TOTorrent tOTorrent, String string, String string2) {
        HashMap<String, byte[]> hashMap;
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map.get(TORRENT_AZ_PROP_PLUGINS);
        if (v instanceof Map) {
            hashMap = (HashMap<String, byte[]>)v;
        } else {
            hashMap = new HashMap<String, byte[]>();
            map.put(TORRENT_AZ_PROP_PLUGINS, hashMap);
        }
        if (string2 == null) {
            hashMap.remove(string);
        } else {
            hashMap.put(string, string2.getBytes());
        }
    }

    public static String getPluginStringProperty(TOTorrent tOTorrent, String string) {
        Map map;
        Map map2 = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map2.get(TORRENT_AZ_PROP_PLUGINS);
        if (v instanceof Map && (v = (map = (Map)v).get(string)) instanceof byte[]) {
            return new String((byte[])v);
        }
        return null;
    }

    public static void setPluginMapProperty(TOTorrent tOTorrent, String string, Map map) {
        HashMap<String, Map> hashMap;
        Map map2 = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map2.get(TORRENT_AZ_PROP_PLUGINS);
        if (v instanceof Map) {
            hashMap = (HashMap<String, Map>)v;
        } else {
            hashMap = new HashMap<String, Map>();
            map2.put(TORRENT_AZ_PROP_PLUGINS, hashMap);
        }
        if (map == null) {
            hashMap.remove(string);
        } else {
            hashMap.put(string, map);
        }
    }

    public static Map getPluginMapProperty(TOTorrent tOTorrent, String string) {
        Map map;
        Map map2 = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map2.get(TORRENT_AZ_PROP_PLUGINS);
        if (v instanceof Map && (v = (map = (Map)v).get(string)) instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public static void setDHTBackupEnabled(TOTorrent tOTorrent, boolean bl) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        map.put(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE, new Long(bl ? 1L : 0L));
    }

    public static boolean getDHTBackupEnabled(TOTorrent tOTorrent) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map.get(TORRENT_AZ_PROP_DHT_BACKUP_ENABLE);
        if (v instanceof Long) {
            return (Long)v == 1L;
        }
        return true;
    }

    public static boolean isDHTBackupRequested(TOTorrent tOTorrent) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        Object v = map.get(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED);
        if (v instanceof Long) {
            return (Long)v == 1L;
        }
        return false;
    }

    public static void setDHTBackupRequested(TOTorrent tOTorrent, boolean bl) {
        Map map = TorrentUtils.getAzureusProperties(tOTorrent);
        map.put(TORRENT_AZ_PROP_DHT_BACKUP_REQUESTED, new Long(bl ? 1L : 0L));
    }

    public static boolean isReallyPrivate(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return false;
        }
        if (UrlUtils.containsPasskey(tOTorrent.getAnnounceURL())) {
            return tOTorrent.getPrivate();
        }
        return false;
    }

    public static boolean getPrivate(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return false;
        }
        return tOTorrent.getPrivate();
    }

    public static void setPrivate(TOTorrent tOTorrent, boolean bl) {
        if (tOTorrent == null) {
            return;
        }
        try {
            tOTorrent.setPrivate(bl);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public static Set getIgnoreSet() {
        return TorrentUtils.getIgnoreSetSupport(false);
    }

    public static synchronized Set getIgnoreSetSupport(boolean bl) {
        if (ignore_set == null || bl) {
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            String string = COConfigurationManager.getStringParameter("File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini");
            if (ignore_set == null) {
                COConfigurationManager.addParameterListener("File.Torrent.IgnoreFiles", new ParameterListener(){

                    @Override
                    public void parameterChanged(String string) {
                        TorrentUtils.getIgnoreSetSupport(true);
                    }
                });
            }
            int n2 = 0;
            do {
                String string2;
                if ((n = string.indexOf(";", n2)) == -1) {
                    string2 = string.substring(n2);
                } else {
                    string2 = string.substring(n2, n);
                    n2 = n + 1;
                }
                hashSet.add(string2.trim().toLowerCase());
            } while (n != -1);
            ignore_set = hashSet;
        }
        return ignore_set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMapFluff(String[] stringArray) {
        Class<TorrentUtils> clazz = TorrentUtils.class;
        synchronized (TorrentUtils.class) {
            for (int i = 0; i < stringArray.length; ++i) {
                torrentFluffKeyset.add(stringArray[i]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static File copyTorrentFileToSaveDir(File file, boolean bl) throws IOException {
        File file2;
        boolean bl2 = bl && COConfigurationManager.getBooleanParameter("Save Torrent Files");
        File file3 = bl2 ? new File(COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) : new File(file.getParent());
        boolean bl3 = COConfigurationManager.getBooleanParameter("Move Completed When Done");
        String string = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (bl3 && string.length() > 0 && (file2 = new File(string, file.getName())).exists()) {
            file3 = new File(string);
        }
        FileUtil.mkdirs(file3);
        file2 = new File(file3, file.getName().replaceAll("%20", "."));
        if (file2.equals(file)) {
            return file;
        }
        while (file2.exists()) {
            file2 = new File(file3, "_" + file2.getName());
        }
        file2.createNewFile();
        if (!FileUtil.copyFile(file, file2)) {
            throw new IOException("File copy failed");
        }
        return file2;
    }

    public static DownloadManager getDownloadManager(HashWrapper hashWrapper) {
        try {
            return AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(hashWrapper);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void recursiveEmptyDirDelete(File file) {
        TorrentUtils.recursiveEmptyDirDelete(file, true);
    }

    public static void recursiveEmptyDirDelete(File file, boolean bl) {
        Set set = TorrentUtils.getIgnoreSet();
        FileUtil.recursiveEmptyDirDelete(file, set, bl);
    }

    public static String nicePrintTorrentHash(TOTorrent tOTorrent) {
        return TorrentUtils.nicePrintTorrentHash(tOTorrent, false);
    }

    public static String nicePrintTorrentHash(TOTorrent tOTorrent, boolean bl) {
        byte[] byArray;
        if (tOTorrent == null) {
            byArray = new byte[20];
        } else {
            try {
                byArray = tOTorrent.getHash();
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
                byArray = new byte[20];
            }
        }
        return ByteFormatter.nicePrint(byArray, bl);
    }

    public static boolean isTorrentFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + string + " not found.");
        }
        if (!file.canRead()) {
            throw new IOException("File " + string + " cannot be read.");
        }
        if (file.isDirectory()) {
            throw new FileIsADirectoryException("File " + string + " is a directory.");
        }
        try {
            TOTorrentFactory.deserialiseFromBEncodedFile(file);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedTorrent(TOTorrent tOTorrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hashWrapper;
                byte[] byArray = tOTorrent.getHash();
                if (created_torrents.size() == 0) {
                    COConfigurationManager.setParameter("my.created.torrents", created_torrents);
                }
                if (!created_torrents_set.contains(hashWrapper = new HashWrapper(byArray))) {
                    created_torrents.add(byArray);
                    created_torrents_set.add(hashWrapper);
                    COConfigurationManager.setDirty();
                }
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCreatedTorrent(TOTorrent tOTorrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hashWrapper = tOTorrent.getHashWrapper();
                byte[] byArray = hashWrapper.getBytes();
                Iterator iterator = created_torrents.iterator();
                while (iterator.hasNext()) {
                    byte[] byArray2 = (byte[])iterator.next();
                    if (!Arrays.equals(byArray, byArray2)) continue;
                    iterator.remove();
                }
                COConfigurationManager.setDirty();
                created_torrents_set.remove(hashWrapper);
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreatedTorrent(TOTorrent tOTorrent) {
        List list = created_torrents;
        synchronized (list) {
            try {
                HashWrapper hashWrapper = tOTorrent.getHashWrapper();
                boolean bl = created_torrents_set.contains(hashWrapper);
                if (!bl) {
                    bl = tOTorrent.isCreated();
                }
                return bl;
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
                return false;
            }
        }
    }

    private static void fireAttributeListener(TOTorrent tOTorrent, String string, Object object) {
        Iterator iterator = torrent_attribute_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((torrentAttributeListener)iterator.next()).attributeSet(tOTorrent, string, object);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public static void addTorrentAttributeListener(torrentAttributeListener torrentAttributeListener2) {
        torrent_attribute_listeners.add(torrentAttributeListener2);
    }

    public static void removeTorrentAttributeListener(torrentAttributeListener torrentAttributeListener2) {
        torrent_attribute_listeners.remove(torrentAttributeListener2);
    }

    static {
        tls = new ThreadLocal<Map<String, Object>>(){

            @Override
            public Map<String, Object> initialValue() {
                return new HashMap<String, Object>();
            }
        };
        torrent_attribute_listeners = new CopyOnWriteList();
        COConfigurationManager.addAndFireParameterListener("Save Torrent Backup", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                bSaveTorrentBackup = COConfigurationManager.getBooleanParameter(string);
            }
        });
        created_torrents = COConfigurationManager.getListParameter("my.created.torrents", new ArrayList());
        created_torrents_set = new HashSet();
        Iterator iterator = created_torrents.iterator();
        while (iterator.hasNext()) {
            created_torrents_set.add(new HashWrapper((byte[])iterator.next()));
        }
        torrent_delegates = new WeakHashMap();
        SimpleTimer.addPeriodicEvent("TorrentUtils:pieceDiscard", 90000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                long l = SystemTime.getCurrentTime();
                Map map = torrent_delegates;
                synchronized (map) {
                    Iterator iterator = torrent_delegates.keySet().iterator();
                    while (iterator.hasNext()) {
                        ((torrentDelegate)iterator.next()).discardPieces(l, false);
                    }
                }
            }
        });
        torrentFluffKeyset = new HashSet(2);
        fluffThombstone = new HashMap(1);
    }

    public static interface torrentAttributeListener {
        public void attributeSet(TOTorrent var1, String var2, Object var3);
    }

    private static class torrentDelegate
    extends LogRelation
    implements ExtendedTorrent {
        private TOTorrent delegate;
        private File file;
        private boolean fluff_dirty;
        private long last_pieces_read_time = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected torrentDelegate(TOTorrent tOTorrent, File file) {
            this.delegate = tOTorrent;
            this.file = file;
            Map map = torrent_delegates;
            synchronized (map) {
                torrent_delegates.put(this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDiscardFluff(boolean bl) {
            if (bl && !torrentFluffKeyset.isEmpty()) {
                try {
                    this.getMonitor().enter();
                    try {
                        Object object;
                        if (this.fluff_dirty) {
                            object = this.restoreState(true, true);
                            this.delegate.serialiseToBEncodedFile(this.file);
                            this.fluff_dirty = false;
                            if (object[0] != false) {
                                this.discardPieces(SystemTime.getCurrentTime(), true);
                            }
                        }
                        object = torrentFluffKeyset.iterator();
                        while (object.hasNext()) {
                            this.delegate.setAdditionalMapProperty((String)object.next(), fluffThombstone);
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                finally {
                    this.getMonitor().exit();
                }
            }
        }

        @Override
        public byte[] getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isSimpleTorrent() {
            return this.delegate.isSimpleTorrent();
        }

        @Override
        public byte[] getComment() {
            return this.delegate.getComment();
        }

        @Override
        public void setComment(String string) {
            this.delegate.setComment(string);
        }

        @Override
        public long getCreationDate() {
            return this.delegate.getCreationDate();
        }

        @Override
        public void setCreationDate(long l) {
            this.delegate.setCreationDate(l);
        }

        @Override
        public byte[] getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        @Override
        public void setCreatedBy(byte[] byArray) {
            this.delegate.setCreatedBy(byArray);
        }

        @Override
        public boolean isCreated() {
            return this.delegate.isCreated();
        }

        @Override
        public URL getAnnounceURL() {
            return this.delegate.getAnnounceURL();
        }

        @Override
        public boolean setAnnounceURL(URL uRL) {
            return this.delegate.setAnnounceURL(uRL);
        }

        @Override
        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            return this.delegate.getAnnounceURLGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void discardPieces(long l, boolean bl) {
            block7: {
                if (l < this.last_pieces_read_time && !bl) {
                    this.last_pieces_read_time = l;
                } else {
                    try {
                        if (l - this.last_pieces_read_time <= 180000L && !bl || this.delegate.getPieces() == null) break block7;
                        try {
                            this.getMonitor().enter();
                            this.delegate.setPieces(null);
                        }
                        finally {
                            this.getMonitor().exit();
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[][] getPieces() throws TOTorrentException {
            byte[][] byArray = this.delegate.getPieces();
            this.last_pieces_read_time = SystemTime.getCurrentTime();
            if (byArray == null) {
                try {
                    this.getMonitor().enter();
                    this.restoreState(true, false);
                    byArray = this.delegate.getPieces();
                }
                finally {
                    this.getMonitor().exit();
                }
            }
            return byArray;
        }

        protected boolean[] restoreState(boolean bl, boolean bl2) throws TOTorrentException {
            boolean bl3 = this.delegate.getPieces() != null;
            boolean bl4 = true;
            Object object = torrentFluffKeyset.iterator();
            while (object.hasNext()) {
                bl4 &= this.delegate.getAdditionalMapProperty((String)object.next()) != fluffThombstone;
            }
            if (bl3) {
                bl = false;
            }
            if (bl4) {
                bl2 = false;
            }
            if (bl || bl2) {
                Object object2;
                object = TorrentUtils.readFromFile(this.file, false);
                if (bl) {
                    object2 = object.getPieces();
                    this.delegate.setPieces((byte[][])object2);
                }
                if (bl2) {
                    object2 = torrentFluffKeyset.iterator();
                    while (object2.hasNext()) {
                        String string = (String)object2.next();
                        if (this.delegate.getAdditionalMapProperty(string) != fluffThombstone) continue;
                        this.delegate.setAdditionalMapProperty(string, object.getAdditionalMapProperty(string));
                    }
                }
            }
            return new boolean[]{bl, bl2};
        }

        @Override
        public byte[][] peekPieces() throws TOTorrentException {
            return this.delegate.getPieces();
        }

        @Override
        public void setPieces(byte[][] byArray) throws TOTorrentException {
            throw new TOTorrentException("Unsupported Operation", 5);
        }

        @Override
        public long getPieceLength() {
            return this.delegate.getPieceLength();
        }

        @Override
        public int getNumberOfPieces() {
            return this.delegate.getNumberOfPieces();
        }

        @Override
        public long getSize() {
            return this.delegate.getSize();
        }

        @Override
        public TOTorrentFile[] getFiles() {
            return this.delegate.getFiles();
        }

        @Override
        public byte[] getHash() throws TOTorrentException {
            return this.delegate.getHash();
        }

        @Override
        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.delegate.getHashWrapper();
        }

        @Override
        public void setHashOverride(byte[] byArray) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        @Override
        public boolean getPrivate() {
            return this.delegate.getPrivate();
        }

        @Override
        public void setPrivate(boolean bl) throws TOTorrentException {
            throw new TOTorrentException("Can't amend private attribute", 5);
        }

        @Override
        public boolean hasSameHashAs(TOTorrent tOTorrent) {
            return this.delegate.hasSameHashAs(tOTorrent);
        }

        @Override
        public void setAdditionalStringProperty(String string, String string2) {
            this.delegate.setAdditionalStringProperty(string, string2);
        }

        @Override
        public String getAdditionalStringProperty(String string) {
            return this.delegate.getAdditionalStringProperty(string);
        }

        @Override
        public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
            this.delegate.setAdditionalByteArrayProperty(string, byArray);
        }

        @Override
        public byte[] getAdditionalByteArrayProperty(String string) {
            return this.delegate.getAdditionalByteArrayProperty(string);
        }

        @Override
        public void setAdditionalLongProperty(String string, Long l) {
            this.delegate.setAdditionalLongProperty(string, l);
        }

        @Override
        public Long getAdditionalLongProperty(String string) {
            return this.delegate.getAdditionalLongProperty(string);
        }

        @Override
        public void setAdditionalListProperty(String string, List list) {
            this.delegate.setAdditionalListProperty(string, list);
        }

        @Override
        public List getAdditionalListProperty(String string) {
            return this.delegate.getAdditionalListProperty(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAdditionalMapProperty(String string, Map map) {
            if (torrentFluffKeyset.contains(string)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalMapProperty(string, map);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalMapProperty(string, map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getAdditionalMapProperty(String string) {
            block7: {
                if (torrentFluffKeyset.contains(string)) {
                    try {
                        this.getMonitor().enter();
                        Map map = this.delegate.getAdditionalMapProperty(string);
                        if (map != fluffThombstone) break block7;
                        try {
                            Map map2;
                            this.restoreState(false, true);
                            Map map3 = map2 = this.delegate.getAdditionalMapProperty(string);
                            return map3;
                        }
                        catch (Throwable throwable) {
                            Debug.out("Property '" + string + " lost due to torrent read error", throwable);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalMapProperty(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAdditionalProperty(String string) {
            block7: {
                if (torrentFluffKeyset.contains(string)) {
                    try {
                        this.getMonitor().enter();
                        Object object = this.delegate.getAdditionalProperty(string);
                        if (object != fluffThombstone) break block7;
                        try {
                            Object object2;
                            this.restoreState(false, true);
                            Object object3 = object2 = this.delegate.getAdditionalProperty(string);
                            return object3;
                        }
                        catch (Throwable throwable) {
                            Debug.out("Property '" + string + " lost due to torrent read error", throwable);
                        }
                    }
                    finally {
                        this.getMonitor().exit();
                    }
                }
            }
            return this.delegate.getAdditionalProperty(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAdditionalProperty(String string, Object object) {
            if (torrentFluffKeyset.contains(string)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.setAdditionalProperty(string, object);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.setAdditionalProperty(string, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAdditionalProperty(String string) {
            if (this.delegate.getAdditionalProperty(string) == null) {
                return;
            }
            if (torrentFluffKeyset.contains(string)) {
                try {
                    this.getMonitor().enter();
                    this.delegate.removeAdditionalProperty(string);
                    this.fluff_dirty = true;
                }
                finally {
                    this.getMonitor().exit();
                }
            } else {
                this.delegate.removeAdditionalProperty(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAdditionalProperties() {
            try {
                this.getMonitor().enter();
                this.delegate.removeAdditionalProperties();
                this.fluff_dirty = true;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialiseToBEncodedFile(File file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] blArray = this.restoreState(true, true);
                this.delegate.serialiseToBEncodedFile(file);
                if (file.equals(this.file)) {
                    this.fluff_dirty = false;
                }
                if (blArray[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (blArray[1]) {
                    Iterator iterator = torrentFluffKeyset.iterator();
                    while (iterator.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)iterator.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map serialiseToMap() throws TOTorrentException {
            try {
                Object object;
                this.getMonitor().enter();
                boolean[] blArray = this.restoreState(true, true);
                Map map = this.delegate.serialiseToMap();
                if (blArray[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (blArray[1]) {
                    object = torrentFluffKeyset.iterator();
                    while (object.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)object.next(), fluffThombstone);
                    }
                }
                object = map;
                return object;
            }
            finally {
                this.getMonitor().exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialiseToXMLFile(File file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                boolean[] blArray = this.restoreState(true, true);
                this.delegate.serialiseToXMLFile(file);
                if (blArray[0]) {
                    this.discardPieces(SystemTime.getCurrentTime(), true);
                }
                if (blArray[1]) {
                    Iterator iterator = torrentFluffKeyset.iterator();
                    while (iterator.hasNext()) {
                        this.delegate.setAdditionalMapProperty((String)iterator.next(), fluffThombstone);
                    }
                }
            }
            finally {
                this.getMonitor().exit();
            }
        }

        @Override
        public void addListener(TOTorrentListener tOTorrentListener) {
            this.delegate.addListener(tOTorrentListener);
        }

        @Override
        public void removeListener(TOTorrentListener tOTorrentListener) {
            this.delegate.removeListener(tOTorrentListener);
        }

        @Override
        public AEMonitor getMonitor() {
            return this.delegate.getMonitor();
        }

        @Override
        public void print() {
            this.delegate.print();
        }

        @Override
        public String getRelationText() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getRelationText();
            }
            return this.delegate.toString();
        }

        @Override
        public Object[] getQueryableInterfaces() {
            if (this.delegate instanceof LogRelation) {
                return ((LogRelation)((Object)this.delegate)).getQueryableInterfaces();
            }
            return super.getQueryableInterfaces();
        }

        @Override
        public String getUTF8Name() {
            return this.delegate.getUTF8Name();
        }
    }

    public static interface ExtendedTorrent
    extends TOTorrent {
        public byte[][] peekPieces() throws TOTorrentException;

        public void setDiscardFluff(boolean var1);
    }
}

