/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PausableAverage
extends Average {
    private long offset;
    private long pause_time;

    public static PausableAverage getPausableInstance(int n, int n2) {
        if (n < 100) {
            return null;
        }
        if (n2 * 1000 < n) {
            return null;
        }
        return new PausableAverage(n, n2);
    }

    private PausableAverage(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void addValue(long l) {
        super.addValue(l);
    }

    @Override
    public long getAverage() {
        long l = super.getAverage();
        return l;
    }

    @Override
    protected long getEffectiveTime() {
        return SystemTime.getCurrentTime() - this.offset;
    }

    public void pause() {
        if (this.pause_time == 0L) {
            this.pause_time = SystemTime.getCurrentTime();
        }
    }

    public void resume() {
        if (this.pause_time != 0L) {
            long l = SystemTime.getCurrentTime();
            if (l > this.pause_time) {
                this.offset += l - this.pause_time;
            }
            this.pause_time = 0L;
        }
    }
}

