/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.NonDaemonTask;

public class NonDaemonTaskRunner {
    public static final int LINGER_PERIOD = 2500;
    protected static NonDaemonTaskRunner singleton;
    protected static AEMonitor class_mon;
    protected Stack tasks = new Stack();
    protected AEMonitor tasks_mon = new AEMonitor("NonDaemonTaskRunner:tasks");
    protected AESemaphore task_sem = new AESemaphore("NonDaemonTaskRunner");
    protected List wait_until_idle_list = new ArrayList();
    protected AEThread2 current_thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NonDaemonTaskRunner getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new NonDaemonTaskRunner();
            }
            NonDaemonTaskRunner nonDaemonTaskRunner = singleton;
            return nonDaemonTaskRunner;
        }
        finally {
            class_mon.exit();
        }
    }

    public static Object run(NonDaemonTask nonDaemonTask) throws Throwable {
        return NonDaemonTaskRunner.getSingleton().runSupport(nonDaemonTask, false);
    }

    public static Object runAsync(NonDaemonTask nonDaemonTask) throws Throwable {
        return NonDaemonTaskRunner.getSingleton().runSupport(nonDaemonTask, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runSupport(NonDaemonTask nonDaemonTask, boolean bl) throws Throwable {
        if (this.current_thread != null && this.current_thread.isCurrentThread()) {
            return nonDaemonTask.run();
        }
        taskWrapper taskWrapper2 = new taskWrapper(nonDaemonTask);
        try {
            this.tasks_mon.enter();
            this.tasks.push(taskWrapper2);
            this.task_sem.release();
            if (this.current_thread == null) {
                final AESemaphore aESemaphore = new AESemaphore("NonDaemonTaskRunnerTask: " + nonDaemonTask.getName());
                this.current_thread = new AEThread2("NonDaemonTaskRunner", false){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        aESemaphore.release();
                        while (true) {
                            NonDaemonTaskRunner.this.task_sem.reserve(2500L);
                            taskWrapper taskWrapper2 = null;
                            try {
                                NonDaemonTaskRunner.this.tasks_mon.enter();
                                if (NonDaemonTaskRunner.this.tasks.isEmpty()) {
                                    NonDaemonTaskRunner.this.current_thread = null;
                                    for (int i = 0; i < NonDaemonTaskRunner.this.wait_until_idle_list.size(); ++i) {
                                        ((AESemaphore)NonDaemonTaskRunner.this.wait_until_idle_list.get(i)).release();
                                    }
                                    NonDaemonTaskRunner.this.wait_until_idle_list.clear();
                                    break;
                                }
                                taskWrapper2 = (taskWrapper)NonDaemonTaskRunner.this.tasks.pop();
                            }
                            finally {
                                NonDaemonTaskRunner.this.tasks_mon.exit();
                            }
                            taskWrapper2.run();
                        }
                    }
                };
                this.current_thread.start();
                aESemaphore.reserve();
            }
        }
        finally {
            this.tasks_mon.exit();
        }
        if (bl) {
            return null;
        }
        return taskWrapper2.waitForResult();
    }

    public static void waitUntilIdle() {
        NonDaemonTaskRunner.getSingleton().waitUntilIdleSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilIdleSupport() {
        AESemaphore aESemaphore;
        try {
            this.tasks_mon.enter();
            if (this.current_thread == null) {
                return;
            }
            aESemaphore = new AESemaphore("NDTR::idleWaiter");
            this.wait_until_idle_list.add(aESemaphore);
        }
        finally {
            this.tasks_mon.exit();
        }
        while (!aESemaphore.reserve(10000L)) {
            if (!Logger.isEnabled()) continue;
            try {
                this.tasks_mon.enter();
                for (int i = 0; i < this.wait_until_idle_list.size(); ++i) {
                    AESemaphore aESemaphore2 = (AESemaphore)this.wait_until_idle_list.get(i);
                    if (aESemaphore2 == aESemaphore) continue;
                    Logger.log(new LogEvent(LogIDs.CORE, "Waiting for " + aESemaphore2.getName() + " to complete"));
                }
            }
            finally {
                this.tasks_mon.exit();
            }
        }
    }

    static {
        class_mon = new AEMonitor("NonDaemonTaskRunner:class");
    }

    protected class taskWrapper {
        protected NonDaemonTask task;
        protected AESemaphore sem;
        protected Object result;
        protected Throwable exception;

        protected taskWrapper(NonDaemonTask nonDaemonTask) {
            this.task = nonDaemonTask;
            this.sem = new AESemaphore("NonDaemonTaskRunner::taskWrapper");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            try {
                this.result = this.task.run();
            }
            catch (Throwable throwable) {
                this.exception = throwable;
            }
            finally {
                this.sem.release();
            }
        }

        protected Object waitForResult() throws Throwable {
            this.sem.reserve();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

