/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class HashWrapper2 {
    private final byte[] hash;
    private final short offset;
    private final short length;
    private final int hash_code;

    public HashWrapper2(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public HashWrapper2(byte[] byArray, int n, int n2) {
        if (n >= Short.MAX_VALUE) {
            throw new RuntimeException("Illegal value - offset too large");
        }
        if (n2 >= Short.MAX_VALUE) {
            throw new RuntimeException("Illegal value - length too large");
        }
        this.hash = byArray;
        this.offset = (short)n;
        this.length = (short)n2;
        int n3 = 0;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            n3 = 31 * n3 + this.hash[i];
        }
        this.hash_code = n3;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof HashWrapper2)) {
            return false;
        }
        HashWrapper2 hashWrapper2 = (HashWrapper2)object;
        if (hashWrapper2.length != this.length) {
            return false;
        }
        byte[] byArray = hashWrapper2.hash;
        short s = hashWrapper2.offset;
        for (int i = 0; i < this.length; ++i) {
            if (this.hash[this.offset + i] == byArray[s + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash_code;
    }
}

