/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class DisplayFormatters {
    private static final boolean ROUND_NO = true;
    private static final boolean TRUNCZEROS_NO = false;
    private static final boolean TRUNCZEROS_YES = true;
    public static final int UNIT_B = 0;
    public static final int UNIT_KB = 1;
    public static final int UNIT_MB = 2;
    public static final int UNIT_GB = 3;
    public static final int UNIT_TB = 4;
    private static final int[] UNITS_PRECISION = new int[]{0, 1, 2, 2, 3};
    private static final NumberFormat[] cached_number_formats = new NumberFormat[20];
    private static NumberFormat percentage_format;
    private static String[] units;
    private static String[] units_bits;
    private static String[] units_rate;
    private static int unitsStopAt;
    private static String[] units_base10;
    private static String per_sec;
    private static boolean use_si_units;
    private static boolean force_si_values;
    private static boolean use_units_rate_bits;
    private static boolean not_use_GB_TB;
    private static int message_text_state;
    private static boolean separate_prot_data_stats;
    private static boolean data_stats_only;
    private static char decimalSeparator;
    private static String PeerManager_status_finished;
    private static String PeerManager_status_finishedin;
    private static String Formats_units_alot;
    private static String discarded;
    private static String ManagerItem_waiting;
    private static String ManagerItem_initializing;
    private static String ManagerItem_allocating;
    private static String ManagerItem_checking;
    private static String ManagerItem_finishing;
    private static String ManagerItem_ready;
    private static String ManagerItem_downloading;
    private static String ManagerItem_seeding;
    private static String ManagerItem_superseeding;
    private static String ManagerItem_stopping;
    private static String ManagerItem_stopped;
    private static String ManagerItem_paused;
    private static String ManagerItem_queued;
    private static String ManagerItem_error;
    private static String ManagerItem_forced;
    private static String yes;
    private static String no;

    public static void setUnits() {
        units = new String[unitsStopAt + 1];
        units_bits = new String[unitsStopAt + 1];
        units_rate = new String[unitsStopAt + 1];
        if (use_si_units) {
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = DisplayFormatters.getUnit("TiB");
                    DisplayFormatters.units_bits[4] = DisplayFormatters.getUnit("Tibit");
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? DisplayFormatters.getUnit("Tibit") : DisplayFormatters.getUnit("TiB");
                }
                case 3: {
                    DisplayFormatters.units[3] = DisplayFormatters.getUnit("GiB");
                    DisplayFormatters.units_bits[3] = DisplayFormatters.getUnit("Gibit");
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? DisplayFormatters.getUnit("Gibit") : DisplayFormatters.getUnit("GiB");
                }
                case 2: {
                    DisplayFormatters.units[2] = DisplayFormatters.getUnit("MiB");
                    DisplayFormatters.units_bits[2] = DisplayFormatters.getUnit("Mibit");
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? DisplayFormatters.getUnit("Mibit") : DisplayFormatters.getUnit("MiB");
                }
                case 1: {
                    DisplayFormatters.units[1] = DisplayFormatters.getUnit("KiB");
                    DisplayFormatters.units_bits[1] = DisplayFormatters.getUnit("Kibit");
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? DisplayFormatters.getUnit("Kibit") : DisplayFormatters.getUnit("KiB");
                }
                case 0: {
                    DisplayFormatters.units[0] = DisplayFormatters.getUnit("B");
                    DisplayFormatters.units_bits[0] = DisplayFormatters.getUnit("bit");
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? DisplayFormatters.getUnit("bit") : DisplayFormatters.getUnit("B");
                }
            }
        } else {
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = DisplayFormatters.getUnit("TB");
                    DisplayFormatters.units_bits[4] = DisplayFormatters.getUnit("Tbit");
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? DisplayFormatters.getUnit("Tbit") : DisplayFormatters.getUnit("TB");
                }
                case 3: {
                    DisplayFormatters.units[3] = DisplayFormatters.getUnit("GB");
                    DisplayFormatters.units_bits[3] = DisplayFormatters.getUnit("Gbit");
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? DisplayFormatters.getUnit("Gbit") : DisplayFormatters.getUnit("GB");
                }
                case 2: {
                    DisplayFormatters.units[2] = DisplayFormatters.getUnit("MB");
                    DisplayFormatters.units_bits[2] = DisplayFormatters.getUnit("Mbit");
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? DisplayFormatters.getUnit("Mbit") : DisplayFormatters.getUnit("MB");
                }
                case 1: {
                    DisplayFormatters.units[1] = DisplayFormatters.getUnit("kB");
                    DisplayFormatters.units_bits[1] = DisplayFormatters.getUnit("kbit");
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? DisplayFormatters.getUnit("kbit") : DisplayFormatters.getUnit("kB");
                }
                case 0: {
                    DisplayFormatters.units[0] = DisplayFormatters.getUnit("B");
                    DisplayFormatters.units_bits[0] = DisplayFormatters.getUnit("bit");
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? DisplayFormatters.getUnit("bit") : DisplayFormatters.getUnit("B");
                }
            }
        }
        per_sec = DisplayFormatters.getResourceString("Formats.units.persec", "/s");
        units_base10 = new String[]{DisplayFormatters.getUnit("B"), DisplayFormatters.getUnit("KB"), DisplayFormatters.getUnit("MB"), DisplayFormatters.getUnit("GB"), DisplayFormatters.getUnit("TB")};
        for (int i = 0; i <= unitsStopAt; ++i) {
            DisplayFormatters.units[i] = units[i];
            DisplayFormatters.units_rate[i] = units_rate[i] + per_sec;
        }
        Arrays.fill(cached_number_formats, null);
        percentage_format = NumberFormat.getPercentInstance();
        percentage_format.setMinimumFractionDigits(1);
        percentage_format.setMaximumFractionDigits(1);
        decimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    }

    private static String getUnit(String string) {
        String string2 = " " + DisplayFormatters.getResourceString("Formats.units." + string, string);
        return string2;
    }

    public static void loadMessages() {
        PeerManager_status_finished = DisplayFormatters.getResourceString("PeerManager.status.finished", "Finished");
        PeerManager_status_finishedin = DisplayFormatters.getResourceString("PeerManager.status.finishedin", "Finished in");
        Formats_units_alot = DisplayFormatters.getResourceString("Formats.units.alot", "A lot");
        discarded = DisplayFormatters.getResourceString("discarded", "discarded");
        ManagerItem_waiting = DisplayFormatters.getResourceString("ManagerItem.waiting", "waiting");
        ManagerItem_initializing = DisplayFormatters.getResourceString("ManagerItem.initializing", "initializing");
        ManagerItem_allocating = DisplayFormatters.getResourceString("ManagerItem.allocating", "allocating");
        ManagerItem_checking = DisplayFormatters.getResourceString("ManagerItem.checking", "checking");
        ManagerItem_finishing = DisplayFormatters.getResourceString("ManagerItem.finishing", "finishing");
        ManagerItem_ready = DisplayFormatters.getResourceString("ManagerItem.ready", "ready");
        ManagerItem_downloading = DisplayFormatters.getResourceString("ManagerItem.downloading", "downloading");
        ManagerItem_seeding = DisplayFormatters.getResourceString("ManagerItem.seeding", "seeding");
        ManagerItem_superseeding = DisplayFormatters.getResourceString("ManagerItem.superseeding", "superseeding");
        ManagerItem_stopping = DisplayFormatters.getResourceString("ManagerItem.stopping", "stopping");
        ManagerItem_stopped = DisplayFormatters.getResourceString("ManagerItem.stopped", "stopped");
        ManagerItem_paused = DisplayFormatters.getResourceString("ManagerItem.paused", "paused");
        ManagerItem_queued = DisplayFormatters.getResourceString("ManagerItem.queued", "queued");
        ManagerItem_error = DisplayFormatters.getResourceString("ManagerItem.error", "error");
        ManagerItem_forced = DisplayFormatters.getResourceString("ManagerItem.forced", "forced");
        yes = DisplayFormatters.getResourceString("GeneralView.yes", "Yes");
        no = DisplayFormatters.getResourceString("GeneralView.no", "No");
    }

    private static String getResourceString(String string, String string2) {
        if (message_text_state == 0) {
            try {
                MessageText.class.getName();
                message_text_state = 1;
            }
            catch (Throwable throwable) {
                message_text_state = 2;
            }
        }
        if (message_text_state == 1) {
            return MessageText.getString(string);
        }
        return string2;
    }

    public static String getYesNo(boolean bl) {
        return bl ? yes : no;
    }

    public static String getRateUnit(int n) {
        return units_rate[n].substring(1, units_rate[n].length());
    }

    public static String getUnit(int n) {
        return units[n].substring(1, units[n].length());
    }

    public static String getRateUnitBase10(int n) {
        return units_base10[n] + per_sec;
    }

    public static String getUnitBase10(int n) {
        return units_base10[n];
    }

    public static boolean isRateUsingBits() {
        return use_units_rate_bits;
    }

    public static String formatByteCountToKiBEtc(int n) {
        return DisplayFormatters.formatByteCountToKiBEtc((long)n);
    }

    public static String formatByteCountToKiBEtc(long l) {
        return DisplayFormatters.formatByteCountToKiBEtc(l, false, false);
    }

    public static String formatByteCountToKiBEtc(long l, boolean bl) {
        return DisplayFormatters.formatByteCountToKiBEtc(l, false, bl);
    }

    public static String formatByteCountToKiBEtc(long l, boolean bl, boolean bl2) {
        return DisplayFormatters.formatByteCountToKiBEtc(l, bl, bl2, -1);
    }

    public static String formatByteCountToKiBEtc(long l, boolean bl, boolean bl2, int n) {
        int n2;
        long l2;
        double d = bl && use_units_rate_bits ? (double)(l * 8L) : (double)l;
        long l3 = force_si_values ? 1024L : (l2 = (long)(use_si_units ? 1024 : 1000));
        for (n2 = 0; d >= (double)l2 && n2 < unitsStopAt; d /= (double)l2, ++n2) {
        }
        if (n < 0) {
            n = UNITS_PRECISION[n2];
        }
        return DisplayFormatters.formatDecimal(d, n, bl2, bl) + (bl ? units_rate[n2] : units[n2]);
    }

    public static boolean isDataProtSeparate() {
        return separate_prot_data_stats;
    }

    public static String formatDataProtByteCountToKiBEtc(long l, long l2) {
        if (separate_prot_data_stats) {
            if (l == 0L && l2 == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtc(0);
            }
            if (l == 0L) {
                return "(" + DisplayFormatters.formatByteCountToKiBEtc(l2) + ")";
            }
            if (l2 == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtc(l);
            }
            return DisplayFormatters.formatByteCountToKiBEtc(l) + " (" + DisplayFormatters.formatByteCountToKiBEtc(l2) + ")";
        }
        if (data_stats_only) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(l2 + l);
    }

    public static String formatDataProtByteCountToKiBEtcPerSec(long l, long l2) {
        if (separate_prot_data_stats) {
            if (l == 0L && l2 == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(0L);
            }
            if (l == 0L) {
                return "(" + DisplayFormatters.formatByteCountToKiBEtcPerSec(l2) + ")";
            }
            if (l2 == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(l2) + ")";
        }
        if (data_stats_only) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(l2 + l);
    }

    public static String formatByteCountToKiBEtcPerSec(long l) {
        return DisplayFormatters.formatByteCountToKiBEtc(l, true, false);
    }

    public static String formatByteCountToKiBEtcPerSec(long l, boolean bl) {
        return DisplayFormatters.formatByteCountToKiBEtc(l, true, bl);
    }

    public static String formatByteCountToBase10KBEtc(long l) {
        if (l < 1000L) {
            return l + units_base10[0];
        }
        if (l < 1000000L) {
            return l / 1000L + "." + l % 1000L / 100L + units_base10[1];
        }
        if (l < 1000000000L || not_use_GB_TB) {
            return l / 1000000L + "." + l % 1000000L / 100000L + units_base10[2];
        }
        if (l < 1000000000000L) {
            return l / 1000000000L + "." + l % 1000000000L / 100000000L + units_base10[3];
        }
        if (l < 1000000000000000L) {
            return l / 1000000000000L + "." + l % 1000000000000L / 100000000000L + units_base10[4];
        }
        return Formats_units_alot;
    }

    public static String formatByteCountToBase10KBEtcPerSec(long l) {
        return DisplayFormatters.formatByteCountToBase10KBEtc(l) + per_sec;
    }

    public static String formatByteCountToBitsPerSec(long l) {
        int n;
        double d = l * 8L;
        long l2 = 1000L;
        for (n = 0; d >= (double)l2 && n < unitsStopAt; d /= (double)l2, ++n) {
        }
        int n2 = UNITS_PRECISION[n];
        return DisplayFormatters.formatDecimal(d, n2, true, true) + units_bits[n] + per_sec;
    }

    public static String formatETA(long l) {
        if (l == 0L) {
            return PeerManager_status_finished;
        }
        if (l == -1L) {
            return "";
        }
        if (l > 0L) {
            return TimeFormatter.format(l);
        }
        return PeerManager_status_finishedin + " " + TimeFormatter.format(l * -1L);
    }

    public static String formatDownloaded(DownloadManagerStats downloadManagerStats) {
        long l = downloadManagerStats.getDiscarded();
        long l2 = downloadManagerStats.getTotalGoodDataBytesReceived();
        if (l == 0L) {
            return DisplayFormatters.formatByteCountToKiBEtc(l2);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(l2) + " ( " + DisplayFormatters.formatByteCountToKiBEtc(l) + " " + discarded + " )";
    }

    public static String formatHashFails(DownloadManager downloadManager) {
        TOTorrent tOTorrent = downloadManager.getTorrent();
        if (tOTorrent != null) {
            long l = downloadManager.getStats().getHashFailBytes();
            long l2 = l / tOTorrent.getPieceLength();
            String string = l2 + " ( " + DisplayFormatters.formatByteCountToKiBEtc(l) + " )";
            return string;
        }
        return "";
    }

    public static String formatDownloadStatus(DownloadManager downloadManager) {
        int n = downloadManager.getState();
        String string = "";
        switch (n) {
            case 75: {
                string = ManagerItem_queued;
                break;
            }
            case 50: {
                string = ManagerItem_downloading;
                break;
            }
            case 60: {
                DiskManager diskManager = downloadManager.getDiskManager();
                if (diskManager != null && diskManager.getCompleteRecheckStatus() != -1) {
                    int n2 = diskManager.getCompleteRecheckStatus();
                    if (n2 == -1) {
                        n2 = 1000;
                    }
                    string = ManagerItem_seeding + " + " + ManagerItem_checking + ": " + DisplayFormatters.formatPercentFromThousands(n2);
                    break;
                }
                if (downloadManager.getPeerManager() != null && downloadManager.getPeerManager().isSuperSeedMode()) {
                    string = ManagerItem_superseeding;
                    break;
                }
                string = ManagerItem_seeding;
                break;
            }
            case 70: {
                string = downloadManager.isPaused() ? ManagerItem_paused : ManagerItem_stopped;
                break;
            }
            case 100: {
                string = ManagerItem_error + ": " + downloadManager.getErrorDetails();
                break;
            }
            case 0: {
                string = ManagerItem_waiting;
                break;
            }
            case 5: {
                string = ManagerItem_initializing;
                break;
            }
            case 10: {
                string = ManagerItem_initializing;
                break;
            }
            case 20: {
                string = ManagerItem_allocating;
                DiskManager diskManager = downloadManager.getDiskManager();
                if (diskManager == null) break;
                string = string + ": " + DisplayFormatters.formatPercentFromThousands(diskManager.getPercentDone());
                break;
            }
            case 30: {
                string = ManagerItem_checking + ": " + DisplayFormatters.formatPercentFromThousands(downloadManager.getStats().getCompleted());
                break;
            }
            case 55: {
                string = ManagerItem_finishing;
                break;
            }
            case 40: {
                string = ManagerItem_ready;
                break;
            }
            case 65: {
                string = ManagerItem_stopping;
                break;
            }
            default: {
                string = String.valueOf(n);
            }
        }
        if (downloadManager.isForceStart() && (n == 60 || n == 50)) {
            string = ManagerItem_forced + " " + string;
        }
        return string;
    }

    public static String formatDownloadStatusDefaultLocale(DownloadManager downloadManager) {
        int n = downloadManager.getState();
        String string = "";
        DiskManager diskManager = downloadManager.getDiskManager();
        switch (n) {
            case 0: {
                string = MessageText.getDefaultLocaleString("ManagerItem.waiting");
                break;
            }
            case 5: {
                string = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 10: {
                string = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 20: {
                string = MessageText.getDefaultLocaleString("ManagerItem.allocating");
                break;
            }
            case 30: {
                string = MessageText.getDefaultLocaleString("ManagerItem.checking");
                break;
            }
            case 55: {
                string = MessageText.getDefaultLocaleString("ManagerItem.finishing");
                break;
            }
            case 40: {
                string = MessageText.getDefaultLocaleString("ManagerItem.ready");
                break;
            }
            case 50: {
                string = MessageText.getDefaultLocaleString("ManagerItem.downloading");
                break;
            }
            case 60: {
                if (diskManager != null && diskManager.getCompleteRecheckStatus() != -1) {
                    int n2 = diskManager.getCompleteRecheckStatus();
                    if (n2 == -1) {
                        n2 = 1000;
                    }
                    string = MessageText.getDefaultLocaleString("ManagerItem.seeding") + " + " + MessageText.getDefaultLocaleString("ManagerItem.checking") + ": " + DisplayFormatters.formatPercentFromThousands(n2);
                    break;
                }
                if (downloadManager.getPeerManager() != null && downloadManager.getPeerManager().isSuperSeedMode()) {
                    string = MessageText.getDefaultLocaleString("ManagerItem.superseeding");
                    break;
                }
                string = MessageText.getDefaultLocaleString("ManagerItem.seeding");
                break;
            }
            case 65: {
                string = MessageText.getDefaultLocaleString("ManagerItem.stopping");
                break;
            }
            case 70: {
                string = MessageText.getDefaultLocaleString(downloadManager.isPaused() ? "ManagerItem.paused" : "ManagerItem.stopped");
                break;
            }
            case 75: {
                string = MessageText.getDefaultLocaleString("ManagerItem.queued");
                break;
            }
            case 100: {
                string = MessageText.getDefaultLocaleString("ManagerItem.error").concat(": ").concat(downloadManager.getErrorDetails());
                break;
            }
            default: {
                string = String.valueOf(n);
            }
        }
        return string;
    }

    public static String trimDigits(String string, int n) {
        char[] cArray = string.toCharArray();
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c)) {
                if (++n2 > n) continue;
                string2 = string2 + c;
                continue;
            }
            if (c == '.' && n2 >= 3) continue;
            string2 = string2 + c;
        }
        return string2;
    }

    public static String formatPercentFromThousands(int n) {
        return percentage_format.format((double)n / 1000.0);
    }

    public static String formatTimeStamp(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        stringBuffer.append('[');
        stringBuffer.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(5)));
        stringBuffer.append('.');
        stringBuffer.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(2) + 1));
        stringBuffer.append('.');
        stringBuffer.append(calendar.get(1));
        stringBuffer.append(' ');
        stringBuffer.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(11)));
        stringBuffer.append(':');
        stringBuffer.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(12)));
        stringBuffer.append(':');
        stringBuffer.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(13)));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String formatIntToTwoDigits(int n) {
        return n < 10 ? "0".concat(String.valueOf(n)) : String.valueOf(n);
    }

    private static String formatDate(long l, String string) {
        if (l == 0L) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date(l));
    }

    public static String formatDate(long l) {
        return DisplayFormatters.formatDate(l, "dd-MMM-yyyy HH:mm:ss");
    }

    public static String formatDateShort(long l) {
        return DisplayFormatters.formatDate(l, "MMM dd, HH:mm");
    }

    public static String formatDateNum(long l) {
        return DisplayFormatters.formatDate(l, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatCustomDateOnly(long l) {
        if (l == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(l, "dd-MMM-yyyy");
    }

    public static String formatCustomTimeOnly(long l) {
        return DisplayFormatters.formatCustomTimeOnly(l, true);
    }

    public static String formatCustomTimeOnly(long l, boolean bl) {
        if (l == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(l, bl ? "HH:mm:ss" : "HH:mm");
    }

    public static String formatCustomDateTime(long l) {
        if (l == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(l);
    }

    public static String formatTime(long l) {
        return TimeFormatter.formatColon(l / 1000L);
    }

    public static String formatDecimal(double d, int n) {
        return DisplayFormatters.formatDecimal(d, n, false, true);
    }

    public static String formatDecimal(double d, int n, boolean bl, boolean bl2) {
        double d2;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return "\u221e";
        }
        if (bl2) {
            d2 = d;
        } else if (n == 0) {
            d2 = (long)d;
        } else {
            double d3 = Math.pow(10.0, n);
            d2 = (double)((long)(d * d3)) / d3;
        }
        int n2 = (n << 2) + ((bl ? 1 : 0) << 1) + (bl2 ? 1 : 0);
        NumberFormat numberFormat = null;
        if (n2 < cached_number_formats.length) {
            numberFormat = cached_number_formats[n2];
        }
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            if (!bl) {
                numberFormat.setMinimumFractionDigits(n);
            }
            if (bl2) {
                numberFormat.setMaximumFractionDigits(n);
            }
            if (n2 < cached_number_formats.length) {
                DisplayFormatters.cached_number_formats[n2] = numberFormat;
            }
        }
        return numberFormat.format(d2);
    }

    public static String truncateString(String string, int n) {
        int n2;
        int n3 = string.length() - n;
        if (n3 <= 0) {
            return string;
        }
        n3 += 3;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '~') {
                if (n4 == -1) {
                    n4 = n2;
                    continue;
                }
                int n7 = n2 - n4;
                if (n7 <= n5) continue;
                n5 = n7;
                n6 = n4;
                continue;
            }
            n4 = -1;
        }
        if (n5 >= n3) {
            n2 = n6 + n5;
            return string.substring(0, n2 - n3) + "..." + string.substring(n2);
        }
        return string.substring(0, n - 3) + "...";
    }

    public static void main(String[] stringArray) {
        double d = 3.991630774821635E-6;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(6);
        String string = numberFormat.format(d);
        System.out.println("Actual: " + d);
        System.out.println("NF/6:   " + string);
        System.out.println("DF:     " + DisplayFormatters.formatDecimal(d, 6));
        System.out.println("DF 0:   " + DisplayFormatters.formatDecimal(d, 0));
        System.out.println("0.000000:" + DisplayFormatters.formatDecimal(0.0, 6));
        System.out.println("0.001:" + DisplayFormatters.formatDecimal(0.001, 6, true, true));
        System.out.println("0:" + DisplayFormatters.formatDecimal(0.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.999, 0));
        System.out.println(DisplayFormatters.formatDecimal(Double.NaN, 3));
    }

    public static char getDecimalSeparator() {
        return decimalSeparator;
    }

    static {
        unitsStopAt = 4;
        message_text_state = 0;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"config.style.useSIUnits", "config.style.forceSIValues", "config.style.useUnitsRateBits", "config.style.doNotUseGB"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                use_si_units = COConfigurationManager.getBooleanParameter("config.style.useSIUnits");
                force_si_values = COConfigurationManager.getBooleanParameter("config.style.forceSIValues");
                use_units_rate_bits = COConfigurationManager.getBooleanParameter("config.style.useUnitsRateBits");
                not_use_GB_TB = COConfigurationManager.getBooleanParameter("config.style.doNotUseGB");
                unitsStopAt = not_use_GB_TB ? 2 : 4;
                DisplayFormatters.setUnits();
            }
        });
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                DisplayFormatters.setUnits();
                DisplayFormatters.loadMessages();
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"config.style.dataStatsOnly", "config.style.separateProtDataStats"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                separate_prot_data_stats = COConfigurationManager.getBooleanParameter("config.style.separateProtDataStats");
                data_stats_only = COConfigurationManager.getBooleanParameter("config.style.dataStatsOnly");
            }
        });
        DisplayFormatters.setUnits();
        DisplayFormatters.loadMessages();
    }
}

