/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.ThreadPool;

public class ConcurrentHasher {
    protected static ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected List<ConcurrentHasherRequest> requests = new LinkedList<ConcurrentHasherRequest>();
    protected List<SHA1Hasher> hashers = new ArrayList<SHA1Hasher>();
    protected AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        for (int i = 0; i < this.processor_num + 1; ++i) {
            this.scheduler_sem.release();
        }
        final ThreadPool threadPool = new ThreadPool("ConcurrentHasher", 64);
        new AEThread2("ConcurrentHasher:scheduler", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    SHA1Hasher sHA1Hasher;
                    ConcurrentHasherRequest concurrentHasherRequest;
                    ConcurrentHasher.this.request_sem.reserve();
                    try {
                        ConcurrentHasher.this.requests_mon.enter();
                        concurrentHasherRequest = ConcurrentHasher.this.requests.remove(0);
                        sHA1Hasher = ConcurrentHasher.this.hashers.size() == 0 ? new SHA1Hasher() : ConcurrentHasher.this.hashers.remove(ConcurrentHasher.this.hashers.size() - 1);
                    }
                    finally {
                        ConcurrentHasher.this.requests_mon.exit();
                    }
                    threadPool.run(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            try {
                                concurrentHasherRequest.run(sHA1Hasher);
                            }
                            finally {
                                try {
                                    ConcurrentHasher.this.requests_mon.enter();
                                    ConcurrentHasher.this.hashers.add(sHA1Hasher);
                                }
                                finally {
                                    ConcurrentHasher.this.requests_mon.exit();
                                }
                                if (friendly_hashing && concurrentHasherRequest.isLowPriority()) {
                                    try {
                                        int n = concurrentHasherRequest.getSize();
                                        n /= 1024;
                                        n /= 8;
                                        n = Math.min(n, 250);
                                        n = Math.max(n, 50);
                                        Thread.sleep(n);
                                    }
                                    catch (Throwable throwable) {
                                        Debug.printStackTrace(throwable);
                                    }
                                }
                                ConcurrentHasher.this.scheduler_sem.release();
                            }
                        }
                    });
                }
            }
        }.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer byteBuffer) {
        return this.addRequest(byteBuffer, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHasherRequest addRequest(ByteBuffer byteBuffer, ConcurrentHasherRequestListener concurrentHasherRequestListener, boolean bl) {
        ConcurrentHasherRequest concurrentHasherRequest = new ConcurrentHasherRequest(this, byteBuffer, concurrentHasherRequestListener, bl);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(concurrentHasherRequest);
        }
        finally {
            this.requests_mon.exit();
        }
        this.request_sem.release();
        return concurrentHasherRequest;
    }

    public static void main(String[] stringArray) {
    }

    static {
        COConfigurationManager.addParameterListener("diskmanager.friendly.hashchecking", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        });
    }
}

