/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AESemaphore2;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class AEThread2 {
    public static final boolean TRACE_TIMES = false;
    private static final int MIN_RETAINED = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private static final int MAX_RETAINED = Math.max(MIN_RETAINED * 4, 16);
    private static final int THREAD_TIMEOUT_CHECK_PERIOD = 10000;
    private static final int THREAD_TIMEOUT = 60000;
    private static final LinkedList daemon_threads = new LinkedList();
    private static long last_timeout_check;
    private static long total_starts;
    private static long total_creates;
    private threadWrapper wrapper;
    private String name;
    private boolean daemon;
    private int priority = 5;
    private volatile JoinLock lock = new JoinLock();

    public AEThread2(String string) {
        this(string, true);
    }

    public AEThread2(String string, boolean bl) {
        this.name = string;
        this.daemon = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JoinLock joinLock;
        JoinLock joinLock2 = this.lock;
        Object object = joinLock2;
        synchronized (object) {
            joinLock = joinLock2.released ? (this.lock = new JoinLock()) : joinLock2;
        }
        if (this.daemon) {
            object = daemon_threads;
            synchronized (object) {
                ++total_starts;
                if (daemon_threads.isEmpty()) {
                    ++total_creates;
                    this.wrapper = new threadWrapper(this.name, true);
                } else {
                    this.wrapper = (threadWrapper)daemon_threads.removeLast();
                    this.wrapper.setName(this.name);
                }
            }
        } else {
            this.wrapper = new threadWrapper(this.name, false);
        }
        if (this.priority != this.wrapper.getPriority()) {
            this.wrapper.setPriority(this.priority);
        }
        this.wrapper.currentLock = joinLock;
        this.wrapper.start(this, this.name);
    }

    public void setPriority(int n) {
        this.priority = n;
        if (this.wrapper != null) {
            this.wrapper.setPriority(this.priority);
        }
    }

    public void setName(String string) {
        this.name = string;
        if (this.wrapper != null) {
            this.wrapper.setName(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Interrupted before started!");
        }
        this.wrapper.interrupt();
    }

    public boolean isAlive() {
        return this.wrapper == null ? false : this.wrapper.isAlive();
    }

    public boolean isCurrentThread() {
        return this.wrapper == Thread.currentThread();
    }

    public String toString() {
        if (this.wrapper == null) {
            return this.name + " [daemon=" + this.daemon + ",priority=" + this.priority + "]";
        }
        return this.wrapper.toString();
    }

    public abstract void run();

    public static boolean isOurThread(Thread thread) {
        return AEThread.isOurThread(thread);
    }

    public static void setOurThread() {
        AEThread.setOurThread();
    }

    public static void setOurThread(Thread thread) {
        AEThread.setOurThread(thread);
    }

    public static void setDebug(Object object) {
        Thread thread = Thread.currentThread();
        if (thread instanceof threadWrapper) {
            ((threadWrapper)thread).setDebug(object);
        }
    }

    public static Object[] getDebug(Thread thread) {
        if (thread instanceof threadWrapper) {
            return ((threadWrapper)thread).getDebug();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        JoinLock joinLock;
        JoinLock joinLock2 = joinLock = this.lock;
        synchronized (joinLock2) {
            while (!joinLock.released) {
                try {
                    joinLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class threadWrapper
    extends Thread {
        private AESemaphore2 sem;
        private AEThread2 target;
        private JoinLock currentLock;
        private long last_active_time;
        private Object[] debug;

        protected threadWrapper(String string, boolean bl) {
            super(string);
            this.setDaemon(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                Object object = this.currentLock;
                synchronized (object) {
                    try {
                        this.target.run();
                    }
                    catch (Throwable throwable) {
                        DebugLight.printStackTrace(throwable);
                    }
                    finally {
                        this.target = null;
                        this.debug = null;
                        this.currentLock.released = true;
                        this.currentLock.notifyAll();
                    }
                }
                if (this.isInterrupted() || !Thread.currentThread().isDaemon()) break;
                object = daemon_threads;
                synchronized (object) {
                    this.last_active_time = SystemTime.getCurrentTime();
                    if (this.last_active_time < last_timeout_check || this.last_active_time - last_timeout_check > 10000L) {
                        last_timeout_check = this.last_active_time;
                        while (daemon_threads.size() > 0 && daemon_threads.size() > MIN_RETAINED) {
                            threadWrapper threadWrapper2 = (threadWrapper)daemon_threads.getFirst();
                            long l = threadWrapper2.last_active_time;
                            if (this.last_active_time >= l && this.last_active_time - l <= 60000L) break;
                            daemon_threads.removeFirst();
                            threadWrapper2.retire();
                        }
                    }
                    if (daemon_threads.size() >= MAX_RETAINED) {
                        return;
                    }
                    daemon_threads.addLast(this);
                    this.setName("AEThead2:parked[" + daemon_threads.size() + "]");
                }
                this.sem.reserve();
            } while (this.target != null);
        }

        protected void start(AEThread2 aEThread2, String string) {
            this.target = aEThread2;
            this.setName(string);
            if (this.sem == null) {
                this.sem = new AESemaphore2("AEThread2");
                super.start();
            } else {
                this.sem.release();
            }
        }

        protected void retire() {
            this.sem.release();
        }

        protected void setDebug(Object object) {
            this.debug = new Object[]{object, SystemTime.getMonotonousTime()};
        }

        protected Object[] getDebug() {
            return this.debug;
        }
    }

    private static final class JoinLock {
        volatile boolean released = false;

        private JoinLock() {
        }
    }
}

