/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.dht.TRTrackerServerDHT;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AsyncController;

public class TRTrackerServerFactoryImpl {
    protected static CopyOnWriteList servers = new CopyOnWriteList();
    protected static List listeners = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerServer create(String string, int n, int n2, InetAddress inetAddress, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws TRTrackerServerException {
        try {
            TRTrackerServerImpl tRTrackerServerImpl;
            class_mon.enter();
            if (n == 1) {
                tRTrackerServerImpl = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking") && bl3 && !bl ? new TRNonBlockingServer(string, n2, inetAddress, bl2, bl4, new TRNonBlockingServerProcessorFactory(){

                    @Override
                    public TRNonBlockingServerProcessor create(TRTrackerServerTCP tRTrackerServerTCP, SocketChannel socketChannel) {
                        return new NonBlockingProcessor(tRTrackerServerTCP, socketChannel);
                    }
                }) : new TRBlockingServer(string, n2, inetAddress, bl, bl2, bl4);
            } else if (n == 2) {
                if (bl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                tRTrackerServerImpl = new TRTrackerServerUDP(string, n2, bl4);
            } else {
                tRTrackerServerImpl = new TRTrackerServerDHT(string, bl4);
            }
            servers.add(tRTrackerServerImpl);
            for (int i = 0; i < listeners.size(); ++i) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(tRTrackerServerImpl);
            }
            TRTrackerServerImpl tRTrackerServerImpl2 = tRTrackerServerImpl;
            return tRTrackerServerImpl2;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void close(TRTrackerServerImpl tRTrackerServerImpl) {
        try {
            class_mon.enter();
            tRTrackerServerImpl.closeSupport();
            if (servers.remove(tRTrackerServerImpl)) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ((TRTrackerServerFactoryListener)listeners.get(i)).serverDestroyed(tRTrackerServerImpl);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(TRTrackerServerFactoryListener tRTrackerServerFactoryListener) {
        try {
            class_mon.enter();
            listeners.add(tRTrackerServerFactoryListener);
            Iterator iterator = servers.iterator();
            while (iterator.hasNext()) {
                tRTrackerServerFactoryListener.serverCreated((TRTrackerServer)iterator.next());
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(TRTrackerServerFactoryListener tRTrackerServerFactoryListener) {
        try {
            class_mon.enter();
            listeners.remove(tRTrackerServerFactoryListener);
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("tracker.read.bytes.total");
        hashSet.add("tracker.write.bytes.total");
        hashSet.add("tracker.announce.count");
        hashSet.add("tracker.announce.time");
        hashSet.add("tracker.scrape.count");
        hashSet.add("tracker.scrape.time");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            public void updateStats(Set set, Map map) {
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                Iterator iterator = servers.iterator();
                while (iterator.hasNext()) {
                    TRTrackerServerStats tRTrackerServerStats = ((TRTrackerServer)iterator.next()).getStats();
                    l += tRTrackerServerStats.getBytesIn();
                    l2 += tRTrackerServerStats.getBytesOut();
                    l3 += tRTrackerServerStats.getAnnounceCount();
                    l4 += tRTrackerServerStats.getAnnounceTime();
                    l5 += tRTrackerServerStats.getScrapeCount();
                    l6 += tRTrackerServerStats.getScrapeTime();
                }
                if (set.contains("tracker.read.bytes.total")) {
                    map.put("tracker.read.bytes.total", new Long(l));
                }
                if (set.contains("tracker.write.bytes.total")) {
                    map.put("tracker.write.bytes.total", new Long(l2));
                }
                if (set.contains("tracker.announce.count")) {
                    map.put("tracker.announce.count", new Long(l3));
                }
                if (set.contains("tracker.announce.time")) {
                    map.put("tracker.announce.time", new Long(l4));
                }
                if (set.contains("tracker.scrape.count")) {
                    map.put("tracker.scrape.count", new Long(l5));
                }
                if (set.contains("tracker.scrape.time")) {
                    map.put("tracker.scrape.time", new Long(l6));
                }
            }
        });
    }

    protected static class NonBlockingProcessor
    extends TRNonBlockingServerProcessor {
        protected NonBlockingProcessor(TRTrackerServerTCP tRTrackerServerTCP, SocketChannel socketChannel) {
            super(tRTrackerServerTCP, socketChannel);
        }

        @Override
        protected ByteArrayOutputStream process(String string, String string2, String string3, InetSocketAddress inetSocketAddress, boolean bl, InputStream inputStream, AsyncController asyncController) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            InetSocketAddress inetSocketAddress2 = null;
            this.processRequest(string, string2, string3, inetSocketAddress2, inetSocketAddress, bl, false, inputStream, byteArrayOutputStream, asyncController);
            return byteArrayOutputStream;
        }
    }
}

