/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TrackerStatus {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final String SS = "Scrape.status.";
    private static final String SSErr = "Scrape.status.error.";
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private static final int NOHASH_RETRY_INTERVAL = 10800000;
    private static final int GROUP_SCRAPES_MS = 900000;
    private static final int GROUP_SCRAPES_LIMIT = 20;
    private static boolean udpScrapeEnabled;
    private byte autoUDPscrapeEvery = 1;
    private int scrapeCount;
    private static List logged_invalid_urls;
    private static ThreadPool thread_pool;
    private final URL tracker_url;
    private boolean az_tracker;
    private String scrapeURL = null;
    private HashMap hashes;
    private TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");
    private final TrackerChecker checker;
    private volatile int numActiveScrapes = 0;

    public TrackerStatus(TrackerChecker trackerChecker, TRTrackerScraperImpl tRTrackerScraperImpl, URL uRL) {
        this.checker = trackerChecker;
        this.scraper = tRTrackerScraperImpl;
        this.tracker_url = uRL;
        this.az_tracker = TRTrackerUtils.isAZTracker(this.tracker_url);
        this.bSingleHashScrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Single Only");
        String string = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            string = string.replaceAll(" ", "");
            int n = string.lastIndexOf(47);
            if (n >= 0 && string.length() >= n + 9 && string.substring(n + 1, n + 9).equals("announce")) {
                this.scrapeURL = string.substring(0, n + 1) + "scrape" + string.substring(n + 9);
            } else if (string.toLowerCase().startsWith("udp:")) {
                this.scrapeURL = string;
            } else if (n >= 0 && string.lastIndexOf(46) < n) {
                this.scrapeURL = string + (string.endsWith("/") ? "" : "/") + "scrape";
            } else if (!logged_invalid_urls.contains(string)) {
                logged_invalid_urls.add(string);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected boolean isTrackerScrapeUrlValid() {
        return this.scrapeURL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hashWrapper) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hashWrapper);
            return tRTrackerScraperResponseImpl;
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected void updateSingleHash(HashWrapper hashWrapper, boolean bl) {
        this.updateSingleHash(hashWrapper, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSingleHash(HashWrapper hashWrapper, boolean bl, boolean bl2) {
        if (this.scrapeURL == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hashWrapper), LOGID, "TrackerStatus: scrape cancelled.. url null"));
            }
            return;
        }
        try {
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl;
            ArrayList<TRTrackerScraperResponseImpl> arrayList = new ArrayList<TRTrackerScraperResponseImpl>();
            try {
                this.hashes_mon.enter();
                tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hashWrapper);
            }
            finally {
                this.hashes_mon.exit();
            }
            if (tRTrackerScraperResponseImpl == null) {
                tRTrackerScraperResponseImpl = this.addHash(hashWrapper);
            }
            long l = tRTrackerScraperResponseImpl.getNextScrapeStartTime();
            if (!bl && l > SystemTime.getCurrentTime()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hashWrapper), LOGID, "TrackerStatus: scrape cancelled.. not forced and still " + (l - SystemTime.getCurrentTime()) + "ms"));
                }
                return;
            }
            tRTrackerScraperResponseImpl.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hashWrapper), LOGID, "TrackerStatus: setting to scraping"));
            }
            arrayList.add(tRTrackerScraperResponseImpl);
            if (!this.bSingleHashScrapes) {
                try {
                    this.hashes_mon.enter();
                    Iterator iterator = this.hashes.values().iterator();
                    while (iterator.hasNext() && arrayList.size() < 20) {
                        long l2;
                        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl2 = (TRTrackerScraperResponseImpl)iterator.next();
                        if (tRTrackerScraperResponseImpl2.getHash().equals(hashWrapper) || (l2 = Math.abs(l - tRTrackerScraperResponseImpl2.getNextScrapeStartTime())) > 900000L || tRTrackerScraperResponseImpl2.getStatus() == 3) continue;
                        tRTrackerScraperResponseImpl2.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(tRTrackerScraperResponseImpl2.getHash()), LOGID, "TrackerStatus: setting to scraping via group scrape"));
                        }
                        arrayList.add(tRTrackerScraperResponseImpl2);
                    }
                }
                finally {
                    this.hashes_mon.exit();
                }
            }
            this.runScrapes(arrayList, bl, bl2);
        }
        catch (Throwable throwable) {
            Debug.out("updateSingleHash() exception", throwable);
        }
    }

    protected void runScrapes(final ArrayList arrayList, final boolean bl, boolean bl2) {
        ++this.numActiveScrapes;
        if (bl2) {
            thread_pool.run(new AERunnable(){

                @Override
                public void runSupport() {
                    TrackerStatus.this.runScrapesSupport(arrayList, bl);
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerStatus: queuing '" + this.scrapeURL + "', for " + arrayList.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N") + ", queue size=" + thread_pool.getQueueSize()));
            }
        } else {
            this.runScrapesSupport(arrayList, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void runScrapesSupport(ArrayList arrayList, boolean bl) {
        block78: {
            Object object;
            int n;
            Map map;
            URL uRL;
            long l;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Object object5;
            byte[] byArray;
            boolean bl2;
            boolean bl3;
            block77: {
                Object object6;
                boolean bl4;
                Object object7;
                Object object8;
                block75: {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TrackerStatus: scraping '" + this.scrapeURL + "', for " + arrayList.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N")));
                    }
                    bl3 = this.bSingleHashScrapes;
                    boolean bl5 = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
                    bl2 = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
                    byArray = null;
                    object8 = null;
                    object5 = null;
                    char c = this.scrapeURL.indexOf(63) == -1 ? (char)'?' : '&';
                    string = "";
                    object4 = "";
                    object3 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object2 = (TRTrackerScraperResponseImpl)arrayList.get(i);
                        object7 = ((TRTrackerScraperResponseImpl)object2).getHash();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager((HashWrapper)object7), LOGID, "TrackerStatus: scraping, single_hash_scrapes = " + this.bSingleHashScrapes));
                        }
                        if (!this.scraper.isNetworkEnabled((HashWrapper)object7, this.tracker_url)) {
                            ((TRTrackerScraperResponseImpl)object2).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            ((TRTrackerScraperResponseImpl)object2).setStatus(1, MessageText.getString("Scrape.status.networkdisabled"));
                            this.scraper.scrapeReceived((TRTrackerScraperResponse)object2);
                            continue;
                        }
                        if (!bl && (bl5 || bl2 && !this.scraper.isTorrentRunning((HashWrapper)object7))) {
                            ((TRTrackerScraperResponseImpl)object2).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            ((TRTrackerScraperResponseImpl)object2).setStatus(1, MessageText.getString("Scrape.status.disabled"));
                            this.scraper.scrapeReceived((TRTrackerScraperResponse)object2);
                            continue;
                        }
                        ((TRTrackerScraperResponseImpl)object2).setStatus(3, MessageText.getString("Scrape.status.scraping"));
                        this.scraper.scrapeReceived((TRTrackerScraperResponse)object2);
                        string = string + (object8 != null ? (char)'&' : c) + "info_hash=";
                        string = string + URLEncoder.encode(new String(((HashWrapper)object7).getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                        Object[] objectArray = this.scraper.getExtensions((HashWrapper)object7);
                        if (objectArray != null) {
                            if (objectArray[0] != null) {
                                string = string + (String)objectArray[0];
                            }
                            object4 = (String)object4 + (Character)objectArray[1];
                        } else {
                            object4 = (String)object4 + TRTrackerScraperClientResolver.FL_NONE;
                        }
                        object5 = object2;
                        object8 = object7;
                        if (object3.size() >= 70) continue;
                        object3.add(object7);
                    }
                    if (object8 != null) break block75;
                    --this.numActiveScrapes;
                    return;
                }
                String string2 = this.scrapeURL + string;
                if (this.az_tracker) {
                    object2 = TRTrackerUtils.getPortsForURL();
                    string2 = string2 + (String)object2;
                    string2 = string2 + "&azsf=" + (String)object4 + "&azver=" + 3;
                }
                object2 = new URL(string2);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Accessing scrape interface using url : " + object2));
                }
                object7 = new ByteArrayOutputStream();
                l = SystemTime.getCurrentTime();
                uRL = null;
                String string3 = ((URL)object2).getProtocol();
                Object object9 = null;
                boolean bl6 = false;
                if (string3.equalsIgnoreCase("udp") && udpScrapeEnabled) {
                    object9 = object2;
                } else if (string3.equalsIgnoreCase("http") && !this.az_tracker && this.scrapeCount % this.autoUDPscrapeEvery == 0 && udpScrapeEnabled) {
                    object9 = new URL(((URL)object2).toString().replaceFirst("^http", "udp"));
                    bl6 = true;
                }
                try {
                    TorrentUtils.setTLSTorrentHash(object8);
                    if (object9 != null) {
                        boolean bl7 = this.scrapeUDP((URL)object2, (ByteArrayOutputStream)object7, (List)object3, !bl6);
                        if (!(bl7 && ((ByteArrayOutputStream)object7).size() != 0 || string3.equalsIgnoreCase("udp"))) {
                            object9 = null;
                            ((ByteArrayOutputStream)object7).reset();
                            if (this.autoUDPscrapeEvery < 16) {
                                this.autoUDPscrapeEvery = (byte)(this.autoUDPscrapeEvery << 1);
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp failed, will retry in " + this.autoUDPscrapeEvery + " scrapes"));
                            }
                        } else if (bl7 && !string3.equalsIgnoreCase("udp")) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp successful"));
                            }
                            this.autoUDPscrapeEvery = 1;
                            TRTrackerUtils.setUDPProbeResult((URL)object2, true);
                        }
                    }
                    ++this.scrapeCount;
                    if (object9 == null) {
                        uRL = this.scrapeHTTP((URL)object2, (ByteArrayOutputStream)object7);
                    }
                }
                finally {
                    TorrentUtils.setTLSTorrentHash(null);
                }
                byArray = ((ByteArrayOutputStream)object7).toByteArray();
                Map map2 = BDecoder.decode(byArray);
                boolean bl8 = bl4 = map2.get("aztracker") != null;
                if (this.az_tracker != bl4) {
                    this.az_tracker = bl4;
                    TRTrackerUtils.setAZTracker(this.tracker_url, this.az_tracker);
                }
                map = (Map)map2.get("files");
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Response from scrape interface " + this.scrapeURL + ": " + (map == null ? "null" : "" + map.size()) + " returned"));
                }
                n = 0;
                if (map2 != null && (object6 = (Map)map2.get("flags")) != null) {
                    object = (Long)object6.get("min_request_interval");
                    if (object != null) {
                        n = ((Long)object).intValue();
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Received min_request_interval of " + n));
                    }
                }
                if (map != null && map.size() != 0) break block77;
                object6 = map2 == null ? null : (byte[])map2.get("failure reason");
                Object object10 = object6;
                if (object6 != null) {
                    long l2 = SystemTime.getCurrentTime() + (long)(n == 0 ? 600000 : n * 1000);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)arrayList.get(i);
                        tRTrackerScraperResponseImpl.setNextScrapeStartTime(l2);
                        tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + new String((byte[])object6, "UTF8"));
                        this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
                    }
                } else if (arrayList.size() > 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " doesn't properly support " + "multi-hash scrapes"));
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)arrayList.get(i);
                        tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                        this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
                    }
                } else {
                    long l3 = SystemTime.getCurrentTime() + (long)(n == 0 ? 10800000 : n * 1000);
                    TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)arrayList.get(0);
                    tRTrackerScraperResponseImpl.setNextScrapeStartTime(l3);
                    tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                    this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
                }
                --this.numActiveScrapes;
                return;
            }
            try {
                if (!this.bSingleHashScrapes && arrayList.size() > 1 && map.size() == 1) {
                    this.bSingleHashScrapes = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " only returned " + map.size() + " hash scrape(s), but we asked for " + arrayList.size()));
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n2;
                    object = (TRTrackerScraperResponseImpl)arrayList.get(i);
                    Map map3 = (Map)map.get(new String(((TRTrackerScraperResponseImpl)object).getHash().getBytes(), "ISO-8859-1"));
                    if (map3 == null) {
                        if (arrayList.size() == 1 || map.size() != 1) {
                            ((TRTrackerScraperResponseImpl)object).setNextScrapeStartTime(SystemTime.getCurrentTime() + 10800000L);
                            ((TRTrackerScraperResponseImpl)object).setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                            this.scraper.scrapeReceived((TRTrackerScraperResponse)object);
                            continue;
                        }
                        if (bl2 && !this.scraper.isTorrentRunning(((TRTrackerScraperResponseImpl)object).getHash())) continue;
                        ((TRTrackerScraperResponseImpl)object).revertStatus();
                        if (((TRTrackerScraperResponseImpl)object).getStatus() == 3) {
                            ((TRTrackerScraperResponseImpl)object).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            ((TRTrackerScraperResponseImpl)object).setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                        } else {
                            this.bSingleHashScrapes = true;
                            if (bl3) {
                                ((TRTrackerScraperResponseImpl)object).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            }
                        }
                        this.scraper.scrapeReceived((TRTrackerScraperResponse)object);
                        continue;
                    }
                    int n3 = ((Long)map3.get("complete")).intValue();
                    int n4 = ((Long)map3.get("incomplete")).intValue();
                    Long l4 = (Long)map3.get("downloaded");
                    int n5 = n2 = l4 == null ? -1 : l4.intValue();
                    if (n3 < 0 || n4 < 0 || n2 < -1) {
                        if (Logger.isEnabled()) {
                            HashWrapper hashWrapper = ((TRTrackerScraperResponseImpl)object).getHash();
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hashWrapper), LOGID, "Invalid scrape response from '" + object2 + "': map = " + map3));
                        }
                        if (arrayList.size() > 1 && this.bSingleHashScrapes) {
                            ((TRTrackerScraperResponseImpl)object).setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                            this.scraper.scrapeReceived((TRTrackerScraperResponse)object);
                            continue;
                        }
                        ((TRTrackerScraperResponseImpl)object).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        ((TRTrackerScraperResponseImpl)object).setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid") + " " + (n3 < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + n3 + ". " : "") + (n4 < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + n4 + ". " : "") + (n2 < 0 ? MessageText.getString("MyTorrentsView.completed") + " == " + n2 + ". " : ""));
                        this.scraper.scrapeReceived((TRTrackerScraperResponse)object);
                        continue;
                    }
                    int n6 = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(n, n3);
                    long l5 = SystemTime.getCurrentTime() + (long)(n6 * 1000);
                    ((TRTrackerScraperResponseImpl)object).setNextScrapeStartTime(l5);
                    ((TRTrackerScraperResponseImpl)object).setScrapeStartTime(l);
                    ((TRTrackerScraperResponseImpl)object).setSeeds(n3);
                    ((TRTrackerScraperResponseImpl)object).setPeers(n4);
                    ((TRTrackerScraperResponseImpl)object).setCompleted(n2);
                    ((TRTrackerScraperResponseImpl)object).setStatus(2, MessageText.getString("Scrape.status.ok"));
                    this.scraper.scrapeReceived((TRTrackerScraperResponse)object);
                    try {
                        String string4;
                        int n7;
                        if (arrayList.size() != 1 || uRL == null || (n7 = (string4 = uRL.toString()).indexOf("/scrape")) == -1) continue;
                        URL uRL2 = new URL(string4.substring(0, n7) + "/announce" + string4.substring(n7 + 7));
                        if (!this.scraper.redirectTrackerUrl(((TRTrackerScraperResponseImpl)object).getHash(), this.tracker_url, uRL2)) continue;
                        this.removeHash(((TRTrackerScraperResponseImpl)object).getHash());
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                break block78;
                {
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)arrayList.get(i);
                            tRTrackerScraperResponseImpl.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + noClassDefFoundError.getMessage());
                            this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)arrayList.get(i);
                            tRTrackerScraperResponseImpl.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("DownloadManager.error.filenotfound"));
                            this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
                        }
                    }
                    catch (SocketException socketException) {
                        this.setAllError(socketException);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        this.setAllError(socketTimeoutException);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.setAllError(unknownHostException);
                    }
                    catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
                        this.setAllError(pRUDPPacketHandlerException);
                    }
                    catch (BEncodingException bEncodingException) {
                        this.setAllError(bEncodingException);
                    }
                    catch (Exception exception) {
                        block79: {
                            object5 = exception.getMessage();
                            if (object5 != null) {
                                if (((String)object5).indexOf(" 500 ") >= 0 || ((String)object5).indexOf(" 400 ") >= 0 || ((String)object5).indexOf(" 403 ") >= 0 || ((String)object5).indexOf(" 404 ") >= 0 || ((String)object5).indexOf(" 501 ") >= 0) {
                                    this.setAllError(exception);
                                    --this.numActiveScrapes;
                                    return;
                                }
                                if (((String)object5).indexOf("414") == -1 || this.bSingleHashScrapes) break block79;
                                this.bSingleHashScrapes = true;
                                --this.numActiveScrapes;
                                return;
                            }
                        }
                        try {
                            String string5 = Debug.getNestedExceptionMessage(exception);
                            if (byArray != null) {
                                string = byArray.length <= 150 ? new String(byArray) : new String(byArray, 0, 150) + "...";
                                string5 = string5 + " [" + string + "]";
                            }
                            for (int i = 0; i < arrayList.size(); ++i) {
                                object4 = (TRTrackerScraperResponseImpl)arrayList.get(i);
                                if (Logger.isEnabled()) {
                                    object3 = ((TRTrackerScraperResponseImpl)object4).getHash();
                                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager((HashWrapper)object3), LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + string5 + " (" + exception.getClass() + ")"));
                                }
                                ((TRTrackerScraperResponseImpl)object4).setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                ((TRTrackerScraperResponseImpl)object4).setStatus(1, MessageText.getString("Scrape.status.error") + string5);
                                this.scraper.scrapeReceived((TRTrackerScraperResponse)object4);
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.out("runScrapesSupport failed", throwable);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                --this.numActiveScrapes;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllError(Exception exception) {
        Object[] objectArray;
        try {
            this.hashes_mon.enter();
            objectArray = this.hashes.values().toArray();
        }
        finally {
            this.hashes_mon.exit();
        }
        String string = exception.getLocalizedMessage();
        if (exception instanceof BEncodingException) {
            string = string.indexOf("html") != -1 ? "could not decode response, appears to be a website instead of tracker scrape: " + string.replace('\n', ' ') : "bencoded response malformed:" + string;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)objectArray[i];
            if (Logger.isEnabled()) {
                HashWrapper hashWrapper = tRTrackerScraperResponseImpl.getHash();
                Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hashWrapper), LOGID, 1, "Error from scrape interface " + this.scrapeURL + " : " + string));
            }
            tRTrackerScraperResponseImpl.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
            tRTrackerScraperResponseImpl.setStatus(1, StringInterner.intern(MessageText.getString("Scrape.status.error") + string + " (IO)"));
            this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL scrapeHTTP(URL uRL, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        URL uRL2 = null;
        TRTrackerUtils.checkForBlacklistedURLs(uRL);
        uRL = TRTrackerUtils.adjustURLForHosting(uRL);
        uRL = AddressUtils.adjustURL(uRL);
        Properties properties = new Properties();
        properties.put("URL", uRL);
        try {
            ClientIDManagerImpl.getSingleton().generateHTTPProperties(properties);
        }
        catch (ClientIDException clientIDException) {
            throw new IOException(clientIDException.getMessage());
        }
        uRL = (URL)properties.get("URL");
        InputStream inputStream = null;
        try {
            String string;
            int n;
            Object object;
            Object object2 = null;
            if (uRL.getProtocol().equalsIgnoreCase("https")) {
                object = (HttpsURLConnection)uRL.openConnection();
                ((HttpsURLConnection)object).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
                object2 = object;
            } else {
                object2 = (HttpURLConnection)uRL.openConnection();
            }
            object = (String)properties.get("User-Agent");
            if (object != null) {
                ((URLConnection)object2).setRequestProperty("User-Agent", (String)object);
            }
            ((URLConnection)object2).addRequestProperty("Accept-Encoding", "gzip");
            ((URLConnection)object2).setRequestProperty("Connection", "close");
            ((URLConnection)object2).connect();
            inputStream = ((URLConnection)object2).getInputStream();
            String string2 = ((URLConnection)object2).getURL().toString();
            if (!uRL.toString().equals(string2) && (n = string2.indexOf(string = "permredirect=1")) != -1) {
                --n;
                try {
                    uRL2 = new URL(string2.substring(0, n));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            int n2 = n = (string = ((URLConnection)object2).getHeaderField("content-encoding")) != null && string.equalsIgnoreCase("gzip") ? 1 : 0;
            if (n != 0) {
                inputStream = new GZIPInputStream(inputStream);
            }
            byte[] byArray = new byte[1024];
            int n3 = 0;
            try {
                while (true) {
                    int n4;
                    if ((n4 = inputStream.read(byArray)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n4);
                        if ((n3 += n4) <= 131072) continue;
                        byteArrayOutputStream.reset();
                        throw new Exception("Tracker response invalid (too large)");
                    }
                    if (n4 == 0) {
                        Thread.sleep(20L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + Debug.getNestedExceptionMessage(exception)));
                }
                URL uRL3 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return uRL3;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean scrapeUDP(URL var1_1, ByteArrayOutputStream var2_2, List var3_3, boolean var4_4) throws Exception {
        var5_5 = new HashMap<String, Object>();
        var6_6 = new ByteEncodedKeyHashMap<T, S>();
        var5_5.put("files", var6_6);
        var1_1 = TRTrackerUtils.adjustURLForHosting(var1_1);
        var7_7 = null;
        var8_8 = false;
        try {
            block22: {
                block21: {
                    if (var4_4 && UrlUtils.queryHasParameter(var1_1.getQuery(), "auth", false)) {
                        var7_7 = SESecurityManager.getPasswordAuthentication("UDP Tracker", var1_1);
                    }
                    var9_9 = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                    var10_10 = PRUDPPacketHandlerFactory.getHandler(var9_9);
                    var11_11 = new InetSocketAddress(var1_1.getHost(), var1_1.getPort() == -1 ? 80 : var1_1.getPort());
                    var10_10 = var10_10.openSession(var11_11);
                    try {
                        var12_12 = null;
                        for (var13_14 = 0; var13_14 < 1; ++var13_14) {
                            try {
                                var14_17 = new PRUDPPacketRequestConnect();
                                var15_18 = var10_10.sendAndReceive(var7_7, var14_17, var11_11);
                                if (var15_18.getAction() != 0) ** GOTO lbl89
                                var16_19 = (PRUDPPacketReplyConnect)var15_18;
                                var17_20 = var16_19.getConnectionId();
                                var19_21 = new PRUDPPacketRequestScrape(var17_20, var3_3);
                                if ((var15_18 = var10_10.sendAndReceive(var7_7, var19_21, var11_11)).getAction() != 2) ** GOTO lbl-1000
                                var8_8 = true;
                                if (PRUDPPacketTracker.VERSION == 1) {
                                    var20_22 = (PRUDPPacketReplyScrape)var15_18;
                                    var21_24 = var20_22.getHashes();
                                    var22_26 = var20_22.getComplete();
                                    var23_28 = var20_22.getDownloaded();
                                    var24_30 = var20_22.getIncomplete();
                                    for (var25_32 = 0; var25_32 < var21_24.length; ++var25_32) {
                                        var26_35 = new HashMap<String, Long>();
                                        var27_39 = var21_24[var25_32];
                                        var6_6.put(new String(var27_39, "ISO-8859-1"), var26_35);
                                        var26_35.put("complete", new Long(var22_26[var25_32]));
                                        var26_35.put("downloaded", new Long(var23_28[var25_32]));
                                        var26_35.put("incomplete", new Long(var24_30[var25_32]));
                                    }
                                    var25_33 = BEncoder.encode(var5_5);
                                    var2_2.write(var25_33);
                                    var26_36 = true;
                                    break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (PRUDPPacketHandlerException var14_16) {
                                if (var14_16.getMessage() == null) throw var14_16;
                                if (var14_16.getMessage().indexOf("timed out") == -1) {
                                    throw var14_16;
                                }
                                var12_12 = "Timeout";
                                continue;
                            }
                        }
                        break block22;
                    }
                    catch (Throwable var28_41) {
                        var10_10.closeSession();
                        throw var28_41;
                    }
                }
                var10_10.closeSession();
                return var26_36;
lbl-1000:
                // 1 sources

                {
                    var20_23 = (PRUDPPacketReplyScrape2)var15_18;
                    var21_25 = var20_23.getComplete();
                    var22_27 = var20_23.getDownloaded();
                    var23_29 = var20_23.getIncomplete();
                    var25_34 = var3_3.iterator();
                    for (var24_31 = 0; var25_34.hasNext() && var24_31 < var21_25.length; ++var24_31) {
                        var26_37 = (HashWrapper)var25_34.next();
                        var27_40 = new HashMap<String, Long>();
                        var27_40.put("complete", new Long(var21_25[var24_31]));
                        var27_40.put("downloaded", new Long(var22_27[var24_31]));
                        var27_40.put("incomplete", new Long(var23_29[var24_31]));
                        var6_6.put(new String(var26_37.getBytes(), "ISO-8859-1"), var27_40);
                    }
                    var25_34 = BEncoder.encode(var5_5);
                    var2_2.write((byte[])var25_34);
                    var26_38 = true;
                }
                var10_10.closeSession();
                return var26_38;
lbl-1000:
                // 1 sources

                {
                    var12_12 = ((PRUDPPacketReplyError)var15_18).getMessage();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + var1_1 + " : " + var12_12));
                    }
                    break block22;
lbl89:
                    // 1 sources

                    var12_12 = ((PRUDPPacketReplyError)var15_18).getMessage();
                    if (!Logger.isEnabled()) break block22;
                    Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + var1_1 + " : " + ((PRUDPPacketReplyError)var15_18).getMessage()));
                }
            }
            if (var12_12 != null) {
                var5_5.put("failure reason", var12_12.getBytes());
                var5_5.remove("files");
                var13_15 = BEncoder.encode(var5_5);
                var2_2.write(var13_15);
            }
            var10_10.closeSession();
            var12_13 = false;
            return var12_13;
        }
        finally {
            if (var7_7 != null) {
                SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, var1_1, var8_8);
            }
        }
    }

    protected String getURLParam(String string, String string2) {
        int n = string.indexOf(string2 + "=");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("&", n);
        if (n2 == -1) {
            return string.substring(n + string2.length() + 1);
        }
        return string.substring(n + string2.length() + 1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl addHash(HashWrapper hashWrapper) {
        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl;
        try {
            this.hashes_mon.enter();
            tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hashWrapper);
            if (tRTrackerScraperResponseImpl == null) {
                tRTrackerScraperResponseImpl = new TRTrackerBTScraperResponseImpl(this, hashWrapper);
                if (this.scrapeURL == null) {
                    tRTrackerScraperResponseImpl.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.badURL"));
                } else {
                    tRTrackerScraperResponseImpl.setStatus(0, MessageText.getString("Scrape.status.initializing"));
                }
                tRTrackerScraperResponseImpl.setNextScrapeStartTime(this.checker.getNextScrapeCheckOn());
                this.hashes.put(hashWrapper, tRTrackerScraperResponseImpl);
            }
        }
        finally {
            this.hashes_mon.exit();
        }
        this.scraper.scrapeReceived(tRTrackerScraperResponseImpl);
        return tRTrackerScraperResponseImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHash(HashWrapper hashWrapper) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hashWrapper);
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.scraper.scrapeReceived(tRTrackerScraperResponse);
    }

    public boolean getSupportsMultipeHashScrapes() {
        return !this.bSingleHashScrapes;
    }

    protected String getString() {
        return this.tracker_url + ", " + this.scrapeURL + ", multi-scrape=" + !this.bSingleHashScrapes;
    }

    public int getNumActiveScrapes() {
        return this.numActiveScrapes;
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListener("Server Enable UDP", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                udpScrapeEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
            }
        });
        udpScrapeEnabled = true;
        logged_invalid_urls = new ArrayList();
        thread_pool = new ThreadPool("TrackerStatus", 10, true);
    }
}

