/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class OverallStatsImpl
extends GlobalManagerAdapter
implements OverallStats {
    private static final long TEN_YEARS = 315360000L;
    private static final int STATS_PERIOD = 60000;
    private static final int SAVE_PERIOD = 600000;
    private static final int SAVE_TICKS = 10;
    private AzureusCore core;
    private long totalDownloaded;
    private long totalUploaded;
    private long totalUptime;
    private long lastDownloaded;
    private long lastUploaded;
    private long lastUptime;
    private long totalProtocolUploaded;
    private long totalDataUploaded;
    private long totalProtocolDownloaded;
    private long totalDataDownloaded;
    private long lastProtocolUploaded;
    private long lastDataUploaded;
    private long lastProtocolDownloaded;
    private long lastDataDownloaded;
    private long session_start_time = SystemTime.getCurrentTime();
    protected AEMonitor this_mon = new AEMonitor("OverallStats");
    private int tick_count;

    private Map load(String string) {
        return FileUtil.readResilientConfigFile(string);
    }

    private Map load() {
        return this.load("azureus.statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String string, Map map) {
        try {
            this.this_mon.enter();
            FileUtil.writeResilientConfigFile(string, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void save(Map map) {
        this.save("azureus.statistics", map);
    }

    private void validateAndLoadValues(Map map) {
        this.lastUptime = SystemTime.getCurrentTime() / 1000L;
        Map map2 = (Map)map.get("all");
        this.totalDownloaded = this.getLong(map2, "downloaded");
        this.totalUploaded = this.getLong(map2, "uploaded");
        this.totalUptime = this.getLong(map2, "uptime");
        this.totalProtocolUploaded = this.getLong(map2, "p_uploaded");
        this.totalDataUploaded = this.getLong(map2, "d_uploaded");
        this.totalProtocolDownloaded = this.getLong(map2, "p_downloaded");
        this.totalDataDownloaded = this.getLong(map2, "d_downloaded");
    }

    protected long getLong(Map map, String string) {
        if (map == null) {
            return 0L;
        }
        Object v = map.get(string);
        if (!(v instanceof Long)) {
            return 0L;
        }
        return (Long)v;
    }

    public OverallStatsImpl(AzureusCore azureusCore) {
        this.core = azureusCore;
        Map map = this.load();
        this.validateAndLoadValues(map);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("xfer.upload.protocol.bytes.total");
        hashSet.add("xfer.upload.data.bytes.total");
        hashSet.add("xfer.download.protocol.bytes.total");
        hashSet.add("xfer.download.data.bytes.total");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStats(Set set, Map map) {
                try {
                    OverallStatsImpl.this.this_mon.enter();
                    if (OverallStatsImpl.this.core.isStarted()) {
                        GlobalManagerStats globalManagerStats = OverallStatsImpl.this.core.getGlobalManager().getStats();
                        if (set.contains("xfer.upload.protocol.bytes.total")) {
                            map.put("xfer.upload.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolUploaded + (globalManagerStats.getTotalProtocolBytesSent() - OverallStatsImpl.this.lastProtocolUploaded)));
                        }
                        if (set.contains("xfer.upload.data.bytes.total")) {
                            map.put("xfer.upload.data.bytes.total", new Long(OverallStatsImpl.this.totalDataUploaded + (globalManagerStats.getTotalDataBytesSent() - OverallStatsImpl.this.lastDataUploaded)));
                        }
                        if (set.contains("xfer.download.protocol.bytes.total")) {
                            map.put("xfer.download.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolDownloaded + (globalManagerStats.getTotalProtocolBytesReceived() - OverallStatsImpl.this.lastProtocolDownloaded)));
                        }
                        if (set.contains("xfer.download.data.bytes.total")) {
                            map.put("xfer.download.data.bytes.total", new Long(OverallStatsImpl.this.totalDataDownloaded + (globalManagerStats.getTotalDataBytesReceived() - OverallStatsImpl.this.lastDataDownloaded)));
                        }
                    }
                }
                finally {
                    OverallStatsImpl.this.this_mon.exit();
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                if (azureusCoreComponent instanceof GlobalManager) {
                    GlobalManager globalManager = (GlobalManager)azureusCoreComponent;
                    globalManager.addListener(OverallStatsImpl.this, false);
                    SimpleTimer.addPeriodicEvent("OverallStats", 60000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent timerEvent2) {
                            OverallStatsImpl.this.updateStats(false);
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getAverageDownloadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalDownloaded / this.totalUptime);
        }
        return 0;
    }

    @Override
    public int getAverageUploadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalUploaded / this.totalUptime);
        }
        return 0;
    }

    @Override
    public long getDownloadedBytes() {
        return this.totalDownloaded;
    }

    @Override
    public long getUploadedBytes() {
        return this.totalUploaded;
    }

    @Override
    public long getTotalUpTime() {
        return this.totalUptime;
    }

    @Override
    public long getSessionUpTime() {
        return (SystemTime.getCurrentTime() - this.session_start_time) / 1000L;
    }

    @Override
    public void destroyInitiated() {
        this.updateStats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(boolean bl) {
        try {
            long l;
            this.this_mon.enter();
            long l2 = SystemTime.getCurrentTime() / 1000L;
            if (l2 < this.lastUptime) {
                this.lastUptime = l2;
                return;
            }
            GlobalManagerStats globalManagerStats = this.core.getGlobalManager().getStats();
            long l3 = globalManagerStats.getTotalDataBytesReceived();
            long l4 = globalManagerStats.getTotalProtocolBytesReceived();
            long l5 = globalManagerStats.getTotalDataBytesSent();
            long l6 = globalManagerStats.getTotalProtocolBytesSent();
            long l7 = l3 + l4;
            long l8 = l5 + l6;
            this.totalDownloaded += l7 - this.lastDownloaded;
            this.lastDownloaded = l7;
            if (this.totalDownloaded < 0L) {
                this.totalDownloaded = 0L;
            }
            this.totalUploaded += l8 - this.lastUploaded;
            this.lastUploaded = l8;
            if (this.totalUploaded < 0L) {
                this.totalUploaded = 0L;
            }
            this.totalDataDownloaded += l3 - this.lastDataDownloaded;
            this.lastDataDownloaded = l3;
            if (this.totalDataDownloaded < 0L) {
                this.totalDataDownloaded = 0L;
            }
            this.totalProtocolDownloaded += l4 - this.lastProtocolDownloaded;
            this.lastProtocolDownloaded = l4;
            if (this.totalProtocolDownloaded < 0L) {
                this.totalProtocolDownloaded = 0L;
            }
            this.totalDataUploaded += l5 - this.lastDataUploaded;
            this.lastDataUploaded = l5;
            if (this.totalDataUploaded < 0L) {
                this.totalDataUploaded = 0L;
            }
            this.totalProtocolUploaded += l6 - this.lastProtocolUploaded;
            this.lastProtocolUploaded = l6;
            if (this.totalProtocolUploaded < 0L) {
                this.totalProtocolUploaded = 0L;
            }
            if ((l = l2 - this.lastUptime) > 100L || l < 0L) {
                this.lastUptime = l2;
                return;
            }
            if (this.totalUptime > 315360000L) {
                this.totalUptime = 0L;
            }
            if (this.totalUptime < 0L) {
                this.totalUptime = 0L;
            }
            this.totalUptime += l;
            this.lastUptime = l2;
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("downloaded", new Long(this.totalDownloaded));
            hashMap.put("uploaded", new Long(this.totalUploaded));
            hashMap.put("uptime", new Long(this.totalUptime));
            hashMap.put("p_uploaded", new Long(this.totalProtocolUploaded));
            hashMap.put("d_uploaded", new Long(this.totalDataUploaded));
            hashMap.put("p_downloaded", new Long(this.totalProtocolDownloaded));
            hashMap.put("d_downloaded", new Long(this.totalDataDownloaded));
            HashMap<String, HashMap<String, Long>> hashMap2 = new HashMap<String, HashMap<String, Long>>();
            hashMap2.put("all", hashMap);
            ++this.tick_count;
            if (bl || this.tick_count % 10 == 0) {
                this.save(hashMap2);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

